/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.ent.business.service.impl.EntProdPoolCommandServiceImpl;
import kd.scm.ent.opplugin.validator.EntProdManageBarcodeValidator;

public class EntProdManageSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("taxrateid");
        fieldKeys.add("taxprice");
        fieldKeys.add("taxrate");
        fieldKeys.add("price");
        fieldKeys.add("createorg");
        fieldKeys.add("unit");
        fieldKeys.add("status");
        fieldKeys.add("protocolentry.protocol");
        fieldKeys.add("protocolentry.prodpool");
        fieldKeys.add("barcode");
        fieldKeys.add("supplier");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new EntProdManageBarcodeValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.createNewProdPool(e.getDataEntities());
        this.addProdPoolRelate(e.getDataEntities());
    }

    private void createNewProdPool(DynamicObject[] dataEntities) {
        EntProdPoolCommandServiceImpl prodPoolCommandService = new EntProdPoolCommandServiceImpl();
        List successPkIds = prodPoolCommandService.addNoProtocolProdPool(dataEntities);
        prodPoolCommandService.addProdEntry(successPkIds, dataEntities);
    }

    private void addProdPoolRelate(DynamicObject[] dataEntities) {
        DynamicObject[] prodPools;
        HashSet<Long> prodIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            prodIds.add(dynamicObject.getLong("id"));
        }
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,protocolentry.prodpool prodpool", (QFilter[])new QFilter[]{new QFilter("id", "in", prodIds)});
        HashMap<Long, Long> prodPoolAndProdMap = new HashMap<Long, Long>(dataEntities.length);
        for (DynamicObject prod : prods) {
            prodPoolAndProdMap.put(prod.getLong("prodpool"), prod.getLong("id"));
        }
        for (DynamicObject prodPool : prodPools = BusinessDataServiceHelper.load((String)"ent_prodpool", (String)"id,goods", (QFilter[])new QFilter[]{new QFilter("id", "in", prodPoolAndProdMap.keySet())})) {
            prodPool.set("goods_id", prodPoolAndProdMap.get(prodPool.getLong("id")));
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodPools);
    }
}

