/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.malcore.enums.ProdEffectStatusEnum;
import kd.scm.malcore.enums.SaleStatusEnum;

public class EntProdPoolDownloadOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("salestatus");
        fieldKeys.add("effectstatus");
        fieldKeys.add("protocol.id");
        fieldKeys.add("goods.id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] prods;
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> prodIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("salestatus", (Object)SaleStatusEnum.HIDE.getVal());
            dynamicObject.set("effectstatus", (Object)ProdEffectStatusEnum.INVALID.getVal());
            DynamicObject goods = dynamicObject.getDynamicObject("goods");
            if (goods == null) continue;
            prodIds.add(goods.getLong("id"));
        }
        Date now = TimeServiceHelper.now();
        QFilter qFilter = new QFilter("id", "in", prodIds);
        for (DynamicObject prod : prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"downloaddate", (QFilter[])qFilter.toArray())) {
            prod.set("downloaddate", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])prods);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodpool").getDynamicObjectType());
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ent_prodpool").getDynamicObjectType());
    }
}

