/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public class EntProdRequestImportOp
extends BatchImportPlugin {
    private String billno = null;
    private static final Log log = LogFactory.getLog((String)EntProdRequestImportOp.class.getName());
    private boolean isSuccess = true;

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        for (ImportBillData data : billdatas) {
            List entryCOl = (List)data.getData().get((Object)"entryentity");
            HashSet<String> goodNumSet = new HashSet<String>(1024);
            this.billno = String.valueOf(data.getData().get((Object)"billno"));
            for (int i = 0; i < entryCOl.size(); ++i) {
                Map row = (Map)entryCOl.get(i);
                if (null == row.get("goods")) continue;
                Map goodsMap = (Map)row.get("goods");
                goodNumSet.add(String.valueOf(goodsMap.get("number")));
            }
            Map supplierCOl = (Map)data.getData().get((Object)"supplier");
            Map protocolidCol = (Map)data.getData().get((Object)"protocolid");
            if (null == protocolidCol) continue;
            Object supNumber = supplierCOl.get("number");
            Object proBillno = protocolidCol.get("billno");
            QFilter prodFilter = new QFilter("billno", "=", (Object)this.billno);
            DynamicObjectCollection prodreques = QueryServiceHelper.query((String)"ent_prodrequest", (String)"org,bizpartner,curr,supplier.id,supplier.number,protocolid.billno", (QFilter[])prodFilter.toArray());
            if (prodreques.size() == 0) continue;
            long bizpartner = ((DynamicObject)prodreques.get(0)).getLong("bizpartner");
            long supplierId = ((DynamicObject)prodreques.get(0)).getLong("supplier.id");
            long cur = ((DynamicObject)prodreques.get(0)).getLong("curr");
            String number = ((DynamicObject)prodreques.get(0)).getString("supplier.number");
            String pbillno = ((DynamicObject)prodreques.get(0)).getString("protocolid.billno");
            Long org = ((DynamicObject)prodreques.get(0)).getLong("org");
            if (null == supNumber || !supNumber.equals(number) || null == proBillno || !proBillno.equals(pbillno)) continue;
            HashSet<String> removeSet = new HashSet<String>(1024);
            QFilter qFilter = new QFilter("number", "in", goodNumSet);
            String sectors = "number,status";
            DynamicObjectCollection prodmanages = QueryServiceHelper.query((String)"ent_prodmanage", (String)sectors, (QFilter[])qFilter.toArray());
            StringBuilder saveGoodsStr = new StringBuilder();
            for (DynamicObject prod : prodmanages) {
                removeSet.add(prod.getString("number"));
                if (!"A".equals(prod.getString("status"))) continue;
                saveGoodsStr.append(prod.getString("number")).append(',');
            }
            if (saveGoodsStr.length() > 0) {
                saveGoodsStr.substring(0, saveGoodsStr.length() - 1);
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1\u201c{0}\u201d\u5df2\u5b58\u5728\u6682\u5b58\u72b6\u6001\u7684\u5546\u54c1\u3002", (String)"EntProdRequestImportOp_0", (String)"scm-ent-opplugin", (Object[])new Object[]{saveGoodsStr});
                logger.log(Integer.valueOf(data.getStartRowIndex()), msg);
                this.isSuccess = false;
                return;
            }
            goodNumSet.removeAll(removeSet);
            ArrayList<DynamicObject> entProdmanageList = new ArrayList<DynamicObject>(1024);
            ArrayList<String> entProdNumberList = new ArrayList<String>(1024);
            for (int i = 0; i < entryCOl.size(); ++i) {
                Map goodsMap;
                Map row = (Map)entryCOl.get(i);
                if (null == row.get("goods") || null != (goodsMap = (Map)row.get("goods")).get("number") && !goodNumSet.contains(String.valueOf(goodsMap.get("number")))) continue;
                DynamicObject entProdmanage = this.createEntProdmanage(row, bizpartner, cur, supplierId, org);
                entProdmanageList.add(entProdmanage);
                entProdNumberList.add(entProdmanage.getString("number"));
            }
            if (entProdmanageList.size() <= 0) continue;
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult saveResullt = OperationServiceHelper.executeOperate((String)"save", (String)"ent_prodmanage", (DynamicObject[])entProdmanageList.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            if (!saveResullt.isSuccess()) {
                throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)saveResullt.getAllErrorOrValidateInfo()));
            }
            String pks = SerializationUtils.toJsonString((Object)saveResullt.getSuccessPkIds());
            IAppCache appCache = AppCache.get((String)this.billno);
            appCache.put("pks", (Object)pks);
            for (int i = 0; i < entProdmanageList.size(); ++i) {
                DynamicObject info = (DynamicObject)entProdmanageList.get(i);
                info.set("number", entProdNumberList.get(i));
            }
            SaveServiceHelper.save((DynamicObject[])entProdmanageList.toArray(new DynamicObject[0]));
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult result = super.save(rowdatas, logger);
        if (null == result.getData() || !this.isSuccess) {
            return result;
        }
        List billResults = (List)result.getData();
        if (!((Boolean)((Map)billResults.get(0)).get("success")).booleanValue()) {
            IAppCache appCache = AppCache.get((String)this.billno);
            String pks = (String)appCache.get("pks", String.class);
            if (pks == null) {
                return result;
            }
            List pkList = (List)SerializationUtils.fromJsonString((String)pks, List.class);
            ArrayList<Long> pkList_long = new ArrayList<Long>(1024);
            for (Object id : pkList) {
                pkList_long.add(Long.parseLong(String.valueOf(id)));
            }
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)"ent_prodmanage", (Object[])pkList_long.toArray(), (OperateOption)saveOption);
            if (!deleteResullt.isSuccess()) {
                log.error(ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo()));
            }
            appCache.remove(this.billno);
        }
        return result;
    }

    private DynamicObject createEntProdmanage(Map<String, Object> row, long bizpartner, long cur, long supId, Long org) {
        String goodremark;
        Long bdVal;
        DynamicObject entGood = ORM.create().newDynamicObject("ent_prodmanage");
        if (null != row.get("goods")) {
            Map goodsMap = (Map)row.get("goods");
            if (null == goodsMap.get("name")) {
                entGood.set("name", goodsMap.get("number"));
            } else {
                entGood.set("name", goodsMap.get("name"));
            }
            entGood.set("number", goodsMap.get("number"));
        }
        entGood.set("barcode", row.get("barcode"));
        String goodsbrand = "";
        Object goodsprice = row.get("price");
        if (null != goodsprice) {
            entGood.set("price", (Object)new BigDecimal(String.valueOf(goodsprice)));
        }
        entGood.set("taxtype", (Object)"1");
        Object goodstaxprice = row.get("taxprice");
        if (null != goodstaxprice) {
            entGood.set("taxprice", (Object)new BigDecimal(String.valueOf(goodstaxprice)));
            entGood.set("price", (Object)new BigDecimal(String.valueOf(goodstaxprice)));
        }
        if (null != row.get("unit") && (bdVal = this.getBdVal(row, "unit", "bd_measureunits")) != 0L) {
            entGood.set("unit", (Object)bdVal);
        }
        if (null != row.get("class") && (bdVal = this.getBdVal(row, "class", "mdr_goodsclass")) != 0L) {
            entGood.set("category", (Object)bdVal);
        }
        if (null != (goodremark = "")) {
            entGood.set("remark", (Object)goodremark);
        }
        entGood.set("origin", (Object)"1");
        entGood.set("status", (Object)"A");
        entGood.set("enable", (Object)"1");
        entGood.set("mallstatus", (Object)"F");
        entGood.set("source", (Object)"1");
        entGood.set("standard", (Object)Long.parseLong("944841720602823680"));
        entGood.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        if (null == RequestContext.get().getBizPartnerId()) {
            entGood.set("bizpartner", (Object)bizpartner);
        } else {
            entGood.set("bizpartner", (Object)RequestContext.get().getBizPartnerId());
        }
        entGood.set("supplier_id", (Object)supId);
        entGood.set("createorg", (Object)org);
        entGood.set("curr", (Object)cur);
        return entGood;
    }

    private Long getBdVal(Map<String, Object> row, String columName, String bdName) {
        Map unitMap = (Map)row.get(columName);
        Object unitNumber = unitMap.get("number");
        Object unitName = unitMap.get("name");
        if (null != unitName || null != unitNumber) {
            QFilter bdQfilter = new QFilter("number", "=", unitNumber);
            bdQfilter.or(new QFilter("name", "=", unitName));
            DynamicObjectCollection bdCol = QueryServiceHelper.query((String)bdName, (String)"id,number", (QFilter[])bdQfilter.toArray());
            if (bdCol.size() > 0) {
                return ((DynamicObject)bdCol.get(0)).getLong("id");
            }
            return 0L;
        }
        return 0L;
    }
}

