/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class EntSupRequestSubmitPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("supplier.id");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("linkman");
        e.getFieldKeys().add("phone");
        e.getFieldKeys().add("suggestion");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length == 0) {
            return;
        }
        HashSet<Long> supplierIdSet = new HashSet<Long>(objs.length);
        for (DynamicObject obj : objs) {
            supplierIdSet.add(obj.getDynamicObject("supplier").getLong("id"));
        }
        DynamicObject[] supplierGroupDetailArray = BusinessDataServiceHelper.load((String)"bd_suppliergroupdetail", (String)"id,standard,group,supplier", (QFilter[])new QFilter[]{new QFilter("supplier", "in", supplierIdSet)});
        HashMap<Long, Long> supplierIDAndGroupIdDynMap = new HashMap<Long, Long>(supplierGroupDetailArray.length);
        for (DynamicObject supplierGroupDetail : supplierGroupDetailArray) {
            DynamicObject standard = supplierGroupDetail.getDynamicObject("standard");
            if (!"JBFLBZ".equals(standard.getString("number"))) continue;
            supplierIDAndGroupIdDynMap.put(supplierGroupDetail.getDynamicObject("supplier").getLong("id"), supplierGroupDetail.getDynamicObject("group").getLong("id"));
        }
        for (DynamicObject obj : objs) {
            obj.set("suggestion", (Object)"");
            obj.set("cfmstatus", (Object)"A");
            DynamicObject supplier = obj.getDynamicObject("supplier");
            Long groupId = (Long)supplierIDAndGroupIdDynMap.get(supplier.getLong("id"));
            if (groupId != null) {
                obj.set("group", (Object)groupId);
            }
            obj.set("linkman", (Object)supplier.getString("linkman"));
            obj.set("phone", (Object)supplier.getString("bizpartner_phone"));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length == 0) {
            return;
        }
        HashSet<Long> supplierIdSet = new HashSet<Long>(objs.length);
        for (DynamicObject obj : objs) {
            supplierIdSet.add(obj.getLong("supplier.id"));
            this.updateSupplier(supplierIdSet);
        }
        if (StringUtils.equals((CharSequence)e.getOperationKey(), (CharSequence)"submit")) {
            Object id = e.getDataEntities()[0].get("id");
            WorkflowServiceHelper.tryTriggerProcess((String)id.toString(), (String)"intoworkflow", (String)"pmm_supplieraudit", null);
        }
    }

    private void updateSupplier(Set<Long> supplierIds) {
        if (supplierIds == null || supplierIds.isEmpty()) {
            return;
        }
        Object[] supplierObjs = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"mallstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        if (supplierObjs.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : supplierObjs) {
            dynamicObject.set("mallstatus", (Object)"A");
        }
        SaveServiceHelper.save((IDataEntityType)supplierObjs[0].getDynamicObjectType(), (Object[])supplierObjs);
    }
}

