/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin.validator;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntPriceReqSubmitValidator
extends AbstractValidator {
    public void validate() {
        HashMap<String, Object> prodNumbers = new HashMap<String, Object>();
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                DynamicObject goods = entry.getDynamicObject("goods");
                if (goods == null) continue;
                prodNumbers.put(goods.getString("number"), extendedDataEntity);
            }
        }
        QFilter prodQFilter = new QFilter("number", "in", prodNumbers.keySet());
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"number", (QFilter[])prodQFilter.toArray());
        HashSet<String> numberCheck = new HashSet<String>(prods.size());
        for (ExtendedDataEntity[] prod : prods) {
            String number = prod.getString("number");
            if (numberCheck.contains(number)) {
                String message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u5546\u54c1\u7ba1\u7406\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"EntPriceReqSubmitValidator_6", (String)"scm-ent-opplugin", (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)prodNumbers.get(number), String.format(message, number));
                continue;
            }
            numberCheck.add(number);
        }
        HashMap<Long, ExtendedDataEntity> prodPoolIds = new HashMap<Long, ExtendedDataEntity>(this.getDataEntities().length);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject priceReqBill = rowDataEntity.getDataEntity();
            if (null != priceReqBill.getString("cfmstatus") && priceReqBill.getString("cfmstatus").equals("D")) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4e0d\u540c\u610f\u7684\u8c03\u4ef7\u7533\u8bf7\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u3002", (String)"EntPriceReqSubmitValidator_0", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!priceReqBill.getString("billstatus").equals("A") && !priceReqBill.getString("billstatus").equals("D")) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u6b64\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u3002", (String)"EntPriceReqSubmitValidator_1", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (null != priceReqBill.getString("cfmstatus") && priceReqBill.getString("cfmstatus").equals("D")) continue;
            DynamicObjectCollection col = priceReqBill.getDynamicObjectCollection("entryentity");
            if (priceReqBill.getString("billstatus").equals("A")) {
                for (DynamicObject entry : col) {
                    DynamicObject prodPool = entry.getDynamicObject("prodpool");
                    if (null == prodPool || null == prodPool.getPkValue()) continue;
                    String mallStatus = prodPool.getString("mallstatus");
                    DynamicObject goods = entry.getDynamicObject("goods");
                    if (!MallStatusEnum.UNSOLD.getVal().equals(mallStatus) && !MallStatusEnum.SOLD.getVal().equals(mallStatus)) {
                        this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\u4e0d\u662f\u5f85\u4e0a\u67b6/\u5df2\u4e0a\u67b6\uff0c\u4e0d\u80fd\u63d0\u4ea4\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"EntPriceReqSubmitValidator_3", (String)"scm-ent-opplugin", (Object[])new Object[0]), goods.getString("number")));
                        continue;
                    }
                    if (prodPoolIds.containsKey(prodPool.getLong("id"))) {
                        this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\u5b58\u5728\u91cd\u590d\u7684\u8c03\u4ef7\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"EntPriceReqSubmitValidator_4", (String)"scm-ent-opplugin", (Object[])new Object[0]), goods.getString("number")));
                        this.addErrorMessage((ExtendedDataEntity)prodPoolIds.remove(prodPool.getLong("id")), MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\u5b58\u5728\u91cd\u590d\u7684\u8c03\u4ef7\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"EntPriceReqSubmitValidator_4", (String)"scm-ent-opplugin", (Object[])new Object[0]), goods.getString("number")));
                        continue;
                    }
                    prodPoolIds.put(prodPool.getLong("id"), rowDataEntity);
                }
            }
            if (priceReqBill.getString("billstatus").equals("A")) continue;
            for (DynamicObject row : col) {
                DynamicObjectCollection subEntry;
                int seq = row.getInt("seq");
                String pricetype = row.getString("pricetype");
                if (!"B".equals(pricetype) || (subEntry = row.getDynamicObjectCollection("subentryentity")).size() != 0) continue;
                this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6ca1\u6709\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"EntPriceReqSubmitValidator_5", (String)"scm-ent-opplugin", (Object[])new Object[0]), seq));
            }
        }
        QFilter qFilter = new QFilter("cfmstatus", "=", (Object)"A");
        qFilter.and("entryentity.prodpool", "in", prodPoolIds.keySet());
        DynamicObjectCollection priceReqBills = QueryServiceHelper.query((String)"ent_pricerequest", (String)"entryentity.prodpool prodpool,entryentity.prodpool.goods.number number", (QFilter[])qFilter.toArray());
        for (DynamicObject priceReqBill : priceReqBills) {
            this.addErrorMessage((ExtendedDataEntity)prodPoolIds.get(priceReqBill.getLong("prodpool")), MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1\u201c{0}\u201d\u6709\u5f85\u5ba1\u6279\u7684\u8c03\u4ef7\u7533\u8bf7\uff0c\u4e0d\u80fd\u518d\u6b21\u63d0\u8d77\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"EntPriceReqSubmitValidator_2", (String)"scm-ent-opplugin", (Object[])new Object[0]), priceReqBill.getString("number")));
        }
    }
}

