/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntProdRequestReSubmitValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("cfmstatus");
        propertys.add("protocolid.id");
        propertys.add("protocolid.protocolstatus");
        propertys.add("biztype");
        propertys.add("protocolstatus");
        propertys.add("entryentity.goods");
        propertys.add("entryentity.entryresult");
        return propertys;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length > 0) {
            DynamicObject info = dataEntities[0].getDataEntity();
            DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entryentity");
            HashSet<Long> goodIds = new HashSet<Long>(1024);
            String cfmStatus = info.getString("cfmstatus");
            if (!"C".equals(cfmStatus) && !"D".equals(cfmStatus)) {
                String msg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u6761\u9700\u91cd\u65b0\u4fee\u6539\u7684\u7533\u8bf7\u5355\u91cd\u65b0\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"EntPriceRequestReSubmitValidator_5", (String)"scm-ent-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntities[0], msg);
                return;
            }
            if ("C".equals(cfmStatus)) {
                for (DynamicObject row : entryCol) {
                    String result = row.getString("entryresult");
                    if (null == row.get("goods")) continue;
                    long good = row.getLong("goods.id");
                    if (!"0".equals(result) || 0L == good) continue;
                    goodIds.add(good);
                }
            }
            if ("D".equals(cfmStatus)) {
                for (DynamicObject row : entryCol) {
                    long good;
                    if (null == row.get("goods") || 0L == (good = row.getLong("goods.id"))) continue;
                    goodIds.add(good);
                }
            }
            if (null != info.get("protocolid") && info.getLong("protocolid.id") != 0L) {
                this.resubmitProtocolCheck(goodIds, info);
            }
        }
    }

    private void resubmitProtocolCheck(Set<Long> goodIds, DynamicObject info) {
        long protocolid = info.getLong("protocolid.id");
        String biztype = info.getString("biztype");
        String protocolStatus = info.getString("protocolid.protocolstatus");
        if ("1".equals(biztype) && ("C".equals(protocolStatus) || "D".equals(protocolStatus))) {
            String msg = ResManager.loadKDString((String)"\u5546\u57ce\u534f\u8bae\u5df2\u5931\u6548/\u5df2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u5feb\u901f\u7533\u8bf7\u3002", (String)"EntPriceRequestReSubmitValidator_2", (String)"scm-ent-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(this.getDataEntities()[0], msg);
            return;
        }
        QFilter qFilter1 = new QFilter("goods", "in", goodIds);
        qFilter1.and(new QFilter("protocol", "=", (Object)protocolid));
        if ("1".equals(biztype)) {
            qFilter1.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()).or("mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()));
        } else {
            qFilter1.and(new QFilter("mallstatus", "!=", (Object)MallStatusEnum.SOLD.getVal()).and("mallstatus", "!=", (Object)MallStatusEnum.UNSOLD.getVal()));
        }
        DynamicObjectCollection goodPools = QueryServiceHelper.query((String)"ent_prodpool", (String)"id", (QFilter[])qFilter1.toArray());
        if (goodPools.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u5173\u8054\u534f\u8bae\u5e76\u4e0a\u67b6\uff0c\u65e0\u6cd5\u5feb\u901f\u7533\u8bf7\u3002", (String)"EntPriceRequestReSubmitValidator_3", (String)"scm-ent-opplugin", (Object[])new Object[0]);
            if ("2".equals(biztype)) {
                msg = ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u5feb\u901f\u7533\u8bf7\u3002", (String)"EntPriceRequestReSubmitValidator_4", (String)"scm-ent-opplugin", (Object[])new Object[0]);
            }
            this.addErrorMessage(this.getDataEntities()[0], msg);
            return;
        }
    }
}

