/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.business.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.ent.business.service.EntProdPoolCommandService;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.enums.ProdEffectStatusEnum;
import kd.scm.malcore.enums.SaleStatusEnum;

public class EntProdPoolCommandServiceImpl
implements EntProdPoolCommandService {
    @Override
    public List<Object> addNoProtocolProdPool(DynamicObject[] prodDynArray) {
        List<Object> successPkIds = new ArrayList<Object>(prodDynArray.length);
        ArrayList<DynamicObject> newProdPoolDynList = new ArrayList<DynamicObject>(prodDynArray.length);
        HashMap<Long, DynamicObject> updateProdPoolDynMap = new HashMap<Long, DynamicObject>(prodDynArray.length);
        for (DynamicObject prodDyn : prodDynArray) {
            DynamicObjectCollection protocolentry = prodDyn.getDynamicObjectCollection("protocolentry");
            if (!protocolentry.isEmpty() && ((DynamicObject)protocolentry.get(0)).get("protocol") != null) continue;
            if (!protocolentry.isEmpty() && ((DynamicObject)protocolentry.get(0)).get("protocol") == null) {
                updateProdPoolDynMap.put(((DynamicObject)protocolentry.get(0)).getDynamicObject("prodpool").getLong("id"), prodDyn);
                continue;
            }
            DynamicObject newProdPoolDyn = this.createNewProdPoolDyn(prodDyn);
            newProdPoolDynList.add(newProdPoolDyn);
        }
        this.updateProdPoolByProd(updateProdPoolDynMap);
        if (!newProdPoolDynList.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult saveOpRes = OperationServiceHelper.executeOperate((String)"save", (String)"ent_prodpool", (DynamicObject[])newProdPoolDynList.toArray(new DynamicObject[0]), (OperateOption)option);
            if (!saveOpRes.isSuccess()) {
                String msg = ResManager.loadKDString((String)"\u5546\u54c1\u6c60\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"EntProdManageSaveOp_0", (String)"scm-ent-opplugin", (Object[])new Object[0]);
                throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)saveOpRes.getAllErrorOrValidateInfo()));
            }
            OperationResult submitOpRes = OperationServiceHelper.executeOperate((String)"submit", (String)"ent_prodpool", (Object[])saveOpRes.getSuccessPkIds().toArray(), (OperateOption)option);
            if (!submitOpRes.isSuccess()) {
                String msg = ResManager.loadKDString((String)"\u5546\u54c1\u6c60\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"EntProdManageSaveOp_1", (String)"scm-ent-opplugin", (Object[])new Object[0]);
                throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)submitOpRes.getAllErrorOrValidateInfo()));
            }
            OperationResult auditOpRes = OperationServiceHelper.executeOperate((String)"audit", (String)"ent_prodpool", (Object[])submitOpRes.getSuccessPkIds().toArray(), (OperateOption)option);
            if (!auditOpRes.isSuccess()) {
                String msg = ResManager.loadKDString((String)"\u5546\u54c1\u6c60\u5ba1\u6838\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"EntProdManageSaveOp_2", (String)"scm-ent-opplugin", (Object[])new Object[0]);
                throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)auditOpRes.getAllErrorOrValidateInfo()));
            }
            successPkIds = auditOpRes.getSuccessPkIds();
        }
        return successPkIds;
    }

    @Override
    public void addProdEntry(List<Object> prodPoolIdList, DynamicObject[] prodDynArray) {
        if (prodPoolIdList.isEmpty()) {
            return;
        }
        DynamicObjectCollection prodPoolDynArray = QueryServiceHelper.query((String)"ent_prodpool", (String)"id,goods.id goods,protocol.id protocol", (QFilter[])new QFilter[]{new QFilter("id", "in", prodPoolIdList)});
        HashMap<Long, List> prodIdAndPoolsMap = new HashMap<Long, List>(prodPoolDynArray.size());
        for (DynamicObject prodPoolDyn : prodPoolDynArray) {
            List prodPools = prodIdAndPoolsMap.computeIfAbsent(prodPoolDyn.getLong("goods"), k -> new ArrayList(prodPoolDynArray.size()));
            prodPools.add(prodPoolDyn);
        }
        HashSet<Long> saveStatusProdIds = new HashSet<Long>(prodDynArray.length);
        for (DynamicObject prodDyn : prodDynArray) {
            List prodPoolDynList = (List)prodIdAndPoolsMap.get(prodDyn.getLong("id"));
            if (!"C".equals(prodDyn.getString("status"))) {
                saveStatusProdIds.add(prodDyn.getLong("id"));
            }
            for (DynamicObject prodPoolDyn : prodPoolDynList) {
                DynamicObjectCollection prodProtocolEntry = prodDyn.getDynamicObjectCollection("protocolentry");
                DynamicObject newProdProtocolEntry = prodProtocolEntry.addNew();
                newProdProtocolEntry.set("prodpool_id", (Object)prodPoolDyn.getLong("id"));
                newProdProtocolEntry.set("protocol_id", (Object)prodPoolDyn.getLong("protocol"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])prodDynArray);
        this.deleteProdPoolRelate(saveStatusProdIds);
    }

    private void deleteProdPoolRelate(Set<Long> saveStatusProdIds) {
        DynamicObject[] prodPools;
        if (saveStatusProdIds.isEmpty()) {
            return;
        }
        for (DynamicObject prodPool : prodPools = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"id,goods", (QFilter[])new QFilter[]{new QFilter("goods", "in", saveStatusProdIds)})) {
            prodPool.set("goods", null);
        }
        SaveServiceHelper.save((DynamicObject[])prodPools);
    }

    private DynamicObject createNewProdPoolDyn(DynamicObject prodDyn) {
        DynamicObject newProdPoolDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodpool");
        newProdPoolDyn.set("name", (Object)prodDyn.getString("name"));
        newProdPoolDyn.set("goods", (Object)prodDyn);
        newProdPoolDyn.set("taxprice", prodDyn.get("taxprice"));
        newProdPoolDyn.set("taxrateid", prodDyn.get("taxrateid"));
        newProdPoolDyn.set("taxrate", prodDyn.get("taxrate"));
        newProdPoolDyn.set("price", prodDyn.get("price"));
        newProdPoolDyn.set("createorg", prodDyn.get("createorg"));
        newProdPoolDyn.set("auditorg", prodDyn.get("createorg"));
        newProdPoolDyn.set("mallstatus", (Object)MallStatusEnum.TEMPSTATUS.getVal());
        newProdPoolDyn.set("salestatus", (Object)SaleStatusEnum.HIDE.getVal());
        newProdPoolDyn.set("unit", prodDyn.get("unit"));
        newProdPoolDyn.set("platform", (Object)"1");
        newProdPoolDyn.set("enable", (Object)"1");
        newProdPoolDyn.set("status", (Object)"A");
        newProdPoolDyn.set("isgoodvisible", (Object)Boolean.TRUE);
        newProdPoolDyn.set("centralpurtype", (Object)"1");
        newProdPoolDyn.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        newProdPoolDyn.set("effectstatus", (Object)ProdEffectStatusEnum.INEFFECTIVE.getVal());
        return newProdPoolDyn;
    }

    private void updateProdPoolByProd(Map<Long, DynamicObject> updateProdPoolDynMap) {
        DynamicObject[] prodPoolArray;
        for (DynamicObject prodPoolDyn : prodPoolArray = BusinessDataServiceHelper.load((String)"ent_prodpool", (String)"id,name,goods,taxprice,taxrateid,taxrate,price,unit,createorg,auditorg", (QFilter[])new QFilter[]{new QFilter("id", "in", updateProdPoolDynMap.keySet())})) {
            DynamicObject prodDyn = updateProdPoolDynMap.get(prodPoolDyn.getLong("id"));
            prodPoolDyn.set("taxprice", prodDyn.get("taxprice"));
            prodPoolDyn.set("taxrateid", prodDyn.get("taxrateid"));
            prodPoolDyn.set("taxrate", prodDyn.get("taxrate"));
            prodPoolDyn.set("price", prodDyn.get("price"));
            prodPoolDyn.set("unit", prodDyn.get("unit"));
            prodPoolDyn.set("createorg", prodDyn.get("createorg"));
            prodPoolDyn.set("auditorg", prodDyn.get("createorg"));
        }
        SaveServiceHelper.save((DynamicObject[])prodPoolArray);
    }
}

