/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.common.constant.CalConstant;

public class EntAdjustPricePlugin
extends AbstractFormPlugin {
    private static final String ADJUSTPRICE = "adjustprice";
    private static final String MODE = "adjustmode";
    private static final String TYPE = "adjusttype";
    private static final String PERCENT = "percent";
    private static final String AMOUNT = "amount";
    private static boolean legal = true;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "adjustprice": {
                if (legal) break;
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "adjustprice": {
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                String mode = (String)model.getValue(MODE);
                String type = (String)model.getValue(TYPE);
                returnData.put(MODE, mode);
                returnData.put(TYPE, type);
                if (mode.equals("1")) {
                    BigDecimal percent = (BigDecimal)model.getValue(PERCENT);
                    returnData.put(PERCENT, percent);
                } else {
                    BigDecimal amount = (BigDecimal)model.getValue(AMOUNT);
                    returnData.put(AMOUNT, amount);
                }
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String mode = (String)model.getValue(MODE);
        String type = (String)model.getValue(TYPE);
        switch (propertyName = e.getProperty().getName()) {
            case "percent": {
                BigDecimal percent = (BigDecimal)model.getValue(PERCENT);
                if (mode.equals("1") && type.equals("1") && (percent.compareTo(CalConstant.BIGDECIMAL_ZERO) < 0 || percent.compareTo(CalConstant.BIGDECIMAL_ONEHUNDRED) >= 0)) {
                    model.setValue(PERCENT, e.getChangeSet()[0].getOldValue());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u51fa\u6570\u503c\u8303\u56f4[0,100)\u3002", (String)"EntProdManageList_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    legal = false;
                    break;
                }
                legal = true;
                break;
            }
            case "amount": {
                BigDecimal amount = (BigDecimal)model.getValue(AMOUNT);
                if (amount.compareTo(CalConstant.BIGDECIMAL_ZERO) < 0 || amount.compareTo(new BigDecimal("100000000.0")) > 0) {
                    model.setValue(AMOUNT, e.getChangeSet()[0].getOldValue());
                    legal = false;
                    break;
                }
                legal = true;
            }
        }
    }
}

