/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.common.util.CommonUtil;

public class EntProdAttributeContent
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(EntProdAttributeContent.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplierEdit = (BasedataEdit)this.getView().getControl("supplier");
        supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"supplier")) {
            List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            QFilter filter = new QFilter("id", "in", (Object)supIdList);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        if (supIdList.size() > 0) {
            this.getModel().setValue("supplier", supIdList.get(0));
        }
        this.getModel().setValue("prodattributeclass", this.getCustomParams().get("prodAttributeClass"));
    }

    private Map<String, Object> getCustomParams() {
        return this.getView().getFormShowParameter().getShowParameter().getCustomParams();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "name": {
                this.checkSameData(model, rowIndex);
            }
        }
    }

    private void checkSameData(IDataModel model, int rowIndex) {
        IFormView view = this.getView();
        if (null == model.getValue("name", rowIndex)) {
            return;
        }
        Object name = model.getValue("name", rowIndex);
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entrys) {
            String rowName = row.getString("name");
            if (null == name || !rowName.equals(name) || rowIndex + 1 == row.getInt("seq")) continue;
            String msg = ResManager.loadKDString((String)"\u5728\u7b2c{0}\u884c\u5b58\u5728\u76f8\u540c\u7684\u5c5e\u6027\u5185\u5bb9\u3002", (String)"EntProdAttributeContent_2", (String)"scm-ent-formplugin", (Object[])new Object[]{row.getInt("seq")});
            view.showErrorNotification(msg);
            model.setValue("name", null);
            break;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "cancel": {
                event.setCancel(true);
                this.getView().close();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.saveProduct();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        this.setDefaultNumber(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDefaultNumber(int rowIndex) {
        if (!Objects.nonNull(this.getModel().getValue("number", rowIndex))) return;
        String billno = null;
        try {
            billno = CodeRuleUtil.getCodeRule((String)"ent_prodattributevalue");
        }
        catch (Exception e) {
            try {
                log.info("\u5c5e\u6027\u503c\u7f16\u7801\u8bbe\u7f6e\uff1a" + rowIndex + "\u884c" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.getModel().setValue("number", (Object)billno, rowIndex);
                if (billno == null) throw throwable;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"number"});
                throw throwable;
            }
            this.getModel().setValue("number", (Object)billno, rowIndex);
            if (billno == null) return;
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"number"});
            return;
        }
        this.getModel().setValue("number", (Object)billno, rowIndex);
        if (billno == null) return;
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"number"});
        return;
    }

    private void saveProduct() {
        DynamicObject sourceDyo = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)sourceDyo.get("entryentity");
        Object supplier = this.getModel().getValue("supplier");
        Object prodAttributeClass = this.getModel().getValue("prodattributeclass");
        if (!CollectionUtils.isEmpty((Collection)entryDyoCol)) {
            ArrayList<DynamicObject> prodAttributeValueList = new ArrayList<DynamicObject>();
            for (DynamicObject entryDyo : entryDyoCol) {
                DynamicObject prodAttributeValue = BusinessDataServiceHelper.newDynamicObject((String)"ent_prodattributevalue");
                prodAttributeValue.set("number", (Object)entryDyo.getString("number"));
                prodAttributeValue.set("name", (Object)entryDyo.getString("name"));
                prodAttributeValue.set("status", (Object)"C");
                prodAttributeValue.set("enable", (Object)"1");
                prodAttributeValue.set("origin", (Object)"1");
                prodAttributeValue.set("creator", (Object)RequestContext.get().getCurrUserId());
                prodAttributeValue.set("supplier", supplier);
                prodAttributeValue.set("group", prodAttributeClass);
                prodAttributeValueList.add(prodAttributeValue);
            }
            DynamicObject[] prods = prodAttributeValueList.toArray(new DynamicObject[0]);
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)"ent_prodattributevalue", (DynamicObject[])prods, (OperateOption)option));
        }
    }
}

