/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class EntProdManageAllotPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    public static final String surchargeid = "surchargeid";
    public static final String surchargename = "surchargename";
    public static final String surchargeamount = "surchargeamount";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshEntry();
    }

    private void refreshEntry() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String operate = (String)param.getCustomParam("operate");
        Long supplier = (Long)param.getCustomParam("supplier");
        ORM orm = ORM.create();
        String orderby = "number";
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        if ("unallot".equals(operate)) {
            List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            Set<Long> idSet = this.getsurchangeByGoodsId();
            QFilter filters = new QFilter("supplier", "in", (Object)supIdList);
            filters.and(new QFilter("id", "in", idSet));
            try (DataSet ds = orm.queryDataSet("ent_surcharge", "ent_surcharge", this.assembleSelectProdFilds(), new QFilter[]{filters}, orderby);){
                Iterator rows = ds.iterator();
                int index = 0;
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    vs.set("number", (Object)row.getString("id"), index);
                    ++index;
                }
            }
        }
        QFilter filters = new QFilter("supplier", "=", (Object)supplier);
        try (DataSet ds = orm.queryDataSet("ent_surcharge", "ent_surcharge", this.assembleSelectProdFilds(), new QFilter[]{filters}, orderby);){
            Iterator rows = ds.iterator();
            int index = 0;
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                vs.set("number", (Object)row.getString("id"), index);
                ++index;
            }
        }
        model.deleteEntryData(ENTRY_ENTITY);
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
    }

    public Set<Long> getsurchangeByGoodsId() {
        HashSet<Long> idSet = new HashSet<Long>();
        HashSet<Long> ids = new HashSet<Long>();
        FormShowParameter param = this.getView().getFormShowParameter();
        String idStr = null;
        if (param.getCustomParams().containsKey("goodid")) {
            idStr = (String)param.getCustomParam("goodid");
        }
        if (idStr != null && !idStr.isEmpty()) {
            DynamicObject[] goods;
            String[] idsArray;
            for (String str : idsArray = idStr.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)str)) continue;
                ids.add(Long.valueOf(str));
            }
            for (DynamicObject good : goods = this.getGoodsByIds(ids)) {
                String[] surchanges;
                for (String surd : surchanges = good.getString(surchargeid).split(",")) {
                    if (!StringUtils.isNotEmpty((CharSequence)surd)) continue;
                    idSet.add(Long.valueOf(surd));
                }
            }
        }
        return idSet;
    }

    private String assembleSelectProdFilds() {
        String selectFields = "id,number,project.id,project.number,project.name,cost,maxcost,remark,supplier.id,supplier.name,supplier.number";
        return selectFields;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemkey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (itemkey = args.getOperateKey()) {
            case "confirm": {
                this.confirmOperate();
                break;
            }
        }
    }

    private void confirmOperate() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String operate = (String)param.getCustomParam("operate");
        if (!this.checkSelct()) {
            return;
        }
        String idStr = (String)param.getCustomParam("goodid");
        String[] idsArray = idStr.split(",");
        HashSet<Long> ids = new HashSet<Long>(idsArray.length * 2);
        for (String id : idsArray) {
            ids.add(Long.valueOf(id));
        }
        DynamicObject[] goods = this.getGoodsByIds(ids);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectrows = grid.getEntryState().getSelectedRows();
        String[] surchargeids = new String[selectrows.length];
        String[] surchargenames = new String[selectrows.length];
        String[] surchargeamounts = new String[selectrows.length];
        for (int i = 0; i < selectrows.length; ++i) {
            DynamicObject prod = this.getModel().getEntryRowEntity(ENTRY_ENTITY, selectrows[i]);
            DynamicObject surc = prod.getDynamicObject("number");
            String prodId = surc.getPkValue().toString();
            String name = surc.getDynamicObject("project").getString("name");
            String cost = surc.getString("cost");
            surchargeids[i] = prodId;
            surchargenames[i] = name;
            surchargeamounts[i] = cost;
        }
        if ("allot".equals(operate)) {
            this.allot(goods, surchargeids, surchargenames, surchargeamounts);
        } else {
            this.unallot(goods, surchargeids, surchargenames, surchargeamounts);
        }
    }

    public void unallot(DynamicObject[] goods, String[] surchargeids, String[] surchargenames, String[] surchargeamounts) {
        StringBuffer idStr = null;
        StringBuffer nameStr = null;
        StringBuffer amountStr = null;
        HashSet<Integer> indexSet = null;
        int index = 0;
        for (int i = 0; i < goods.length; ++i) {
            int j;
            idStr = new StringBuffer();
            nameStr = new StringBuffer();
            amountStr = new StringBuffer();
            indexSet = new HashSet<Integer>();
            idStr.append(goods[i].getString(surchargeid));
            nameStr.append(goods[i].getString(surchargename));
            amountStr.append(goods[i].getString(surchargeamount));
            String[] ids = goods[i].getString(surchargeid).split(",");
            String[] names = goods[i].getString(surchargename).split(",");
            String[] amounts = goods[i].getString(surchargeamount).split(",");
            for (j = 0; j < surchargeids.length; ++j) {
                if (!idStr.toString().contains(surchargeids[j])) continue;
                index = this.getIndex(ids, surchargeids[j]);
                indexSet.add(index);
            }
            idStr.setLength(0);
            nameStr.setLength(0);
            amountStr.setLength(0);
            for (j = 0; j < ids.length; ++j) {
                if (indexSet.contains(j)) continue;
                if (amounts[j].length() >= 1) {
                    BigDecimal amount = new BigDecimal(amounts[j].substring(1));
                    String amo = String.valueOf(amount.setScale(2, 4));
                    amountStr.append('\uffe5').append(amo).append(',');
                }
                idStr.append(ids[j]).append(',');
                nameStr.append(names[j]).append(',');
            }
            goods[i].set(surchargeid, (Object)(idStr.length() == 0 ? idStr : idStr.toString().substring(0, idStr.toString().length() - 1)));
            goods[i].set(surchargename, (Object)(nameStr.length() == 0 ? nameStr : nameStr.toString().substring(0, nameStr.toString().length() - 1)));
            goods[i].set(surchargeamount, (Object)(amountStr.length() == 0 ? amountStr : amountStr.toString().substring(0, amountStr.toString().length() - 1)));
        }
        SaveServiceHelper.save((IDataEntityType)goods[0].getDataEntityType(), (Object[])goods);
        HashMap<String, String> isSuccess = new HashMap<String, String>();
        isSuccess.put("success", "true");
        this.getView().returnDataToParent(isSuccess);
        this.getView().close();
    }

    public int getIndex(String[] array, String str) {
        int index = array.length + 1;
        for (int i = array.length - 1; i >= 0; --i) {
            if (!str.equals(array[i])) continue;
            return i;
        }
        return index;
    }

    public void allot(DynamicObject[] goods, String[] surchargeids, String[] surchargenames, String[] surchargeamounts) {
        StringBuilder idStr = null;
        StringBuilder nameStr = null;
        StringBuilder amountStr = null;
        for (int i = 0; i < goods.length; ++i) {
            idStr = new StringBuilder();
            nameStr = new StringBuilder();
            amountStr = new StringBuilder();
            idStr.append(goods[i].getString(surchargeid));
            nameStr.append(goods[i].getString(surchargename));
            amountStr.append(goods[i].getString(surchargeamount));
            if (idStr.length() > 0) {
                idStr.append(',');
                nameStr.append(',');
                amountStr.append(',');
            }
            for (int j = 0; j < surchargeids.length; ++j) {
                if (idStr.toString().contains(surchargeids[j])) continue;
                idStr.append(surchargeids[j]).append(',');
                BigDecimal amount = new BigDecimal(surchargeamounts[j]);
                String amo = String.valueOf(amount.setScale(2, 4));
                nameStr.append(surchargenames[j]).append(',');
                amountStr.append('\uffe5').append(amo).append(',');
            }
            if (idStr.length() > 255) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u9644\u52a0\u8d39\u65b9\u6848ID\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u8fc7\u9650\u5b9a\u8303\u56f4\uff1a0\u2264\u957f\u5ea6\u2264255\u3002", (String)"EntProdManageAllotPlugin_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return;
            }
            if (nameStr.length() > 255) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u9644\u52a0\u8d39\u65b9\u6848\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u8fc7\u9650\u5b9a\u8303\u56f4\uff1a0\u2264\u957f\u5ea6\u2264255\u3002", (String)"EntProdManageAllotPlugin_2", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return;
            }
            if (amountStr.length() > 255) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u9644\u52a0\u8d39\u91d1\u989d\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u8fc7\u9650\u5b9a\u8303\u56f4\uff1a0\u2264\u957f\u5ea6\u2264255\u3002", (String)"EntProdManageAllotPlugin_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return;
            }
            goods[i].set(surchargeid, (Object)idStr.toString().substring(0, idStr.toString().length() - 1));
            goods[i].set(surchargename, (Object)nameStr.toString().substring(0, nameStr.toString().length() - 1));
            goods[i].set(surchargeamount, (Object)amountStr.toString().substring(0, amountStr.toString().length() - 1));
        }
        SaveServiceHelper.save((IDataEntityType)goods[0].getDataEntityType(), (Object[])goods);
        HashMap<String, String> isSuccess = new HashMap<String, String>();
        isSuccess.put("success", "true");
        this.getView().returnDataToParent(isSuccess);
        this.getView().close();
    }

    public DynamicObject[] getGoodsByIds(Set<Long> ids) {
        QFilter prodfilter = new QFilter("id", "in", ids);
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"id,number,surchargename,surchargeid,surchargeamount", (QFilter[])new QFilter[]{prodfilter});
        return prodArray;
    }

    public boolean checkSelct() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectrows = grid.getEntryState().getSelectedRows();
        if (null == selectrows || selectrows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u79cd\u9644\u52a0\u8d39\u65b9\u6848\u3002", (String)"EntProdManageAllotPlugin_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

