/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.OrgUtil;

public class EntOrgSelectEdit
extends AbstractFormPlugin
implements EntryGridBindDataListener,
SearchEnterListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String SEARCHTEXT = "searchtext";
    private static final String SEARCHFIELDS = "searchfields";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{KEY_ENTRYENTITY});
        Button bt = (Button)this.getControl("btnok");
        bt.addClickListener((ClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!kd.bos.util.StringUtils.isEmpty((String)formShowParameter.getCaption())) {
            Label labelap = (Label)this.getControl("labelap");
            labelap.setText(formShowParameter.getCaption());
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String orgType = (String)formShowParameter.getCustomParam("orgType");
        String orgIds = (String)formShowParameter.getCustomParam("orgIds");
        if (kd.bos.util.StringUtils.isEmpty((String)orgType)) {
            return;
        }
        switch (orgType) {
            case "purorg": {
                List purOrgIds = OrgUtil.getUserHasAllPurPermissionOrgs();
                if (null != orgIds) {
                    purOrgIds = (List)SerializationUtils.fromJsonString((String)orgIds, List.class);
                }
                this.fillEntryData(purOrgIds, this.getSearchFilterDetail(), e);
                break;
            }
        }
    }

    private void fillEntryData(List<Long> ids, QFilter qFilter, EntryGridBindDataEvent e) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY);
        QFilter filter = new QFilter("id", "in", ids);
        filter.and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        if (qFilter != null) {
            filter.and(qFilter);
        }
        DynamicObjectCollection purorgs = QueryServiceHelper.query((String)"bos_org", (String)"number,name,id,enable,status,orgpattern.name orgpattern", (QFilter[])new QFilter[]{filter}, (String)"number");
        int dataSize = purorgs.size();
        int startIndex = (grid.getEntryState().getCurrentPageIndex() - 1) * grid.getEntryState().getPageRows();
        int endIndex = Math.min(startIndex + grid.getPageRow(), dataSize);
        ArrayList<DynamicObject> allBillList = new ArrayList<DynamicObject>(purorgs.size());
        int index = 0;
        for (DynamicObject org : purorgs) {
            DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
            rowObj.set("seq", (Object)index);
            rowObj.set("number", org.get("number"));
            rowObj.set("name", org.get("name"));
            rowObj.set("orgid", org.get("id"));
            rowObj.set("orgpattern", org.get("orgpattern"));
            allBillList.add(rowObj);
            ++index;
        }
        DynamicObject[] allBills = allBillList.toArray(new DynamicObject[0]);
        this.getModel().getDataEntity().getDynamicObjectCollection(KEY_ENTRYENTITY).clear();
        this.getModel().getDataEntity().getDynamicObjectCollection(KEY_ENTRYENTITY).addAll(allBillList);
        this.getModel().getDataEntity().getDynamicObjectCollection(KEY_ENTRYENTITY).setStartRowIndex(startIndex);
        ((EntryInfo)this.getModel().getDataEntity().getDataEntityState().getEntryInfos().get(KEY_ENTRYENTITY)).setRowCount(allBillList.size());
        ((EntryInfo)this.getModel().getDataEntity().getDataEntityState().getEntryInfos().get(KEY_ENTRYENTITY)).setPageSize(allBillList.size());
        DynamicObject[] dataEntitys = Arrays.copyOfRange(allBills, startIndex, endIndex);
        ArrayList<RowDataEntity> objs = new ArrayList<RowDataEntity>(10);
        ArrayList<List> rows = new ArrayList<List>(10);
        int entryPageSize = grid.getEntryState().getPageRows();
        if (dataEntitys != null && dataEntitys.length > 0) {
            for (int rowIndex = 0; rowIndex < endIndex - startIndex; ++rowIndex) {
                objs.add(new RowDataEntity(rowIndex + startIndex, dataEntitys[rowIndex]));
            }
            if (grid.getRuleCount() > 0) {
                RuleContainer ruleContainer = (RuleContainer)this.getView().getService(RuleContainer.class);
                ruleContainer.raise(new RaiseEventSource(RaiseEventType.Initialized, objs, (IDataEntityType)entityType), (RuleExecuteContext)new FormRuleExecuteContext(this.getView()));
            }
            for (RowDataEntity obj : objs) {
                BindingContext bindCtx = new BindingContext((IDataEntityType)entityType, obj.getDataEntity(), obj.getRowIndex());
                rows.add(grid.getRowBindValue(bindCtx));
            }
        }
        e.getData().put("rowcount", dataSize);
        e.getData().put("rows", rows);
        e.getData().put("pagecount", dataSize / entryPageSize + 1);
        e.getData().put("datacount", dataSize);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchtext = searchEnterEvent.getText();
        List searchFields = searchEnterEvent.getSearchFields();
        this.getView().getPageCache().put(SEARCHTEXT, searchtext);
        if (StringUtils.isNotBlank((CharSequence)searchtext) && searchFields != null) {
            String searchfields = SerializationUtils.toJsonString((Object)searchFields);
            this.getView().getPageCache().put(SEARCHFIELDS, searchfields);
        }
        this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRYENTITY).clear();
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("confirm".equals(formOperate.getOperateKey())) {
            this.setReturnDataToParent();
        }
    }

    private void setReturnDataToParent() {
        HashMap returnData = new HashMap();
        EntryGrid entryentity = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] selectRows = entryentity.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"EntOrgSelectEdit_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entrydata = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<String> orgIdList = new ArrayList<String>(selectRows.length);
        for (int i : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entrydata.get(i);
            orgIdList.add(dynamicObject.getString("orgid"));
        }
        returnData.put("orgIdList", orgIdList);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private QFilter getSearchFilterDetail() {
        String searchText = this.getView().getPageCache().get(SEARCHTEXT);
        String searchFieldsStr = this.getView().getPageCache().get(SEARCHFIELDS);
        List<Map<String, Object>> searchFields = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)searchText) && StringUtils.isNotBlank((CharSequence)searchFieldsStr)) {
            searchFields = this.deSerializeSearchFields(searchFieldsStr);
        }
        return this.getSearchFilterDetail(searchText, searchFields);
    }

    private List<Map<String, Object>> deSerializeSearchFields(String fieldsStr) {
        if (StringUtils.isBlank((CharSequence)fieldsStr)) {
            return null;
        }
        return (List)SerializationUtils.fromJsonString((String)fieldsStr, ArrayList.class);
    }

    private QFilter getSearchFilterDetail(String searchText, List<Map<String, Object>> searchFields) {
        QFilter qf = null;
        if (StringUtils.isNotBlank((CharSequence)searchText) && searchFields != null) {
            HashMap filterMap = new HashMap(16);
            for (Map<String, Object> searchField : searchFields) {
                List fieldNames = (List)searchField.get("fieldName");
                List values = (List)searchField.get("value");
                for (String fieldName : fieldNames) {
                    HashSet<String> fieldNameSet = (HashSet<String>)filterMap.get(fieldName);
                    if (fieldNameSet == null) {
                        fieldNameSet = new HashSet<String>(16);
                    }
                    for (String fieldValue : values) {
                        fieldNameSet.add(fieldValue);
                    }
                    filterMap.put(fieldName, fieldNameSet);
                }
            }
            Set entries = filterMap.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                Set value = (Set)entry.getValue();
                if (qf == null) {
                    qf = EntOrgSelectEdit.getSearchFilterDetail(value, key);
                    continue;
                }
                qf.or(EntOrgSelectEdit.getSearchFilterDetail(value, key));
            }
        }
        return qf;
    }

    private static QFilter getSearchFilterDetail(Set<String> orgFilters, String name) {
        QFilter ofilter = null;
        if (CollectionUtils.isEmpty(orgFilters)) {
            return ofilter;
        }
        for (String filter : orgFilters) {
            if (ofilter == null) {
                ofilter = new QFilter(name, "like", (Object)("%" + filter + "%"));
                continue;
            }
            ofilter.or(new QFilter(name, "like", (Object)("%" + filter + "%")));
        }
        return ofilter;
    }
}

