/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class EntPackageSelectionEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit goodsEdit = (BasedataEdit)this.getControl("goods");
        goodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplierComponent = (BasedataEdit)this.getControl("headsupplier");
        supplierComponent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"goods")) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            showParameter.setMultiSelect(true);
            qFilters.clear();
            if (this.getModel().getValue("createorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba1\u6279\u5355\u4f4d\u3002", (String)"EntPackageSelectionEdit_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("source", "=", (Object)"1"));
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            if (this.getModel().getValue("headsupplier") != null) {
                qFilters.add(new QFilter("supplier.id", "=", ((DynamicObject)this.getModel().getValue("headsupplier")).getPkValue()));
            }
            this.setF7OpenStyle(showParameter);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"headsupplier")) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            this.setSupplierFilter(showParameter);
        }
    }

    private void setSupplierFilter(ListShowParameter showParameter) {
        List filterList = showParameter.getListFilterParameter().getQFilters();
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        QFilter supQFilter = new QFilter("id", "in", (Object)supIdList);
        filterList.add(supQFilter);
    }

    private void setF7OpenStyle(ListShowParameter showParameter) {
        showParameter.setCustomParam("ismergerows", (Object)true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1152px");
        styleCss.setHeight("696px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        HashSet<String> hideFields = new HashSet<String>(8);
        hideFields.add("status");
        hideFields.add("prodmatmappingstatus");
        hideFields.add("protocol.effectdate");
        hideFields.add("protocol.invaliddate");
        showParameter.setCustomParam("hideFields", (Object)SerializationUtils.toJsonString(hideFields));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        if ("goods".equals(property)) {
            for (ChangeData data : changedData) {
                int rowIndex = data.getRowIndex();
                if (data.getNewValue() == null) {
                    return;
                }
                this.getModel().setValue("qty", (Object)BigDecimal.ONE, rowIndex);
                DynamicObject headsupplier = (DynamicObject)this.getModel().getValue("headsupplier");
                if (headsupplier == null) continue;
                this.getModel().setValue("goodssupplier", (Object)headsupplier.getString("name"));
            }
        } else if ("headsupplier".equals(property)) {
            DynamicObject oldValue = (DynamicObject)changedData[0].getOldValue();
            DynamicObject newValue = (DynamicObject)changedData[0].getNewValue();
            if (newValue != null && oldValue != null && !oldValue.getPkValue().equals(newValue.getPkValue())) {
                this.getPageCache().put("headsupplier", oldValue.getPkValue().toString());
                String msg = ResManager.loadKDString((String)"\u5207\u6362\u6240\u5c5e\u5546\u5bb6\uff0c\u5c06\u81ea\u52a8\u6e05\u7a7a\u5546\u54c1\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EntPackageSelectionEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("changesupplier"));
            }
        } else if ("isprimary".equals(property)) {
            for (ChangeData data : changedData) {
                boolean isprimary;
                if (data.getNewValue() == null || !(isprimary = Boolean.parseBoolean(data.getNewValue().toString()))) continue;
                this.getModel().beginInit();
                int rowcount = this.getModel().getEntryEntity("entryentity").size();
                int rowIndex = data.getRowIndex();
                for (int i = 0; i < rowcount; ++i) {
                    if (i == rowIndex) continue;
                    this.getModel().setValue("isprimary", (Object)false, i);
                }
                this.getModel().endInit();
            }
            this.getView().updateView("entryentity");
        } else if ("qty".equals(property)) {
            for (ChangeData data : changedData) {
                BigDecimal qty = BigDecimal.ONE;
                int rowIndex = data.getRowIndex();
                if (data.getNewValue() != null) {
                    qty = new BigDecimal(data.getNewValue().toString());
                    qty = qty.setScale(0, 5);
                }
                this.getModel().beginInit();
                this.getModel().setValue("qty", (Object)qty, rowIndex);
                this.getModel().endInit();
            }
            this.getView().updateView("entryentity");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("changesupplier".equals(e.getCallBackId())) {
            if ("Yes".equals(e.getResultValue())) {
                this.doSupplierChange(this.getModel().getValue("headsupplier"));
            } else {
                String oldValue = this.getPageCache().get("headsupplier");
                if (oldValue != null) {
                    this.getModel().beginInit();
                    this.getModel().setValue("headsupplier", (Object)Long.parseLong(oldValue.toString()));
                    this.getModel().endInit();
                    this.getPageCache().remove("headsupplier");
                    this.getView().updateView("headsupplier");
                }
            }
        }
    }

    private void doSupplierChange(Object newVal) {
        if (newVal == null) {
            return;
        }
        DynamicObject supplier = (DynamicObject)newVal;
        this.setOrgBySupplier(supplier);
        this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").clear();
        this.getView().updateView("entryentity");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String supplierPrt = (String)showParameter.getCustomParam("cur_supplier");
        if (Objects.nonNull(supplierPrt)) {
            this.doDefaultValue();
        } else {
            List<Long> supIdList = this.getSupplierByUserOfBizPartner();
            if (supIdList != null && supIdList.size() >= 1) {
                model.setValue("headsupplier", (Object)supIdList.get(0));
            }
            model.setValue("isprimary", (Object)true, 0);
            DynamicObject supplier = (DynamicObject)model.getValue("headsupplier");
            this.setOrgBySupplier(supplier);
        }
    }

    private void doDefaultValue() {
        this.getModel().beginInit();
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String supplierPrtstr = (String)showParameter.getCustomParam("cur_supplier");
        String cur_suppliername = (String)showParameter.getCustomParam("cur_suppliername");
        long supplierPrt = Long.parseLong(supplierPrtstr);
        String allprodids = (String)showParameter.getCustomParam("allprodids");
        model.setValue("headsupplier", (Object)supplierPrt);
        String[] prodids = allprodids.split(",");
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(allprodids.length());
        for (String prodIdStr : prodids) {
            Long prodId = Long.parseLong(prodIdStr);
            selfGoodsIds.add(prodId);
        }
        Map<Long, DynamicObject> goodsMap = this.getGoodsMap(selfGoodsIds);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        this.getModel().deleteEntryData("entryentity");
        DynamicObject goods = null;
        for (Map.Entry<Long, DynamicObject> goodsEntry : goodsMap.entrySet()) {
            goods = goodsEntry.getValue();
            vs.addField("isprimary", new Object[]{false});
            vs.addField("source", new Object[]{"pmm_prodmanage"});
            vs.addField("goodssupplier", new Object[]{cur_suppliername});
            vs.addField("goods", new Object[]{goods.getLong("id")});
            vs.addField("unit", new Object[]{goods.getLong("unitid")});
        }
        ((AbstractFormDataModel)model).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getPageCache().remove("cur_supplier");
        this.getPageCache().remove("cur_suppliername");
        this.getPageCache().remove("allprodids");
    }

    private Map<Long, DynamicObject> getGoodsMap(List<Long> selfGoodsIds) {
        HashMap<Long, DynamicObject> goodsMap = new HashMap<Long, DynamicObject>(64);
        if (!selfGoodsIds.isEmpty()) {
            DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,name,model,unit.id unitid,unit.name unitname,supplier.name suppliername,thumbnail,shopprice ", (QFilter[])new QFilter[]{new QFilter("id", "in", selfGoodsIds)});
            for (DynamicObject selfGoodsEntry : selfGoodsEntryCol) {
                goodsMap.put(selfGoodsEntry.getLong("id"), selfGoodsEntry);
            }
        }
        return goodsMap;
    }

    private List<Long> getSupplierByUserOfBizPartner() {
        return BizPartnerUtil.getSupplierByUserOfBizPartner();
    }

    private void setOrgBySupplier(DynamicObject supplier) {
        DynamicObject orgDyn;
        String appId = AppMetadataCache.getAppInfo((String)"ent").getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)UserServiceHelper.getCurrentUserId(), (String)"02", (boolean)true, (String)appId, (String)"ent_packageselection", (String)"47156aff000000ac");
        List purOrgIds = hasPermOrgResult.getHasPermOrgs();
        long createorg = supplier.getLong("createorg_id");
        if (this.getPageCache().get("newOrgValue") != null) {
            createorg = Long.parseLong(this.getPageCache().get("newOrgValue"));
        }
        if (purOrgIds.contains(createorg) && (orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fispurchase", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)createorg)})).getBoolean("fispurchase")) {
            this.getModel().setValue("createorg", (Object)createorg);
            String ctrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)"pmm_packageselection", (String)String.valueOf(createorg));
            this.getModel().setValue("ctrlstrategy", (Object)ctrlStrgy);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

