/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.ent.common.plugin.AbstractEntBillPlugIn;

public class EntPriceManageEdit
extends AbstractEntBillPlugIn {
    private boolean flag = false;
    private String PRICE = "price";
    private String TAXPRICE = "taxprice";
    private String TAXRATE = "taxrate";
    private String TAXTYPE = "taxtype";
    private BigDecimal ZERO = BigDecimal.ZERO;

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.flag) {
            this.flag = true;
            return;
        }
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propertyName) {
            case "price": {
                this.calTaxPriceByPrice(model);
                break;
            }
            case "taxprice": {
                this.calPriceByTaxPrice(model);
                break;
            }
            case "taxrate": {
                this.calPriceByTaxPrice(model);
            }
        }
    }

    public void calPriceByTaxPrice(IDataModel model) {
        String taxType = (String)model.getValue(this.TAXTYPE);
        BigDecimal taxPrice = null == model.getValue(this.TAXPRICE) ? this.ZERO : (BigDecimal)model.getValue(this.TAXPRICE);
        BigDecimal taxRate = null == model.getValue(this.TAXRATE) ? this.ZERO : (BigDecimal)model.getValue(this.TAXRATE);
        int scale = this.getPricePrecision(model);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        this.flag = true;
        model.setValue(this.PRICE, (Object)price);
    }

    public void calTaxPriceByPrice(IDataModel model) {
        BigDecimal price = null == model.getValue(this.PRICE) ? this.ZERO : (BigDecimal)model.getValue(this.PRICE);
        BigDecimal taxRate = null == model.getValue(this.TAXRATE) ? this.ZERO : (BigDecimal)model.getValue(this.TAXRATE);
        int scale = this.getPricePrecision(model);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        this.flag = true;
        model.setValue(this.TAXPRICE, (Object)taxPrice);
    }

    protected int getPricePrecision(IDataModel datamodel) {
        int pricePrecision = 6;
        Object currency = datamodel.getValue("curr");
        if (null != currency && currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            pricePrecision = curr.getInt("priceprecision");
        }
        return pricePrecision;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseModel model = (BaseModel)this.getModel();
        String prodid = model.getDataEntity().getPkValue().toString();
        String selectFields = "id,org,cfmdate,entryentity,entryentity.goods,entryentity.taxprice_old,entryentity.shopprice_old,entryentity.taxprice,entryentity.shopprice,entryentity.note";
        QFilter idfilter = new QFilter("entryentity.goods", "=", (Object)Long.valueOf(prodid));
        QFilter statusfilter = new QFilter("cfmstatus", "=", (Object)"B");
        QFilter[] filters = new QFilter[]{idfilter, statusfilter};
        String orderBys = "cfmdate desc";
        DynamicObject[] adjustPriceCol = BusinessDataServiceHelper.load((String)"pmm_priceaudit", (String)selectFields, (QFilter[])filters, (String)orderBys);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int row = 0;
        for (DynamicObject adjustPrice : adjustPriceCol) {
            DynamicObjectCollection entries = adjustPrice.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject prod = entry.getDynamicObject("goods");
                if (!prodid.equals(prod.getPkValue().toString())) continue;
                BigDecimal taxprice = entry.getBigDecimal("taxprice");
                BigDecimal oldtaxprice = entry.getBigDecimal("taxprice_old");
                BigDecimal shopprice = entry.getBigDecimal("shopprice");
                BigDecimal oldshopprice = entry.getBigDecimal("shopprice_old");
                String note = entry.getString("note");
                DynamicObject org = adjustPrice.getDynamicObject("org");
                Date adjustdate = adjustPrice.getDate("cfmdate");
                vs.set("seq", (Object)(row + 1), row);
                vs.set("taxprice_old", (Object)oldtaxprice, row);
                vs.set("shopprice_old", (Object)oldshopprice, row);
                vs.set("taxprice_new", (Object)taxprice, row);
                vs.set("shopprice_new", (Object)shopprice, row);
                vs.set("adjustdate", (Object)adjustdate, row);
                vs.set("note", (Object)note, row);
                vs.set("auditorg", org.getPkValue(), row);
                ++row;
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
    }
}

