/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.ent.formplugin.edit.EntProdManageEdit;
import kd.scm.malcore.util.prodinfochange.MalProdInfoChangeUtil;

public class EntProdInfoChangeEdit
extends EntProdManageEdit
implements BeforeF7SelectListener {
    private static final String RICHTEXTEDITORAP = "richtexteditorap";
    private static final String RICHTEXTEDITORAP1 = "richtexteditorap1";
    private static final String INFO_CHANGE_CONFIRM = "infoChangeConfirm";

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object hasOrder = customParams.get("hasOrder");
        if ("true".equals(hasOrder)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "model", "taxrateid", RICHTEXTEDITORAP, "prodattribute", "prodattributevalue", "attributeremark", RICHTEXTEDITORAP1, "packinglist", "guarantee", "btnaddrow", "btndelrow"});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "create": {
                this.withSave(model, args);
            }
        }
    }

    private void withSave(IDataModel model, BeforeDoOperationEventArgs args) {
        if (!this.checkValid()) {
            args.setCancel(true);
            return;
        }
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITORAP);
        String text = richTextEditor.getText();
        model.setValue("content_tag", (Object)text);
        model.setValue("content", (Object)"");
        RichTextEditor richTextEditor1 = (RichTextEditor)this.getControl(RICHTEXTEDITORAP1);
        String text1 = richTextEditor1.getText();
        model.setValue("specification_tag", (Object)text1);
        model.setValue("specification", (Object)"");
    }

    private boolean checkValid() {
        Long prodId = (Long)this.getModel().getValue("id");
        QFilter prodQFilter = new QFilter("id", "=", (Object)prodId);
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,status", (QFilter[])prodQFilter.toArray());
        for (DynamicObject prod : prods) {
            String status = prod.getString("status");
            if (BillStatusEnum.AUDIT.getVal().equals(status)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"EntProdInfoChangeEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("create") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Long prodId = (Long)this.getModel().getValue("id");
            QFilter qFilter = new QFilter("prod", "=", (Object)prodId);
            qFilter.and(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()));
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getVal()));
            DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"ent_prodchange_manage", (String)"id,prod,oldthumbnail,thumbnail,oldpicture1,picture1,oldpicture2,picture2,oldpicture3,picture3,oldpicture4,picture4,entryentity.oldvalue,entryentity.newvalue,entryentity.fieldname,entryentity.srcdata,entryentity.entryname,entryentity.srcbillentryid", (QFilter[])qFilter.toArray(), (String)"createtime desc", (int)1);
            if (dynamicObject.length == 0) {
                return;
            }
            DynamicObject prodChgDyn = dynamicObject[0];
            if (MalProdInfoChangeUtil.checkAttributeChangeInfluenceSPU((DynamicObject)prodChgDyn)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u5185\u5bb9\u6d89\u53caSPU\u4fe1\u606f\uff0c\u53d8\u66f4\u540e\u5c06\u6e05\u7a7a\u5173\u8054SPU\uff0c\u8bf7\u77e5\u6089\u3002", (String)"EntProdInfoChangeEdit_3", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(INFO_CHANGE_CONFIRM, (IFormPlugin)this));
                this.getPageCache().put("prodChangeId", prodChgDyn.getString("id"));
            } else {
                OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"ent_prodchange_manage", (Object)prodChgDyn.getLong("id"), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                this.getView().close();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (INFO_CHANGE_CONFIRM.equals(callBackId)) {
            Long prodChangeId = Long.valueOf(this.getPageCache().get("prodChangeId"));
            if (messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
                HashMap paramMap = new HashMap();
                OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"ent_prodchange_manage", (Object)prodChangeId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, paramMap, null);
                this.getView().close();
            } else {
                DeleteServiceHelper.delete((String)"ent_prodchange_manage", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)prodChangeId)});
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

