/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.common.util.BaseDataViewDetailUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.common.util.ValidateDataUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.ent.common.plugin.AbstractEntBillPlugIn;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.util.MalFuzzySearchUtil;

public class EntProdRequestEdit
extends AbstractEntBillPlugIn
implements HyperLinkClickListener,
RowClickEventListener,
BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static Log log = LogFactory.getLog(EntProdRequestEdit.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ORG = "org";
    private static final String SUPPLIER = "supplier";
    private static final String BIZPARTER = "bizpartner";
    private static final String PROD_SEQ = "seq";
    private static final String PROD_NUMBER = "goods";
    private static final String PROD_CLASS = "class";
    private static final String PROD_UNIT = "unit";
    private static final String PROD_PRICE = "price";
    private static final String PROD_TAXPRICE = "taxprice";
    private static final String PROD_SHOPPRICE = "shopprice";
    private static final String PROD_TAXRATE = "taxrate";
    private static final String PROD_MALLSTATUS = "mallstatus";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String PRICEEFFECTDATE = "priceeffectdate";
    private static final String PRICEINVALIDDATE = "priceinvaliddate";
    private static final String BIZTYPE_UPLOAD = "1";
    private static final String BIZTYPE_DOWNLOAD = "2";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u67b6\u7533\u8bf7", (String)"EntProdRequestEdit_25", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        String param;
        super.afterBindData(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_export", "protocolid", "protocolentry", "proentryseq", "material", "materialname", "proprice", "protaxrate", "protaxprice", "promodel", "prounit", "auxpty", PRICEEFFECTDATE, PRICEINVALIDDATE, "advconbaritemap", "leadtime", "minorderqty", "barcode", "purorgnap"});
            this.getView().setEnable(Boolean.FALSE, new String[]{ORG});
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (null == this.getModel().getValue("protocolid") || model.getValue("biztype").equals(BIZTYPE_DOWNLOAD)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
        }
        this.setMustInput(model);
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        if (protocol != null) {
            Date protocolEffectDate = protocol.getDate("effectdate");
            Date protocolInvalidDate = protocol.getDate("invaliddate");
            this.getPageCache().put("protocolEffectDate", DateUtil.date2str((Date)protocolEffectDate, (String)YYYY_MM_DD));
            this.getPageCache().put("protocolInvalidDate", DateUtil.date2str((Date)protocolInvalidDate, (String)YYYY_MM_DD));
        }
        if (Boolean.parseBoolean(param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pricetype", "ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pricetype", "ladderprice"});
        }
        this.setEntryValueByGoods();
        String biztype = (String)this.getModel().getValue("biztype");
        if (BIZTYPE_DOWNLOAD.equals(biztype)) {
            this.downloadView();
        }
        this.setBtnStatusByProtocolDiff();
        Object cfmstatus = this.getModel().getValue("cfmstatus");
        if ("C".equals(cfmstatus) || "D".equals(cfmstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"resubmit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"resubmit"});
        }
    }

    private void setBtnStatusByProtocolDiff() {
        String biztype = (String)this.getModel().getValue("biztype");
        DynamicObject protocolid = this.getModel().getDataEntity(true).getDynamicObject("protocolid");
        if (null == protocolid || !protocolid.getBoolean("differentarea")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purplan"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"proentryseq", "newentry", "deleteentry"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"proentryseq"});
            if (BIZTYPE_DOWNLOAD.equals(biztype) && protocolid.getBoolean("differentarea")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"newentry", "deleteentry"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"purplan"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"purplan"});
            }
        }
    }

    private void downloadView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_export", "quickcreategoods", "bar_import", "bar_refresh", "advconbaritemap"});
        this.getView().setEnable(Boolean.FALSE, new String[]{ORG, "protocolid"});
        this.getView().setEnable(Boolean.FALSE, -1, new String[]{PRICEEFFECTDATE, PRICEINVALIDDATE, PROD_CLASS, "pricetype", PROD_TAXPRICE, "minorderqty", "leadtime"});
    }

    private void setPriceEffectDefaultValue() {
        this.setProtocolEffectDefaultValue();
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        List<Long> goodsIds = entryEntity.stream().filter(entry -> entry.getDynamicObject(PROD_NUMBER) != null).map(entry -> entry.getDynamicObject(PROD_NUMBER).getLong("id")).collect(Collectors.toList());
        this.setGoodsEffectDateToEntry(goodsIds);
    }

    private void setProtocolEffectDefaultValue() {
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        if (protocol == null) {
            return;
        }
        Date protocolEffectDate = protocol.getDate("effectdate");
        Date protocolInvalidDate = protocol.getDate("invaliddate");
        this.getPageCache().put("protocolEffectDate", DateUtil.date2str((Date)protocolEffectDate, (String)YYYY_MM_DD));
        this.getPageCache().put("protocolInvalidDate", DateUtil.date2str((Date)protocolInvalidDate, (String)YYYY_MM_DD));
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        this.getModel().beginInit();
        for (DynamicObject entry : entryEntity) {
            if (entry.get(PROD_NUMBER) == null) continue;
            if (null == entry.getDate(PRICEEFFECTDATE)) {
                entry.set(PRICEEFFECTDATE, (Object)protocolEffectDate);
            }
            if (null != entry.getDate(PRICEINVALIDDATE)) continue;
            entry.set(PRICEINVALIDDATE, (Object)protocolInvalidDate);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setGoodsEffectDateToEntry(List<Long> goodsIds) {
        QFilter qFilter = new QFilter(PROD_NUMBER, "in", goodsIds);
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        if (protocol != null) {
            qFilter.and(new QFilter("protocol", "=", (Object)protocol.getLong("id")));
        } else {
            qFilter.and(new QFilter("protocol", "=", (Object)0L).or(new QFilter("protocol", "is null", (Object)0L)));
        }
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods,priceinvaliddate", (QFilter[])qFilter.toArray());
        HashMap prodAndDateMap = new HashMap(prodPools.size());
        prodPools.forEach(prod -> prodAndDateMap.put(prod.getLong(PROD_NUMBER), prod.getDate(PRICEINVALIDDATE)));
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        this.getModel().beginInit();
        for (DynamicObject entry : entryEntity) {
            long entryGoodsId = entry.getLong("goods_id");
            if (prodAndDateMap.get(entryGoodsId) == null) continue;
            Date addDays = DateUtil.addDays((Date)((Date)prodAndDateMap.get(entryGoodsId)), (int)1);
            entry.set(PRICEEFFECTDATE, (Object)addDays);
            Object priceInvalidDate = entry.get(PRICEINVALIDDATE);
            if (priceInvalidDate == null || !addDays.after((Date)priceInvalidDate)) continue;
            entry.set(PRICEEFFECTDATE, priceInvalidDate);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setEntryValueByGoods() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (int rowIndex = 0; rowIndex < entrys.size(); ++rowIndex) {
            DynamicObject entry = (DynamicObject)entrys.get(rowIndex);
            if (entry.get(PROD_NUMBER) != null) continue;
            model.setValue(PROD_PRICE, null, rowIndex);
            model.setValue(PROD_TAXPRICE, null, rowIndex);
            model.setValue(PROD_SHOPPRICE, null, rowIndex);
            model.setValue(PROD_CLASS, null, rowIndex);
            model.setValue(PROD_UNIT, null, rowIndex);
            model.setValue("barcode", null, rowIndex);
            if (null != model.getValue("protocolentry", rowIndex)) continue;
            model.setValue(PRICEEFFECTDATE, null, rowIndex);
            model.setValue(PRICEINVALIDDATE, null, rowIndex);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equalsIgnoreCase("bar_save") || itemKey.equalsIgnoreCase("bar_submit")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject protocolid = dataEntity.getDynamicObject("protocolid");
            if (null != protocolid && protocolid.getBoolean("differentarea")) {
                return;
            }
            if (!ValidateDataUtil.EntryDuplicateValidate((IFormView)this.getView(), (DynamicObjectCollection)this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY), (String)PROD_NUMBER)) {
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selectcol = (String)showParameter.getCustomParam("allProd");
        ArrayList allProd = StringConversionUtil.conversion((String)selectcol);
        String biztype = (String)showParameter.getCustomParam("biztype");
        if ("download".equals(biztype)) {
            model.setValue("biztype", (Object)BIZTYPE_DOWNLOAD);
        }
        String materialIdsJson = (String)showParameter.getCustomParam("materialIds");
        ArrayList materialIds = StringConversionUtil.conversion((String)materialIdsJson);
        Long protocolId = (Long)showParameter.getCustomParam("protocolId");
        if (null != protocolId) {
            model.setValue("protocolid", (Object)protocolId);
            DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
            this.getModel().setValue(ORG, (Object)protocol.getDynamicObject(ORG));
        } else {
            model.setValue("protocolid", null);
        }
        if (null != allProd && allProd.size() > 0) {
            model.deleteEntryData(ENTRY_ENTITY);
            if (null == protocolId) {
                this.setEntryData();
            } else {
                this.setProtocolProd(allProd);
            }
        } else if (null != materialIds && materialIds.size() > 0) {
            model.deleteEntryData(ENTRY_ENTITY);
            ArrayList<Long> list = new ArrayList<Long>(materialIds.size());
            for (String str : materialIds) {
                list.add(Long.parseLong(str));
            }
            HashMap<Long, Long> materiaId_goodMap = new HashMap<Long, Long>(1024);
            HashMap<String, Long> entry_goodMap = new HashMap<String, Long>();
            HashMap<String, DynamicObject> entry_bdMap = new HashMap<String, DynamicObject>();
            this.setGoodIds(materiaId_goodMap, list, entry_goodMap, entry_bdMap, String.valueOf(protocolId));
            this.setEntryProtocolData(list, entry_goodMap, entry_bdMap);
        }
        model.setValue("person", (Object)RequestContext.get().getUserId());
        this.setSupplierData(model);
        this.setOrgData(model);
        this.setQFilter(this.getModel().getDataEntity().getDynamicObject(SUPPLIER), this.getModel().getDataEntity().getDynamicObject(ORG));
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            model.setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
        this.setMustInput((IDataModel)model);
        this.setPriceEffectDefaultValue();
        this.setDefaultLadPrice();
        this.setPricelimit();
        if (this.getView().getParentView() != null && (Boolean.parseBoolean((String)AppCache.get((String)this.getView().getParentView().getPageId()).get("resubmit", String.class)) || Boolean.parseBoolean((String)AppCache.get((String)this.getView().getPageId()).get("resubmit", String.class)))) {
            AppCache.get((String)this.getView().getParentView().getPageId()).remove("resubmit");
            AppCache.get((String)this.getView().getPageId()).remove("resubmit");
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            ArrayList<Integer> indexs = new ArrayList<Integer>(entrys.size());
            for (DynamicObject row : entrys) {
                String entryresult = row.getString("entryresult");
                if (!BIZTYPE_UPLOAD.equals(entryresult)) continue;
                indexs.add(row.getInt(PROD_SEQ) - 1);
            }
            if (indexs.size() > 0) {
                int[] removeIndexs = new int[indexs.size()];
                for (int i = 0; i < indexs.size(); ++i) {
                    removeIndexs[i] = (Integer)indexs.get(i);
                }
                this.getPageCache().put("option", "resubmit");
                this.getModel().deleteEntryRows(ENTRY_ENTITY, removeIndexs);
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void setPricelimit() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (DynamicObject row : entryCols) {
            DynamicObject goods = row.getDynamicObject(PROD_NUMBER);
            if (null == goods) continue;
            String mallstatus = goods.getString(PROD_MALLSTATUS);
            if (MallStatusEnum.TEMPSTATUS.getVal().equals(mallstatus)) continue;
            goodsIds.add(goods.getLong("id"));
        }
        Map<String, DynamicObject> prodPoolMap = this.getProPoolMap(goodsIds);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        for (DynamicObject row : entryCols) {
            DynamicObject goods = row.getDynamicObject(PROD_NUMBER);
            BigDecimal reqTaxPrice = row.getBigDecimal(PROD_TAXPRICE);
            this.setPricelimitValue(goods, row.getInt(PROD_SEQ) - 1, reqTaxPrice, prodPoolMap, cellStyles);
        }
        if (cellStyles.size() > 0) {
            grid.setCellStyle(cellStyles);
        }
    }

    private Map<String, DynamicObject> getProPoolMap(Set<Long> goodsIds) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        HashMap<String, DynamicObject> prodPoolMap = new HashMap<String, DynamicObject>(16);
        String billstatus = dataEntity.getString("billstatus");
        if (goodsIds.size() > 0) {
            QFilter qFilter = new QFilter("goods.id", "in", goodsIds);
            DynamicObjectCollection ent_prodpools = QueryServiceHelper.query((String)"ent_prodpool", (String)"goods.id,id,taxprice,protocol,protocolentry", (QFilter[])qFilter.toArray());
            for (DynamicObject row : ent_prodpools) {
                String key = row.getString("goods.id") + row.getString("protocol") + row.getString("protocolentry");
                prodPoolMap.put(key, row);
            }
            if (!"A".equals(billstatus) && !"B".equals(billstatus)) {
                String id = dataEntity.getString("id");
                QFilter logQFilter = new QFilter("goods.id", "in", goodsIds);
                logQFilter.and(new QFilter("srcbillid", "=", (Object)id));
                DynamicObjectCollection newPricelog = QueryServiceHelper.query((String)"ent_newpricelog", (String)"adjustdate,goods.id,id,lastprice taxprice,goodspool.protocol protocol,goodspool.protocolentry protocolentry", (QFilter[])logQFilter.toArray(), (String)"adjustdate asc");
                for (DynamicObject row : newPricelog) {
                    String key = row.getString("goods.id") + row.getString("protocol") + row.getString("protocolentry");
                    prodPoolMap.put(key, row);
                }
            }
        }
        return prodPoolMap;
    }

    private void setPricelimitValue(DynamicObject goods, int seq, BigDecimal reqTaxPrice, Map<String, DynamicObject> prodPoolMap, ArrayList<CellStyle> cellStyles) {
        String protocolEntryId = "0";
        String protocolId = "0";
        BigDecimal hundred = new BigDecimal("100");
        BigDecimal divTaxPrice = BigDecimal.ZERO;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject protocol = dataEntity.getDynamicObject("protocolid");
        DynamicObject protocolentry = null;
        if (null != this.getModel().getValue("protocolentry", seq)) {
            protocolentry = (DynamicObject)this.getModel().getValue("protocolentry", seq);
            protocolEntryId = protocolentry.getString("id");
        }
        BigDecimal taxPrice = BigDecimal.ZERO;
        if (null != protocol) {
            protocolId = protocol.getString("id");
        }
        if (null != goods) {
            String mallstatus = goods.getString(PROD_MALLSTATUS);
            if (MallStatusEnum.TEMPSTATUS.getVal().equals(mallstatus)) {
                taxPrice = goods.getBigDecimal(PROD_TAXPRICE);
            } else {
                String key = goods.getString("id") + protocolId + protocolEntryId;
                if (null != prodPoolMap.get(key)) {
                    DynamicObject prodPool = prodPoolMap.get(key);
                    taxPrice = prodPool.getBigDecimal(PROD_TAXPRICE);
                } else {
                    taxPrice = goods.getBigDecimal(PROD_TAXPRICE);
                }
            }
            String biztype = dataEntity.getString("biztype");
            if (BIZTYPE_DOWNLOAD.equals(biztype)) {
                taxPrice = reqTaxPrice;
            }
            divTaxPrice = taxPrice;
            if (taxPrice.compareTo(BigDecimal.ZERO) > 0 && divTaxPrice.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newTaxPrice = reqTaxPrice.subtract(taxPrice);
                if (newTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal multiply = newTaxPrice.divide(divTaxPrice, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
                    if (newTaxPrice.compareTo(BigDecimal.ZERO) > 0) {
                        this.getModel().setValue("pricelimit", (Object)(multiply + "%"), seq);
                        cellStyles.add(this.getCellStyle("#D9001B", "pricelimit", seq));
                    } else {
                        this.getModel().setValue("pricelimit", (Object)(multiply + "%"), seq);
                        cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
                    }
                } else {
                    this.getModel().setValue("pricelimit", (Object)"-", seq);
                    cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
                }
            } else {
                this.getModel().setValue("pricelimit", (Object)"-", seq);
                cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
            }
            this.getModel().setValue("beforesetprice", (Object)divTaxPrice, seq);
            if (null != protocolentry) {
                BigDecimal protaxprice = protocolentry.getBigDecimal(PROD_TAXPRICE);
                if (protaxprice.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal newTaxPrice = reqTaxPrice.subtract(protaxprice);
                    if (newTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal protocolpricelimit = newTaxPrice.divide(protaxprice, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
                        if (newTaxPrice.compareTo(BigDecimal.ZERO) > 0) {
                            this.getModel().setValue("protocolpricelimit", (Object)(protocolpricelimit + "%"), seq);
                            cellStyles.add(this.getCellStyle("#D9001B", "protocolpricelimit", seq));
                        } else {
                            this.getModel().setValue("protocolpricelimit", (Object)(protocolpricelimit + "%"), seq);
                            cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
                        }
                    } else {
                        this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
                        cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
                    }
                } else {
                    this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
                    cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
                }
            }
        }
    }

    private CellStyle getCellStyle(String foreColor, String fieldName, int seq) {
        CellStyle cs = new CellStyle();
        cs.setForeColor(foreColor);
        cs.setRow(seq);
        cs.setFieldKey(fieldName);
        return cs;
    }

    private void setDefaultLadPrice() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String selector = "goods,protocol,protocolentry,auditorg,goods.id,priceentry.qtyfrom,priceentry.qtyto,priceentry.ladprice";
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Long> goodsIds = new ArrayList<Long>(1024);
        for (DynamicObject row : entryentity) {
            if (null == row.getDynamicObject(PROD_NUMBER)) continue;
            Long goodId = row.getDynamicObject(PROD_NUMBER).getLong("id");
            goodsIds.add(goodId);
        }
        QFilter qFilter = new QFilter("goods.id", "in", goodsIds);
        Map customParams = showParameter.getCustomParams();
        if (null == showParameter.getCustomParam("protocolId")) {
            String selectcol = (String)showParameter.getCustomParam("prodPoolIds");
            ArrayList allProd = StringConversionUtil.conversion((String)selectcol);
            if (null != allProd) {
                ArrayList<Long> list = new ArrayList<Long>(1024);
                for (String str : allProd) {
                    list.add(Long.parseLong(str));
                }
                if (list.size() > 0) {
                    qFilter.and(new QFilter("id", "in", list));
                }
            }
        } else if (null != customParams.get("protocolId")) {
            Long proticolId = Long.parseLong(String.valueOf(customParams.get("protocolId")));
            qFilter.and(new QFilter("protocol", "=", (Object)proticolId));
        }
        DynamicObjectCollection prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selector, (QFilter[])qFilter.toArray());
        HashMap good_PoolsMap = new HashMap(1024);
        for (int i = 0; i < prodpools.size(); ++i) {
            DynamicObject prod = (DynamicObject)prodpools.get(i);
            String key = prod.getString("goods.id") + prod.getString("protocol") + prod.getString("protocolentry");
            List<Object> pools = new ArrayList<DynamicObject>(1024);
            if (null != good_PoolsMap.get(key)) {
                pools = (List)good_PoolsMap.get(key);
            }
            pools.add(prod);
            good_PoolsMap.put(key, pools);
        }
        IDataModel entryOperate = this.getModel();
        for (DynamicObject row : entryentity) {
            String key;
            List pools;
            if (row == null || null == row.get(PROD_NUMBER)) continue;
            String goodsId = row.getString("goods.id");
            String protocolId = "0";
            if (null != dataEntity.get("protocolid")) {
                protocolId = dataEntity.getString("protocolid.id");
            }
            String protocolentryId = "0";
            if (null != row.get("protocolentry")) {
                protocolentryId = row.getString("protocolentry.id");
            }
            if ((pools = (List)good_PoolsMap.get(key = goodsId + protocolId + protocolentryId)) == null) continue;
            int entrySeq = row.getInt(PROD_SEQ) - 1;
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, entrySeq);
            entryOperate.deleteEntryData("subentryentity");
            boolean ispricetype = false;
            for (DynamicObject pool : pools) {
                BigDecimal qtyto = pool.getBigDecimal("priceentry.qtyto");
                BigDecimal qtyfrom = pool.getBigDecimal("priceentry.qtyfrom");
                BigDecimal ladprice = pool.getBigDecimal("priceentry.ladprice");
                if (ladprice.compareTo(BigDecimal.ZERO) == 0) continue;
                int subRow = entryOperate.createNewEntryRow("subentryentity");
                this.getModel().setValue("qtyto", (Object)qtyto, subRow, entrySeq);
                this.getModel().setValue("qtyfrom", (Object)qtyfrom, subRow, entrySeq);
                this.getModel().setValue("ladprice", (Object)ladprice, subRow, entrySeq);
                this.getModel().setValue("subkey", (Object)qtyfrom, subRow, entrySeq);
                ispricetype = true;
            }
            if (ispricetype) {
                this.getModel().setValue("pricetype", (Object)"B", entrySeq);
                continue;
            }
            this.getModel().setValue("pricetype", (Object)"A", entrySeq);
            entryOperate.deleteEntryData("subentryentity");
        }
    }

    private void setProtocolProd(List<String> allProd) {
        ArrayList<Long> list = new ArrayList<Long>(allProd.size());
        for (String str : allProd) {
            list.add(Long.parseLong(str));
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String selectFields = "id,number,name,category,unit,model,price,taxprice,mallstatus,supplier,description,status,barcode";
        QFilter qFilter = new QFilter("id", "in", list);
        DynamicObject[] prods = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int seq = 0;
        for (int i = 0; i < prods.length; ++i) {
            DynamicObject prod = prods[i];
            vs.set(PROD_SEQ, (Object)(seq + 1), seq);
            vs.set(PROD_NUMBER, (Object)prod.getLong("id"), seq);
            vs.set(PROD_CLASS, (DynamicObject)prod.get("category") == null ? null : Long.valueOf(((DynamicObject)prod.get("category")).getLong("id")), seq);
            if (null != prod.get(PROD_UNIT)) {
                vs.set(PROD_UNIT, (DynamicObject)prod.get(PROD_UNIT) == null ? null : Long.valueOf(((DynamicObject)prod.get(PROD_UNIT)).getLong("id")), seq);
            }
            vs.set(PROD_PRICE, prod.get(PROD_PRICE), seq);
            vs.set(PROD_TAXPRICE, prod.get(PROD_TAXPRICE), seq);
            vs.set(PROD_SHOPPRICE, prod.get(PROD_TAXPRICE), seq);
            vs.set("barcode", prod.get("barcode"), seq);
            ++seq;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
    }

    private void setOrgData(AbstractFormDataModel model) {
        if (this.getModel().getValue(ORG) != null) {
            return;
        }
        DynamicObject supplier = (DynamicObject)model.getValue(SUPPLIER);
        String supfilterpk = "0";
        DynamicObject org = null;
        if (null != supplier && null != supplier.getPkValue()) {
            supfilterpk = supplier.getPkValue().toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)supfilterpk)) {
            QFilter supfilter = new QFilter(SUPPLIER, "=", (Object)Long.parseLong(supfilterpk));
            supfilter.and("cfmstatus", "=", (Object)"B");
            DynamicObject auditorg = BusinessDataServiceHelper.loadSingle((String)"ent_suprequest", (String)ORG, (QFilter[])new QFilter[]{supfilter});
            if (null != auditorg) {
                org = auditorg.getDynamicObject(ORG);
            }
        }
        if (null != org) {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(org.getPkValue().toString()));
            idFilter.and("fispurchase", "=", (Object)BIZTYPE_UPLOAD);
            QFilter[] filters = new QFilter[]{idFilter};
            String select = "id";
            DynamicObject org1 = QueryServiceHelper.queryOne((String)"bos_org", (String)select, (QFilter[])filters);
            if (null != org1) {
                model.setValue(ORG, (Object)org);
            }
        }
        if (model.getValue(ORG) == null) {
            model.setValue(ORG, (Object)OrgUnitServiceHelper.getRootOrgId());
        }
    }

    private void setSupplierData(AbstractFormDataModel model) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long supplierPrt = (Long)showParameter.getCustomParam(SUPPLIER);
        if (Objects.nonNull(supplierPrt)) {
            DynamicObject[] suppliers;
            QFilter enterFilter = new QFilter("id", "=", (Object)supplierPrt);
            for (DynamicObject dyn : suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name,number,bizpartner", (QFilter[])new QFilter[]{enterFilter})) {
                model.setValue(SUPPLIER, (Object)supplierPrt);
                DynamicObject bizpartnerdy = (DynamicObject)dyn.get(BIZPARTER);
                if (null == bizpartnerdy) continue;
                model.setValue(BIZPARTER, (Object)bizpartnerdy.getLong("id"));
            }
        } else {
            RequestContext rc = RequestContext.get();
            long bizPartnerId = 0L;
            if (null != rc.getBizPartnerId()) {
                bizPartnerId = rc.getBizPartnerId();
            } else {
                DynamicObject bizpartneruser = QueryServiceHelper.queryOne((String)"bos_bizpartneruser", (String)BIZPARTER, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()))});
                if (null != bizpartneruser) {
                    bizPartnerId = bizpartneruser.getLong(BIZPARTER);
                }
            }
            QFilter qFilter = new QFilter(BIZPARTER, "=", (Object)bizPartnerId);
            DynamicObjectCollection supcol = QueryServiceHelper.query((String)"bd_supplier", (String)"id,bizpartner,mallstatus", (QFilter[])qFilter.toArray());
            for (DynamicObject sup : supcol) {
                String mallStatus = sup.getString(PROD_MALLSTATUS);
                if (!"B".equals(mallStatus)) continue;
                model.setValue(SUPPLIER, sup.get(0));
                long bizpartner = sup.getLong(BIZPARTER);
                model.setValue(BIZPARTER, (Object)bizpartner);
                break;
            }
        }
    }

    private Map<String, List<DynamicObject>> getLadPriceMapByProtocolEntryID(Set<String> protocolEntryIds) {
        HashMap<String, List<DynamicObject>> entryId_LadPriceMap = new HashMap<String, List<DynamicObject>>(1024);
        if (protocolEntryIds.size() == 0) {
            return entryId_LadPriceMap;
        }
        HashSet<Long> newEntryIdSet = new HashSet<Long>(1024);
        for (String key : protocolEntryIds) {
            newEntryIdSet.add(Long.parseLong(key));
        }
        String ladSelectors = "entryentity1.id,entryentity1.subentryentity.qtyfrom,entryentity1.subentryentity.qtyto,entryentity1.subentryentity.ladprice";
        QFilter qFilter = new QFilter("entryentity1.id", "in", newEntryIdSet);
        DynamicObjectCollection pmm_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)ladSelectors, (QFilter[])qFilter.toArray());
        for (DynamicObject row : pmm_protocols) {
            String entryId = row.getString("entryentity1.id");
            List<Object> ladpriceEntrys = new ArrayList<DynamicObject>(1024);
            if (null != entryId_LadPriceMap.get(entryId)) {
                ladpriceEntrys = (List)entryId_LadPriceMap.get(entryId);
            }
            ladpriceEntrys.add(row);
            entryId_LadPriceMap.put(entryId, ladpriceEntrys);
        }
        return entryId_LadPriceMap;
    }

    private void setEntryDataByProtocol(TableValueSetter vs, int seq, DynamicObject entryInfo) {
        if (null != entryInfo.getDynamicObject("material")) {
            vs.set("material", (Object)entryInfo.getDynamicObject("material"), seq);
            vs.set("material_id", entryInfo.getDynamicObject("material").getPkValue(), seq);
        }
        if (null != entryInfo.get("auxpty")) {
            vs.set("auxpty", entryInfo.get("auxpty"), seq);
            if (entryInfo.get("auxpty") instanceof DynamicObject) {
                vs.set("auxpty_id", (Object)entryInfo.getDynamicObject("auxpty").getLong("id"), seq);
            } else {
                vs.set("auxpty_id", entryInfo.get("auxpty"), seq);
            }
        }
        vs.set(PRICEEFFECTDATE, (Object)entryInfo.getDate(PRICEEFFECTDATE), seq);
        vs.set(PRICEINVALIDDATE, (Object)entryInfo.getDate(PRICEINVALIDDATE), seq);
        vs.set("pricetype", entryInfo.get("entrypricetype"), seq);
        vs.set("minorderqty", entryInfo.get("minorderqty"), seq);
        vs.set("leadtime", entryInfo.get("leadtime"), seq);
    }

    private void setLadderPriceFromProtocol(Map<Integer, Object> seq_ladPricemap) {
        IDataModel entryOperate = this.getModel();
        for (Map.Entry<Integer, Object> map : seq_ladPricemap.entrySet()) {
            List subRows = (List)map.getValue();
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, map.getKey().intValue());
            entryOperate.deleteEntryData("subentryentity");
            List<Object> ladderPriceInfos = new ArrayList(1024);
            for (Object subRow : subRows) {
                entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, map.getKey().intValue());
                Map subRowMap = (Map)subRow;
                int subIndex = entryOperate.createNewEntryRow("subentryentity");
                BigDecimal qtyfrom = BigDecimal.ZERO;
                if (null != subRowMap.get("entryentity1.subentryentity.qtyfrom")) {
                    qtyfrom = new BigDecimal(String.valueOf(subRowMap.get("entryentity1.subentryentity.qtyfrom")));
                }
                BigDecimal qtyto = BigDecimal.ZERO;
                if (null != subRowMap.get("entryentity1.subentryentity.qtyto")) {
                    qtyto = new BigDecimal(String.valueOf(subRowMap.get("entryentity1.subentryentity.qtyto")));
                }
                BigDecimal ladprice = BigDecimal.ZERO;
                if (null != subRowMap.get("entryentity1.subentryentity.ladprice")) {
                    ladprice = new BigDecimal(String.valueOf(subRowMap.get("entryentity1.subentryentity.ladprice")));
                }
                this.getModel().setValue("qtyfrom", (Object)qtyfrom, subIndex, map.getKey().intValue());
                this.getModel().setValue("qtyto", (Object)qtyto, subIndex, map.getKey().intValue());
                this.getModel().setValue("ladprice", (Object)ladprice, subIndex, map.getKey().intValue());
                this.getModel().setValue("subkey", subRowMap.get("entryentity1.subentryentity.qtyfrom"), subIndex, map.getKey().intValue());
                LadderPriceInfo info = new LadderPriceInfo(qtyfrom, qtyto, ladprice, Long.valueOf(0L));
                ladderPriceInfos.add(info);
            }
            if ((ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList())).size() <= 0) continue;
            DynamicObject entryprod = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY).get(map.getKey().intValue());
            BigDecimal ladprice = ((LadderPriceInfo)ladderPriceInfos.get(0)).getLadprice();
            this.getModel().setValue(PROD_TAXPRICE, (Object)ladprice, map.getKey().intValue());
            DynamicObject prod = entryprod.getDynamicObject(PROD_NUMBER);
            BigDecimal price = BigDecimal.ZERO;
            if (null == prod) continue;
            BigDecimal taxRate = prod.getBigDecimal(PROD_TAXRATE);
            int taxtype = prod.getInt("taxtype");
            price = 0 == taxtype ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)ladprice, (int)2) : CalculateUtils.calPrice((BigDecimal)ladprice, (BigDecimal)taxRate, (int)2);
            this.getModel().setValue(PROD_PRICE, (Object)price, map.getKey().intValue());
            this.getModel().setValue(PROD_SHOPPRICE, (Object)ladprice, map.getKey().intValue());
        }
    }

    private void setEntryForNull(TableValueSetter vs, int seq) {
        vs.set(PROD_SEQ, (Object)(seq + 1), seq);
        vs.set(PROD_NUMBER, null, seq);
        vs.set(PROD_CLASS, null, seq);
        vs.set(PROD_UNIT, null, seq);
        vs.set(PROD_PRICE, null, seq);
        vs.set(PROD_TAXPRICE, null, seq);
        vs.set(PROD_SHOPPRICE, null, seq);
    }

    private void setEntryProtocolData(List<Long> list, Map<String, Long> entry_goodMap, Map<String, DynamicObject> entry_bdMap) {
        Map<String, List<DynamicObject>> ladPriceMap = this.getLadPriceMapByProtocolEntryID(entry_bdMap.keySet());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String selectFields = "id,number,name,category,unit,model,price,taxprice,mallstatus,supplier,description,status,barcode";
        QFilter qFilter = new QFilter("id", "in", list);
        DynamicObject[] prods = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> id_goodMap = new HashMap<Long, DynamicObject>(1024);
        for (DynamicObject goods : prods) {
            id_goodMap.put(goods.getLong("id"), goods);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int seq = 0;
        HashMap<Integer, Object> seq_LadPricemap = new HashMap<Integer, Object>(1024);
        if (prods.length == 0) {
            seq = 0;
            for (Map.Entry<String, Long> map1 : entry_goodMap.entrySet()) {
                String[] entryId_materialId = map1.getKey().split("_");
                if (Long.parseLong(entryId_materialId[0]) == 0L) continue;
                vs.set("protocolentry", (Object)entryId_materialId[0], seq);
                if (entry_bdMap.containsKey(entryId_materialId[0])) {
                    DynamicObject entryInfo = entry_bdMap.get(entryId_materialId[0]);
                    this.setEntryDataByProtocol(vs, seq, entryInfo);
                    if ("B".equals(entryInfo.get("entrypricetype"))) {
                        List<DynamicObject> ladPrices = ladPriceMap.get(entryId_materialId[0]);
                        ArrayList<Map> subRows = new ArrayList<Map>(1024);
                        if (null != ladPrices && ladPrices.size() > 0) {
                            for (DynamicObject subRow : ladPrices) {
                                Map subRowMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)subRow);
                                subRows.add(subRowMap);
                            }
                        }
                        seq_LadPricemap.put(seq, subRows);
                    }
                }
                ++seq;
            }
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
            model.endInit();
            this.getView().updateView(ENTRY_ENTITY);
            this.setLadderPriceFromProtocol(seq_LadPricemap);
            return;
        }
        seq = 0;
        for (Map.Entry<String, Long> map1 : entry_goodMap.entrySet()) {
            String[] entryId_materialId = map1.getKey().split("_");
            if (null == map1.getValue()) {
                if (Long.parseLong(entryId_materialId[0]) == 0L) continue;
                this.setEntryForNull(vs, seq);
            } else if (id_goodMap.containsKey(map1.getValue())) {
                DynamicObject prod = (DynamicObject)id_goodMap.get(map1.getValue());
                if (null != prod) {
                    vs.set(PROD_SEQ, (Object)(seq + 1), seq);
                    vs.set(PROD_NUMBER, (Object)prod.getLong("id"), seq);
                    vs.set(PROD_CLASS, (DynamicObject)prod.get("category") == null ? null : Long.valueOf(((DynamicObject)prod.get("category")).getLong("id")), seq);
                    if (null != prod.get(PROD_UNIT)) {
                        vs.set(PROD_UNIT, (DynamicObject)prod.get(PROD_UNIT) == null ? null : Long.valueOf(((DynamicObject)prod.get(PROD_UNIT)).getLong("id")), seq);
                    }
                    vs.set(PROD_PRICE, prod.get(PROD_PRICE), seq);
                    vs.set(PROD_TAXPRICE, prod.get(PROD_TAXPRICE), seq);
                    vs.set(PROD_SHOPPRICE, prod.get(PROD_TAXPRICE), seq);
                    vs.set("barcode", prod.get("barcode"), seq);
                }
            } else {
                this.setEntryForNull(vs, seq);
            }
            vs.set("protocolentry", (Object)entryId_materialId[0], seq);
            if (entry_bdMap.containsKey(entryId_materialId[0])) {
                DynamicObject entryInfo = entry_bdMap.get(entryId_materialId[0]);
                this.setEntryDataByProtocol(vs, seq, entryInfo);
                if ("B".equals(entryInfo.get("entrypricetype"))) {
                    List<DynamicObject> ladPrices = ladPriceMap.get(entryId_materialId[0]);
                    ArrayList<Map> subRows = new ArrayList<Map>(1024);
                    if (null != ladPrices && ladPrices.size() > 0) {
                        for (DynamicObject subRow : ladPrices) {
                            Map subRowMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)subRow);
                            subRows.add(subRowMap);
                        }
                    }
                    seq_LadPricemap.put(seq, subRows);
                }
            }
            ++seq;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
        this.setLadderPriceFromProtocol(seq_LadPricemap);
    }

    private void setEntryData() {
        String prodPoolIdsJson = (String)this.getView().getFormShowParameter().getCustomParam("prodPoolIds");
        ArrayList prodPoolIds = StringConversionUtil.conversion((String)prodPoolIdsJson);
        ArrayList<Long> list = new ArrayList<Long>(prodPoolIds.size());
        for (String str : prodPoolIds) {
            list.add(Long.parseLong(str));
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        QFilter qFilter = new QFilter("id", "in", list);
        String selector = "id,auditorg,goods.id goods,goods.category category,unit,taxprice,price,protocol,protocolentry,priceeffectdate,priceinvaliddate,minorderqty,leadtime";
        DynamicObjectCollection prodpools = QueryServiceHelper.query((String)"ent_prodpool", (String)selector, (QFilter[])qFilter.toArray());
        model.setValue("protocolid", (Object)((DynamicObject)prodpools.get(0)).getLong("protocol"));
        HashSet<Long> protocolEntryIds = new HashSet<Long>(1024);
        HashMap<Long, DynamicObject> proEntry_EntryDynMap = new HashMap<Long, DynamicObject>(1024);
        for (Object row : prodpools) {
            protocolEntryIds.add(row.getLong("protocolentry"));
            model.setValue(ORG, (Object)row.getLong("auditorg"));
        }
        if (protocolEntryIds.size() > 0) {
            selector = "material,materialgroup,unit,auxpty,entryid";
            qFilter = new QFilter("entryid", "in", protocolEntryIds);
            DynamicObjectCollection proEntrys = QueryServiceHelper.query((String)"ent_protocolentry_bd", (String)selector, (QFilter[])qFilter.toArray());
            for (DynamicObject row : proEntrys) {
                proEntry_EntryDynMap.put(row.getLong("entryid"), row);
            }
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int seq = 0;
        for (int i = 0; i < prodpools.size(); ++i) {
            DynamicObject prodPool = (DynamicObject)prodpools.get(i);
            vs.set(PROD_SEQ, (Object)(seq + 1), seq);
            vs.set(PROD_NUMBER, (Object)prodPool.getLong(PROD_NUMBER), seq);
            vs.set(PROD_CLASS, (Object)prodPool.getLong("category"), seq);
            vs.set(PROD_UNIT, (Object)prodPool.getLong(PROD_UNIT), seq);
            vs.set(PROD_PRICE, prodPool.get(PROD_PRICE), seq);
            vs.set(PROD_TAXPRICE, prodPool.get(PROD_TAXPRICE), seq);
            vs.set(PROD_SHOPPRICE, prodPool.get(PROD_TAXPRICE), seq);
            vs.set(PRICEEFFECTDATE, prodPool.get(PRICEEFFECTDATE), seq);
            vs.set(PRICEINVALIDDATE, prodPool.get(PRICEINVALIDDATE), seq);
            vs.set("minorderqty", prodPool.get("minorderqty"), seq);
            vs.set("leadtime", prodPool.get("leadtime"), seq);
            if (proEntry_EntryDynMap.containsKey(prodPool.getLong("protocolentry"))) {
                DynamicObject row = (DynamicObject)proEntry_EntryDynMap.get(prodPool.getLong("protocolentry"));
                vs.set("protocolentry", (Object)prodPool.getLong("protocolentry"), seq);
                vs.set("material", (Object)row.getLong("material"), seq);
                if (null != row.get("auxpty")) {
                    vs.set("auxpty", row.get("auxpty"), seq);
                    if (row.get("auxpty") instanceof DynamicObject) {
                        vs.set("auxpty_id", (Object)row.getDynamicObject("auxpty").getLong("id"), seq);
                    } else {
                        vs.set("auxpty_id", row.get("auxpty"), seq);
                    }
                }
            }
            ++seq;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
    }

    private List<Long> setGoodIds(Map<Long, Long> materiaId_goodMap, List<Long> list, Map<String, Long> entry_goodMap, Map<String, DynamicObject> entry_bdMap, String protocolId) {
        DynamicObject[] pmmProtocolsBd;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long supplierPrt = 0L;
        if (null != showParameter.getCustomParam(SUPPLIER)) {
            supplierPrt = (Long)showParameter.getCustomParam(SUPPLIER);
        } else if (null != this.getModel().getValue(SUPPLIER)) {
            DynamicObject sup = (DynamicObject)this.getModel().getValue(SUPPLIER);
            supplierPrt = sup.getLong("id");
        }
        HashSet<Long> goodsIdSet = new HashSet<Long>(1024);
        QFilter qFilter = new QFilter(SUPPLIER, "=", (Object)supplierPrt);
        DynamicObjectCollection ent_prodmanages = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id", (QFilter[])qFilter.toArray());
        for (DynamicObject info : ent_prodmanages) {
            goodsIdSet.add(info.getLong("id"));
        }
        QFilter filter = new QFilter("protocol", "in", (Object)Long.valueOf(protocolId));
        filter.and(PROD_MALLSTATUS, "in", Arrays.asList(MallStatusEnum.SOLD.getVal(), MallStatusEnum.UNSOLD.getVal()));
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"ent_prodpool", (String)"id,goods", (QFilter[])filter.toArray());
        ArrayList goodsIdList = new ArrayList(prodPools.size());
        prodPools.forEach(prodPool -> goodsIdList.add(prodPool.getLong(PROD_NUMBER)));
        HashMap<Long, Date> materiaId_dateMap = new HashMap<Long, Date>(1024);
        qFilter = new QFilter("material", "in", list);
        qFilter.and(new QFilter(PROD_NUMBER, "not in", goodsIdList));
        String selectors = "goods,material,modifytime";
        DynamicObjectCollection pmmProdmatmappings = QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)selectors, (QFilter[])qFilter.toArray());
        for (DynamicObject info : pmmProdmatmappings) {
            Long materialId = info.getLong("material");
            Long goodId = info.getLong(PROD_NUMBER);
            Date date = info.getDate("modifytime");
            if (!goodsIdSet.contains(goodId) || 0L == materialId || 0L == goodId) continue;
            if (null != materiaId_dateMap.get(materialId)) {
                Date beforeupDat = (Date)materiaId_dateMap.get(materialId);
                if (!date.after(beforeupDat)) continue;
                materiaId_goodMap.put(materialId, goodId);
                materiaId_dateMap.put(materialId, date);
                continue;
            }
            materiaId_goodMap.put(materialId, goodId);
            materiaId_dateMap.put(materialId, date);
        }
        String entryMapStr = (String)this.getView().getFormShowParameter().getCustomParam("entrymapping");
        HashMap<String, String> entryMap = null;
        if (null == this.getView().getFormShowParameter().getCustomParam("entrymapping")) {
            qFilter = new QFilter("id", "=", (Object)Long.parseLong(protocolId));
            String selector = "entryentity.material,entryentity.materialname,partyb,entryentity.id,entryentity.purplanid";
            DynamicObjectCollection ent_protocolCol = QueryServiceHelper.query((String)"ent_protocol", (String)selector, (QFilter[])qFilter.toArray());
            entryMap = new HashMap<String, String>();
            if (ent_protocolCol.size() > 0) {
                if (0L != ((DynamicObject)ent_protocolCol.get(0)).getLong("entryentity.purplanid")) {
                    HashSet<String> hashSet = new HashSet<String>(1024);
                    for (DynamicObject protocol : ent_protocolCol) {
                        Long purplanid = protocol.getLong("entryentity.purplanid");
                        hashSet.add(protocol.getString("entryentity.material") + protocol.getString("entryentity.materialname") + purplanid);
                    }
                    for (DynamicObject protocol : ent_protocolCol) {
                        String materialId = protocol.getString("entryentity.material");
                        String materialName = protocol.getString("entryentity.materialname");
                        String purplanid = protocol.getString("entryentity.purplanid");
                        String key = materialId + materialName + purplanid;
                        if (!hashSet.remove(key)) continue;
                        entryMap.put(protocol.getString("entryentity.id"), materialId);
                    }
                } else {
                    for (DynamicObject protocol : ent_protocolCol) {
                        entryMap.put(protocol.getString("entryentity.id"), protocol.getString("entryentity.material"));
                    }
                }
            }
        } else {
            entryMap = (HashMap<String, String>)SerializationUtils.fromJsonString((String)entryMapStr, Map.class);
        }
        HashSet goodIDs = new HashSet(1024);
        for (Map.Entry entry : materiaId_goodMap.entrySet()) {
            goodIDs.add(entry.getValue());
        }
        list.clear();
        list.addAll(goodIDs);
        HashSet<Long> entryIdSet = new HashSet<Long>(1024);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry map : entryMap.entrySet()) {
            String proEntryId = (String)map.getKey();
            String proMaterialId = (String)map.getValue();
            Long goodId = materiaId_goodMap.get(Long.parseLong(proMaterialId));
            stringBuilder.setLength(0);
            stringBuilder.append(proEntryId).append('_').append(goodId);
            entry_goodMap.put(stringBuilder.toString(), goodId);
            entryIdSet.add(Long.parseLong(proEntryId));
        }
        String entProtocolentrySel = DynamicObjectUtil.getSelectfields((String)"ent_protocolentry_bd", (boolean)false);
        qFilter = new QFilter("entryid", "in", entryIdSet);
        for (DynamicObject dyn : pmmProtocolsBd = BusinessDataServiceHelper.load((String)"ent_protocolentry_bd", (String)entProtocolentrySel, (QFilter[])qFilter.toArray())) {
            entry_bdMap.put(dyn.getString("id"), dyn);
        }
        return list;
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        if (this.getView().getParentView() != null && (Boolean.parseBoolean((String)AppCache.get((String)this.getView().getParentView().getPageId()).get("resubmit", String.class)) || Boolean.parseBoolean((String)AppCache.get((String)this.getView().getPageId()).get("resubmit", String.class)))) {
            AppCache.get((String)this.getView().getParentView().getPageId()).remove("resubmit");
            AppCache.get((String)this.getView().getPageId()).remove("resubmit");
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            ArrayList<Integer> indexs = new ArrayList<Integer>(entrys.size());
            for (DynamicObject row : entrys) {
                String entryresult = row.getString("entryresult");
                if (!BIZTYPE_UPLOAD.equals(entryresult)) continue;
                indexs.add(row.getInt(PROD_SEQ) - 1);
            }
            if (indexs.size() > 0) {
                int[] removeIndexs = new int[indexs.size()];
                for (int i = 0; i < indexs.size(); ++i) {
                    removeIndexs[i] = (Integer)indexs.get(i);
                }
                this.getPageCache().put("option", "resubmit");
                this.getModel().deleteEntryRows(ENTRY_ENTITY, removeIndexs);
            }
            this.getModel().setDataChanged(false);
        }
        this.setPricelimit();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entries.size(); ++i) {
            if (((DynamicObject)entries.get(i)).getDynamicObject(PROD_NUMBER) == null) continue;
            String prodid = ((DynamicObject)entries.get(i)).getDynamicObject(PROD_NUMBER).getPkValue().toString();
            QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(prodid));
            QFilter[] filters = new QFilter[]{idFilter};
            String selectFields = "id,number,name,category,unit,model,price,taxrate,taxprice,mallstatus,supplier,description,status";
            DynamicObject prod = QueryServiceHelper.queryOne((String)"ent_prodmanage", (String)selectFields, (QFilter[])filters);
            model.setValue(PROD_UNIT, prod.get(PROD_UNIT), i);
            model.setValue(PROD_CLASS, prod.get("category"), i);
            if (((DynamicObject)entries.get(i)).getBigDecimal(PROD_TAXPRICE).compareTo(BigDecimal.ZERO) != 0) continue;
            model.setValue(PROD_TAXPRICE, prod.get(PROD_TAXPRICE), i);
            model.setValue(PROD_PRICE, prod.get(PROD_PRICE), i);
        }
        this.setPricelimit();
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("submit".equals(key) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
            this.setShopprice();
        }
        if ("unaudit".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        if ("save".equals(key) || "submit".equals(key)) {
            if (null == this.getModel().getValue("protocolid") || this.getModel().getValue("biztype").equals(BIZTYPE_DOWNLOAD)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
            }
        }
        if ("resubmit".equals(key) && args.getOperationResult().isSuccess()) {
            AppCache.get((String)this.getView().getPageId()).put("resubmit", (Object)"true");
            this.getView().invokeOperation("copy");
        }
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        super.propertyChanged(arg0);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String property = arg0.getProperty().getName();
        DynamicObject supplier = null;
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        Object oldValue = arg0.getChangeSet()[0].getOldValue();
        switch (property) {
            case "supplier": {
                this.doSupplierChange(supplier, model);
                break;
            }
            case "org": {
                this.doOrgChange(oldValue);
                break;
            }
            case "goods": {
                this.doProdChange(model, property, rowIndex, oldValue);
                this.doProdChangeAndEffectDeal(model, property, rowIndex);
                this.doPriceLimitChange(arg0);
                break;
            }
            case "taxprice": {
                this.doTaxrateChange(model, property, arg0, view);
                this.doPriceLimitChange(arg0);
                break;
            }
            case "protocolid": {
                this.doProtocaolIDChange(oldValue);
                break;
            }
            case "priceeffectdate": {
                this.doPriceEffectDateChange(arg0);
                break;
            }
            case "priceinvaliddate": {
                this.doPriceInvalidDateChange(arg0);
                break;
            }
            case "pricetype": {
                this.doPriceTypeChange(arg0);
                break;
            }
            case "minorderqty": {
                this.doMinorderqtyChange(arg0);
                break;
            }
        }
    }

    private void doPriceLimitChange(PropertyChangedArgs arg0) {
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        if (null != this.getModel().getValue(PROD_NUMBER, rowIndex)) {
            DynamicObject goods = (DynamicObject)this.getModel().getValue(PROD_NUMBER, rowIndex);
            String mallstatus = goods.getString(PROD_MALLSTATUS);
            if (!MallStatusEnum.TEMPSTATUS.getVal().equals(mallstatus)) {
                goodsIds.add(goods.getLong("id"));
            }
            Map<String, DynamicObject> prodPoolMap = this.getProPoolMap(goodsIds);
            BigDecimal reqTaxPrice = BigDecimal.ZERO;
            if (null != this.getModel().getValue(PROD_TAXPRICE, rowIndex)) {
                reqTaxPrice = (BigDecimal)this.getModel().getValue(PROD_TAXPRICE, rowIndex);
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            this.setPricelimitValue(goods, rowIndex, reqTaxPrice, prodPoolMap, cellStyles);
            if (cellStyles.size() > 0) {
                grid.setCellStyle(cellStyles);
            }
        }
    }

    private void doMinorderqtyChange(PropertyChangedArgs arg0) {
        Object newValue = arg0.getChangeSet()[0].getNewValue();
        Object oldValue = arg0.getChangeSet()[0].getOldValue();
        BigDecimal newMinOrderQty = CommonUtil.getBigDecimalPro((Object)newValue);
        if (newMinOrderQty.compareTo(CommonUtil.getBigDecimalPro((Object)oldValue)) == 0) {
            return;
        }
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        model.setValue("minorderqty", (Object)newMinOrderQty.setScale(0, RoundingMode.FLOOR), rowIndex);
        DynamicObjectCollection entryCol = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
        if (subentryentity.size() > 1) {
            DynamicObject subrow = (DynamicObject)subentryentity.get(0);
            if (newMinOrderQty.compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("qtyfrom", (Object)BigDecimal.ZERO, 0, rowIndex);
            } else {
                BigDecimal minqty = new BigDecimal(String.valueOf(newValue));
                BigDecimal qtyto = subrow.getBigDecimal("qtyto");
                if (minqty.compareTo(BigDecimal.ZERO) == 0) {
                    model.setValue("qtyfrom", (Object)BigDecimal.ZERO, 0, rowIndex);
                    return;
                }
                if (minqty.compareTo(qtyto) < 0) {
                    model.setValue("qtyfrom", (Object)minqty, 0, rowIndex);
                } else if ("A".equals(model.getValue("pricetype"))) {
                    IDataModel entryOperate = this.getModel();
                    entryOperate.deleteEntryData("subentryentity");
                } else {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("minorderqty", (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9636\u68af\u4ef7\uff0c\u4fee\u6539\u8d77\u8ba2\u91cf\u540e\u6e05\u7a7a\u9636\u68af\u4ef7\uff0c\u9700\u91cd\u8bbe\u3002", (String)"EntSupRequestEdit_15", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                    this.getPageCache().put("minorderqty", String.valueOf(oldValue));
                    this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                }
            }
        }
    }

    private void doPriceTypeChange(PropertyChangedArgs arg0) {
        Object newValue = arg0.getChangeSet()[0].getNewValue();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        if ("A".equals(newValue)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ladderprice"});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ladderprice"});
            this.setTaxpriceByLadprice(rowIndex);
        }
    }

    private void setTaxpriceByLadprice(int rowIndex) {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
        if (subentryentity.size() > 1) {
            ArrayList<LadderPriceInfo> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
            for (DynamicObject subRow : subentryentity) {
                LadderPriceInfo info = new LadderPriceInfo(subRow.getBigDecimal("qtyfrom"), subRow.getBigDecimal("qtyto"), subRow.getBigDecimal("ladprice"), Long.valueOf(0L));
                ladderPriceInfos.add(info);
            }
            if (ladderPriceInfos.size() > 0) {
                this.getModel().setValue(PROD_TAXPRICE, (Object)((LadderPriceInfo)ladderPriceInfos.get(0)).getLadprice(), rowIndex);
            }
        }
    }

    private void doSupplierChange(DynamicObject supplier, IDataModel model) {
        supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER);
        if (supplier == null) {
            return;
        }
        DynamicObject bizpartner = supplier.getDynamicObject(BIZPARTER);
        model.setValue(BIZPARTER, (Object)bizpartner);
        this.setQFilter(supplier, this.getModel().getDataEntity().getDynamicObject(ORG));
    }

    private void doOrgChange(Object oldValue) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        boolean isTip = true;
        for (DynamicObject row : entrys) {
            if (this.getModel().getValue("protocolid") != null) {
                isTip = false;
                break;
            }
            if (row.getDynamicObject(PROD_NUMBER) == null) continue;
            isTip = false;
            break;
        }
        if (!isTip) {
            if (oldValue != null) {
                String orgId = ((DynamicObject)oldValue).getString("id");
                this.getPageCache().put("doOrgChangeOldValue", orgId);
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgChangeConfirm", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u4f4d\u5207\u6362\u5c06\u6e05\u7a7a\u5546\u57ce\u534f\u8bae\u548c\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EntProdRequestEdit_14", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.doOrgChangeConfirm();
        }
    }

    private void doOrgChangeConfirm() {
        this.setQFilter(this.getModel().getDataEntity().getDynamicObject(SUPPLIER), this.getModel().getDataEntity().getDynamicObject(ORG));
        this.getModel().beginInit();
        this.getModel().setValue("protocolid", null);
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Object> goodsIds = new ArrayList<Object>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            DynamicObject goods = entry.getDynamicObject(PROD_NUMBER);
            if (goods == null || !"A".equals(goods.getString("status"))) continue;
            goodsIds.add(goods.getLong("id"));
        }
        this.deleteSaveGoods(goodsIds);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void doProdChange(IDataModel model, String property, int rowIndex, Object oldValue) {
        DynamicObject newObject = (DynamicObject)model.getValue(property, rowIndex);
        String biztype = (String)this.getModel().getValue("biztype");
        if (newObject == null) {
            model.setValue(PROD_PRICE, null, rowIndex);
            model.setValue(PROD_TAXPRICE, null, rowIndex);
            model.setValue(PROD_SHOPPRICE, null, rowIndex);
            model.setValue(PROD_CLASS, null, rowIndex);
            model.setValue(PROD_UNIT, null, rowIndex);
            model.setValue("beforesetprice", null, rowIndex);
            model.setValue("pricelimit", null, rowIndex);
            model.setValue("protocolpricelimit", null, rowIndex);
            if (null == model.getValue("protocolentry", rowIndex)) {
                model.setValue(PRICEEFFECTDATE, null, rowIndex);
                model.setValue(PRICEINVALIDDATE, null, rowIndex);
                model.setValue("minorderqty", null, rowIndex);
                model.setValue("leadtime", null, rowIndex);
            }
            model.setValue("barcode", null, rowIndex);
            if (BIZTYPE_DOWNLOAD.equals(biztype)) {
                model.setValue("protocolentry", null, rowIndex);
                model.setValue("material", null, rowIndex);
                model.setValue("auxpty", null, rowIndex);
            }
            if (null != oldValue) {
                ArrayList<Object> goodIds = new ArrayList<Object>(1024);
                DynamicObject good = (DynamicObject)oldValue;
                if ("A".equals(good.getString("status"))) {
                    goodIds.add(good.getLong("id"));
                }
                if (goodIds.size() > 0) {
                    this.deleteSaveGoods(goodIds);
                }
            }
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, rowIndex);
            entryOperate.deleteEntryData("subentryentity");
            return;
        }
        DynamicObjectCollection oldRows = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (oldRows == null || oldRows.size() == 0) {
            return;
        }
        DynamicObject prod = (DynamicObject)model.getValue(property, rowIndex);
        this.setProdPriceData(model, rowIndex, prod, oldValue);
        DynamicObject cate = (DynamicObject)prod.get("category");
        if (null != cate) {
            model.setValue(PROD_CLASS, (Object)cate, rowIndex);
        }
        String barcode = prod.getString("barcode");
        model.setValue("barcode", (Object)barcode, rowIndex);
        Long goodsId = newObject.getLong("id");
        Object protocolid = this.getModel().getValue("protocolid");
        QFilter qFilter = new QFilter("goods.id", "=", (Object)goodsId);
        if (null != protocolid) {
            Object protocolentry;
            DynamicObject protocolInfo = (DynamicObject)protocolid;
            qFilter.and(new QFilter("protocol.id", "=", (Object)protocolInfo.getLong("id")));
            if (protocolInfo.getBoolean("differentarea") && null != (protocolentry = this.getModel().getValue("protocolentry", rowIndex))) {
                DynamicObject protocolentryDyn = (DynamicObject)protocolentry;
                qFilter.and(new QFilter("protocolentry.id", "=", (Object)protocolentryDyn.getLong("id")));
            }
        }
        DynamicObjectCollection pmm_prodpool = QueryServiceHelper.query((String)"pmm_prodpool", (String)"priceentry.qtyto,priceentry.qtyfrom,priceentry.ladprice", (QFilter[])qFilter.toArray());
        IDataModel model1 = this.getModel();
        if (pmm_prodpool.size() > 1) {
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, rowIndex);
            entryOperate.deleteEntryData("subentryentity");
            for (DynamicObject pool : pmm_prodpool) {
                int subRow = entryOperate.createNewEntryRow("subentryentity");
                BigDecimal qtyto = pool.getBigDecimal("priceentry.qtyto");
                BigDecimal qtyfrom = pool.getBigDecimal("priceentry.qtyfrom");
                BigDecimal ladprice = pool.getBigDecimal("priceentry.ladprice");
                model1.setValue("qtyto", (Object)qtyto, subRow, rowIndex);
                model1.setValue("qtyfrom", (Object)qtyfrom, subRow, rowIndex);
                model1.setValue("ladprice", (Object)ladprice, subRow, rowIndex);
            }
            model1.setValue("pricetype", (Object)"B", rowIndex);
        } else if (pmm_prodpool.size() > 0) {
            model1.setValue("pricetype", (Object)"A", rowIndex);
        }
    }

    private void setProdPriceData(IDataModel model, int rowIndex, DynamicObject prod, Object oldValue) {
        BigDecimal shopPrice;
        BigDecimal taxPrice;
        long prodId = prod.getLong("id");
        QFilter qFilter = new QFilter(PROD_NUMBER, "=", (Object)prodId);
        QFilter mallstatusQFilter = new QFilter(PROD_MALLSTATUS, "=", (Object)MallStatusEnum.SOLD.getVal());
        mallstatusQFilter.or(new QFilter(PROD_MALLSTATUS, "=", (Object)MallStatusEnum.UNSOLD.getVal()));
        qFilter.and(mallstatusQFilter);
        Object protocol = this.getModel().getValue("protocolid");
        if (protocol != null) {
            DynamicObject protocolDyn = (DynamicObject)protocol;
            qFilter.and(new QFilter("protocol_id", "=", (Object)protocolDyn.getLong("id")));
            Object protocolentry = this.getModel().getValue("protocolentry", rowIndex);
            long protocolEntryId = 0L;
            if (null != protocolentry) {
                DynamicObject protocolentryDyn = (DynamicObject)protocolentry;
                protocolEntryId = protocolentryDyn.getLong("id");
                qFilter.and(new QFilter("protocolentry.id", "=", (Object)protocolEntryId));
            }
            HashSet<Long> protocolEntryIds = new HashSet<Long>(1024);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject row : entryCol) {
                DynamicObject protocolentryDyn;
                if (null == row.get("protocolentry") || null == row.get(PROD_NUMBER) || protocolEntryId == (protocolentryDyn = row.getDynamicObject("protocolentry")).getLong("id") && prodId == row.getDynamicObject(PROD_NUMBER).getLong("id") || prodId != row.getDynamicObject(PROD_NUMBER).getLong("id")) continue;
                protocolEntryIds.add(protocolentryDyn.getLong("id"));
            }
            if (protocolEntryIds.size() > 0) {
                qFilter.and(new QFilter("protocolentry.id", "not in", protocolEntryIds));
            }
        }
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods,unit,taxprice,price,minorderqty,leadtime,priceeffectdate,priceinvaliddate,protocolentry.id protocolentry,protocolentry.material material,protocolentry.auxpty auxpty", (QFilter[])qFilter.toArray());
        String biztype = (String)this.getModel().getValue("biztype");
        for (DynamicObject prodPool : prodPools) {
            model.setValue(PROD_PRICE, (Object)prodPool.getBigDecimal(PROD_PRICE), rowIndex);
            model.setValue(PROD_TAXPRICE, (Object)prodPool.getBigDecimal(PROD_TAXPRICE), rowIndex);
            model.setValue(PROD_SHOPPRICE, (Object)prodPool.getBigDecimal(PROD_TAXPRICE), rowIndex);
            model.setValue(PROD_UNIT, (Object)prodPool.getLong(PROD_UNIT), rowIndex);
            model.setValue(PRICEEFFECTDATE, (Object)prodPool.getDate(PRICEEFFECTDATE), rowIndex);
            model.setValue(PRICEINVALIDDATE, (Object)prodPool.getDate(PRICEEFFECTDATE), rowIndex);
            model.setValue("minorderqty", prodPool.get("minorderqty"), rowIndex);
            model.setValue("leadtime", prodPool.get("leadtime"), rowIndex);
            if (!BIZTYPE_DOWNLOAD.equals(biztype)) continue;
            model.setValue("protocolentry", (Object)prodPool.getLong("protocolentry"), rowIndex);
            model.setValue("material", (Object)prodPool.getLong("material"), rowIndex);
            model.setValue("auxpty", (Object)prodPool.getLong("auxpty"), rowIndex);
        }
        if (BIZTYPE_DOWNLOAD.equals(biztype) && prodPools.size() == 0) {
            model.setValue("protocolentry", null, rowIndex);
            model.setValue("material", null, rowIndex);
            model.setValue("auxpty", null, rowIndex);
        }
        BigDecimal taxpriceB = new BigDecimal(String.valueOf(model.getValue(PROD_TAXPRICE, rowIndex)));
        BigDecimal price = prod.getBigDecimal(PROD_PRICE);
        DynamicObject unit = prod.getDynamicObject(PROD_UNIT);
        if ("A".equals(prod.getString("status")) && (taxpriceB = prod.getBigDecimal(PROD_TAXPRICE)).compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue(PROD_TAXPRICE, (Object)taxpriceB, rowIndex);
            this.calTaxprice(model, rowIndex, PROD_TAXPRICE);
            model.setValue(PROD_UNIT, (Object)unit, rowIndex);
        }
        if (null != price) {
            model.setValue(PROD_PRICE, (Object)price, rowIndex);
        }
        if (null != (taxPrice = prod.getBigDecimal(PROD_TAXPRICE))) {
            model.setValue(PROD_TAXPRICE, (Object)taxPrice, rowIndex);
        }
        if (null != (shopPrice = prod.getBigDecimal(PROD_SHOPPRICE))) {
            model.setValue(PROD_SHOPPRICE, (Object)shopPrice, rowIndex);
        }
        if (null != unit) {
            model.setValue(PROD_UNIT, (Object)unit, rowIndex);
        }
        Object pricetype = this.getModel().getValue("pricetype", rowIndex);
        if (null != oldValue || "A".equals(pricetype)) {
            this.getModel().deleteEntryData("subentryentity");
        }
    }

    private void doProdChangeAndEffectDeal(IDataModel model, String property, int rowIndex) {
        DynamicObject prod = (DynamicObject)model.getValue(property, rowIndex);
        if (prod == null) {
            if (null == model.getValue("protocolentry", rowIndex)) {
                model.setValue(PRICEEFFECTDATE, null, rowIndex);
                model.setValue(PRICEINVALIDDATE, null, rowIndex);
            }
            return;
        }
        this.prodChangePriceEffectValueSet(rowIndex, prod);
    }

    private void prodChangePriceEffectValueSet(int rowIndex, DynamicObject prod) {
        String protocolInvalidDateStr;
        String biztype = (String)this.getModel().getValue("biztype");
        if (BIZTYPE_DOWNLOAD.equals(biztype)) {
            return;
        }
        String protocolEffectDateStr = this.getPageCache().get("protocolEffectDate");
        if (StringUtils.isNotBlank((CharSequence)protocolEffectDateStr) && null == this.getModel().getValue(PRICEEFFECTDATE, rowIndex)) {
            this.getModel().setValue(PRICEEFFECTDATE, (Object)DateUtil.string2date((String)protocolEffectDateStr, (String)YYYY_MM_DD), rowIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)(protocolInvalidDateStr = this.getPageCache().get("protocolInvalidDate"))) && null == this.getModel().getValue(PRICEINVALIDDATE, rowIndex)) {
            this.getModel().setValue(PRICEINVALIDDATE, (Object)DateUtil.string2date((String)protocolInvalidDateStr, (String)YYYY_MM_DD), rowIndex);
        }
        ArrayList<Long> goodsIds = new ArrayList<Long>(8);
        goodsIds.add(prod.getLong("id"));
        this.setGoodsEffectDateToEntry(goodsIds);
    }

    private void doTaxrateChange(IDataModel model, String property, PropertyChangedArgs arg0, IFormView view) {
        int rowIndex1 = arg0.getChangeSet()[0].getRowIndex();
        IDataModel entryOperate = this.getModel();
        DynamicObject entry = entryOperate.getEntryRowEntity(ENTRY_ENTITY, rowIndex1);
        DynamicObject entryprod = entry.getDynamicObject(PROD_NUMBER);
        if (null == entryprod) {
            entry.set(PROD_TAXPRICE, null);
            return;
        }
        this.calTaxprice(model, rowIndex1, property);
    }

    private void calTaxprice(IDataModel model, int rowIndex1, String property) {
        DynamicObject entryprod = (DynamicObject)model.getValue(PROD_NUMBER, rowIndex1);
        if (null == entryprod) {
            return;
        }
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        if (null == model.getValue(property, rowIndex1)) {
            return;
        }
        taxPrice = (BigDecimal)model.getValue(property, rowIndex1);
        BigDecimal taxRate = entryprod.getBigDecimal(PROD_TAXRATE);
        int taxtype = entryprod.getInt("taxtype");
        price = 0 == taxtype ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)2) : CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)2);
        model.setValue(PROD_PRICE, (Object)price, rowIndex1);
        model.setValue(PROD_SHOPPRICE, (Object)taxPrice, rowIndex1);
    }

    private void doProtocaolIDChange(Object oldValue) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        boolean isTip = true;
        for (DynamicObject row : entrys) {
            if (row.getDynamicObject(PROD_NUMBER) == null) continue;
            isTip = false;
            break;
        }
        if (!isTip) {
            if (oldValue != null) {
                String protocolId = ((DynamicObject)oldValue).getString("id");
                this.getPageCache().put("doProtocolChangeOldValue", protocolId);
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("protocolid", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u534f\u8bae\u5207\u6362\u5c06\u6e05\u7a7a\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EntSupRequestEdit_9", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.protocolChange(this.getModel());
            this.setOrgData((AbstractFormDataModel)this.getModel());
            this.setMustInput(this.getModel());
            this.setProtocolLinkBtn();
            this.setBtnStatusByProtocolDiff();
        }
    }

    public void setProtocolLinkBtn() {
        DynamicObject protocolid = this.getModel().getDataEntity(true).getDynamicObject("protocolid");
        if (null == this.getModel().getValue("protocolid") || this.getModel().getValue("biztype").equals(BIZTYPE_DOWNLOAD)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_export", "bar_import", "bar_refresh", "quickcreategoods"});
        }
        if (null == protocolid || !protocolid.getBoolean("differentarea")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"proentryseq", "newentry", "deleteentry"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"proentryseq", "newentry", "deleteentry"});
        }
    }

    private void doPriceEffectDateChange(PropertyChangedArgs arg0) {
        String protocolEffectDateStr = this.getPageCache().get("protocolEffectDate");
        Object newValue = arg0.getChangeSet()[0].getNewValue();
        Object oldValue = arg0.getChangeSet()[0].getOldValue();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        String biztype = (String)this.getModel().getValue("biztype");
        if (newValue == null || biztype.equals(BIZTYPE_DOWNLOAD)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)protocolEffectDateStr)) {
            Date protocolEffectDate = DateUtil.string2date((String)protocolEffectDateStr, (String)YYYY_MM_DD);
            if (newValue != null && protocolEffectDate.after((Date)newValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"EntProdRequestEdit_7", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue(PRICEEFFECTDATE, oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView(ENTRY_ENTITY);
                return;
            }
        }
        Object priceInvalidDate = this.getModel().getValue(PRICEINVALIDDATE, rowIndex);
        if (newValue != null && priceInvalidDate != null && ((Date)newValue).after((Date)priceInvalidDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"EntProdRequestEdit_9", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(PRICEEFFECTDATE, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            return;
        }
    }

    private void doPriceInvalidDateChange(PropertyChangedArgs arg0) {
        Date protocolInvalidDate;
        String protocolInvalidDateStr = this.getPageCache().get("protocolInvalidDate");
        Object newValue = arg0.getChangeSet()[0].getNewValue();
        Object oldValue = arg0.getChangeSet()[0].getOldValue();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        String biztype = (String)this.getModel().getValue("biztype");
        if (newValue == null || biztype.equals(BIZTYPE_DOWNLOAD)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)protocolInvalidDateStr) && (protocolInvalidDate = DateUtil.string2date((String)protocolInvalidDateStr, (String)YYYY_MM_DD)).before((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"EntProdRequestEdit_8", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(PRICEINVALIDDATE, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            return;
        }
        Object priceEffectDate = this.getModel().getValue(PRICEEFFECTDATE, rowIndex);
        if (priceEffectDate != null && ((Date)newValue).before((Date)priceEffectDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u751f\u6548\u65e5\u671f\u3002", (String)"EntProdRequestEdit_10", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(PRICEINVALIDDATE, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            return;
        }
    }

    private void setMustInput(IDataModel model) {
        BasedataEdit goods = (BasedataEdit)this.getView().getControl(PROD_NUMBER);
        BasedataEdit classs = (BasedataEdit)this.getView().getControl(PROD_CLASS);
        DecimalEdit taxprice = (DecimalEdit)this.getView().getControl(PROD_TAXPRICE);
        taxprice.setMustInput(true);
        if (null != model.getValue("protocolid")) {
            goods.setMustInput(false);
            classs.setMustInput(false);
        } else {
            goods.setMustInput(true);
            classs.setMustInput(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String oldValue;
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"protocolid", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.protocolChange(this.getModel());
                this.setOrgData((AbstractFormDataModel)this.getModel());
                this.setMustInput(this.getModel());
            } else {
                this.getModel().beginInit();
                oldValue = this.getPageCache().get("doProtocolChangeOldValue");
                if (oldValue == null) {
                    this.getModel().setValue("protocolid", null);
                } else {
                    this.getModel().setValue("protocolid", (Object)Long.valueOf(oldValue));
                }
                this.getModel().endInit();
                this.getView().updateView("protocolid");
            }
            this.setProtocolLinkBtn();
            this.setBtnStatusByProtocolDiff();
            this.getPageCache().remove("doProtocolChangeOldValue");
        }
        if (StringUtils.equals((CharSequence)"orgChangeConfirm", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.doOrgChangeConfirm();
            } else {
                this.getModel().beginInit();
                oldValue = this.getPageCache().get("doOrgChangeOldValue");
                if (oldValue == null) {
                    this.getModel().setValue(ORG, null);
                } else {
                    this.getModel().setValue(ORG, (Object)Long.valueOf(oldValue));
                }
                this.getModel().endInit();
                this.getView().updateView(ORG);
            }
            this.getPageCache().remove("doOrgChangeOldValue");
        }
        if (StringUtils.equals((CharSequence)"minorderqty", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                IDataModel entryOperate = this.getModel();
                entryOperate.deleteEntryData("subentryentity");
            } else {
                String qtyStr = this.getPageCache().get("minorderqty");
                String rowIndex = this.getPageCache().get("rowIndex");
                this.getModel().setValue("minorderqty", (Object)new BigDecimal(qtyStr), Integer.parseInt(rowIndex));
            }
        }
        if (StringUtils.equals((CharSequence)"quickcreategoods", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.showGoodClass(true);
            } else {
                this.showGoodClass(false);
            }
        }
    }

    private void protocolChange(IDataModel model) {
        if (null == model.getValue("protocolid")) {
            model.deleteEntryData(ENTRY_ENTITY);
            this.getPageCache().remove("protocolEffectDate");
            this.getPageCache().remove("protocolInvalidDate");
        } else {
            model.deleteEntryData(ENTRY_ENTITY);
            DynamicObject protocolid = (DynamicObject)model.getValue("protocolid");
            this.setDefaultEntryData(protocolid.getString("id"));
            this.setProtocolEffectDefaultValue();
        }
    }

    private void setDefaultEntryData(String protocolId) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(protocolId));
        DynamicObjectCollection entryCol = QueryServiceHelper.query((String)"pmm_protocol", (String)"entryentity1.material", (QFilter[])qFilter.toArray());
        ArrayList<Long> idList = new ArrayList<Long>(1024);
        for (DynamicObject row : entryCol) {
            idList.add(row.getLong("entryentity1.material"));
        }
        HashMap<Long, Long> materiaId_goodMap = new HashMap<Long, Long>(1024);
        HashMap<String, Long> entry_goodMap = new HashMap<String, Long>();
        HashMap<String, DynamicObject> entry_bdMap = new HashMap<String, DynamicObject>();
        this.setGoodIds(materiaId_goodMap, idList, entry_goodMap, entry_bdMap, protocolId);
        this.setEntryProtocolData(idList, entry_goodMap, entry_bdMap);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel model = this.getModel();
        BasedataEdit supplier1 = (BasedataEdit)this.getView().getControl(SUPPLIER);
        supplier1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit goodsListener = (BasedataEdit)this.getView().getControl(PROD_NUMBER);
        goodsListener.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        goodsListener.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
        BasedataEdit classListener = (BasedataEdit)this.getView().getControl(PROD_CLASS);
        classListener.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit protocolid = (BasedataEdit)this.getView().getControl("protocolid");
        protocolid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        protocolid.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"ent_protocol", (String)"ent_protocol"));
        });
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)ENTRY_ENTITY, (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    public static final DynamicObject getSupplier(String supplierId) {
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(supplierId));
        String select = "id,createorg,group,entry_bank,bank.name,bankaccount,accountname,isdefault_bank,bizpartnerid";
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject suppliers = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)select, (QFilter[])filters);
        return null != suppliers ? suppliers : null;
    }

    private void setShopprice() {
        DynamicObject[] goodObjs;
        DynamicObjectCollection rows = null;
        rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<Object> prodList = new ArrayList<Object>();
        for (Object row : rows) {
            if (row.getDynamicObject(PROD_NUMBER) == null) continue;
            prodList.add(row.getDynamicObject(PROD_NUMBER).getPkValue());
        }
        ArrayList<Long> list = new ArrayList<Long>(prodList.size());
        for (Object e : prodList) {
            list.add(Long.parseLong(String.valueOf(e)));
        }
        QFilter fileter = new QFilter("id", "in", list);
        QFilter[] qFilterArray = new QFilter[]{fileter};
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pbd_goods", (boolean)false);
        for (DynamicObject goodObj : goodObjs = BusinessDataServiceHelper.load((String)"pbd_goods", (String)selectFields, (QFilter[])qFilterArray)) {
            goodObj.set(PROD_SHOPPRICE, (Object)goodObj.getString(PROD_TAXPRICE));
            goodObj.set(PROD_MALLSTATUS, (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])goodObjs);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObjectCollection rows = null;
        rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObject dynamicObject = (DynamicObject)rows.get(arg0.getRowIndex());
        DynamicObject o = (DynamicObject)dynamicObject.get(PROD_NUMBER);
        String productId = o.getString("id");
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)Long.parseLong(productId), null, null));
    }

    public void beforeF7Select(BeforeF7SelectEvent var1) {
        String key = var1.getProperty().getName();
        int rowIndex = var1.getRow();
        ListShowParameter showParameter = (ListShowParameter)var1.getFormShowParameter();
        Map paraMap = SrmCommonUtil.getSrmParameter();
        switch (key) {
            case "goods": {
                if (this.getModel().getValue(ORG) == null) {
                    var1.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba1\u6279\u5355\u4f4d\u3002", (String)"EntPriceRequestEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setGoodsFilter(showParameter, paraMap, rowIndex);
                break;
            }
            case "class": {
                this.setClassFilter(showParameter, paraMap);
                break;
            }
            case "protocolid": {
                if (this.getModel().getValue(ORG) == null) {
                    var1.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba1\u6279\u5355\u4f4d\u3002", (String)"EntPriceRequestEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setProtocolFilter(showParameter);
                break;
            }
            case "supplier": {
                this.setSupplierFilter(showParameter);
                break;
            }
            case "org": {
                if (!"click".equals(var1.getSourceMethod())) break;
                var1.setCancel(true);
                HashMap<String, String> paramMap = new HashMap<String, String>(8);
                paramMap.put("orgType", "purorg");
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"ent_orgselect", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orgclose"));
                break;
            }
        }
    }

    private void setClassFilter(ListShowParameter showParameter, Map<String, Boolean> paraMap) {
        if (paraMap.get("iscategoryctl").booleanValue()) {
            QFilter qFilter2 = QFilter.fromSerializedString((String)this.getPageCache().get("qFilter2"));
            showParameter.getListFilterParameter().setFilter(qFilter2);
        }
    }

    private void setGoodsFilter(ListShowParameter showParameter, Map<String, Boolean> paraMap, int rowIndex) {
        DynamicObject supplierdy;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (paraMap.get("iscategoryctl").booleanValue()) {
            QFilter qFilter = QFilter.fromSerializedString((String)this.getPageCache().get("qFilter"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
        if (null == (supplierdy = dataEntity.getDynamicObject(SUPPLIER))) {
            return;
        }
        QFilter filter = new QFilter(SUPPLIER, "=", (Object)supplierdy.getLong("id")).and(new QFilter("standard", "=", (Object)Long.parseLong("944841720602823680")));
        HashSet<Long> goodsSet = new HashSet<Long>(1024);
        Object protocolid = this.getModel().getValue("protocolid");
        String biztype = (String)this.getModel().getValue("biztype");
        Object protocolentry = this.getModel().getValue("protocolentry", rowIndex);
        if (null != protocolid) {
            QFilter qFilter = new QFilter("protocolid", "=", ((DynamicObject)protocolid).getPkValue());
            qFilter.and("biztype", "=", (Object)biztype);
            qFilter.and(new QFilter("cfmstatus", "=", (Object)"A"));
            DynamicObjectCollection prodRequests = QueryServiceHelper.query((String)"ent_prodrequest", (String)"protocolid,entryentity.goods,entryentity.protocolentry", (QFilter[])qFilter.toArray());
            for (DynamicObject row : prodRequests) {
                if (((DynamicObject)protocolid).getBoolean("differentarea")) {
                    Long protocolentryId = ((DynamicObject)protocolentry).getLong("id");
                    if (!protocolentryId.equals(row.getLong("entryentity.protocolentry"))) continue;
                    goodsSet.add(row.getLong("entryentity.goods"));
                    continue;
                }
                goodsSet.add(row.getLong("entryentity.goods"));
            }
            if (BIZTYPE_UPLOAD.equals(biztype)) {
                Object goodsIdsByCOnflict;
                QFilter prodPoolQFilter = new QFilter("protocol", "=", ((DynamicObject)protocolid).getPkValue());
                prodPoolQFilter.and(new QFilter(PROD_MALLSTATUS, "!=", (Object)MallStatusEnum.SOLDOUT.getVal()).and(PROD_MALLSTATUS, "!=", (Object)MallStatusEnum.BACKMODIFY.getVal()));
                DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"ent_prodpool", (String)"goods,protocol,protocolentry,protocolentry.purplanid", (QFilter[])prodPoolQFilter.toArray());
                for (DynamicObject prodPool : prodPools) {
                    if (dataEntity.getDynamicObject("protocolid").getBoolean("differentarea")) {
                        DynamicObject protocolentryDyn = (DynamicObject)protocolentry;
                        Long l = protocolentryDyn.getLong("id");
                        Long purplanid = protocolentryDyn.getDynamicObject("purplanid").getLong("id");
                        if (!l.equals(prodPool.getLong("protocolentry")) && !purplanid.equals(prodPool.getLong("protocolentry.purplanid"))) continue;
                        goodsSet.add(prodPool.getLong(PROD_NUMBER));
                        continue;
                    }
                    goodsSet.add(prodPool.getLong(PROD_NUMBER));
                }
                if (!(this.getModel().getDataEntity().getDynamicObject("protocolid").getBoolean("differentarea") && null == this.getModel().getValue("protocolentry", rowIndex) || (goodsIdsByCOnflict = this.getGoodsIdsByConflict(rowIndex)).size() <= 0)) {
                    filter.and("id", "not in", goodsIdsByCOnflict);
                    log.info("goodsIdsByCOnflict" + SerializationUtils.toJsonString((Object)goodsIdsByCOnflict));
                }
            } else {
                filter.and(new QFilter("protocolentry.prodpool.mallstatus", "in", Arrays.asList(MallStatusEnum.SOLD.getVal(), MallStatusEnum.UNSOLD.getVal())));
                filter.and(new QFilter("protocolentry.protocol", "=", ((DynamicObject)protocolid).getPkValue()));
                if (dataEntity.getDynamicObject("protocolid").getBoolean("differentarea")) {
                    if (null != protocolentry) {
                        DynamicObject protocolentryDyn = (DynamicObject)protocolentry;
                        filter.and(new QFilter("protocolentry.prodpool.protocolentry", "=", (Object)protocolentryDyn.getLong("id")));
                    } else {
                        DynamicObjectCollection entProdmanages = QueryServiceHelper.query((String)"ent_prodmanage", (String)"protocolentry.prodpool,id,protocolentry.prodpool.protocolentry", (QFilter[])filter.toArray());
                        HashMap<String, Long> goods_poolIdMap = new HashMap<String, Long>(1024);
                        for (Object row : entProdmanages) {
                            String key = row.getString("id") + "_" + row.getString("protocolentry.prodpool.protocolentry");
                            goods_poolIdMap.put(key, row.getLong("protocolentry.prodpool"));
                        }
                        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
                        for (Object row : entryCol) {
                            if (null == row.get(PROD_NUMBER) || null == row.get("protocolentry")) continue;
                            String string = row.getString("goods_id") + "_" + row.getString("protocolentry_id");
                            goods_poolIdMap.remove(string);
                        }
                        if (goods_poolIdMap.size() > 0) {
                            HashSet poolIds = new HashSet(1024);
                            for (Map.Entry entry : goods_poolIdMap.entrySet()) {
                                poolIds.add(entry.getValue());
                            }
                            filter.and(new QFilter("protocolentry.prodpool", "in", poolIds));
                        }
                    }
                }
            }
        } else {
            if (BIZTYPE_UPLOAD.equals(biztype)) {
                filter.and(new QFilter("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.SOLDOUT.getVal()).or("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.TEMPSTATUS.getVal()).or("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.BACKMODIFY.getVal()));
            } else {
                filter.and(new QFilter("protocolentry.prodpool.mallstatus", "in", Arrays.asList(MallStatusEnum.SOLD.getVal(), MallStatusEnum.UNSOLD.getVal())));
            }
            filter.and(new QFilter("protocolentry.protocol", "=", (Object)0L));
        }
        DynamicObjectCollection newObject = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        if (null == protocolid || !dataEntity.getDynamicObject("protocolid").getBoolean("differentarea")) {
            ArrayList<Object> list = new ArrayList<Object>(newObject.size());
            for (DynamicObject dyn : newObject) {
                Object goodsid = dyn.get("goods.id");
                if (null == goodsid) continue;
                list.add(dyn.get("goods.id"));
            }
            if (list.size() > 0) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", list));
                log.info("list" + SerializationUtils.toJsonString(list));
            }
        }
        if (null != protocolid && dataEntity.getDynamicObject("protocolid").getBoolean("differentarea") && null != protocolentry) {
            long purplanid = ((DynamicObject)protocolentry).getDynamicObject("purplanid").getLong("id");
            ArrayList<Object> list = new ArrayList<Object>(newObject.size());
            for (DynamicObject dyn : newObject) {
                Object goodsid = dyn.get("goods.id");
                if (dyn.getDynamicObject("protocolentry") == null) continue;
                long l = dyn.getDynamicObject("protocolentry").getDynamicObject("purplanid").getLong("id");
                if (null == goodsid || purplanid != l) continue;
                list.add(dyn.get("goods.id"));
            }
            if (list.size() > 0) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", list));
                log.info("list1" + SerializationUtils.toJsonString(list));
            }
            if (BIZTYPE_UPLOAD.equals(biztype)) {
                showParameter.setMultiSelect(false);
            }
        }
        if (goodsSet.size() > 0) {
            filter.and("id", "not in", goodsSet);
            log.info("goodsSet" + SerializationUtils.toJsonString(goodsSet));
        }
        showParameter.getListFilterParameter().getQFilters().add(filter);
        showParameter.setCustomParam("ismergerows", (Object)Boolean.TRUE);
    }

    private void setSupplierFilter(ListShowParameter showParameter) {
        showParameter.getListFilterParameter().getQFilters().add(new QFilter(BIZPARTER, "in", (Object)BizPartnerUtil.getBizPartnerId()));
    }

    private void setProtocolFilter(ListShowParameter showParameter) {
        QFilter qFilter = new QFilter("confirmstatus", "=", (Object)"C");
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        QFilter cfmStatusQFilter = new QFilter("protocolstatus", "=", (Object)"A");
        cfmStatusQFilter.or(new QFilter("protocolstatus", "=", (Object)"B"));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(cfmStatusQFilter);
        if (null != this.getModel().getValue(SUPPLIER)) {
            DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
            qFilter.and(new QFilter("partyb", "=", (Object)supplier.getLong("id")));
        } else {
            qFilter.and(BizPartnerUtil.assembleQFilterBizPartner());
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        qFilter.and(new QFilter(ORG, "=", (Object)org.getLong("id")));
        HashSet<Long> protocolIDS = new HashSet<Long>(1024);
        DynamicObjectCollection protocolCols = QueryServiceHelper.query((String)"ent_protocol", (String)"id", (QFilter[])qFilter.toArray());
        for (DynamicObject info : protocolCols) {
            protocolIDS.add(info.getLong("id"));
        }
        qFilter = new QFilter("protocolid", "in", protocolIDS);
        QFilter entReqcfmStatusQFilter = new QFilter("cfmstatus", "=", (Object)"E");
        entReqcfmStatusQFilter.or(new QFilter("cfmstatus", "=", (Object)"A"));
        qFilter.and(entReqcfmStatusQFilter);
        DynamicObjectCollection prodrequestCols = QueryServiceHelper.query((String)"ent_prodrequest", (String)"protocolid", (QFilter[])qFilter.toArray());
        for (DynamicObject info : prodrequestCols) {
            protocolIDS.remove(info.getLong("protocolid"));
        }
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", protocolIDS));
    }

    private void setQFilter(DynamicObject supplier, DynamicObject org) {
        Map paraMap = SrmCommonUtil.getSrmParameter();
        if (((Boolean)paraMap.get("iscategoryctl")).booleanValue() && supplier != null && org != null) {
            Set categorys = SrmCommonUtil.getGoodsCategoryBySupplier_Org((Long)SrmCommonUtil.getPkValue((DynamicObject)supplier), (Long)SrmCommonUtil.getPkValue((DynamicObject)org));
            QFilter qFilter = new QFilter("category", "in", (Object)categorys);
            this.getPageCache().put("qFilter", qFilter.toSerializedString());
            QFilter qFilter2 = new QFilter("id", "in", (Object)categorys);
            this.getPageCache().put("qFilter2", qFilter2.toSerializedString());
        }
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Map searchResult = e.getSearchResult();
        for (Map.Entry map : searchResult.entrySet()) {
            if (!PROD_NUMBER.equals(((BasedataItem)map.getKey()).getFieldKey())) continue;
            String searchKey = ((BasedataItem)map.getKey()).getSearchKey();
            String searchValue = ((BasedataItem)map.getKey()).getSearchValue();
            QFilter qFilter = new QFilter(searchKey, "=", (Object)searchValue);
            DynamicObjectCollection prods = QueryServiceHelper.query((String)((BasedataItem)map.getKey()).getEntityNumber(), (String)"id", (QFilter[])qFilter.toArray());
            if (prods.size() <= 0) continue;
            ((List)map.getValue()).add(((DynamicObject)prods.get(0)).getLong("id"));
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        ArrayList<Long> goodIds = new ArrayList<Long>(1024);
        boolean isDel = true;
        for (int index : rowIndexs) {
            DynamicObject good;
            if (null != this.getModel().getValue(PROD_NUMBER, index) && "A".equals((good = (DynamicObject)this.getModel().getValue(PROD_NUMBER, index)).getString("status"))) {
                goodIds.add(good.getLong("id"));
            }
            if (null == this.getModel().getValue("protocolentry", index)) continue;
            isDel = false;
            break;
        }
        String option = this.getPageCache().get("option");
        String biztype = (String)this.getModel().getValue("biztype");
        if (!isDel && option != null && !"save".equals(option) && !"resubmit".equals(option) && BIZTYPE_UPLOAD.equals(biztype)) {
            if ("deleteentry".equals(option)) {
                String msg = ResManager.loadKDString((String)"\u5173\u8054\u534f\u8bae\u6e05\u5355\u7684\u5546\u54c1\u660e\u7ec6\u5206\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdAuditProtocolEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
            e.setCancel(true);
        }
        if ("save".equals(option) || option == null) {
            e.setCancel(true);
        }
        this.getPageCache().remove("option");
        if (goodIds.size() > 0) {
            this.getPageCache().put(PROD_NUMBER, SerializationUtils.toJsonString(goodIds));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (null == this.getPageCache().get(PROD_NUMBER)) {
            return;
        }
        List goods = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PROD_NUMBER), List.class);
        this.deleteSaveGoods(goods);
    }

    private void deleteSaveGoods(List<Object> goods) {
        ArrayList<Long> goodIds = new ArrayList<Long>(goods.size());
        for (Object id : goods) {
            goodIds.add(Long.parseLong(String.valueOf(id)));
        }
        if (goodIds.size() > 0) {
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)"ent_prodmanage", (Object[])goodIds.toArray(), (OperateOption)saveOption);
            if (!deleteResullt.isSuccess()) {
                log.error(ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo()));
            } else {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"new")) {
            this.getView().getFormShowParameter().getCustomParams().clear();
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save") || StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit")) {
            this.getPageCache().put("option", "save");
            this.checkGoodsUnqiue(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"deleteentry")) {
            this.getPageCache().put("option", "deleteentry");
        }
        if ((StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"exportlist") || StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"importdata")) && this.getModel().getDataEntity(true).getPkValue().equals(0L)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u4e00\u4e0b\u3002", (String)"EntSupRequestEdit_11", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"quickcreategoods")) {
            this.checkQuickCreateGoods(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"batchimportimage")) {
            this.checkBatchImportImage(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"setladderprice")) {
            this.setLadderPrice(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"viewpurorg")) {
            this.viewPurOrg(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"resubmit")) {
            this.checkResubmit(args);
        }
    }

    private void checkResubmit(BeforeDoOperationEventArgs args) {
        DynamicObject info = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = info.getDynamicObjectCollection(ENTRY_ENTITY);
        String cfmStatus = info.getString("cfmstatus");
        if ("C".equals(cfmStatus) || "D".equals(cfmStatus)) {
            long protocolid = 0L;
            if (null != info.get("protocolid")) {
                protocolid = info.getLong("protocolid.id");
            }
            String biztype = info.getString("biztype");
            HashSet<Long> goodIDs = new HashSet<Long>(1024);
            if ("C".equals(cfmStatus)) {
                for (DynamicObject row : entryCol) {
                    if (null == row.get(PROD_NUMBER)) continue;
                    String result = row.getString("entryresult");
                    long good = row.getLong("goods.id");
                    if (!"0".equals(result) || 0L == good) continue;
                    goodIDs.add(good);
                }
            }
            if ("D".equals(cfmStatus)) {
                for (DynamicObject row : entryCol) {
                    long good;
                    if (null == row.get(PROD_NUMBER) || 0L == (good = row.getLong("goods.id"))) continue;
                    goodIDs.add(good);
                }
            }
            if (protocolid == 0L) {
                this.resubmitNoProtocolCheck(args, goodIDs, biztype);
            }
        }
    }

    private void resubmitNoProtocolCheck(BeforeDoOperationEventArgs args, Set<Long> goodIDs, String biztype) {
        if (goodIDs.size() > 0) {
            StringBuilder goodsNumber = new StringBuilder();
            QFilter qFilter1 = new QFilter(PROD_NUMBER, "in", goodIDs);
            DynamicObjectCollection goodPools = QueryServiceHelper.query((String)"ent_prodpool", (String)"id,mallstatus,protocol,goods.number number", (QFilter[])qFilter1.toArray());
            HashSet<String> goodsNumbers = new HashSet<String>(16);
            for (DynamicObject goodPool : goodPools) {
                if (goodPool.getLong("protocol") != 0L) {
                    goodsNumbers.add(goodPool.getString("number"));
                    continue;
                }
                String mallStatus = goodPool.getString(PROD_MALLSTATUS);
                if (BIZTYPE_UPLOAD.equals(biztype) && (MallStatusEnum.SOLD.getVal().equals(mallStatus) || MallStatusEnum.UNSOLD.getVal().equals(mallStatus))) {
                    goodsNumbers.add(goodPool.getString("number"));
                    continue;
                }
                if (!BIZTYPE_DOWNLOAD.equals(biztype) || MallStatusEnum.SOLD.getVal().equals(mallStatus) || MallStatusEnum.UNSOLD.getVal().equals(mallStatus)) continue;
                goodsNumbers.add(goodPool.getString("number"));
            }
            if (goodsNumbers.size() > 0) {
                for (String key : goodsNumbers) {
                    goodsNumber.append(key).append('\n');
                }
                String msg = ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u4e2d\u90e8\u5206\u5546\u54c1\u5df2\u4e0a\u67b6/\u5df2\u5173\u8054\u534f\u8bae\uff0c\u4e0d\u652f\u6301\u91cd\u65b0\u7533\u8bf7\uff0c\u8bf7\u624b\u5de5\u65b0\u589e\u4e0a\u67b6\u7533\u8bf7\u5355\u3002", (String)"EntProdRequestList_5", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                if (BIZTYPE_DOWNLOAD.equals(biztype)) {
                    msg = ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u4e2d\u90e8\u5206\u5546\u54c1\u5df2\u4e0b\u67b6/\u5df2\u5173\u8054\u534f\u8bae\uff0c\u4e0d\u652f\u6301\u91cd\u65b0\u7533\u8bf7\uff0c\u8bf7\u624b\u5de5\u65b0\u589e\u4e0b\u67b6\u7533\u8bf7\u5355\u3002", (String)"EntSupRequestEdit_14", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                }
                this.getView().showMessage(msg, goodsNumber.toString(), MessageTypes.Default);
                args.setCancel(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkGoodsUnqiue(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject protocolid = dataEntity.getDynamicObject("protocolid");
        if (null == protocolid || !protocolid.getBoolean("differentarea")) {
            return;
        }
        HashMap<String, void> purPlanId_SeqsMap = new HashMap<String, void>(1024);
        for (Object row : entryCol) {
            void var8_8;
            if (null == row.getDynamicObject(PROD_NUMBER)) continue;
            ArrayList arrayList = new ArrayList(1024);
            String key = row.getDynamicObject("protocolentry").getDynamicObject("purplanid").getString("id") + row.getDynamicObject(PROD_NUMBER).getString("id");
            if (null != purPlanId_SeqsMap.get(key)) {
                List list = (List)purPlanId_SeqsMap.get(key);
            }
            var8_8.add(row.getInt(PROD_SEQ));
            purPlanId_SeqsMap.put(key, var8_8);
        }
        ArrayList seqList = new ArrayList(1024);
        for (Map.Entry entry : purPlanId_SeqsMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            seqList.addAll((Collection)entry.getValue());
        }
        if (seqList.size() > 0) {
            Collections.sort(seqList);
            StringBuilder stringBuilder = new StringBuilder();
            for (Integer seq : seqList) {
                DynamicObject row = (DynamicObject)entryCol.get(seq - 1);
                String number = row.getDynamicObject(PROD_NUMBER).getString("number");
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u5546\u54c1\u7f16\u7801\uff1a{1}\uff1b", (String)"EntProdRequestEdit_24", (String)"scm-ent-formplugin", (Object[])new Object[]{seq, number});
                stringBuilder.append(msg).append('\n');
            }
            String string = ResManager.loadKDString((String)"\u4e00\u4e2a\u91c7\u4e70\u65b9\u6848\u4e0b\u4e0d\u5141\u8bb8\u51fa\u73b0\u91cd\u590d\u5546\u54c1\u3002", (String)"EntProdRequestEdit_23", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(string, stringBuilder.toString(), MessageTypes.Default);
            args.setCancel(true);
        }
    }

    private void viewPurOrg(BeforeDoOperationEventArgs args) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObject goods = row.getDynamicObject(PROD_NUMBER);
        DynamicObject protocolentry = row.getDynamicObject("protocolentry");
        DynamicObject protocolid = dataEntity.getDynamicObject("protocolid");
        if (null == goods && null == protocolid || null != protocolid && null == goods) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5546\u54c1\u518d\u67e5\u770b\u91c7\u4e70\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"EntProdRequestEdit_21", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ent_orgscopesetting");
        ArrayList<Long> goodsIds = new ArrayList<Long>(1024);
        if (null != goods) {
            goodsIds.add(goods.getLong("id"));
        }
        detailParamMap.put("goodsid", goodsIds);
        if (null != protocolentry) {
            detailParamMap.put("protocolentryid", protocolentry.getLong("id"));
        }
        if (null != protocolid) {
            detailParamMap.put("protocolid", protocolid.getLong("id"));
            detailParamMap.put("differentarea", protocolid.getBoolean("differentarea"));
        }
        detailParamMap.put("status", "0");
        showParameter.setCustomParams(detailParamMap);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "viewpurorg"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setLadderPrice(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        if ("A".equals((row = (DynamicObject)entryCol.get(rowIndex)).getString("pricetype"))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u4ef7\u683c\u7c7b\u578b\u4e3a\u9636\u68af\u4ef7\u624d\u80fd\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"EntProdRequestEdit_22", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        BigDecimal minorderqty = row.getBigDecimal("minorderqty");
        if (minorderqty.compareTo(BigDecimal.ZERO) == 0) {
            minorderqty = BigDecimal.ZERO;
        }
        DynamicObjectCollection subEntryRows = row.getDynamicObjectCollection("subentryentity");
        List<Object> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
        for (DynamicObject subrow : subEntryRows) {
            if (subrow.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) <= 0) continue;
            LadderPriceInfo info = new LadderPriceInfo(subrow.getBigDecimal("qtyfrom"), subrow.getBigDecimal("qtyto"), subrow.getBigDecimal("ladprice"), Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id")));
            ladderPriceInfos.add(info);
        }
        BigDecimal price = row.getBigDecimal(PROD_TAXPRICE);
        if (ladderPriceInfos.size() < 2) {
            ladderPriceInfos.clear();
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty, minorderqty.add(BigDecimal.ONE), price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty.add(BigDecimal.ONE), BigDecimal.ZERO, price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        Object billstatus = this.getModel().getValue("billstatus");
        Object biztype = this.getModel().getValue("biztype");
        if ("A".equals(billstatus) && BIZTYPE_UPLOAD.equals(biztype)) {
            detailParamMap.put("status", "0");
        } else {
            detailParamMap.put("status", BIZTYPE_UPLOAD);
        }
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    public void initialize() {
    }

    private void checkBatchImportImage(BeforeDoOperationEventArgs args) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EntProdRequestEdit_15", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(1024);
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (int seq : selectRows) {
            DynamicObject row = (DynamicObject)entryCol.get(seq);
            DynamicObject goods = row.getDynamicObject(PROD_NUMBER);
            if (null == goods) continue;
            idList.add(goods.getLong("id"));
        }
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,supplier", (QFilter[])new QFilter("id", "in", idList).toArray());
        HashSet goodIds = new HashSet(dynList.size());
        dynList.forEach(t -> goodIds.add(t.getLong(SUPPLIER)));
        if (goodIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u3002", (String)"EntProdManageList_31", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (idList.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u6570\u91cf\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EntProdManageList_32", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ent_importpicture");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        detailParamMap.put("goodsIds", idList);
        detailParamMap.put("origin", "ent");
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"quickcreategoods") && null != (returnData = e.getReturnData())) {
            Object classId = ((ListSelectedRowCollection)e.getReturnData()).get(0).getPrimaryKeyValue();
            this.quickCreateGoods(classId);
            this.doQuickCreateOp();
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"setladderprice")) {
            this.doSetladderprice(e);
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"orgclose") && null != e.getReturnData()) {
            returnData = (HashMap)e.getReturnData();
            List orgIdList = (List)returnData.get("orgIdList");
            for (String orgId : orgIdList) {
                this.getModel().setValue(ORG, (Object)Long.valueOf(orgId));
            }
            this.getView().updateView(ORG);
        }
    }

    private void doQuickCreateOp() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isshowmessage", "false");
        OperationResult operationResult = this.getView().invokeOperation("save", operateOption);
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5546\u54c1\u521b\u5efa\u6210\u529f\u3002", (String)"EntProdRequestEdit_27", (String)"scm-ent-formplugin", (Object[])new Object[0]));
        } else {
            CommonUtil.check((OperationResult)operationResult);
        }
    }

    private void doSetladderprice(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (null != returnData) {
            Map returnDataMap = (Map)returnData;
            List entryList = (List)returnDataMap.get("entry");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("subentryentity");
            int index = 0;
            BigDecimal price = BigDecimal.ZERO;
            for (LadderPriceInfo info : entryList) {
                vs.set("qtyfrom", (Object)info.getQtyfrom(), index);
                vs.set("qtyto", (Object)info.getQtyto(), index);
                vs.set("ladprice", (Object)info.getLadprice(), index);
                if (index == 0) {
                    price = info.getLadprice();
                }
                ++index;
            }
            model.beginInit();
            model.batchCreateNewEntryRow("subentryentity", vs);
            model.endInit();
            this.getView().updateView("subentryentity");
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectRows = grid.getSelectRows();
            int rowIndex = selectRows[0];
            if (null != this.getPageCache().get("row")) {
                rowIndex = Integer.parseInt(this.getPageCache().get("row"));
                this.getPageCache().remove("row");
            }
            this.getModel().setValue(PROD_TAXPRICE, (Object)price, rowIndex);
        }
    }

    private void quickCreateGoods(Object classId) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        long bizpartner = dataEntity.getDynamicObject(BIZPARTER).getLong("id");
        DynamicObject supplierDyn = this.getSupplierDyn(bizpartner);
        ArrayList<DynamicObject> prods = new ArrayList<DynamicObject>(1024);
        HashMap<Integer, DynamicObject> seq_GoodsMap = new HashMap<Integer, DynamicObject>(1024);
        String indexstr = this.getPageCache().get("index");
        if (null == indexstr || StringUtils.isEmpty((CharSequence)indexstr)) {
            this.getPageCache().remove("index");
            return;
        }
        List indexs = (List)SerializationUtils.fromJsonString((String)indexstr, List.class);
        Iterator iterator = indexs.iterator();
        while (iterator.hasNext()) {
            int seq = (Integer)iterator.next();
            DynamicObject row = (DynamicObject)entryCol.get(seq);
            DynamicObject protocolentry = row.getDynamicObject("protocolentry");
            if (null == protocolentry || protocolentry.getString("materialname").isEmpty()) continue;
            DynamicObject goods = this.createEntProdmanage(row, bizpartner, classId, supplierDyn);
            prods.add(goods);
            seq_GoodsMap.put(row.getInt(PROD_SEQ), goods);
        }
        this.getPageCache().remove("index");
        if (prods.size() > 0) {
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult saveResullt = OperationServiceHelper.executeOperate((String)"save", (String)"ent_prodmanage", (DynamicObject[])prods.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            if (!saveResullt.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)saveResullt.getAllErrorOrValidateInfo()));
            } else {
                IDataModel entryOperate = this.getModel();
                for (Integer seq : indexs) {
                    if (null == seq_GoodsMap.get(seq + 1)) continue;
                    DynamicObject googds = (DynamicObject)seq_GoodsMap.get(seq + 1);
                    this.getModel().setValue(PROD_NUMBER, (Object)googds, seq.intValue());
                    entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, seq.intValue());
                    entryOperate.deleteEntryData("subentryentity");
                }
            }
        }
    }

    private void checkQuickCreateGoods(BeforeDoOperationEventArgs args) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EntProdRequestEdit_15", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        boolean isExistGoods = false;
        boolean isEmptyGoods = true;
        for (int seq : selectRows) {
            DynamicObject row = (DynamicObject)entryCol.get(seq);
            DynamicObject protocolentry = row.getDynamicObject("protocolentry");
            if (null == protocolentry || protocolentry.getString("materialname").isEmpty()) continue;
            isEmptyGoods = false;
            if (null == row.getDynamicObject(PROD_NUMBER)) continue;
            isExistGoods = true;
        }
        if (isEmptyGoods) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7269\u6599\uff0c\u65e0\u6cd5\u81ea\u52a8\u521b\u5efa\u5546\u54c1\u3002", (String)"EntProdRequestEdit_16", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (isExistGoods) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("quickcreategoods", (IFormPlugin)this);
            String confirmTip = "";
            confirmTip = selectRows.length == 1 ? ResManager.loadKDString((String)"\u8be5\u884c\u5df2\u5b58\u5728\u5546\u54c1\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"EntProdRequestEdit_18", (String)"scm-ent-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u90e8\u5206\u884c\u4e2d\u5df2\u5b58\u5728\u5546\u54c1\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"EntProdRequestEdit_19", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.showGoodClass(false);
        }
    }

    private void showGoodClass(boolean isYesNo) {
        int[] selectRows;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        long bizpartner = dataEntity.getDynamicObject(BIZPARTER).getLong("id");
        DynamicObject supplier = this.getSupplierDyn(bizpartner);
        DynamicObject goods = this.createEntProdmanage((DynamicObject)entryCol.get(0), bizpartner, 0L, supplier);
        ArrayList<Integer> indexs = new ArrayList<Integer>(1024);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        for (int index : selectRows = grid.getSelectRows()) {
            DynamicObject protocolentry;
            DynamicObject row = (DynamicObject)entryCol.get(index);
            if (isYesNo) {
                indexs.add(index);
            }
            if (null == (protocolentry = row.getDynamicObject("protocolentry")) || protocolentry.getString("materialname").isEmpty() || isYesNo || null != row.getDynamicObject(PROD_NUMBER)) continue;
            indexs.add(index);
        }
        if (indexs.size() == 0) {
            return;
        }
        this.getPageCache().put("index", SerializationUtils.toJsonString(indexs));
        String orgId = null;
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"ent_prodmanage", (DynamicObject)goods, orgId);
        if (null == codeRule) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u542f\u7528\u5546\u54c1\u7f16\u7801\u89c4\u5219\u3002", (String)"EntProdRequestEdit_17", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Long> materialGroupIds = this.getMaterialGroupIdsByMaterialIds(indexs);
        Map<Long, List<Long>> categoryMatMapping = this.getCategoryMatMappingByMaterialGroupIds(materialGroupIds);
        if (materialGroupIds.size() == 1 && !categoryMatMapping.isEmpty() && categoryMatMapping.entrySet().iterator().next().getValue().size() == 1) {
            this.quickCreateGoods(categoryMatMapping.get(materialGroupIds.iterator().next()).get(0));
            this.doQuickCreateOp();
            return;
        }
        List<Long> categoryMappingsIntersection = this.getCategoryMappingsIntersection(categoryMatMapping);
        if (categoryMappingsIntersection.isEmpty() && !categoryMatMapping.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u53ef\u9009\u5546\u54c1\u5206\u7c7b\u65e0\u4ea4\u96c6\uff0c\u8bf7\u5206\u5f00\u521b\u5efa\u5546\u54c1\u3002", (String)"EntProdRequestEdit_26", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter classQfilter = new QFilter("number", "=", (Object)"00000801");
        DynamicObjectCollection classStards = QueryServiceHelper.query((String)"bd_goodsclassstandard", (String)"id", (QFilter[])classQfilter.toArray());
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bd_item_classtreelistf7");
        parameter.setBillFormId("mdr_goodsclass");
        parameter.getOpenStyle().setShowType(ShowType.Default);
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "quickcreategoods"));
        parameter.setShowTitle(false);
        parameter.setLookUp(true);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setMultiSelect(false);
        parameter.setHasRight(true);
        QFilter qFilter = new QFilter("level", "=", (Object)3);
        qFilter.and("enable", "=", (Object)BIZTYPE_UPLOAD);
        qFilter.and("standard.number", "=", (Object)"00000801");
        if (!categoryMappingsIntersection.isEmpty()) {
            qFilter.and("id", "in", categoryMappingsIntersection);
        }
        parameter.getListFilterParameter().getQFilters().add(qFilter);
        HashMap<String, Long> paramMap = new HashMap<String, Long>(1024);
        if (classStards.size() > 0) {
            paramMap.put("groupStandard", ((DynamicObject)classStards.get(0)).getLong("id"));
        }
        parameter.getCustomParams().putAll(paramMap);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private Set<Long> getMaterialGroupIdsByMaterialIds(List<Integer> indexs) {
        ArrayList<Long> materialIds = new ArrayList<Long>(indexs.size());
        for (Integer index : indexs) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index.intValue());
            DynamicObject material = entryRowEntity.getDynamicObject("material");
            if (material == null) continue;
            materialIds.add(material.getLong("id"));
        }
        QFilter qFilter = new QFilter("material.id", "in", materialIds);
        qFilter.and(new QFilter("standard", "=", (Object)BillAssistConstant.MATERIAL_STANDARD_ID));
        HashSet<Long> materialGroupIds = new HashSet<Long>(materialIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialgroupdetail", (String)"group.id group", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> materialGroupIds.add(row.getLong("group")));
        }
        return materialGroupIds;
    }

    private Map<Long, List<Long>> getCategoryMatMappingByMaterialGroupIds(Set<Long> materialGroupIds) {
        HashMap<Long, List<Long>> categoryMatMapping = new HashMap<Long, List<Long>>(materialGroupIds.size());
        QFilter mappingQFilter = new QFilter("materialgroup.id", "in", materialGroupIds);
        mappingQFilter.and("goodscategory.standard.id", "=", (Object)944841720602823680L);
        mappingQFilter.and("goodscategory.enable", "=", (Object)BIZTYPE_UPLOAD);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_categorymatmapping", (String)"materialgroup,goodscategory", (QFilter[])mappingQFilter.toArray(), null);){
            dataSet.forEach(row -> {
                List materialGroup = categoryMatMapping.computeIfAbsent(row.getLong("materialgroup"), k -> new ArrayList());
                materialGroup.add(row.getLong("goodscategory"));
            });
        }
        return categoryMatMapping;
    }

    private List<Long> getCategoryMappingsIntersection(Map<Long, List<Long>> categoryMatMapping) {
        List<Long> goodsCategoryIds = new ArrayList<Long>(categoryMatMapping.size());
        if (categoryMatMapping.isEmpty()) {
            return goodsCategoryIds;
        }
        int i = 0;
        for (Map.Entry<Long, List<Long>> entry : categoryMatMapping.entrySet()) {
            List<Long> value = entry.getValue();
            if (++i == 1) {
                goodsCategoryIds = value;
                continue;
            }
            goodsCategoryIds.retainAll(value);
        }
        return goodsCategoryIds;
    }

    private DynamicObject getSupplierDyn(long bizpartner) {
        QFilter qFilter = new QFilter(BIZPARTER, "=", (Object)bizpartner);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (null != dataEntity.get(SUPPLIER)) {
            if (dataEntity.get(SUPPLIER) instanceof DynamicObject) {
                qFilter.and(new QFilter("id", "=", (Object)dataEntity.getDynamicObject(SUPPLIER).getLong("id")));
            } else {
                Long supplierId = Long.parseLong(String.valueOf(dataEntity.get(SUPPLIER)));
                qFilter.and(new QFilter("id", "=", (Object)supplierId));
            }
        }
        DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,createorg.id", (QFilter[])qFilter.toArray());
        return supplier;
    }

    private DynamicObject createEntProdmanage(DynamicObject row, long bizpartner, Object classId, DynamicObject supplier) {
        DynamicObject entGood = ORM.create().newDynamicObject("ent_prodmanage");
        ORM.create().setPrimaryKey(entGood);
        DynamicObject protocolentry = row.getDynamicObject("protocolentry");
        entGood.set("name", (Object)protocolentry.getString("materialname"));
        String goodsbrand = "";
        entGood.set(PROD_PRICE, (Object)protocolentry.getBigDecimal(PROD_PRICE));
        if (null != protocolentry.getDynamicObject("taxrateid")) {
            entGood.set("taxrateid", (Object)protocolentry.getDynamicObject("taxrateid"));
            entGood.set(PROD_TAXRATE, (Object)protocolentry.getBigDecimal(PROD_TAXRATE));
        }
        entGood.set(PROD_TAXPRICE, (Object)protocolentry.getBigDecimal(PROD_TAXPRICE));
        entGood.set(PROD_UNIT, (Object)protocolentry.getDynamicObject(PROD_UNIT));
        entGood.set("category_id", (Object)Long.parseLong(String.valueOf(classId)));
        entGood.set("origin", (Object)BIZTYPE_UPLOAD);
        entGood.set("status", (Object)"A");
        entGood.set("enable", (Object)BIZTYPE_UPLOAD);
        entGood.set(PROD_MALLSTATUS, (Object)"F");
        entGood.set("taxtype", (Object)BIZTYPE_UPLOAD);
        entGood.set("source", (Object)BIZTYPE_UPLOAD);
        entGood.set("standard", (Object)Long.parseLong("944841720602823680"));
        entGood.set(BIZPARTER, (Object)bizpartner);
        if (null != supplier) {
            entGood.set("supplier_id", (Object)supplier.getLong("id"));
            entGood.set("createorg_id", (Object)supplier.getLong("createorg.id"));
        }
        entGood.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        DynamicObject protocolid = this.getModel().getDataEntity(true).getDynamicObject("protocolid");
        if (null != protocolid) {
            entGood.set("curr", (Object)protocolid.getDynamicObject("curr"));
        }
        return entGood;
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue(ENTRY_ENTITY);
        List dataList = (List)e.getSourceData().get(ENTRY_ENTITY);
        for (DynamicObject row : billentrys) {
            int seq = row.getInt(PROD_SEQ) - 1;
            for (Object obj : dataList) {
                Map entry = (Map)obj;
                if (!row.getString("id").equals(entry.get("id")) || entry.get(PROD_NUMBER) != null) continue;
                model.setValue(PROD_NUMBER, null, seq);
                row.set(PROD_NUMBER, null);
            }
            BigDecimal taxprice = row.getBigDecimal(PROD_TAXPRICE);
            this.doProdChange(model, PROD_NUMBER, seq, null);
            if (null == row.getDynamicObject(PROD_NUMBER)) continue;
            model.setValue(PROD_TAXPRICE, (Object)taxprice, seq);
            this.calTaxprice(model, seq, PROD_TAXPRICE);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map supplierCOl = (Map)e.getSourceData().get(SUPPLIER);
        Map protocolidCol = (Map)e.getSourceData().get("protocolid");
        Object supNumber = supplierCOl.get("number");
        Object proBillno = protocolidCol.get("billno");
        Object billno = e.getSourceData().get("billno");
        QFilter prodFilter = new QFilter("billno", "=", billno);
        DynamicObjectCollection prodreques = QueryServiceHelper.query((String)"ent_prodrequest", (String)"bizpartner,curr,supplier.number,protocolid.billno,protocolid.effectdate,protocolid.invaliddate", (QFilter[])prodFilter.toArray());
        if (prodreques.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a\u8be5\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"EntProdRequestEdit_4", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(String.format(msg, new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        String srcNumber = ((DynamicObject)prodreques.get(0)).getString("supplier.number");
        String srcBillno = ((DynamicObject)prodreques.get(0)).getString("protocolid.billno");
        Date proEffectDate = ((DynamicObject)prodreques.get(0)).getDate("protocolid.effectdate");
        Date proInvalidDate = ((DynamicObject)prodreques.get(0)).getDate("protocolid.invaliddate");
        if (null == supNumber || !supNumber.equals(srcNumber)) {
            String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a\u5f15\u5165\u5546\u5bb6\u7f16\u7801\u4e0e\u5f53\u524d\u5355\u636e\u5546\u5bb6\u7f16\u7801\u4e0d\u4e00\u81f4\u3002", (String)"EntProdRequestEdit_5", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(String.format(msg, new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        if (null == proBillno || !proBillno.equals(srcBillno)) {
            String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a\u5f15\u5165\u534f\u8bae\u7f16\u7801\u4e0e\u5f53\u524d\u5355\u636e\u534f\u8bae\u7f16\u7801\u4e0d\u4e00\u81f4\u3002", (String)"EntProdRequestEdit_6", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(String.format(msg, new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        List entryCOl = (List)e.getSourceData().get(ENTRY_ENTITY);
        for (int i = 0; i < entryCOl.size(); ++i) {
            Date priceInvalidDate;
            Date priceInvalidDate2;
            String msg;
            Date priceEffectDate;
            Map row = (Map)entryCOl.get(i);
            String priceEffectDateStr = (String)row.get(PRICEEFFECTDATE);
            String priceInvalidDateStr = (String)row.get(PRICEINVALIDDATE);
            if (null != priceEffectDateStr && (priceEffectDate = DateUtil.string2date((String)priceEffectDateStr, (String)YYYY_MM_DD)).before(proEffectDate)) {
                msg = ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"EntProdRequestEdit_11", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg);
                e.setFireAfterImportData(false);
                return;
            }
            if (null != priceInvalidDateStr && (priceInvalidDate2 = DateUtil.string2date((String)priceInvalidDateStr, (String)YYYY_MM_DD)).after(proInvalidDate)) {
                msg = ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"EntProdRequestEdit_12", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg);
                e.setFireAfterImportData(false);
                return;
            }
            if (null == priceEffectDateStr || null == priceInvalidDateStr || !(priceEffectDate = DateUtil.string2date((String)priceEffectDateStr, (String)YYYY_MM_DD)).after(priceInvalidDate = DateUtil.string2date((String)priceInvalidDateStr, (String)YYYY_MM_DD))) continue;
            String msg2 = ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"EntProdRequestEdit_13", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg2);
            e.setFireAfterImportData(false);
            return;
        }
    }

    public void handleData(BasedataFuzzySearchEvent arg0) {
        List queryData = arg0.getQueryData();
        MalFuzzySearchUtil.queryDataDuplicatesRemoveByNumber((List)queryData);
    }

    private Set<Long> getGoodsIdsByConflict(int rowIndex) {
        HashSet<Long> remoeGoodsIds = new HashSet<Long>(1024);
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
        if (protocol == null || supplier == null) {
            return remoeGoodsIds;
        }
        Long srcProtocolId = protocol.getLong("id");
        boolean differentarea = protocol.getBoolean("differentarea");
        Date effectdate = protocol.getDate("effectdate");
        Date invaliddate = DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)protocol.getDate("invaliddate")), (String)"yyyy-MM-dd HH:mm:ss");
        String purmode = protocol.getString("purmode");
        QFilter qFilter = new QFilter("partyb.id", "=", (Object)supplier.getLong("id"));
        qFilter.and(new QFilter("effectdate", "<=", (Object)invaliddate));
        qFilter.and(new QFilter("invaliddate", ">=", (Object)effectdate));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        Map<Long, Map<String, Object>> protocolId_DynMap = this.getProtocolMap(qFilter);
        HashSet<Long> conflictIds = new HashSet<Long>(1024);
        Map<String, Object> srcDataMap = protocolId_DynMap.get(srcProtocolId);
        Set srcOrgSet = (Set)srcDataMap.get("orgs");
        if (differentarea) {
            DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
            Long l = row.getDynamicObject("protocolentry").getLong("id");
            Map entryOrgs = (Map)srcDataMap.get("entryOrgs");
            if (null != entryOrgs.get(l)) {
                srcOrgSet = (Set)entryOrgs.get(l);
            }
        }
        for (Map.Entry entry : protocolId_DynMap.entrySet()) {
            Long id = (Long)entry.getKey();
            if (srcProtocolId.equals(id)) continue;
            Map dataMap = (Map)entry.getValue();
            Date tarEffectdate = (Date)dataMap.get("effectdate");
            Date tarInvaliddate = (Date)dataMap.get("invaliddate");
            Set tarOrgSet = (Set)dataMap.get("orgs");
            Set<Long> diffOrgIds = this.getDiffOrgId(srcOrgSet, tarOrgSet);
            if (null == tarEffectdate || null == tarInvaliddate || effectdate.after(tarInvaliddate) || invaliddate.before(tarEffectdate) || !purmode.equals(BIZTYPE_UPLOAD) && diffOrgIds.size() <= 0) continue;
            conflictIds.add(id);
        }
        if (conflictIds.size() > 0) {
            QFilter filter = new QFilter("protocol.id", "in", conflictIds);
            QFilter qFilter2 = new QFilter("protocol.protocolstatus", "=", (Object)"A");
            qFilter2.or(new QFilter("protocol.protocolstatus", "=", (Object)"B"));
            QFilter malstatus = new QFilter(PROD_MALLSTATUS, "=", (Object)"A");
            malstatus.or(new QFilter(PROD_MALLSTATUS, "=", (Object)"B"));
            QFilter salestatus = new QFilter("salestatus", "=", (Object)"A");
            salestatus.or(new QFilter("salestatus", "=", (Object)"C"));
            filter.and(qFilter2).and(malstatus).and(salestatus);
            String prodSectlors = "id,goods.id,entryentity.orgname,protocolentry.purplanid";
            DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"pmm_prodpool", (String)prodSectlors, (QFilter[])new QFilter[]{filter});
            boolean isgoodvisible = (Boolean)srcDataMap.get("isgoodvisible");
            for (DynamicObject row : prodDynColl) {
                if (!isgoodvisible && !srcOrgSet.contains(row.getLong("entryentity.orgname")) && 0L != row.getLong("entryentity.orgname")) continue;
                remoeGoodsIds.add(row.getLong("goods.id"));
            }
        }
        remoeGoodsIds.addAll(this.getGoodsIdsByProdRequest(supplier.getLong("id"), srcProtocolId, rowIndex));
        if (differentarea) {
            remoeGoodsIds.addAll(this.getConflictGoodsIdsByPurPlan(rowIndex, srcProtocolId));
        }
        return remoeGoodsIds;
    }

    private Set<Long> getConflictGoodsIdsByPurPlan(int rowIndex, Long srcProtocolId) {
        DynamicObjectCollection entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        QFilter qFilter1 = new QFilter("protocol.id", "=", (Object)srcProtocolId);
        String selectors = "id,entryentity.org";
        DynamicObjectCollection pmmPurPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)selectors, (QFilter[])qFilter1.toArray());
        HashMap purPlanMap = new HashMap(1024);
        for (DynamicObject row : pmmPurPlans) {
            List<Long> orgIds = new ArrayList<Long>(1024);
            if (null != purPlanMap.get(row.getLong("id"))) {
                orgIds = (List)purPlanMap.get(row.getLong("id"));
            }
            orgIds.add(row.getLong("entryentity.org"));
            purPlanMap.put(row.getLong("id"), orgIds);
        }
        HashSet<Long> goodsIds = new HashSet<Long>(1024);
        Long curPurPlanId = ((DynamicObject)entryCols.get(rowIndex)).getDynamicObject("protocolentry").getLong("purplanid.id");
        List curOrgIds = (List)purPlanMap.get(curPurPlanId);
        block1: for (DynamicObject row : entryCols) {
            if (null == row.get(PROD_NUMBER) || row.getInt(PROD_SEQ) - 1 == rowIndex) continue;
            long purPlanId = row.getDynamicObject("protocolentry").getLong("purplanid.id");
            List tarOrgIds = (List)purPlanMap.get(purPlanId);
            for (Long orgId : curOrgIds) {
                if (!tarOrgIds.contains(orgId)) continue;
                goodsIds.add(row.getLong("goods.id"));
                continue block1;
            }
        }
        return goodsIds;
    }

    private Map<Long, Map<String, Object>> getProtocolMap(QFilter qFilter) {
        String selectors = "id,effectdate,invaliddate,purmode,entryentity.orgname,differentarea,isgoodvisible";
        HashMap<Long, Map<String, Object>> protocolId_DynMap = new HashMap<Long, Map<String, Object>>(1024);
        DynamicObjectCollection pmmProtocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<Long> differentareaProtocolIds = new HashSet<Long>(1024);
        for (DynamicObject row : pmmProtocols) {
            Long id = row.getLong("id");
            if (row.getBoolean("differentarea")) {
                differentareaProtocolIds.add(id);
            }
            Date effectdate = row.getDate("effectdate");
            Date invaliddate = row.getDate("invaliddate");
            Map<String, Date> dataMap = new HashMap(1024);
            Set<Long> orgIDSet = new HashSet(1024);
            if (null != protocolId_DynMap.get(id)) {
                dataMap = (Map)protocolId_DynMap.get(id);
                orgIDSet = (Set)dataMap.get("orgs");
            }
            if (!BIZTYPE_UPLOAD.equals(row.getString("purmode")) && row.getLong("entryentity.orgname") != 0L) {
                orgIDSet.add(row.getLong("entryentity.orgname"));
            }
            dataMap.put("effectdate", effectdate);
            dataMap.put("invaliddate", invaliddate);
            dataMap.put("orgs", (Date)((Object)orgIDSet));
            dataMap.put("isgoodvisible", (Date)((Object)Boolean.valueOf(row.getBoolean("isgoodvisible"))));
            protocolId_DynMap.put(id, dataMap);
        }
        if (differentareaProtocolIds.size() > 0) {
            qFilter = new QFilter("id", "in", differentareaProtocolIds);
            selectors = "id,effectdate,invaliddate,purmode,entryentity1.id,entryentity1.purplanid,entryentity1.purorg,differentarea";
            pmmProtocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
            HashMap purPlanId_OrgsMap = new HashMap(1024);
            HashMap<Long, Long> entryId_purPlanIdMap = new HashMap<Long, Long>(1024);
            HashMap protocolId_entrysMap = new HashMap(1024);
            for (DynamicObject row : pmmProtocols) {
                Long id = row.getLong("id");
                Long entryId = row.getLong("entryentity1.id");
                List<Long> entrys = new ArrayList<Long>(1024);
                if (null != protocolId_entrysMap.get(id)) {
                    entrys = (List)protocolId_entrysMap.get(id);
                }
                entrys.add(entryId);
                protocolId_entrysMap.put(id, entrys);
                Long purplanid = row.getLong("entryentity1.purplanid");
                Long purorg = row.getLong("entryentity1.purorg");
                Set<Long> orgIds = new HashSet<Long>(1024);
                if (null != purPlanId_OrgsMap.get(purplanid)) {
                    orgIds = (Set)purPlanId_OrgsMap.get(purplanid);
                }
                orgIds.add(purorg);
                purPlanId_OrgsMap.put(purplanid, orgIds);
                entryId_purPlanIdMap.put(entryId, purplanid);
            }
            for (Map.Entry map : protocolId_DynMap.entrySet()) {
                Map value = (Map)map.getValue();
                if (!differentareaProtocolIds.contains(map.getKey())) continue;
                List protocolEntryIds = (List)protocolId_entrysMap.get(map.getKey());
                HashMap<Long, Set> newValueMap = new HashMap<Long, Set>(1024);
                for (Long entryId : protocolEntryIds) {
                    Long purPlanId = (Long)entryId_purPlanIdMap.get(entryId);
                    Set orgIds = (Set)purPlanId_OrgsMap.get(purPlanId);
                    newValueMap.put(entryId, orgIds);
                }
                value.put("entryOrgs", newValueMap);
                protocolId_DynMap.put((Long)map.getKey(), value);
            }
        }
        return protocolId_DynMap;
    }

    private Set<Long> getGoodsIdsByProdRequest(long supId, Long srcProtocolId, int rowIndex) {
        HashSet<Long> removeGoodsIds = new HashSet<Long>(1024);
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        if (protocol == null) {
            return removeGoodsIds;
        }
        boolean differentarea = protocol.getBoolean("differentarea");
        QFilter filter = new QFilter("supplier.id", "in", (Object)supId);
        QFilter statusFilter = new QFilter("cfmstatus", "=", (Object)"A");
        statusFilter.or(new QFilter("billstatus", "=", (Object)"A"));
        filter.and(statusFilter);
        filter.and(new QFilter("biztype", "=", (Object)BIZTYPE_UPLOAD));
        String prodSectlors = "id,entryentity.goods.id,protocolid,billno,protocolid.differentarea,entryentity.protocolentry";
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"ent_prodrequest", (String)prodSectlors, (QFilter[])new QFilter[]{filter});
        HashMap protocolId_GoodsIdMap = new HashMap(1024);
        HashSet<Long> differentAreaProtocols = new HashSet<Long>(1024);
        HashMap<Long, Long> protocolEntryId_GoodsIdMap = new HashMap<Long, Long>(1024);
        for (DynamicObject prod : prodDynColl) {
            Long protocolId = prod.getLong("protocolid");
            Long goodsId = prod.getLong("entryentity.goods.id");
            if (null == protocolId || protocolId.equals(0L) || null == goodsId || goodsId.equals(0L)) continue;
            List<Long> goodsIds = new ArrayList<Long>(1024);
            if (null != protocolId_GoodsIdMap.get(protocolId)) {
                goodsIds = (List)protocolId_GoodsIdMap.get(protocolId);
            }
            goodsIds.add(goodsId);
            protocolId_GoodsIdMap.put(protocolId, goodsIds);
            if (!prod.getBoolean("protocolid.differentarea")) continue;
            differentAreaProtocols.add(protocolId);
            protocolEntryId_GoodsIdMap.put(prod.getLong("entryentity.protocolentry"), goodsId);
        }
        if (protocolId_GoodsIdMap.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", protocolId_GoodsIdMap.keySet());
            qFilter.or(new QFilter("id", "=", (Object)srcProtocolId));
            Map<Long, Map<String, Object>> protocolId_DynMap = this.getProtocolMap(qFilter);
            Map<String, Object> srcDataMap = protocolId_DynMap.get(srcProtocolId);
            Date effectdate = (Date)srcDataMap.get("effectdate");
            Date invaliddate = (Date)srcDataMap.get("invaliddate");
            Set srcOrgSet = (Set)srcDataMap.get("orgs");
            if (differentarea) {
                DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
                Long protocolentryId = row.getDynamicObject("protocolentry").getLong("id");
                Map entryOrgs = (Map)srcDataMap.get("entryOrgs");
                if (null != entryOrgs.get(protocolentryId)) {
                    srcOrgSet = (Set)entryOrgs.get(protocolentryId);
                }
            }
            String purmode = protocol.getString("purmode");
            for (Map.Entry<Long, Map<String, Object>> map : protocolId_DynMap.entrySet()) {
                Long id = map.getKey();
                if (srcProtocolId.equals(id)) continue;
                Map<String, Object> dataMap = map.getValue();
                Date tarEffectdate = (Date)dataMap.get("effectdate");
                Date tarInvaliddate = (Date)dataMap.get("invaliddate");
                Set tarOrgSet = (Set)dataMap.get("orgs");
                Set<Long> diffOrgIds = this.getDiffOrgId(srcOrgSet, tarOrgSet);
                if (null == tarEffectdate || null == tarInvaliddate || effectdate.after(tarInvaliddate) || invaliddate.before(tarEffectdate)) continue;
                if (differentAreaProtocols.contains(map.getKey())) {
                    Map entryOrgs = (Map)dataMap.get("entryOrgs");
                    for (Map.Entry entryOrgsMap : entryOrgs.entrySet()) {
                        Set orgs = (Set)entryOrgsMap.getValue();
                        diffOrgIds = this.getDiffOrgId(srcOrgSet, orgs);
                        if (diffOrgIds.size() <= 0 || null == protocolEntryId_GoodsIdMap.get(entryOrgsMap.getKey())) continue;
                        removeGoodsIds.add((Long)protocolEntryId_GoodsIdMap.get(entryOrgsMap.getKey()));
                    }
                    continue;
                }
                if (!purmode.equals(BIZTYPE_UPLOAD) && diffOrgIds.size() <= 0 || null == protocolId_GoodsIdMap.get(id)) continue;
                removeGoodsIds.addAll((Collection)protocolId_GoodsIdMap.get(id));
            }
        }
        return removeGoodsIds;
    }

    private Set<Long> getDiffOrgId(Set<Long> srcOrgs, Set<Long> tarOrgs) {
        HashSet<Long> differOrgIds = new HashSet<Long>(1024);
        if (tarOrgs.size() == 0) {
            return srcOrgs;
        }
        for (Long id : srcOrgs) {
            if (!tarOrgs.contains(id)) continue;
            differOrgIds.add(id);
        }
        return differOrgIds;
    }
}

