/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.ent.common.plugin.AbstractEntBillPlugIn;
import kd.scm.malcore.domain.LadderPriceInfo;

public class EntProtocolEdit
extends AbstractEntBillPlugIn
implements HyperLinkClickListener,
RowClickEventListener {
    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        int rowIndex = e.getRowIndex();
        if ("purplanid".equals(fieldName)) {
            DynamicObject purplanDyn = (DynamicObject)this.getModel().getValue("purplanid", rowIndex);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ent_purchaseorgshow");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Long> detailParamMap = new HashMap<String, Long>();
            detailParamMap.put("purplanId", purplanDyn.getLong("id"));
            showParameter.setCustomParams(detailParamMap);
            showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "purplanid"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("orgentryset".equals(operateKey)) {
            this.showPurOrgEntrySetForm(e);
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"setladderprice")) {
            this.setLadderPrice(e);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrypricetype", "ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrypricetype", "ladderprice"});
        }
    }

    private void setLadderPrice(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entryentity");
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        if ("A".equals((row = (DynamicObject)entryCol.get(rowIndex)).getString("entrypricetype"))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u4ef7\u683c\u7c7b\u578b\u4e3a\u9636\u68af\u4ef7\u624d\u80fd\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"EntProtocolEdit_0", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        BigDecimal minorderqty = row.getBigDecimal("minorderqty");
        if (minorderqty.compareTo(BigDecimal.ZERO) == 0) {
            minorderqty = BigDecimal.ZERO;
        }
        DynamicObjectCollection subEntryRows = row.getDynamicObjectCollection("subentryentity");
        List<Object> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
        for (DynamicObject subrow : subEntryRows) {
            if (subrow.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) <= 0) continue;
            LadderPriceInfo info = new LadderPriceInfo(subrow.getBigDecimal("qtyfrom"), subrow.getBigDecimal("qtyto"), subrow.getBigDecimal("ladprice"), Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id")));
            ladderPriceInfos.add(info);
        }
        BigDecimal price = row.getBigDecimal("taxprice");
        if (ladderPriceInfos.size() < 2) {
            ladderPriceInfos.clear();
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty, minorderqty.add(BigDecimal.ONE), price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty.add(BigDecimal.ONE), BigDecimal.ZERO, price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        detailParamMap.put("status", "1");
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private void showPurOrgEntrySetForm(BeforeDoOperationEventArgs e) {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashMap purPlan_rowProsMap = new HashMap(1024);
        if (entryCol.size() > 0) {
            HashMap purPlanOrg_rowProsMap = new HashMap(1024);
            HashSet<String> purPlanIds = new HashSet<String>(1024);
            for (DynamicObject row : entryCol) {
                Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)row);
                String purPlanId = row.getString("purplanid.id");
                String purorgId = row.getString("purorg.id");
                String key = purPlanId + "_" + purorgId;
                List rowsPros = new ArrayList<Map>();
                if (null != purPlanOrg_rowProsMap.get(key)) {
                    rowsPros = (List)purPlanOrg_rowProsMap.get(key);
                }
                rowsPros.add(objectMap);
                purPlanOrg_rowProsMap.put(key, rowsPros);
                purPlanIds.add(purPlanId);
            }
            for (String purPlanId : purPlanIds) {
                for (Map.Entry map : purPlanOrg_rowProsMap.entrySet()) {
                    if (!((String)map.getKey()).contains(purPlanId)) continue;
                    ArrayList rowsPros = new ArrayList();
                    if (null != purPlan_rowProsMap.get(Long.parseLong(purPlanId))) continue;
                    rowsPros.addAll((Collection)map.getValue());
                    purPlan_rowProsMap.put(Long.parseLong(purPlanId), rowsPros);
                }
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ent_purorgentryset");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        detailParamMap.put("entrypros", purPlan_rowProsMap);
        detailParamMap.put("protocolId", this.getModel().getDataEntity().getPkValue());
        detailParamMap.put("loccurr", this.getModel().getDataEntity().getDynamicObject("loccurr") == null ? Long.valueOf(0L) : this.getModel().getDataEntity().getDynamicObject("loccurr").getPkValue());
        detailParamMap.put("curr", this.getModel().getDataEntity().getDynamicObject("curr") == null ? Long.valueOf(0L) : this.getModel().getDataEntity().getDynamicObject("curr").getPkValue());
        detailParamMap.put("lock", true);
        detailParamMap.put("orgId", this.getModel().getDataEntity().getDynamicObject("org").getLong("id"));
        showParameter.setCustomParams(detailParamMap);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "orgentryset"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }
}

