/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.plugin.AbstractMalBillPlugIn;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class EntSupRequestEdit
extends AbstractMalBillPlugIn {
    private static final String SUPPLIER = "supplier";
    private static final String BIZPARTER = "bizpartner";
    private static final String PERSON = "person";
    private static final String CFMSTATUS = "cfmstatus";
    private static final String MALLSTATUS = "mallstatus";
    private static final String ISSUEDATE = "issuedate";
    private static final String DATETO = "dateto";
    private static final String CHECKDATE = "checkdate";
    private static final Log log = LogFactory.getLog((String)EntSupRequestEdit.class.getName());

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equalsIgnoreCase("bar_close")) {
            return;
        }
        switch (itemKey) {
            case "bar_supplierinfo": {
                Object object = this.getModel().getValue(SUPPLIER);
                if (!(object instanceof DynamicObject)) {
                    evt.setCancel(true);
                    return;
                }
                DynamicObject suppInfo = QueryServiceHelper.queryOne((String)"srm_supplierinfo", (String)"id", (QFilter[])new QFilter[]{new QFilter(SUPPLIER, "=", ((DynamicObject)object).getPkValue())});
                if (suppInfo != null) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u4f9b\u5e94\u5546\u672a\u7ecf\u8fc7\u51c6\u5165\u6d41\u7a0b\uff0c\u6ca1\u6709\u8be6\u7ec6\u7684\u6ce8\u518c\u4fe1\u606f\u3002", (String)"EntSupRequestEdit_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterCreateNewData(EventObject eventobject) {
        DynamicObject supplier;
        super.afterCreateNewData(eventobject);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()))};
        DynamicObject[] supbizperson = BusinessDataServiceHelper.load((String)"pbd_supbizperson", (String)"id,mallstatus", (QFilter[])filters);
        if (supbizperson.length > 0) {
            model.setValue(PERSON, (Object)supbizperson[0].getLong("id"));
        }
        DynamicObjectCollection suppcoll = BizPartnerUtil.getSupplierCollByBizPartner();
        for (DynamicObject sup : suppcoll) {
            String mallStatus = sup.getString(MALLSTATUS);
            if (!mallStatus.equals("A") && !mallStatus.equals("") && !mallStatus.equals(" ")) continue;
            model.setValue(SUPPLIER, sup.get(0));
            this.setDefultValue(model, sup.get(0).toString());
            break;
        }
        if ((supplier = model.getDataEntity(true).getDynamicObject(SUPPLIER)) != null) {
            DynamicObject bizpartner = supplier.getDynamicObject(BIZPARTER);
            model.setValue(BIZPARTER, (Object)bizpartner);
        }
    }

    private void setDefultValue(AbstractFormDataModel model, String supplierId) {
        String bankName = null;
        String bankaccount = null;
        String accountname = null;
        DynamicObject supplier = EntSupRequestEdit.getSupplier(supplierId);
        if (null == supplier) {
            return;
        }
        DynamicObject bizpartner = EntSupRequestEdit.getBizPartners(BizPartnerUtil.getBizPartnerBySupplier((Object)Long.valueOf(supplierId)));
        DynamicObject srmSupplier = EntSupRequestEdit.getSrmSupplier(supplierId);
        DynamicObjectCollection bankEntries = supplier.getDynamicObjectCollection("entry_bank");
        if (bankEntries.size() > 0) {
            DynamicObject bank = new DynamicObject();
            for (int i = 0; i < bankEntries.size(); ++i) {
                bank = (DynamicObject)bankEntries.get(i);
                if (!bank.getBoolean("isdefault_bank")) continue;
                bankName = bank.getString("bank.name");
                bankaccount = bank.getString("bankaccount");
                accountname = bank.getString("accountname");
            }
            if (null == bankName) {
                bank = (DynamicObject)bankEntries.get(0);
                bankName = bank.getString("bank.name");
                bankaccount = bank.getString("bankaccount");
                accountname = bank.getString("accountname");
            }
        }
        model.setValue("bank", bankName);
        model.setValue("account", bankaccount);
        model.setValue("accname", accountname);
        model.setValue("group", supplier.get("group"));
        DynamicObject org = supplier.getDynamicObject("createorg");
        if (null != org) {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(org.getPkValue().toString()));
            idFilter.and("fispurchase", "=", (Object)"1");
            QFilter[] filters = new QFilter[]{idFilter};
            String select = "id";
            DynamicObject org1 = QueryServiceHelper.queryOne((String)"bos_org", (String)select, (QFilter[])filters);
            if (null != org1) {
                model.setValue("org", (Object)org.getPkValue().toString());
            }
        }
        if (bizpartner != null) {
            model.setValue("txregisterno", (Object)bizpartner.getString("tx_register_no"));
            model.setValue("societycreditcode", (Object)bizpartner.getString("societycreditcode"));
            model.setValue("orgcode", (Object)bizpartner.getString("orgcode"));
            model.setValue("linkman", (Object)bizpartner.getString("linkman"));
            model.setValue("phone", (Object)bizpartner.getString("phone"));
            model.setValue("address", (Object)bizpartner.getString("address"));
        }
        PageCache cache = (PageCache)this.getPageCache();
        cache.put("bank", bankName);
        cache.put("account", bankaccount);
        cache.put("accname", accountname);
        if (null != srmSupplier) {
            model.setValue("centralpurtype", srmSupplier.get("centralpurtype"));
            model.setValue("bizscope", srmSupplier.get("bizscope"));
            DynamicObject invoicetypeid = (DynamicObject)srmSupplier.get("invoicetypeid");
            if (null == invoicetypeid) {
                model.setValue("invoiceid", null);
            } else {
                QFilter qfilter = new QFilter("number", "=", invoicetypeid.get("number"));
                DynamicObject invoicetype = QueryServiceHelper.queryOne((String)"bd_invoicetype", (String)"id,name", (QFilter[])new QFilter[]{qfilter});
                model.setValue("invoiceid", invoicetype.get("id"));
            }
            DynamicObjectCollection srmSupEntries = srmSupplier.getDynamicObjectCollection("entry_aptitude");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (int i = 0; i < srmSupEntries.size(); ++i) {
                DynamicObject entry = (DynamicObject)srmSupEntries.get(i);
                String aptitudename = entry.getString("aptitudename");
                String aptitudetype = entry.getString("aptitudetype");
                String issueorg = entry.getString("issueorg");
                String aptitudenumber = entry.getString("aptitudenumber");
                String aptitudegrade = entry.getString("aptitudegrade");
                Date issuedate = entry.getDate(ISSUEDATE);
                Date dateto = entry.getDate(DATETO);
                Date checkdate = entry.getDate(CHECKDATE);
                String aptitudenote = entry.getString("aptitudenote");
                vs.set("seq", (Object)(i + 1), i);
                vs.set("aptitudename", (Object)aptitudename, i);
                vs.set("aptitudetype", (Object)aptitudetype, i);
                vs.set("issueorg", (Object)issueorg, i);
                vs.set("aptitudenumber", (Object)aptitudenumber, i);
                vs.set("aptitudegrade", (Object)aptitudegrade, i);
                vs.set(ISSUEDATE, (Object)issuedate, i);
                vs.set(DATETO, (Object)dateto, i);
                vs.set(CHECKDATE, (Object)checkdate, i);
                vs.set("aptitudenote", (Object)aptitudenote, i);
            }
            if (srmSupEntries.size() > 0) {
                model.deleteEntryData("entryentity");
            }
            model.batchCreateNewEntryRow("entryentity", vs);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Object object;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_supplierinfo".equals(itemKey) && (object = this.getModel().getValue(SUPPLIER)) instanceof DynamicObject) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setStatus(OperationStatus.VIEW);
            DynamicObject suppInfo = QueryServiceHelper.queryOne((String)"srm_supplierinfo", (String)"id", (QFilter[])new QFilter[]{new QFilter(SUPPLIER, "=", ((DynamicObject)object).getPkValue())});
            billShowParameter.setPkId((Object)suppInfo.getLong("id"));
            billShowParameter.setBillTypeId("srm_supplierinfo");
            billShowParameter.setFormId("srm_supplierinfo");
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propertyName;
        super.propertyChanged(arg0);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (propertyName = arg0.getProperty().getName()) {
            case "supplier": {
                DynamicObject supplier = this.getModel().getDataEntity(true).getDynamicObject(propertyName);
                if (supplier == null) {
                    return;
                }
                DynamicObject bizpartner = supplier.getDynamicObject(BIZPARTER);
                this.getModel().setValue(BIZPARTER, (Object)bizpartner);
                break;
            }
            case "issuedate": {
                int rowIndex = arg0.getChangeSet()[0].getRowIndex();
                Date issueDate = (Date)model.getValue(ISSUEDATE, rowIndex);
                Date dateto = (Date)model.getValue(DATETO, rowIndex);
                Date now = new Date();
                if (null != issueDate && issueDate.after(now)) {
                    view.showMessage(ResManager.loadKDString((String)"\u7b7e\u53d1\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"EntSupRequestEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    model.setValue(ISSUEDATE, null, rowIndex);
                    return;
                }
                if (null == issueDate || null == dateto || !issueDate.after(dateto)) break;
                view.showMessage(ResManager.loadKDString((String)"\u7b7e\u53d1\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u6709\u6548\u65e5\u671f\u3002", (String)"EntSupRequestEdit_2", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                model.setValue(ISSUEDATE, null, rowIndex);
                return;
            }
            case "dateto": {
                int rowIndex = arg0.getChangeSet()[0].getRowIndex();
                Date issueDate = (Date)model.getValue(ISSUEDATE, rowIndex);
                Date dateto = (Date)model.getValue(DATETO, rowIndex);
                Date now = new Date();
                if (null != dateto && dateto.before(now)) {
                    view.showMessage(ResManager.loadKDString((String)"\u6709\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"EntSupRequestEdit_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    model.setValue(DATETO, null, rowIndex);
                    return;
                }
                if (null == dateto || null == issueDate || !dateto.before(issueDate)) break;
                view.showMessage(ResManager.loadKDString((String)"\u6709\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7b7e\u53d1\u65e5\u671f\u3002", (String)"EntSupRequestEdit_4", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                model.setValue(DATETO, null, rowIndex);
                return;
            }
            case "checkdate": {
                int rowIndex = arg0.getChangeSet()[0].getRowIndex();
                Date issueDate = (Date)model.getValue(ISSUEDATE, rowIndex);
                Date now = new Date();
                Date checkdate = (Date)model.getValue(CHECKDATE, rowIndex);
                if (null == checkdate) {
                    return;
                }
                if (null != issueDate && checkdate.before(issueDate)) {
                    view.showMessage(ResManager.loadKDString((String)"\u6700\u8fd1\u5e74\u68c0\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7b7e\u53d1\u65e5\u671f\u3002", (String)"EntSupRequestEdit_5", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    model.setValue(CHECKDATE, null, rowIndex);
                    return;
                }
                if (!checkdate.after(now)) break;
                view.showMessage(ResManager.loadKDString((String)"\u6700\u8fd1\u5e74\u68c0\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"EntSupRequestEdit_6", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                model.setValue(CHECKDATE, null, rowIndex);
                return;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier1 = (BasedataEdit)this.getView().getControl(SUPPLIER);
        supplier1.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter(EntSupRequestEdit.BIZPARTER, "in", (Object)BizPartnerUtil.getBizPartnerId()));
            }
        });
        BasedataEdit bizPerson = (BasedataEdit)this.getView().getControl(PERSON);
        bizPerson.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                List qfiltes = formShowParameter.getListFilterParameter().getQFilters();
                qfiltes.add(new QFilter("status", "=", (Object)"A"));
                formShowParameter.getListFilterParameter().setQFilters(qfiltes);
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "save": {
                args.setCancel(this.saveCheck(model));
                break;
            }
            case "submit": {
                args.setCancel(this.saveCheck(model));
            }
        }
    }

    private boolean saveCheck(IDataModel model) {
        DynamicObject supplier = (DynamicObject)model.getValue(SUPPLIER);
        if (null == supplier) {
            return false;
        }
        QFilter filter = new QFilter(SUPPLIER, "=", (Object)supplier.getLong("id"));
        QFilter cfmfilter = new QFilter(CFMSTATUS, "=", (Object)"A").or(CFMSTATUS, "=", (Object)"B");
        QFilter[] filters = new QFilter[]{filter, cfmfilter};
        DynamicObjectCollection sup = QueryServiceHelper.query((String)"ent_suprequest", (String)"id,cfmstatus", (QFilter[])filters);
        if (sup.size() > 0) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u5bb6\u201c{0}\u201d\u5df2\u53d1\u8d77\u8fc7\u5165\u9a7b\u7533\u8bf7\u3002", (String)"EntSupRequestEdit_7", (String)"scm-ent-formplugin", (Object[])new Object[0]), supplier.getString("name")));
            return true;
        }
        return false;
    }

    public static final DynamicObject getSupplier(String supplierId) {
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(supplierId));
        QFilter[] filters = new QFilter[]{idFilter};
        String select = "id,createorg,group,entry_bank,bank.name,bankaccount,accountname,isdefault_bank,bizpartnerid";
        DynamicObject suppliers = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)select, (QFilter[])filters);
        return suppliers;
    }

    public static final DynamicObject getBizPartners(Long bizpartnerid) {
        QFilter userFilter = new QFilter("id", "=", (Object)bizpartnerid);
        QFilter[] filters = new QFilter[]{userFilter};
        String select = "id,linkman,phone,address,orgcode,societycreditcode,tx_register_no";
        DynamicObject partners = QueryServiceHelper.queryOne((String)"bd_bizpartner", (String)select, (QFilter[])filters);
        return partners;
    }

    public static final DynamicObject getSrmSupplier(String supplierId) {
        QFilter supFilter = new QFilter(SUPPLIER, "=", (Object)Long.valueOf(supplierId));
        QFilter[] filters = new QFilter[]{supFilter};
        String select = DynamicObjectUtil.getSelectfields((String)"srm_supplierreg", (boolean)false);
        select = DynamicObjectUtil.getEntrySelectfields((String)select, (String)"srm_supplierreg", (String)"entry_aptitude", (boolean)false);
        DynamicObject srmSupplier = BusinessDataServiceHelper.loadSingle((String)"srm_supplierreg", (String)select, (QFilter[])filters);
        return srmSupplier;
    }
}

