/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.plugin.ICardCustomFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.HyperLinkClickUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.ent.business.service.impl.EntBillFilterServiceImpl;
import kd.scm.ent.business.service.impl.EntPriceRequestValidatorServiceImpl;
import kd.scm.ent.common.plugin.AbstractEntListPlugIn;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntPriceRequestList
extends AbstractEntListPlugIn
implements ICardCustomFilter {
    private static final String SUPPLIER = "supplier";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.malVersionView(args);
    }

    private void malVersionView(BeforeCreateListColumnsArgs args) {
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        Set<String> hideColumns = this.malVersionHideColumns(defaultMalVersion);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            String listFieldKey;
            if (!(listColumn instanceof ListColumn) || !hideColumns.contains(listFieldKey = listColumn.getListFieldKey())) continue;
            listColumn.setVisible(0);
        }
    }

    private Set<String> malVersionHideColumns(boolean isMalNewVersion) {
        HashSet<String> hideColumns = new HashSet<String>(16);
        if (!isMalNewVersion) {
            hideColumns.add("prodpool.protocol.billno");
        }
        return hideColumns;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        EntBillFilterServiceImpl service = new EntBillFilterServiceImpl();
        List qFilterList = e.getQFilters();
        qFilterList.add(service.getEntPricePrequestQfilter());
    }

    public QFilter getCustomFilter() {
        return this.getListFilter();
    }

    public List<QFilter> getCustomFilterList() {
        return null;
    }

    public QFilter getListFilter() {
        QFilter qFilter = null;
        qFilter = BizPartnerUtil.assembleQFilterBizPartner();
        return qFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("resubmit".equals(key) && !this.copyValid()) {
            args.setCancel(true);
        }
        if ("submit".equals(key) && this.checkGoodsHasChange()) {
            args.setCancel(true);
        }
    }

    private boolean checkGoodsHasChange() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCols = listview.getSelectedRows();
        if (selectCols.size() == 0) {
            return false;
        }
        EntPriceRequestValidatorServiceImpl entPriceRequestValidatorService = new EntPriceRequestValidatorServiceImpl();
        QFilter qFilter = new QFilter("id", "in", (Object)selectCols.getPrimaryKeyValues());
        DynamicObject[] prodAudits = BusinessDataServiceHelper.load((String)"ent_pricerequest", (String)"id,billno,cfmstatus,suggestion,entryentity.goods,entryentity.prodpool", (QFilter[])qFilter.toArray());
        StringBuilder msg = entPriceRequestValidatorService.checkGoodsProtocol(prodAudits);
        if (msg.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u5173\u8054\u534f\u8bae\uff0c\u6570\u636e\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"EntPriceRequestList_5", (String)"scm-ent-formplugin", (Object[])new Object[0]), msg.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("confirm"));
            return true;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        return false;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"goods_name", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            HyperLinkClickUtil.MallGoodsView((IFormView)this.getView(), (String)"ent_pricerequest", (String)"entryentity.goods", (String)"entryentity.id", (String)"ent_prodmanage");
        }
    }

    private boolean copyValid() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"EntPriceRequestList_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (objects.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u6761\u4e0d\u540c\u610f\u7684\u7533\u8bf7\u5355\u91cd\u65b0\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"EntPriceRequestList_2", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection priceRequestDyn = QueryServiceHelper.query((String)"ent_pricerequest", (String)"id,cfmstatus,entryentity.prodpool prodpool,entryentity.goods.id goods,entryentity.goods.number goodsnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", objects[0])});
        if (!"D".equals(((DynamicObject)priceRequestDyn.get(0)).getString("cfmstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u6761\u4e0d\u540c\u610f\u7684\u7533\u8bf7\u5355\u91cd\u65b0\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"EntPriceRequestList_2", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Long> prodPoolIdList = new ArrayList<Long>(priceRequestDyn.size());
        HashMap<Long, String> prodPoolIdMap = new HashMap<Long, String>(priceRequestDyn.size());
        ArrayList<Long> goodsIdList = new ArrayList<Long>(priceRequestDyn.size());
        priceRequestDyn.forEach(priceRequest -> priceRequest.getLong("prodpool"));
        for (DynamicObject dynamicObject : priceRequestDyn) {
            prodPoolIdList.add(dynamicObject.getLong("prodpool"));
            prodPoolIdMap.put(dynamicObject.getLong("prodpool"), dynamicObject.getString("goodsnumber"));
            goodsIdList.add(dynamicObject.getLong("goods"));
        }
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,number,protocolentry.prodpool prodpool,protocolentry.prodpool.mallstatus mallstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", goodsIdList)});
        StringBuilder prodNumber = new StringBuilder();
        HashMap<Long, String> prodOfProdPool = new HashMap<Long, String>(prods.size());
        HashMap<Long, String> numberOfProdPool = new HashMap<Long, String>(prods.size());
        prods.forEach(prod -> prodOfProdPool.put(prod.getLong("prodpool"), prod.getString("mallstatus")));
        for (DynamicObject prod2 : prods) {
            prodOfProdPool.put(prod2.getLong("prodpool"), prod2.getString("mallstatus"));
            numberOfProdPool.put(prod2.getLong("prodpool"), prod2.getString("number"));
        }
        for (Long prodPoolId : prodPoolIdList) {
            if (!prodOfProdPool.containsKey(prodPoolId)) {
                prodNumber.append((String)prodPoolIdMap.get(prodPoolId)).append("\n");
                continue;
            }
            String mallStatus = (String)prodOfProdPool.get(prodPoolId);
            if (MallStatusEnum.SOLD.getVal().equals(mallStatus) || MallStatusEnum.UNSOLD.getVal().equals(mallStatus)) continue;
            prodNumber.append((String)numberOfProdPool.get(prodPoolId)).append("\n");
        }
        if (prodNumber.length() > 0) {
            String title = ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u4e2d\u90e8\u5206\u5546\u54c1\u4e0a\u67b6\u72b6\u6001\u5df2\u53d8\u66f4/\u5df2\u5173\u8054\u534f\u8bae\uff0c\u4e0d\u652f\u6301\u91cd\u65b0\u7533\u8bf7\uff0c\u8bf7\u624b\u5de5\u65b0\u589e\u8c03\u4ef7\u7533\u8bf7\u5355\u3002", (String)"EntPriceRequestList_4", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, prodNumber.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }
}

