/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.malcore.util.prodinfochange.MalProdInfoChangeUtil;

public class EntProdChangeManageList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        QFilter qFilter = new QFilter("origin", "=", (Object)"1");
        qFilter.or(new QFilter("origin", "=", (Object)"2").and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal())));
        List userOfBizPartner = BizPartnerUtil.getSupplierByUserOfBizPartner();
        qFilter.and("supplier", "in", (Object)userOfBizPartner);
        qFilters.add(qFilter);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HashMap<String, String> paramMap = new HashMap<String, String>(8);
            paramMap.put("orgType", "purorg");
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"ent_orgselect", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orgclose"));
            args.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        switch (operateKey) {
            case "submit": {
                this.submitOp(primaryKeyValues);
            }
        }
    }

    private void submitOp(Object[] primaryKeyValues) {
        Map prodChangeDyns = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyValues, (String)"ent_prodchange_manage");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : prodChangeDyns.entrySet()) {
            DynamicObject dyn = (DynamicObject)entry.getValue();
            if (!MalProdInfoChangeUtil.checkAttributeChangeInfluenceSPU((DynamicObject)dyn)) continue;
            sb.append(dyn.getString("billno")).append("\n");
        }
        if (sb.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u5185\u5bb9\u6d89\u53caSPU\u4fe1\u606f\uff0c\u53d8\u66f4\u540e\u5c06\u6e05\u7a7a\u5173\u8054SPU\uff0c\u8bf7\u77e5\u6089\u3002", (String)sb.toString(), (String)"EntProdInfoChangeEdit_3", (Object[])new Object[]{"scm-ent-formplugin"}), MessageBoxOptions.OK, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("confirm".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectCol = listview.getSelectedRows();
            Object[] primaryKeyValues = selectCol.getPrimaryKeyValues();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            ArrayList<Long> prodChgIds = new ArrayList<Long>(primaryKeyValues.length);
            for (Object primaryKeyValue : primaryKeyValues) {
                prodChgIds.add((Long)primaryKeyValue);
            }
            paramMap.put("prodChgIds", prodChgIds);
            paramMap.put("origin", "ent");
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pbd_goodschgcfm", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            Map paramMap = (Map)closedCallBackEvent.getReturnData();
            if (paramMap != null && "confirm".equals(paramMap.get("opKey"))) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("opinion", (String)paramMap.get("opinion"));
                if ("B".equals(paramMap.get("result"))) {
                    this.getView().invokeOperation("cfmagree", operateOption);
                } else {
                    this.getView().invokeOperation("cfmdisagree", operateOption);
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

