/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.list;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.plugin.ICardCustomFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.HyperLinkClickUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.ent.business.service.impl.EntBillFilterServiceImpl;
import kd.scm.ent.common.plugin.AbstractEntListPlugIn;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntProdRequestList
extends AbstractEntListPlugIn
implements ICardCustomFilter {
    private static final String BIZTYPE_UPLOAD = "1";
    private static final String BIZTYPE_DOWNLOAD = "2";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u67b6\u7533\u8bf7", (String)"EntProdRequestEdit_25", (String)"scm-ent-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.malVersionView(args);
    }

    private void malVersionView(BeforeCreateListColumnsArgs args) {
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        Set<String> hideColumns = this.malVersionHideColumns(defaultMalVersion);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            String listFieldKey;
            if (!(listColumn instanceof ListColumn) || !hideColumns.contains(listFieldKey = listColumn.getListFieldKey())) continue;
            listColumn.setVisible(0);
        }
    }

    private Set<String> malVersionHideColumns(boolean isMalNewVersion) {
        HashSet<String> hideColumns = new HashSet<String>(16);
        if (!isMalNewVersion) {
            hideColumns.add("protocolid.billno");
        }
        return hideColumns;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        EntBillFilterServiceImpl service = new EntBillFilterServiceImpl();
        qFilterList.add(service.getEntProdrequestQfilter());
        qFilterList.add(new QFilter("platform", "=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal()));
    }

    public QFilter getCustomFilter() {
        return this.getListFilter();
    }

    public List<QFilter> getCustomFilterList() {
        return null;
    }

    public QFilter getListFilter() {
        QFilter qFilter = null;
        qFilter = BizPartnerUtil.assembleQFilterBizPartner();
        return qFilter;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"goods_name", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            HyperLinkClickUtil.MallGoodsView((IFormView)this.getView(), (String)"ent_prodrequest", (String)"entryentity.goods", (String)"entryentity.id", (String)"ent_prodmanage");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"resubmit")) {
            this.checkResubmit(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"resubmit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            AppCache.get((String)this.getView().getPageId()).put("resubmit", (Object)"true");
            this.getView().invokeOperation("copy");
        }
    }

    private void checkResubmit(BeforeDoOperationEventArgs args) {
        String cfmStatus;
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects.length == 0 || objects.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u64cd\u4f5c\u3002", (String)"EntProdRequestList_6", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(objects[0])));
        DynamicObjectCollection dynamicObjectCol = QueryServiceHelper.query((String)"ent_prodrequest", (String)"biztype,protocolid.id protocolid,protocolid.protocolstatus protocolstatus,cfmstatus,entryentity.entryresult,entryentity.goods", (QFilter[])qFilter.toArray());
        if (dynamicObjectCol.size() > 0 && ("C".equals(cfmStatus = ((DynamicObject)dynamicObjectCol.get(0)).getString("cfmstatus")) || "D".equals(cfmStatus))) {
            long protocolid = ((DynamicObject)dynamicObjectCol.get(0)).getLong("protocolid");
            String biztype = ((DynamicObject)dynamicObjectCol.get(0)).getString("biztype");
            HashSet<Long> goodIDs = new HashSet<Long>(1024);
            if ("C".equals(cfmStatus)) {
                for (DynamicObject row : dynamicObjectCol) {
                    String result = row.getString("entryentity.entryresult");
                    long good = row.getLong("entryentity.goods");
                    if (!"0".equals(result) || 0L == good) continue;
                    goodIDs.add(good);
                }
            }
            if ("D".equals(cfmStatus)) {
                for (DynamicObject row : dynamicObjectCol) {
                    long good = row.getLong("entryentity.goods");
                    if (0L == good) continue;
                    goodIDs.add(good);
                }
            }
            if (protocolid == 0L) {
                this.resubmitNoProtocolCheck(args, goodIDs, biztype);
            }
        }
    }

    private void resubmitNoProtocolCheck(BeforeDoOperationEventArgs args, Set<Long> goodIDs, String biztype) {
        if (goodIDs.size() > 0) {
            StringBuilder goodsNumber = new StringBuilder();
            QFilter qFilter1 = new QFilter("goods", "in", goodIDs);
            DynamicObjectCollection goodPools = QueryServiceHelper.query((String)"ent_prodpool", (String)"id,mallstatus,protocol,goods.number number", (QFilter[])qFilter1.toArray());
            HashSet<String> goodsNumbers = new HashSet<String>(16);
            for (DynamicObject goodPool : goodPools) {
                if (goodPool.getLong("protocol") != 0L) {
                    goodsNumbers.add(goodPool.getString("number"));
                    continue;
                }
                String mallStatus = goodPool.getString("mallstatus");
                if (BIZTYPE_UPLOAD.equals(biztype) && (MallStatusEnum.SOLD.getVal().equals(mallStatus) || MallStatusEnum.UNSOLD.getVal().equals(mallStatus))) {
                    goodsNumbers.add(goodPool.getString("number"));
                    continue;
                }
                if (!BIZTYPE_DOWNLOAD.equals(biztype) || MallStatusEnum.SOLD.getVal().equals(mallStatus) || MallStatusEnum.UNSOLD.getVal().equals(mallStatus)) continue;
                goodsNumbers.add(goodPool.getString("number"));
            }
            if (goodsNumbers.size() > 0) {
                for (String key : goodsNumbers) {
                    goodsNumber.append(key).append('\n');
                }
                String msg = ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u4e2d\u90e8\u5206\u5546\u54c1\u5df2\u4e0a\u67b6/\u5df2\u5173\u8054\u534f\u8bae\uff0c\u4e0d\u652f\u6301\u91cd\u65b0\u7533\u8bf7\uff0c\u8bf7\u624b\u5de5\u65b0\u589e\u4e0a\u67b6\u7533\u8bf7\u5355\u3002", (String)"EntProdRequestList_5", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                if (BIZTYPE_DOWNLOAD.equals(biztype)) {
                    msg = ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u4e2d\u90e8\u5206\u5546\u54c1\u5df2\u4e0b\u67b6/\u5df2\u5173\u8054\u534f\u8bae\uff0c\u4e0d\u652f\u6301\u91cd\u65b0\u7533\u8bf7\uff0c\u8bf7\u624b\u5de5\u65b0\u589e\u4e0b\u67b6\u7533\u8bf7\u5355\u3002", (String)"EntSupRequestEdit_14", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                }
                this.getView().showMessage(msg, goodsNumber.toString(), MessageTypes.Default);
                args.setCancel(true);
            }
        }
    }
}

