/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.ent.common.plugin.AbstractEntListPlugIn;

public class EntProtocolList
extends AbstractEntListPlugIn {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(BizPartnerUtil.assembleQFilterBizPartner());
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilters.add(new QFilter("issrm", "=", (Object)"1"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if ("rejectreason".equals(key) || "protocolgood".equals(key) || "unconfirm".equals(key)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
            if (objects.length == 0 || objects.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u64cd\u4f5c\u3002", (String)"BillFormUtil_2", (String)"scm-common", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("protocolgood".equals(key) || "unconfirm".equals(key)) {
                this.checkProtocolGoods(args, objects, key);
            }
        }
    }

    private void checkProtocolGoods(BeforeDoOperationEventArgs args, Object[] objects, String key) {
        QFilter prodPoolQFilter;
        boolean exists;
        QFilter qFilter = new QFilter("protocolid", "=", (Object)Long.parseLong(String.valueOf(objects[0])));
        QFilter cfmStatusQFilter = new QFilter("cfmstatus", "=", (Object)"A");
        cfmStatusQFilter.or(new QFilter("cfmstatus", "=", (Object)"E"));
        if ("unconfirm".equals(key)) {
            cfmStatusQFilter.or(new QFilter("cfmstatus", "=", (Object)"B"));
            cfmStatusQFilter.or(new QFilter("cfmstatus", "=", (Object)"D"));
            cfmStatusQFilter.or(new QFilter("cfmstatus", "=", (Object)"C"));
            QFilter procfmStatusQFilter = new QFilter("protocolid.protocolstatus", "=", (Object)"A");
            procfmStatusQFilter.or(new QFilter("protocolid.protocolstatus", "=", (Object)"B"));
            qFilter.and(procfmStatusQFilter);
            qFilter.and(new QFilter("protocolid.confirmstatus", "=", (Object)"C"));
        }
        qFilter.and(cfmStatusQFilter);
        qFilter.and("biztype", "=", (Object)"1");
        DynamicObject ent_protocolCol = QueryServiceHelper.queryOne((String)"ent_prodrequest", (String)"id", (QFilter[])qFilter.toArray());
        if (null != ent_protocolCol) {
            String msg = "";
            msg = "unconfirm".equals(key) ? ResManager.loadKDString((String)"\u534f\u8bae\u5df2\u5173\u8054\u4e0a\u67b6\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u786e\u8ba4\u3002", (String)"EntProtocolList_1", (String)"scm-ent-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u534f\u8bae\u5173\u8054\u7684\u5546\u54c1\u6b63\u5728\u4e0a\u67b6\u7533\u8bf7\u4e2d\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u5173\u8054\u5546\u54c1\u3002", (String)"EntProtocolList_0", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        } else if ("unconfirm".equals(key) && (exists = QueryServiceHelper.exists((String)"ent_prodpool", (QFilter[])(prodPoolQFilter = new QFilter("protocol", "=", (Object)Long.parseLong(String.valueOf(objects[0])))).toArray()))) {
            String msg = ResManager.loadKDString((String)"\u5df2\u6709\u5546\u54c1\u5173\u8054\u8be5\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u786e\u8ba4\u3002", (String)"EntProtocolList_2", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operate = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() == null || afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operate) {
                case "rejectreason": {
                    this.rejectData();
                    break;
                }
                case "protocolgood": {
                    this.protocolGoodShowForm();
                    break;
                }
                case "confirm": 
                case "unconfirm": {
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }

    private void protocolGoodShowForm() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        paramMap.put("protocolId", objects[0]);
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(objects[0])));
        String selector = "entryentity.material,partyb,entryentity.id,entryentity.materialname,entryentity.purplanid";
        DynamicObjectCollection ent_protocolCol = QueryServiceHelper.query((String)"ent_protocol", (String)selector, (QFilter[])qFilter.toArray());
        ArrayList<String> selectCol = new ArrayList<String>();
        HashMap<String, String> entryID_materialMap = new HashMap<String, String>();
        if (ent_protocolCol.size() > 0) {
            if (0L != ((DynamicObject)ent_protocolCol.get(0)).getLong("entryentity.purplanid")) {
                HashSet materialIdSet = new HashSet(1024);
                for (DynamicObject protocol : ent_protocolCol) {
                    materialIdSet.add(protocol.getString("entryentity.material") + protocol.getString("entryentity.materialname") + protocol.getLong("entryentity.purplanid"));
                }
                for (DynamicObject protocol : ent_protocolCol) {
                    String materialId = protocol.getString("entryentity.material");
                    String materialName = protocol.getString("entryentity.materialname");
                    String key = materialId + materialName + protocol.getLong("entryentity.purplanid");
                    if (!materialIdSet.remove(key)) continue;
                    selectCol.add(protocol.getString("entryentity.material"));
                    entryID_materialMap.put(protocol.getString("entryentity.id"), materialId);
                }
            } else {
                for (DynamicObject protocol : ent_protocolCol) {
                    selectCol.add(protocol.getString("entryentity.material"));
                    entryID_materialMap.put(protocol.getString("entryentity.id"), protocol.getString("entryentity.material"));
                }
            }
        }
        Long supplier = ((DynamicObject)ent_protocolCol.get(0)).getLong("partyb");
        String selectcols = String.join((CharSequence)",", selectCol);
        paramMap.put("materialIds", selectcols);
        paramMap.put("supplier", supplier);
        paramMap.put("entrymapping", SerializationUtils.toJsonString(entryID_materialMap));
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodrequest", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, paramMap, null));
    }

    private void rejectData() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject reject = BillFormUtil.getSelectData((IFormView)this.getView(), (String)"ent_protocol");
        paramMap.put("priceproid", reject.getPkValue());
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_reject", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, (long)0L, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "rejectresaon")));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (actionId.equals("rejectresaon")) {
            this.getView().updateView("billlistap");
        }
    }
}

