/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.extension.ScmExtensionFactory;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.order.service.MalEcOrderConfirmService;
import kd.scm.mal.business.order.service.impl.MalEcOrderConfirmServiceImpl;
import kd.scm.mal.business.org.service.MalOrgRelationService;
import kd.scm.mal.business.org.service.MalOrgSwitchService;
import kd.scm.mal.business.org.service.impl.MalOrgRelationServiceImpl;
import kd.scm.mal.business.org.service.impl.MalOrgSwitchServiceImpl;
import kd.scm.mal.business.placeorder.service.MalFreightService;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.business.placeorder.service.MalSurchargeService;
import kd.scm.mal.business.placeorder.service.impl.MalFreightServiceImpl;
import kd.scm.mal.business.placeorder.service.impl.MalPlaceOrderServiceImpl;
import kd.scm.mal.business.placeorder.service.impl.MalSurchageServiceImpl;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.business.receipt.service.impl.MalReceiptServiceImpl;
import kd.scm.mal.business.search.service.MalSearchService;
import kd.scm.mal.business.search.service.impl.MalStandardSearchServiceImpl;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.shopcart.service.impl.MalShopCartServiceImpl;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.business.stock.service.impl.MalStockServiceImpl;

public class MalBusinessFactory {
    private static final Log log = LogFactory.getLog(MalBusinessFactory.class);
    private static final Map<Class<?>, Object> serviceMap = new ConcurrentHashMap();

    public static <T> T serviceOf(Class<T> serviceClass) {
        return (T)serviceMap.get(serviceClass);
    }

    public static <T> T serviceOf(Class<T> serviceClass, String key) {
        try {
            return (T)ScmExtensionFactory.getExtensionFacotry(serviceClass).getExtension(key);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u670d\u52a1\u5b9e\u73b0\u5931\u8d25\uff1a" + e.getMessage() + System.lineSeparator() + ExceptionUtil.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static <T> T defaultExtensionServiceOf(Class<T> serviceClass) {
        try {
            return (T)ScmExtensionFactory.getExtensionFacotry(serviceClass).getDefaultExtension();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u670d\u52a1\u5b9e\u73b0\u5931\u8d25\uff1a" + e.getMessage() + System.lineSeparator() + ExceptionUtil.getStackTrace((Throwable)e));
            return null;
        }
    }

    static {
        serviceMap.put(MalOrgRelationService.class, new MalOrgRelationServiceImpl());
        serviceMap.put(MalReceiptService.class, new MalReceiptServiceImpl());
        serviceMap.put(MalPlaceOrderService.class, new MalPlaceOrderServiceImpl());
        serviceMap.put(MalSurchargeService.class, new MalSurchageServiceImpl());
        serviceMap.put(MalFreightService.class, new MalFreightServiceImpl());
        serviceMap.put(MalOrgSwitchService.class, new MalOrgSwitchServiceImpl());
        serviceMap.put(MalShopCartService.class, new MalShopCartServiceImpl());
        serviceMap.put(MalEcOrderConfirmService.class, new MalEcOrderConfirmServiceImpl());
        serviceMap.put(MalStockService.class, new MalStockServiceImpl());
        serviceMap.put(MalSearchService.class, new MalStandardSearchServiceImpl());
    }
}

