/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.history.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.history.MalProBrowsingHistoryService;
import kd.scm.mal.domain.model.goods.MalGoods;

public class MalProBrowsingHistoryServiceImpl
implements MalProBrowsingHistoryService {
    private static final Log logger = LogFactory.getLog(MalProBrowsingHistoryServiceImpl.class);

    @Override
    public boolean addProductToBrowsingHistory4Ec(String skuNumber, String source) {
        try {
            QFilter filter = QFilter.of((String)"goods.number = ? and goods.source = ?", (Object[])new Object[]{skuNumber, source});
            DynamicObject dyo = this.getBrowsingHistoryByFilter(filter);
            if (Objects.isNull(dyo)) {
                HashSet<Long> goodsIdSet = new HashSet<Long>(4);
                QFilter qFilter = new QFilter("number", "=", (Object)skuNumber);
                qFilter.and(new QFilter("source", "=", (Object)source));
                DynamicObject ecGoods = QueryServiceHelper.queryOne((String)"pbd_mallgoods", (String)"id,priceinfo.price,mainpic", (QFilter[])qFilter.toArray());
                if (Objects.nonNull(ecGoods)) {
                    Long id = ecGoods.getLong("id");
                    goodsIdSet.add(id);
                    MalGoods.syncEcGoodsToGoodsManage(goodsIdSet);
                    this.createAndSaveBrowsingHistory(id, ecGoods.getString("mainpic"), MalOrderUtil.getEcCurrencyId((String)source), ecGoods.getBigDecimal("priceinfo.price"));
                }
            } else {
                dyo.set("num", (Object)(dyo.getInt("num") + 1));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
            }
        }
        catch (KDBizException e) {
            logger.warn("addProductToBrowsingHistory4Ec failed,sku:" + skuNumber + ",source:" + source + "\n" + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean addProductToBrowsingHistory4Self(Long pk) {
        try {
            QFilter filter = QFilter.of((String)"goods.id = ?", (Object[])new Object[]{pk});
            DynamicObject dyo = this.getBrowsingHistoryByFilter(filter);
            if (Objects.isNull(dyo)) {
                DynamicObject prodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"pmm_prodmanage", (String)"thumbnail,curr,taxprice");
                this.createAndSaveBrowsingHistory(pk, prodDyo.getString("thumbnail"), prodDyo.getLong("curr.id"), prodDyo.getBigDecimal("taxprice"));
            } else {
                dyo.set("num", (Object)(dyo.getInt("num") + 1));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
            }
        }
        catch (KDBizException e) {
            logger.warn("addProductToBrowsingHistory4Self failed,pk:" + pk + "\n" + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void deleteBrowsingHistoryByDateInterval(int dayOffset) {
        QFilter filters = new QFilter("time", "<=", (Object)DateUtil.getDayStart((Date)DateUtil.addDays((Date)TimeServiceHelper.now(), (int)dayOffset)));
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        for (int i = 0; i < this.getCycleTimes(filters); ++i) {
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"mal_browsinghistory", (QFilter[])new QFilter[]{filters}, (String)"time asc", (int)1000);
            DeleteServiceHelper.delete((String)"mal_browsinghistory", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        }
    }

    @Override
    public void clearCurrUserAllBrowsingHistory() {
        QFilter filters = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        for (int i = 0; i < this.getCycleTimes(filters); ++i) {
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"mal_browsinghistory", (QFilter[])new QFilter[]{filters}, (String)"time asc", (int)1000);
            OperationServiceHelper.executeOperate((String)"delete", (String)"mal_browsinghistory", (Object[])ids.toArray(), (OperateOption)option);
        }
    }

    private int getCycleTimes(QFilter filters) {
        String select = "count(*) ids";
        DynamicObjectCollection col = QueryServiceHelper.query((String)"mal_browsinghistory", (String)select, (QFilter[])new QFilter[]{filters});
        int totalCount = ((DynamicObject)col.get(0)).getInt("ids");
        int times = totalCount % 1000 > 0 ? totalCount / 1000 + 1 : totalCount / 1000;
        return times;
    }

    @Override
    public boolean addProductToBrowsingHistory(final MalGoods malGoods) {
        try {
            QFilter filter;
            DynamicObject dyo;
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
                MalGoods.syncEcGoodsToGoodsManage((Set<Long>)new HashSet<Long>(){
                    {
                        this.add(malGoods.getId());
                    }
                });
            }
            if (Objects.isNull(dyo = this.getBrowsingHistoryByFilter(filter = QFilter.of((String)"goods.id = ?", (Object[])new Object[]{malGoods.getId()})))) {
                this.createAndSaveBrowsingHistory(malGoods.getId(), malGoods.getThumbnail(), malGoods.getCurrency(), malGoods.getTaxPrice());
            } else {
                dyo.set("num", (Object)(dyo.getInt("num") + 1));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
            }
        }
        catch (KDBizException e) {
            logger.warn("addProductToBrowsingHistory failed,number:" + malGoods.getNumber() + "\n" + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private DynamicObject getBrowsingHistoryByFilter(QFilter filter) {
        QFilter filters = filter.and(this.getQFilter());
        return BusinessDataServiceHelper.loadSingle((String)"mal_browsinghistory", (QFilter[])new QFilter[]{filters});
    }

    private QFilter getQFilter() {
        return new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()).and("time", ">=", (Object)DateUtil.getDayStart((Date)TimeServiceHelper.now())).and("time", "<", (Object)DateUtil.getDayStart((Date)DateUtil.addDays((Date)TimeServiceHelper.now(), (int)1)));
    }

    private void createAndSaveBrowsingHistory(Long goodsId, String mainPic, Long curr, BigDecimal price) {
        DynamicObject history = BusinessDataServiceHelper.newDynamicObject((String)"mal_browsinghistory");
        history.set("goods", (Object)goodsId);
        history.set("goodsimg", (Object)mainPic);
        history.set("curr", (Object)curr);
        history.set("taxprice", (Object)price);
        history.set("user", (Object)RequestContext.get().getCurrUserId());
        history.set("time", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{history});
    }
}

