/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.org.service.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.mal.business.org.entity.MalOrgRelation;
import kd.scm.mal.business.org.service.MalOrgRelationService;
import kd.scm.mal.common.org.IMalOrgService;
import kd.scm.mal.common.org.MalOrgServiceFactory;

public class MalOrgRelationServiceImpl
implements MalOrgRelationService {
    @Override
    public MalOrgRelation getOrgRelationByUserId(Long userId) {
        IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
        Long dptOrgId = malOrgService.getDefaultDemandOrgByUser(userId);
        return this.getOrgRelationByDptOrgId(dptOrgId);
    }

    @Override
    public MalOrgRelation getOrgRelationByDptOrgId(Long dptOrgId) {
        MalOrgRelation malOrgRelation = new MalOrgRelation();
        IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
        malOrgRelation.setDepOrgId(dptOrgId);
        malOrgRelation.setCostOrgId(dptOrgId);
        Long purOrgId = malOrgService.getDefaultPurchaseOrg(dptOrgId);
        malOrgRelation.setPurOrgId(purOrgId);
        boolean hasDelegantRalation = MalOrgServiceFactory.hasDelegantRalation();
        Long rcvOrgId = hasDelegantRalation ? malOrgService.getDefaultInvOrg(dptOrgId) : malOrgService.getDefaultInvOrg(purOrgId);
        malOrgRelation.setRcvOrgId(rcvOrgId);
        Long settleOrgId = hasDelegantRalation ? malOrgService.getDefaultSettleOrg(purOrgId, rcvOrgId) : malOrgService.getDefaultSettleOrg(dptOrgId, purOrgId);
        malOrgRelation.setSettleOrgId(settleOrgId);
        malOrgRelation.setInvoiceOrgId(settleOrgId);
        Long expenseOrgId = malOrgService.getDefaultExpenseOrg(settleOrgId);
        malOrgRelation.setExpenseOrgId(expenseOrgId);
        ArrayList<Long> orgIdList = new ArrayList<Long>(16);
        orgIdList.add(malOrgRelation.getCostOrgId());
        orgIdList.add(malOrgRelation.getDepOrgId());
        orgIdList.add(malOrgRelation.getExpenseOrgId());
        orgIdList.add(malOrgRelation.getInvoiceOrgId());
        orgIdList.add(malOrgRelation.getPurOrgId());
        orgIdList.add(malOrgRelation.getRcvOrgId());
        orgIdList.add(malOrgRelation.getSettleOrgId());
        orgIdList.removeIf(Objects::isNull);
        if (!orgIdList.isEmpty()) {
            DynamicObject expenseOrgDyn;
            DynamicObject invoiceOrgDyn;
            DynamicObject settleOrgDyn;
            DynamicObject rcvOrgDyn;
            DynamicObject purOrgDyn;
            DynamicObject costOrgDyn;
            Map orgIdToDynMap = BusinessDataServiceHelper.loadFromCache((Object[])orgIdList.toArray(), (String)"bos_org");
            DynamicObject depOrgDyn = (DynamicObject)orgIdToDynMap.get(malOrgRelation.getDepOrgId());
            if (depOrgDyn != null) {
                malOrgRelation.setDepOrgName(depOrgDyn.getString("name"));
            }
            if ((costOrgDyn = (DynamicObject)orgIdToDynMap.get(malOrgRelation.getCostOrgId())) != null) {
                malOrgRelation.setCostOrgName(costOrgDyn.getString("name"));
            }
            if ((purOrgDyn = (DynamicObject)orgIdToDynMap.get(malOrgRelation.getPurOrgId())) != null) {
                malOrgRelation.setPurOrgName(purOrgDyn.getString("name"));
            }
            if ((rcvOrgDyn = (DynamicObject)orgIdToDynMap.get(malOrgRelation.getRcvOrgId())) != null) {
                malOrgRelation.setRcvOrgName(rcvOrgDyn.getString("name"));
            }
            if ((settleOrgDyn = (DynamicObject)orgIdToDynMap.get(malOrgRelation.getSettleOrgId())) != null) {
                malOrgRelation.setSettleOrgName(settleOrgDyn.getString("name"));
            }
            if ((invoiceOrgDyn = (DynamicObject)orgIdToDynMap.get(malOrgRelation.getInvoiceOrgId())) != null) {
                malOrgRelation.setInvoiceOrgName(invoiceOrgDyn.getString("name"));
            }
            if ((expenseOrgDyn = (DynamicObject)orgIdToDynMap.get(malOrgRelation.getExpenseOrgId())) != null) {
                malOrgRelation.setExpenseOrgname(expenseOrgDyn.getString("name"));
            }
        }
        return malOrgRelation;
    }
}

