/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.org.service.impl;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.mal.business.org.entity.MalOrgInfo;
import kd.scm.mal.business.org.service.MalOrgSwitchService;
import kd.scm.mal.common.info.PageInfo;

public class MalOrgSwitchServiceImpl
implements MalOrgSwitchService {
    @Override
    public PageInfo<MalOrgInfo> getOrgs(long userId, int pageNum, int pageSize, QFilter customFilter) {
        HasPermOrgResult hasPermOrgResult = UserServiceHelper.getUserChangeAbleOrg((long)userId, (boolean)true);
        QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
        QFilter treeTypeFilter = new QFilter("structure.view.number", "=", (Object)"15");
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        if (customFilter != null) {
            filter.and(customFilter);
        }
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{orgFilter, treeTypeFilter, filter};
        int total = orm.count(RequestContext.get().getTraceId(), "bos_org", "id,name,number,orgpattern.name", filters, (Distinctable)WithDistinctable.get());
        PageInfo page = new PageInfo();
        page.setPageSize(pageSize);
        page.setPageNum(pageNum);
        page.setTotal(total);
        ArrayList orgInfos = new ArrayList(pageSize);
        try (DataSet ds = orm.queryDataSet(RequestContext.get().getTraceId(), "bos_org", "id,name,number,orgpattern.name", filters, "number", (pageNum - 1) * pageSize, pageSize, (Distinctable)WithDistinctable.get());){
            ds.forEach(row -> {
                MalOrgInfo orgInfo = new MalOrgInfo();
                orgInfo.setOrgId(row.getString("id"));
                orgInfo.setOrgName(row.getString("name"));
                orgInfo.setOrgNumber(row.getString("number"));
                orgInfo.setOrgPattern(row.getString("orgpattern.name"));
                orgInfos.add(orgInfo);
            });
        }
        page.setItems(orgInfos);
        return page;
    }

    @Override
    public void switchOrg(long orgId, boolean isDefault) {
        if (isDefault) {
            UserServiceHelper.setUserDefaultOrg((long)RequestContext.get().getCurrUserId(), (long)orgId);
        }
        UserServiceHelper.switchUserDefaultOrg((long)orgId);
    }
}

