/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.placeorder.entity.MalCgSubmitOrderSku;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderParam;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResult;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResultSku;
import kd.scm.mal.business.placeorder.service.impl.MalGenericEcSubmitOrderServiceImpl;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import kd.scm.malcore.cache.CacheKeyHelper;
import kd.scm.malcore.cache.MalObjectCache;
import net.sf.json.JSONArray;

public class MalCgSubmitOrderServiceImpl
extends MalGenericEcSubmitOrderServiceImpl {
    private static final Log log = LogFactory.getLog(MalCgSubmitOrderServiceImpl.class);

    @Override
    public MalEcSubmitOrderResult submitEcOrder(MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Map<String, Object> params = new HashMap<String, Object>(32);
        params.put("thirdOrder", malEcSubmitOrderParam.getThirdOrder());
        JSONArray skus = JSONArray.fromObject((Object)malEcSubmitOrderParam.getEcSkus());
        for (int i = 0; i < skus.size(); ++i) {
            skus.getJSONObject(i).remove("goodsId");
        }
        params.put("sku", skus);
        params.put("receiverName", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("provinceId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("cityId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("countyId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        params.put("address", malEcSubmitOrderParam.getMalReceipt().toString());
        params.put("mobile", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("email", malEcSubmitOrderParam.getMalReceipt().getEmail());
        params.put("zip", malEcSubmitOrderParam.getMalReceipt().getPostalCode());
        params.put("remark", malEcSubmitOrderParam.getRemark());
        params.put("invoiceType", malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        params.put("companyName", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle().trim());
        params.put("invoiceTitle", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle());
        params.put("paymentType", malEcSubmitOrderParam.getPaymentType());
        params.put("amount", malEcSubmitOrderParam.getSumTaxAmount());
        params.put("servFee", malEcSubmitOrderParam.getFreight());
        params.put("regCode", malEcSubmitOrderParam.getMalInvoicingInfo().getTaxRegNum().trim());
        params.put("regBank", malEcSubmitOrderParam.getMalInvoicingInfo().getDepositBank().trim());
        params.put("regBankAccount", malEcSubmitOrderParam.getMalInvoicingInfo().getBankAccount().trim());
        params.put("invoicePhone", malEcSubmitOrderParam.getMalInvoicingInfo().getPhone().trim());
        params.put("invoiceAddress", malEcSubmitOrderParam.getMalInvoicingInfo().getAddress());
        params = this.beforeSubmitEcOrder(params, malEcSubmitOrderParam);
        log.info("\u751f\u6210\u6668\u5149\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570" + params);
        Map submitResult = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_CG_ORDER_order", params));
        MalEcSubmitOrderResult malEcSubmitOrderResult = this.parseResult(submitResult, malEcSubmitOrderParam);
        malEcSubmitOrderResult = this.afterSubmitEcOrder(malEcSubmitOrderResult, submitResult);
        log.info("\u8c03\u7528\u751f\u6210\u6668\u5149\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + submitResult);
        return malEcSubmitOrderResult;
    }

    private MalEcSubmitOrderResult parseResult(Map<String, Object> submitResult, MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Object orderTaxPrice;
        Object freight;
        Object orderPrice;
        MalEcSubmitOrderResult malEcSubmitOrderResult = new MalEcSubmitOrderResult();
        malEcSubmitOrderResult.setEcOrderId(String.valueOf(submitResult.get("yggc_order")));
        Object orderNakedPrice = submitResult.get("order_naked_price");
        if (orderNakedPrice != null) {
            malEcSubmitOrderResult.setAmount(new BigDecimal(String.valueOf(orderNakedPrice)));
        }
        if ((orderPrice = submitResult.get("order_price")) != null) {
            malEcSubmitOrderResult.setTaxAmount(new BigDecimal(String.valueOf(orderPrice)));
        }
        if ((freight = submitResult.get("freight")) != null) {
            malEcSubmitOrderResult.setFreight(new BigDecimal(String.valueOf(freight)));
        }
        if ((orderTaxPrice = submitResult.get("order_taxprice_total")) != null) {
            malEcSubmitOrderResult.setTax(new BigDecimal(String.valueOf(orderTaxPrice)));
        }
        List bizSkus = (List)submitResult.get("skus");
        MalObjectCache malObjectCache = MalObjectCache.get(MalCacheGoodsInfo.class);
        for (Map bizSku : bizSkus) {
            MalCacheGoodsInfo cacheGoodsInfo;
            Object taxAmount;
            Object taxRate;
            Object taxPrice;
            Object price;
            MalEcSubmitOrderResultSku malEcSubmitOrderResultSku = new MalEcSubmitOrderResultSku();
            List ecSkus = (List)malEcSubmitOrderParam.getEcSkus();
            for (MalCgSubmitOrderSku malCgSubmitOrderSku : ecSkus) {
                if (!StringUtils.equals((CharSequence)String.valueOf(malCgSubmitOrderSku.getSku()), (CharSequence)String.valueOf(bizSku.get("sku")))) continue;
                malEcSubmitOrderResultSku.setGoodsId(malCgSubmitOrderSku.getGoodsId());
            }
            Object num = bizSku.get("num");
            if (num != null) {
                malEcSubmitOrderResultSku.setQty(new BigDecimal(String.valueOf(num)));
            }
            if ((price = bizSku.get("price")) != null) {
                malEcSubmitOrderResultSku.setTaxPrice(new BigDecimal(String.valueOf(price)));
            }
            if ((taxPrice = bizSku.get("tax_price")) != null) {
                malEcSubmitOrderResultSku.setTax(new BigDecimal(String.valueOf(taxPrice)));
            }
            if ((taxRate = bizSku.get("tax_rate")) != null) {
                malEcSubmitOrderResultSku.setTaxRate(new BigDecimal(String.valueOf(taxRate)).multiply(new BigDecimal("100")));
            }
            if ((taxAmount = bizSku.get("price_total")) != null) {
                malEcSubmitOrderResultSku.setTaxAmount(new BigDecimal(String.valueOf(taxAmount)));
            }
            if ((cacheGoodsInfo = (MalCacheGoodsInfo)malObjectCache.get(CacheKeyHelper.keyForTrace((String)String.valueOf(malEcSubmitOrderResultSku.getGoodsId())))) != null) {
                malEcSubmitOrderResultSku.setEcPrice(cacheGoodsInfo.getEcPrice());
            }
            malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList().add(malEcSubmitOrderResultSku);
        }
        return malEcSubmitOrderResult;
    }

    @Override
    public DynamicObject saveEcOrder(MalEcSubmitOrderResult malEcSubmitOrderResult) {
        DynamicObject ecOrderDyn = CommonUtil.createDefaultDyn((String)"pbd_order_cg");
        ecOrderDyn.set("porderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("orderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("ordernakedamount", (Object)malEcSubmitOrderResult.getAmount());
        ecOrderDyn.set("ordertaxamount", (Object)malEcSubmitOrderResult.getTax());
        ecOrderDyn.set("freight", (Object)malEcSubmitOrderResult.getFreight());
        ecOrderDyn.set("orderamount", (Object)malEcSubmitOrderResult.getTaxAmount());
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            ecOrderDyn.set("currency", (Object)currency);
        } else {
            ecOrderDyn.set("currency", (Object)"1");
        }
        ecOrderDyn.set("invoicetype", (Object)malEcSubmitOrderResult.getInvoiceType());
        ecOrderDyn.set("createtime", (Object)new Date());
        DynamicObjectCollection entryDyoCol = ecOrderDyn.getDynamicObjectCollection("entryentity");
        for (MalEcSubmitOrderResultSku sku : malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)sku.getGoodsId());
            entryDyo.set("qty", (Object)sku.getQty());
            entryDyo.set("price", (Object)sku.getTaxPrice());
            entryDyo.set("taxrate", (Object)sku.getTaxRate());
            entryDyo.set("taxamount", (Object)sku.getTax());
            entryDyo.set("nakedamount", (Object)sku.getPrice());
        }
        DynamicObject[] sevedSnOrderDyns = (DynamicObject[])SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{ecOrderDyn});
        return sevedSnOrderDyns[0];
    }

    @Override
    public String getOrderStatusFieldKey() {
        return "state";
    }

    @Override
    public Object prepareEcSkus(MalCacheGoodsInfo malCacheGoodsInfo, DynamicObject goodsEntryDyn) {
        if (malCacheGoodsInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalCgSubmitOrderServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
        }
        MalCgSubmitOrderSku malCgSubmitOrderSku = new MalCgSubmitOrderSku();
        malCgSubmitOrderSku.setGoodsId(goodsEntryDyn.getLong("goods_id"));
        malCgSubmitOrderSku.setSku(malCacheGoodsInfo.getProductNumber());
        malCgSubmitOrderSku.setNum(goodsEntryDyn.getInt("qty"));
        malCgSubmitOrderSku.setPrice(malCacheGoodsInfo.getTaxPrice());
        return malCgSubmitOrderSku;
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_CG.getVal();
    }
}

