/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.placeorder.entity.MalDlSubmitOrderSku;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderParam;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResult;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResultSku;
import kd.scm.mal.business.placeorder.service.impl.MalGenericEcSubmitOrderServiceImpl;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import net.sf.json.JSONArray;

public class MalDlSubmitOrderServiceImpl
extends MalGenericEcSubmitOrderServiceImpl {
    private static final Log log = LogFactory.getLog(MalDlSubmitOrderServiceImpl.class);

    @Override
    public MalEcSubmitOrderResult submitEcOrder(MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Map<String, Object> params = new HashMap<String, Object>(32);
        params.put("pxOrderId", malEcSubmitOrderParam.getThirdOrder());
        params.put("name", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("province", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("city", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("county", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        params.put("address", malEcSubmitOrderParam.getMalReceipt().toString());
        params.put("mobile", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("email", malEcSubmitOrderParam.getMalReceipt().getEmail());
        params.put("zip", malEcSubmitOrderParam.getMalReceipt().getPostalCode());
        params.put("remark", malEcSubmitOrderParam.getRemark());
        params.put("companyName", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle().trim());
        params.put("payType", malEcSubmitOrderParam.getPaymentType());
        params.put("orderPrice", malEcSubmitOrderParam.getSumTaxAmount());
        params.put("orderNakedPrice", malEcSubmitOrderParam.getSumAmount());
        params.put("orderTaxPrice", malEcSubmitOrderParam.getSumTaxAmount().subtract(malEcSubmitOrderParam.getSumAmount()));
        params.put("invoiceType", malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        params.put("invoiceState", "2");
        params.put("invoiceTitle", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle());
        params.put("invoiceIdNo", malEcSubmitOrderParam.getMalInvoicingInfo().getTaxRegNum().trim());
        params.put("invoiceBankName", malEcSubmitOrderParam.getMalInvoicingInfo().getDepositBank().trim());
        params.put("invoiceBankNo", malEcSubmitOrderParam.getMalInvoicingInfo().getBankAccount().trim());
        params.put("invoiceAddress", malEcSubmitOrderParam.getMalInvoicingInfo().getAddress());
        params.put("invoiceTelephone", malEcSubmitOrderParam.getMalInvoicingInfo().getPhone().trim());
        JSONArray skus = JSONArray.fromObject((Object)malEcSubmitOrderParam.getEcSkus());
        for (int i = 0; i < skus.size(); ++i) {
            skus.getJSONObject(i).remove("goodsId");
        }
        params.put("orderDetails", skus);
        params.put("freight", malEcSubmitOrderParam.getFreight().toBigInteger());
        params = this.beforeSubmitEcOrder(params, malEcSubmitOrderParam);
        log.info("\u751f\u6210\u5f97\u529b\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570" + params);
        Map submitResult = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_DL_ORDER_submitOrderV2", params));
        MalEcSubmitOrderResult malEcSubmitOrderResult = this.parseResult(submitResult, malEcSubmitOrderParam);
        malEcSubmitOrderResult = this.afterSubmitEcOrder(malEcSubmitOrderResult, submitResult);
        log.info("\u8c03\u7528\u751f\u6210\u5f97\u529b\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + submitResult);
        return malEcSubmitOrderResult;
    }

    private MalEcSubmitOrderResult parseResult(Map<String, Object> submitResult, MalEcSubmitOrderParam malEcSubmitOrderParam) {
        MalEcSubmitOrderResult malEcSubmitOrderResult = new MalEcSubmitOrderResult();
        malEcSubmitOrderResult.setEcOrderId(String.valueOf(submitResult.get("pxOrderId")));
        Object freight = submitResult.get("freight");
        if (freight != null) {
            malEcSubmitOrderResult.setFreight(new BigDecimal(String.valueOf(freight)));
        }
        malEcSubmitOrderResult.setTaxAmount(malEcSubmitOrderParam.getSumTaxAmount());
        List ecSkus = (List)malEcSubmitOrderParam.getEcSkus();
        BigDecimal sumTax = BigDecimal.ZERO;
        for (MalDlSubmitOrderSku ecSku : ecSkus) {
            String skuId = ecSku.getPxSku();
            MalEcSubmitOrderResultSku malEcSubmitOrderResultSku = new MalEcSubmitOrderResultSku();
            for (MalDlSubmitOrderSku malDlSubmitOrderSku : ecSkus) {
                if (!StringUtils.equals((CharSequence)String.valueOf(malDlSubmitOrderSku.getPxSku()), (CharSequence)skuId)) continue;
                malEcSubmitOrderResultSku.setGoodsId(malDlSubmitOrderSku.getGoodsId());
            }
            malEcSubmitOrderResultSku.setQty(new BigDecimal(ecSku.getNum().toString()));
            malEcSubmitOrderResultSku.setTaxPrice(ecSku.getPrice());
            malEcSubmitOrderResultSku.setTaxRate(ecSku.getTaxRate());
            malEcSubmitOrderResultSku.setPrice(ecSku.getNakedPrice());
            malEcSubmitOrderResultSku.setTax(malEcSubmitOrderResultSku.getTaxPrice().subtract(malEcSubmitOrderResultSku.getPrice()));
            sumTax = sumTax.add(malEcSubmitOrderResultSku.getTax());
            malEcSubmitOrderResultSku.setTaxAmount(malEcSubmitOrderResultSku.getTaxPrice().multiply(malEcSubmitOrderResultSku.getQty()));
            malEcSubmitOrderResultSku.setSubOrderId(malEcSubmitOrderResult.getEcOrderId());
            malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList().add(malEcSubmitOrderResultSku);
        }
        malEcSubmitOrderResult.setTax(sumTax);
        malEcSubmitOrderResult.setAmount(malEcSubmitOrderResult.getTaxAmount().subtract(sumTax));
        malEcSubmitOrderResult.setInvoiceType(malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        return malEcSubmitOrderResult;
    }

    @Override
    public DynamicObject saveEcOrder(MalEcSubmitOrderResult malEcSubmitOrderResult) {
        DynamicObject ecOrderDyn = CommonUtil.createDefaultDyn((String)"pbd_order_dl");
        ecOrderDyn.set("porderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("orderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("ordernakedamount", (Object)malEcSubmitOrderResult.getAmount());
        ecOrderDyn.set("ordertaxamount", (Object)malEcSubmitOrderResult.getTax());
        ecOrderDyn.set("freight", (Object)malEcSubmitOrderResult.getFreight());
        ecOrderDyn.set("orderamount", (Object)malEcSubmitOrderResult.getTaxAmount());
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            ecOrderDyn.set("currency", (Object)currency);
        } else {
            ecOrderDyn.set("currency", (Object)"1");
        }
        ecOrderDyn.set("invoicetype", (Object)malEcSubmitOrderResult.getInvoiceType());
        ecOrderDyn.set("createtime", (Object)new Date());
        DynamicObjectCollection entryDyoCol = ecOrderDyn.getDynamicObjectCollection("entryentity");
        for (MalEcSubmitOrderResultSku sku : malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)sku.getGoodsId());
            entryDyo.set("qty", (Object)sku.getQty());
            entryDyo.set("price", (Object)sku.getTaxPrice());
            entryDyo.set("taxrate", (Object)sku.getTaxRate());
            entryDyo.set("taxamount", (Object)sku.getTax());
            entryDyo.set("nakedamount", (Object)sku.getPrice());
        }
        DynamicObject[] sevedSnOrderDyns = (DynamicObject[])SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{ecOrderDyn});
        return sevedSnOrderDyns[0];
    }

    @Override
    public String getOrderStatusFieldKey() {
        return "state";
    }

    @Override
    public Object prepareEcSkus(MalCacheGoodsInfo malCacheGoodsInfo, DynamicObject goodsEntryDyn) {
        if (malCacheGoodsInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalDlSubmitOrderServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
        }
        MalDlSubmitOrderSku malDlSubmitOrderSku = new MalDlSubmitOrderSku();
        malDlSubmitOrderSku.setGoodsId(goodsEntryDyn.getLong("goods_id"));
        malDlSubmitOrderSku.setSku(malCacheGoodsInfo.getProductNumber());
        malDlSubmitOrderSku.setPxSku(malCacheGoodsInfo.getProductNumber());
        malDlSubmitOrderSku.setNum(goodsEntryDyn.getInt("qty"));
        malDlSubmitOrderSku.setPrice(malCacheGoodsInfo.getTaxPrice());
        malDlSubmitOrderSku.setNakedPrice(malCacheGoodsInfo.getPrice());
        malDlSubmitOrderSku.setTaxPrice(malCacheGoodsInfo.getTaxPrice().subtract(malCacheGoodsInfo.getPrice()));
        malDlSubmitOrderSku.setTaxRate(malCacheGoodsInfo.getTaxRate());
        return malDlSubmitOrderSku;
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_DL.getVal();
    }
}

