/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalFeeGoods;
import kd.scm.mal.business.placeorder.entity.MalFreightInfo;
import kd.scm.mal.business.placeorder.entity.MalFreightParam;
import kd.scm.mal.business.placeorder.entity.MalFreightResult;
import kd.scm.mal.business.placeorder.service.MalFreightService;
import kd.scm.mal.business.placeorder.service.MalGetFreightService;

public class MalFreightServiceImpl
implements MalFreightService {
    private static final Log log = LogFactory.getLog((String)MalFreightServiceImpl.class.getName());

    @Override
    public MalFreightResult getMalFreight(MalFreightParam malFreightParam) {
        log.info("\u83b7\u53d6\u8fd0\u8d39\u53c2\u6570\uff1a" + malFreightParam);
        MalFreightResult res = new MalFreightResult();
        res.setSupplierIdToFreightInfoMap(this.getFreight(malFreightParam));
        this.splitFreight(malFreightParam, res);
        log.info("\u83b7\u53d6\u8fd0\u8d39\u7ed3\u679c\uff1a" + res);
        return res;
    }

    private Map<Long, MalFreightInfo> getFreight(MalFreightParam malFreightParam) {
        HashMap<Long, MalFreightInfo> res = new HashMap<Long, MalFreightInfo>(16);
        MalFreightParam malSelfFreightParam = new MalFreightParam();
        malSelfFreightParam.setMalReceipt(malFreightParam.getMalReceipt());
        MalFreightParam malEcFreightParam = new MalFreightParam();
        malEcFreightParam.setMalReceipt(malFreightParam.getMalReceipt());
        HashMap<String, MalFreightParam> platform2FreightParamMap = new HashMap<String, MalFreightParam>(malEcFreightParam.getMalFeeGoodsList().size());
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            MalFreightParam platformFreightParam = platform2FreightParamMap.getOrDefault(malFeeGoods.getPlatform(), new MalFreightParam());
            platformFreightParam.setMalReceipt(malFreightParam.getMalReceipt());
            platformFreightParam.getMalFeeGoodsList().add(malFeeGoods);
            platform2FreightParamMap.put(malFeeGoods.getPlatform(), platformFreightParam);
        }
        platform2FreightParamMap.forEach((platform, freightParam) -> {
            MalGetFreightService malGetFreightService = MalBusinessFactory.serviceOf(MalGetFreightService.class, platform);
            if (malGetFreightService != null) {
                res.putAll(malGetFreightService.getFreight((MalFreightParam)freightParam));
            }
        });
        return res;
    }

    private Map<Long, BigDecimal> getSupplierIdToTotalAmountMap(MalFreightParam malFreightParam) {
        HashMap<Long, BigDecimal> supplierIdToTotalAmountMap = new HashMap<Long, BigDecimal>(16);
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            BigDecimal supTotalAmount = supplierIdToTotalAmountMap.getOrDefault(malFeeGoods.getSupplierId(), BigDecimal.ZERO);
            supplierIdToTotalAmountMap.put(malFeeGoods.getSupplierId(), supTotalAmount.add(malFeeGoods.getQty().multiply(malFeeGoods.getFeePrice())));
        }
        return supplierIdToTotalAmountMap;
    }

    private void splitFreight(MalFreightParam malFreightParam, MalFreightResult malFreightResult) {
        Integer n;
        if (malFreightResult.getSupplierIdToFreightInfoMap().isEmpty()) {
            return;
        }
        Map<Long, MalFreightInfo> supplierIdToFreightMap = malFreightResult.getSupplierIdToFreightInfoMap();
        DynamicObject defaultCurrency = this.getDefaultCurrency();
        int defaultPricePrecision = this.getDefaultPricePrecision(defaultCurrency);
        Map<Long, BigDecimal> supplierIdToTotalAmountMap = this.getSupplierIdToTotalAmountMap(malFreightParam);
        HashMap<Long, BigDecimal> supplierIdToLeftFreight = new HashMap<Long, BigDecimal>(supplierIdToTotalAmountMap.size() << 2);
        HashMap<Long, Integer> supplierIdToRowCount = new HashMap<Long, Integer>(32);
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            Integer rowCount;
            Integer n2 = rowCount = supplierIdToRowCount.getOrDefault(malFeeGoods.getSupplierId(), 0);
            n = rowCount = Integer.valueOf(rowCount + 1);
            supplierIdToRowCount.put(malFeeGoods.getSupplierId(), rowCount);
        }
        HashMap<Long, Integer> supplierAndIndexMap = new HashMap<Long, Integer>(8);
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            BigDecimal avgFreight;
            Integer i;
            n = i = supplierAndIndexMap.getOrDefault(malFeeGoods.getSupplierId(), 0);
            Integer n3 = i = Integer.valueOf(i + 1);
            supplierAndIndexMap.put(malFeeGoods.getSupplierId(), n);
            BigDecimal rowTaxAmount = malFeeGoods.getFeePrice().multiply(malFeeGoods.getQty());
            BigDecimal totalSupAmount = supplierIdToTotalAmountMap.get(malFeeGoods.getSupplierId());
            MalFreightInfo malFreightInfo = supplierIdToFreightMap.get(malFeeGoods.getSupplierId());
            BigDecimal totalSupFreight = BigDecimal.ZERO;
            if (malFreightInfo != null) {
                totalSupFreight = malFreightInfo.getFreight();
            }
            Integer rowCount = (Integer)supplierIdToRowCount.get(malFeeGoods.getSupplierId());
            BigDecimal leftFreight = supplierIdToLeftFreight.getOrDefault(malFeeGoods.getSupplierId(), totalSupFreight);
            if (i < rowCount) {
                avgFreight = totalSupFreight.multiply(rowTaxAmount).divide(totalSupAmount, RoundingMode.HALF_UP).setScale(defaultPricePrecision, RoundingMode.HALF_UP);
                leftFreight = leftFreight.subtract(avgFreight);
                supplierIdToLeftFreight.put(malFeeGoods.getSupplierId(), leftFreight);
            } else {
                avgFreight = leftFreight;
            }
            malFreightResult.getGoodsIdToAvgFreightMap().put(malFeeGoods.getGoodsId(), avgFreight);
            if (avgFreight.compareTo(BigDecimal.ZERO) <= 0) continue;
            malFreightResult.getGoodsIdToSingleAvgFreightMap().put(malFeeGoods.getGoodsId(), avgFreight.divide(malFeeGoods.getQty(), defaultPricePrecision, RoundingMode.HALF_UP));
        }
        this.handleTailDiff(malFreightParam, malFreightResult, supplierIdToFreightMap, defaultPricePrecision);
    }

    private void handleTailDiff(MalFreightParam malFreightParam, MalFreightResult malFreightResult, Map<Long, MalFreightInfo> supplierIdToFreightMap, int defaultPricePrecision) {
        BigDecimal base = BigDecimal.TEN.pow(defaultPricePrecision);
        Map<Long, BigDecimal> supplierId2TotalSubFreightAfterSplit = this.getSupplierId2TotalSubFreightAfterSplit(malFreightParam, malFreightResult);
        HashSet<Long> successHandleDiffSupplierIdSet = new HashSet<Long>(malFreightParam.getMalFeeGoodsList().size());
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            BigDecimal singleAvgFreight;
            BigDecimal singleAvgFreightWithDiff;
            BigDecimal totalSupFreight;
            BigDecimal diffAmount;
            MalFreightInfo malFreightInfo;
            BigDecimal totalSubFreightAfterSplit;
            if (successHandleDiffSupplierIdSet.contains(malFeeGoods.getSupplierId()) || (totalSubFreightAfterSplit = supplierId2TotalSubFreightAfterSplit.get(malFeeGoods.getSupplierId())) == null || (malFreightInfo = supplierIdToFreightMap.get(malFeeGoods.getSupplierId())) == null || (diffAmount = (totalSupFreight = malFreightInfo.getFreight() == null ? BigDecimal.ZERO : malFreightInfo.getFreight()).subtract(totalSubFreightAfterSplit)).compareTo(BigDecimal.ZERO) == 0) continue;
            malFreightInfo.setHasTailDiff(true);
            BigDecimal remainder = diffAmount.multiply(base).remainder(malFeeGoods.getQty());
            if (remainder.compareTo(BigDecimal.ZERO) != 0 || (singleAvgFreightWithDiff = (singleAvgFreight = malFreightResult.getGoodsIdToSingleAvgFreightMap().get(malFeeGoods.getGoodsId())).add(diffAmount.divide(malFeeGoods.getQty(), defaultPricePrecision, RoundingMode.HALF_UP))).compareTo(BigDecimal.ZERO) <= 0) continue;
            malFreightResult.getGoodsIdToSingleAvgFreightMap().put(malFeeGoods.getGoodsId(), singleAvgFreightWithDiff);
            successHandleDiffSupplierIdSet.add(malFeeGoods.getSupplierId());
            malFreightInfo.setHasTailDiff(false);
        }
    }

    private Map<Long, BigDecimal> getSupplierId2TotalSubFreightAfterSplit(MalFreightParam malFreightParam, MalFreightResult malFreightResult) {
        HashMap<Long, BigDecimal> res = new HashMap<Long, BigDecimal>(malFreightParam.getMalFeeGoodsList().size());
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            BigDecimal totalSubFreightAfterSplit = res.getOrDefault(malFeeGoods.getSupplierId(), BigDecimal.ZERO);
            BigDecimal singleAvgFreight = malFreightResult.getGoodsIdToSingleAvgFreightMap().get(malFeeGoods.getGoodsId());
            if (singleAvgFreight == null) continue;
            totalSubFreightAfterSplit = totalSubFreightAfterSplit.add(singleAvgFreight.multiply(malFeeGoods.getQty()));
            res.put(malFeeGoods.getSupplierId(), totalSubFreightAfterSplit);
        }
        return res;
    }

    private int getDefaultPricePrecision(DynamicObject currencyDyn) {
        if (currencyDyn != null) {
            return currencyDyn.getInt("priceprecision");
        }
        return 6;
    }

    private DynamicObject getDefaultCurrency() {
        String defaultCurrency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isBlank((CharSequence)defaultCurrency)) {
            defaultCurrency = "1";
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(defaultCurrency), (String)"bd_currency");
    }
}

