/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ecapi.util.PayTypeUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderParam;
import kd.scm.mal.business.placeorder.entity.MalInvoicingInfo;
import kd.scm.mal.business.placeorder.entity.MalReqPerson;
import kd.scm.mal.business.placeorder.service.MalEcSubmitOrderService;
import kd.scm.mal.business.receipt.entity.MalEcAddressMapping;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalEcAddressMappingService;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import kd.scm.malcore.cache.CacheKeyHelper;
import kd.scm.malcore.cache.MalObjectCache;

public abstract class MalGenericEcSubmitOrderServiceImpl
implements MalEcSubmitOrderService {
    @Override
    public MalEcSubmitOrderParam prepareSubmitOrderParam(DynamicObject malOrderDyn) {
        MalEcSubmitOrderParam malEcSubmitOrderParam = new MalEcSubmitOrderParam();
        malEcSubmitOrderParam.setThirdOrder(malOrderDyn.getString("billno"));
        DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
        ArrayList<Object> submitOrderSkus = new ArrayList<Object>(entryCol.size());
        ArrayList<Long> goodsIdList = new ArrayList<Long>();
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        MalObjectCache malObjectCache = MalObjectCache.get(MalCacheGoodsInfo.class);
        for (DynamicObject entry : entryCol) {
            long goodsId = entry.getLong("goods_id");
            MalCacheGoodsInfo malCacheGoodsInfo = (MalCacheGoodsInfo)malObjectCache.get(CacheKeyHelper.keyForTrace((String)entry.getString("goods_id")));
            sumTaxAmount = sumTaxAmount.add(malCacheGoodsInfo.getTaxPrice().multiply(entry.getBigDecimal("qty")));
            sumAmount = sumAmount.add(malCacheGoodsInfo.getPrice().multiply(entry.getBigDecimal("qty")));
            Object submitOrderSku = this.prepareEcSkus(malCacheGoodsInfo, entry);
            submitOrderSkus.add(submitOrderSku);
            goodsIdList.add(goodsId);
        }
        malEcSubmitOrderParam.setGoodsIdList(goodsIdList);
        malEcSubmitOrderParam.setEcSkus(submitOrderSkus);
        MalReceipt malReceipt = MalBusinessFactory.serviceOf(MalReceiptService.class).getReceiptById(malOrderDyn.getLong("receipt_id"));
        if (malReceipt == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalGenericEcSubmitOrderServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
        }
        malEcSubmitOrderParam.setMalReceipt(malReceipt);
        MalEcAddressMappingService malEcAddressMappingService = MalBusinessFactory.serviceOf(MalEcAddressMappingService.class, malOrderDyn.getString("platform"));
        if (malEcAddressMappingService != null) {
            MalEcAddressMapping malEcAddressMapping = malEcAddressMappingService.map(malReceipt.getAdmindivisionId(), malOrderDyn.getString("platform"));
            malEcSubmitOrderParam.setMalEcAddressMapping(malEcAddressMapping);
        }
        MalInvoicingInfo malInvoicingInfo = this.fillMalInvoicingInfo(malOrderDyn);
        malEcSubmitOrderParam.setMalInvoicingInfo(malInvoicingInfo);
        malEcSubmitOrderParam.setRemark(malOrderDyn.getString("remark"));
        malEcSubmitOrderParam.setPaymentType(PayTypeUtil.getNumberByPayTypeId((Long)malOrderDyn.getLong("malpaytype_id"), (String)this.getPlatform()));
        malEcSubmitOrderParam.setDepOrgId(malOrderDyn.getLong("deporg_id"));
        malEcSubmitOrderParam.setSumTaxAmount(sumTaxAmount);
        malEcSubmitOrderParam.setSumAmount(sumAmount);
        malEcSubmitOrderParam.setFreight(malOrderDyn.getBigDecimal("freight"));
        MalReqPerson malReqPerson = this.fillMalReqPersonInfo(malOrderDyn);
        malEcSubmitOrderParam.setMalReqPerson(malReqPerson);
        return malEcSubmitOrderParam;
    }

    abstract Object prepareEcSkus(MalCacheGoodsInfo var1, DynamicObject var2);

    private MalInvoicingInfo fillMalInvoicingInfo(DynamicObject malOrderDyn) {
        MalInvoicingInfo malInvoicingInfo = new MalInvoicingInfo();
        malInvoicingInfo.setInvoiceOrgId(malOrderDyn.getLong("invoiceorg_id"));
        DynamicObject invoiceOrgDyn = BusinessDataServiceHelper.loadSingle((Object)malOrderDyn.getLong("invoiceorg_id"), (String)"bos_org");
        if (invoiceOrgDyn != null) {
            malInvoicingInfo.setTitle(invoiceOrgDyn.getString("ffirmname"));
            malInvoicingInfo.setTaxRegNum(invoiceOrgDyn.getString("ftaxregnum"));
            malInvoicingInfo.setDepositBank(invoiceOrgDyn.getString("depositbank"));
            malInvoicingInfo.setBankAccount(invoiceOrgDyn.getString("bankaccount"));
            malInvoicingInfo.setAddress(invoiceOrgDyn.getString("faddress"));
            malInvoicingInfo.setPhone(invoiceOrgDyn.getString("phone"));
            malInvoicingInfo.setInvoiceType(malOrderDyn.getString("invtype"));
        }
        return malInvoicingInfo;
    }

    private MalReqPerson fillMalReqPersonInfo(DynamicObject malOrderDyn) {
        MalReqPerson malReqPerson = new MalReqPerson();
        malReqPerson.setId(malOrderDyn.getLong("reqperson.id"));
        malReqPerson.setName(malOrderDyn.getString("reqperson.name"));
        malReqPerson.setPhone(malOrderDyn.getString("reqperson.phone"));
        return malReqPerson;
    }
}

