/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.mal.business.placeorder.entity.MalFeeGoods;
import kd.scm.mal.business.placeorder.entity.MalFreightInfo;
import kd.scm.mal.business.placeorder.entity.MalFreightParam;
import kd.scm.mal.business.placeorder.service.MalGetFreightService;

public class MalGroupGetFreightServiceImpl
implements MalGetFreightService {
    private final Log log = LogFactory.getLog(MalGroupGetFreightServiceImpl.class);

    @Override
    public Map<Long, MalFreightInfo> getFreight(MalFreightParam malFreightParam) {
        return this.getEcFreigt(malFreightParam);
    }

    private Map<Long, MalFreightInfo> getEcFreigt(MalFreightParam malEcFreightParam) {
        this.log.info("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u7535\u5546\u8ba2\u5355\u8fd0\u8d39\u53c2\u6570\uff1a" + malEcFreightParam);
        Map<Long, MalFreightInfo> res = this.initSupplierIdFreightInfoMap(malEcFreightParam);
        Map<Long, BigDecimal> supplierIdToTotalAmountMap = this.getSupplierIdToTotalAmountMap(malEcFreightParam);
        HashMap params = new HashMap(16);
        HashMap<String, String> commonParam = new HashMap<String, String>(16);
        HashMap<String, Map> platformToMalParams = new HashMap<String, Map>(16);
        HashMap<String, Long> platformToSupplierIdMap = new HashMap<String, Long>(16);
        for (MalFeeGoods malFeeGoods : malEcFreightParam.getMalFeeGoodsList()) {
            platformToSupplierIdMap.put(malFeeGoods.getPlatform(), malFeeGoods.getSupplierId());
            Map malParam = platformToMalParams.getOrDefault(malFeeGoods.getPlatform(), new HashMap());
            Map skuNums = malParam.getOrDefault("skuNums", new HashMap());
            if (StringUtils.equals((CharSequence)EcPlatformEnum.ECPLATFORM_XFS.getVal(), (CharSequence)malFeeGoods.getPlatform())) {
                HashMap<String, Object> skuInfo = new HashMap<String, Object>();
                skuInfo.put("skuNo", malFeeGoods.getGoodsNumber());
                skuInfo.put("buyNum", malFeeGoods.getQty());
                skuInfo.put("settlePrice", malFeeGoods.getFeePrice().setScale(2, RoundingMode.HALF_UP));
                skuNums.put(malFeeGoods.getGoodsNumber(), skuInfo);
            } else {
                skuNums.put(malFeeGoods.getGoodsNumber(), malFeeGoods.getQty());
            }
            malParam.put("skuNums", skuNums);
            if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(malFeeGoods.getPlatform())) {
                malParam.put("addrDetail", malEcFreightParam.getMalReceipt().toString());
            } else if (EcPlatformEnum.ECPLATFORM_DL.getVal().equals(malFeeGoods.getPlatform())) {
                malParam.put("addrDetail", supplierIdToTotalAmountMap.get(malFeeGoods.getSupplierId()));
            } else {
                malParam.put("addrDetail", "");
            }
            malParam.put("paymentType", malFeeGoods.getPayType());
            platformToMalParams.put(malFeeGoods.getPlatform(), malParam);
        }
        commonParam.put("townId", malEcFreightParam.getMalReceipt().getAdmindivisionId());
        params.put("common_params", commonParam);
        params.putAll(platformToMalParams);
        Map ecFreightMap = EcGroupApiUtil.getEcFreight(params);
        for (String platform : platformToMalParams.keySet()) {
            BigDecimal freight = (BigDecimal)ecFreightMap.get(platform);
            if (freight != null) {
                MalFreightInfo malFreightInfo = res.get(platformToSupplierIdMap.get(platform));
                if (malFreightInfo == null) continue;
                malFreightInfo.setFreight(freight);
                res.put((Long)platformToSupplierIdMap.get(platform), malFreightInfo);
                continue;
            }
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5546\u8ba2\u5355\u8fd0\u8d39\u4e3a\u7a7a\u3002", (String)"MalFreightServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("getMalGoodsPrice error", EcPlatformEnum.fromVal((String)platform).getName() + msg), new Object[0]);
        }
        return res;
    }

    private Map<Long, MalFreightInfo> initSupplierIdFreightInfoMap(MalFreightParam malFreightParam) {
        HashMap<Long, MalFreightInfo> supplierIdFreightInfoMap = new HashMap<Long, MalFreightInfo>(16);
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            MalFreightInfo malFreightInfo = supplierIdFreightInfoMap.getOrDefault(malFeeGoods.getSupplierId(), new MalFreightInfo());
            malFreightInfo.setSupplierName(malFeeGoods.getSupplierName());
            malFreightInfo.setSupplierId(malFeeGoods.getSupplierId());
            supplierIdFreightInfoMap.put(malFeeGoods.getSupplierId(), malFreightInfo);
        }
        return supplierIdFreightInfoMap;
    }

    private Map<Long, BigDecimal> getSupplierIdToTotalAmountMap(MalFreightParam malFreightParam) {
        HashMap<Long, BigDecimal> supplierIdToTotalAmountMap = new HashMap<Long, BigDecimal>(16);
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            BigDecimal supTotalAmount = supplierIdToTotalAmountMap.getOrDefault(malFeeGoods.getSupplierId(), BigDecimal.ZERO);
            supplierIdToTotalAmountMap.put(malFeeGoods.getSupplierId(), supTotalAmount.add(malFeeGoods.getQty().multiply(malFeeGoods.getFeePrice())));
        }
        return supplierIdToTotalAmountMap;
    }
}

