/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderParam;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResult;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResultSku;
import kd.scm.mal.business.placeorder.entity.MalJdSubmitOrderSku;
import kd.scm.mal.business.placeorder.service.impl.MalGenericEcSubmitOrderServiceImpl;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import kd.scm.malcore.cache.CacheKeyHelper;
import kd.scm.malcore.cache.MalObjectCache;
import net.sf.json.JSONArray;

public class MalJdSubmitOrderServiceImpl
extends MalGenericEcSubmitOrderServiceImpl {
    private static final Log log = LogFactory.getLog(MalJdSubmitOrderServiceImpl.class);

    @Override
    public MalEcSubmitOrderParam prepareSubmitOrderParam(DynamicObject malOrderDyn) {
        MalEcSubmitOrderParam malEcSubmitOrderParam = super.prepareSubmitOrderParam(malOrderDyn);
        String token = JDAccessTokenUtil.getValidToken((String)String.valueOf(malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceOrgId()), (String)malOrderDyn.getString("platform"));
        malEcSubmitOrderParam.setToken(token);
        return malEcSubmitOrderParam;
    }

    @Override
    public MalEcSubmitOrderResult submitEcOrder(MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Map<String, Object> params = new HashMap<String, Object>(32);
        if (StringUtils.isNotBlank((CharSequence)malEcSubmitOrderParam.getToken())) {
            params.put("token", malEcSubmitOrderParam.getToken());
        }
        params.put("thirdOrder", malEcSubmitOrderParam.getThirdOrder());
        JSONArray skus = JSONArray.fromObject((Object)malEcSubmitOrderParam.getEcSkus());
        for (int i = 0; i < skus.size(); ++i) {
            skus.getJSONObject(i).remove("goodsId");
            skus.getJSONObject(i).remove("price");
        }
        params.put("sku", JSON.toJSONString((Object)skus));
        params.put("receiverName", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("address", malEcSubmitOrderParam.getMalReceipt().toString());
        params.put("mobile", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("email", malEcSubmitOrderParam.getMalReceipt().getEmail());
        params.put("zip", malEcSubmitOrderParam.getMalReceipt().getPostalCode());
        params.put("invoiceName", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("invoicePhone", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("provinceId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("cityId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("countyId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        params.put("townId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingTownId());
        params.put("invoiceProvice", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("invoiceCity", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("invoiceCounty", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        params.put("invoiceAddress", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingTownId());
        params.put("remark", malEcSubmitOrderParam.getRemark());
        params.put("invoiceState", "2");
        params.put("invoiceType", malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        params.put("invoiceTitle", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle());
        params.put("invoiceContent", "1");
        params.put("paymentType", malEcSubmitOrderParam.getPaymentType());
        params.put("regCode", malEcSubmitOrderParam.getMalInvoicingInfo().getTaxRegNum().trim());
        params.put("regCompanyName", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle().trim());
        params.put("regPhone", malEcSubmitOrderParam.getMalInvoicingInfo().getPhone().trim());
        params.put("regAddr", malEcSubmitOrderParam.getMalInvoicingInfo().getAddress().trim());
        params.put("regBank", malEcSubmitOrderParam.getMalInvoicingInfo().getDepositBank().trim());
        params.put("regBankAccount", malEcSubmitOrderParam.getMalInvoicingInfo().getBankAccount().trim());
        params.put("isUseBalance", malEcSubmitOrderParam.getPaymentType().equalsIgnoreCase("4") ? "1" : "0");
        params = this.beforeSubmitEcOrder(params, malEcSubmitOrderParam);
        log.info("\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570" + params);
        Map submitResult = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)JdApiParser.getJdApiNumber((String)this.getPlatform(), (String)"SRM_JD_ORDER_submitOrder"), params));
        MalEcSubmitOrderResult malEcSubmitOrderResult = this.parseResult(submitResult, malEcSubmitOrderParam);
        malEcSubmitOrderResult = this.afterSubmitEcOrder(malEcSubmitOrderResult, submitResult);
        log.info("\u8c03\u7528\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + submitResult);
        return malEcSubmitOrderResult;
    }

    private MalEcSubmitOrderResult parseResult(Map<String, Object> submitResult, MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Object orderTaxPrice;
        Object freight;
        Object orderPrice;
        MalEcSubmitOrderResult malEcSubmitOrderResult = new MalEcSubmitOrderResult();
        malEcSubmitOrderResult.setEcOrderId(String.valueOf(submitResult.get("jdOrderId")));
        Object orderNakedPrice = submitResult.get("orderNakedPrice");
        if (orderNakedPrice != null) {
            malEcSubmitOrderResult.setAmount(new BigDecimal(String.valueOf(orderNakedPrice)));
        }
        if ((orderPrice = submitResult.get("orderPrice")) != null) {
            malEcSubmitOrderResult.setTaxAmount(new BigDecimal(String.valueOf(orderPrice)));
        }
        if ((freight = submitResult.get("freight")) != null) {
            malEcSubmitOrderResult.setFreight(new BigDecimal(String.valueOf(freight)));
        }
        if ((orderTaxPrice = submitResult.get("orderTaxPrice")) != null) {
            malEcSubmitOrderResult.setTax(new BigDecimal(String.valueOf(orderTaxPrice)));
        }
        List bizSkus = (List)submitResult.get("sku");
        MalObjectCache malObjectCache = MalObjectCache.get(MalCacheGoodsInfo.class);
        for (Map bizSku : bizSkus) {
            MalCacheGoodsInfo cacheGoodsInfo;
            Object taxRate;
            Object taxPrice;
            Object price;
            MalEcSubmitOrderResultSku malEcSubmitOrderResultSku = new MalEcSubmitOrderResultSku();
            List ecSkus = (List)malEcSubmitOrderParam.getEcSkus();
            for (MalJdSubmitOrderSku malJdSubmitOrderSku : ecSkus) {
                if (!StringUtils.equals((CharSequence)String.valueOf(malJdSubmitOrderSku.getSkuId()), (CharSequence)String.valueOf(bizSku.get("skuId")))) continue;
                malEcSubmitOrderResultSku.setGoodsId(malJdSubmitOrderSku.getGoodsId());
            }
            Object num = bizSku.get("num");
            if (num != null) {
                malEcSubmitOrderResultSku.setQty(new BigDecimal(String.valueOf(num)));
            }
            if ((price = bizSku.get("price")) != null) {
                malEcSubmitOrderResultSku.setTaxPrice(new BigDecimal(String.valueOf(price)));
            }
            if ((taxPrice = bizSku.get("taxPrice")) != null) {
                malEcSubmitOrderResultSku.setTax(new BigDecimal(String.valueOf(taxPrice)));
            }
            if ((taxRate = bizSku.get("tax")) != null) {
                malEcSubmitOrderResultSku.setTaxRate(new BigDecimal(String.valueOf(taxRate)));
            }
            if ((cacheGoodsInfo = (MalCacheGoodsInfo)malObjectCache.get(CacheKeyHelper.keyForTrace((String)String.valueOf(malEcSubmitOrderResultSku.getGoodsId())))) != null) {
                malEcSubmitOrderResultSku.setEcPrice(cacheGoodsInfo.getEcPrice());
            }
            malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList().add(malEcSubmitOrderResultSku);
        }
        return malEcSubmitOrderResult;
    }

    @Override
    Object prepareEcSkus(MalCacheGoodsInfo malCacheGoodsInfo, DynamicObject goodsEntryDyn) {
        MalJdSubmitOrderSku malJdSubmitOrderSku = new MalJdSubmitOrderSku();
        if (malCacheGoodsInfo != null) {
            malJdSubmitOrderSku.setSkuId(Long.valueOf(malCacheGoodsInfo.getProductNumber()));
        }
        malJdSubmitOrderSku.setNum(goodsEntryDyn.getInt("qty"));
        malJdSubmitOrderSku.setbNeedGift(false);
        malJdSubmitOrderSku.setGoodsId(goodsEntryDyn.getLong("goods_id"));
        return malJdSubmitOrderSku;
    }

    @Override
    public DynamicObject saveEcOrder(MalEcSubmitOrderResult malEcSubmitOrderResult) {
        DynamicObject jdOrderDyn = CommonUtil.createDefaultDyn((String)"pbd_jdorder");
        Long personId = RequestContext.get().getCurrUserId();
        jdOrderDyn.set("number", (Object)malEcSubmitOrderResult.getEcOrderId());
        jdOrderDyn.set("jdorderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        jdOrderDyn.set("amount", (Object)malEcSubmitOrderResult.getAmount());
        jdOrderDyn.set("tax", (Object)malEcSubmitOrderResult.getTax());
        jdOrderDyn.set("freight", (Object)malEcSubmitOrderResult.getFreight());
        jdOrderDyn.set("taxamount", (Object)malEcSubmitOrderResult.getTaxAmount());
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            jdOrderDyn.set("currency", (Object)currency);
        } else {
            jdOrderDyn.set("currency", (Object)"1");
        }
        jdOrderDyn.set("status", (Object)"C");
        Date currentDate = new Date();
        jdOrderDyn.set("creator", (Object)personId);
        jdOrderDyn.set("createtime", (Object)currentDate);
        jdOrderDyn.set("modifier", (Object)personId);
        jdOrderDyn.set("modifytime", (Object)currentDate);
        jdOrderDyn.set("auditor", (Object)personId);
        jdOrderDyn.set("auditdate", (Object)currentDate);
        DynamicObjectCollection entryDyoCol = jdOrderDyn.getDynamicObjectCollection("entryentity");
        for (MalEcSubmitOrderResultSku sku : malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)sku.getGoodsId());
            entryDyo.set("qty", (Object)sku.getQty());
            entryDyo.set("taxprice", (Object)sku.getTaxPrice());
            entryDyo.set("jdprice", (Object)sku.getEcPrice());
        }
        DynamicObject[] sevedJdOrderDyns = (DynamicObject[])SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{jdOrderDyn});
        return sevedJdOrderDyns[0];
    }

    @Override
    public String getOrderStatusFieldKey() {
        return "jdorderstate";
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_JD.getVal();
    }
}

