/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.mal.business.placeorder.entity.MalFeeGoods;
import kd.scm.mal.business.placeorder.entity.MalFreightInfo;
import kd.scm.mal.business.placeorder.entity.MalFreightParam;
import kd.scm.mal.business.placeorder.service.MalGetFreightService;

public class MalSelfGetFreightServiceImpl
implements MalGetFreightService {
    @Override
    public Map<Long, MalFreightInfo> getFreight(MalFreightParam malFreightParam) {
        return this.geSelfFreight(malFreightParam);
    }

    private Map<Long, MalFreightInfo> geSelfFreight(MalFreightParam malSelfFreightParam) {
        Map<Long, MalFreightInfo> res = this.initSupplierIdFreightInfoMap(malSelfFreightParam);
        Map<Long, BigDecimal> supplierIdToTotalAmountMap = this.getSupplierIdToTotalAmountMap(malSelfFreightParam);
        Map<Object, DynamicObject> suppliperIdToFreightDynMap = this.getObjectDynamicObjectMap(new HashSet<Long>(supplierIdToTotalAmountMap.keySet()));
        for (Map.Entry<Object, DynamicObject> suppliperIdToFreightDynEntry : suppliperIdToFreightDynMap.entrySet()) {
            boolean national;
            DynamicObject freightDyn = suppliperIdToFreightDynEntry.getValue();
            Long supplierId = freightDyn.getLong("supplier.id");
            MalFreightInfo malFreightInfo = res.get(supplierId);
            if (malFreightInfo == null) continue;
            DynamicObjectCollection entryCol = freightDyn.getDynamicObjectCollection("entryentity");
            boolean foundCityFreight = false;
            boolean foundProvinceFreight = false;
            BigDecimal totalAmount = supplierIdToTotalAmountMap.getOrDefault(supplierId, BigDecimal.ZERO);
            block1: for (DynamicObject entry : entryCol) {
                String[] longNumAttr;
                if (foundCityFreight) break;
                String longNums = entry.getString("longnumber");
                BigDecimal thresholdPrice = entry.getBigDecimal("price");
                malFreightInfo.setThresholdPrice(thresholdPrice);
                BigDecimal freight = entry.getBigDecimal("freight");
                if (!StringUtils.isNotBlank((CharSequence)longNums)) continue;
                for (String longNum : longNumAttr = longNums.split(",")) {
                    if (this.matchLevel2(malSelfFreightParam.getMalReceipt().getLongNumber(), longNum)) {
                        if (totalAmount.compareTo(thresholdPrice) < 0) {
                            malFreightInfo.setFreight(freight);
                        }
                        foundCityFreight = true;
                        continue block1;
                    }
                    if (!this.matchLevel1(malSelfFreightParam.getMalReceipt().getLongNumber(), longNum)) continue;
                    if (totalAmount.compareTo(thresholdPrice) < 0) {
                        malFreightInfo.setFreight(freight);
                    }
                    foundProvinceFreight = true;
                }
            }
            if (!foundCityFreight && !foundProvinceFreight && (national = freightDyn.getBoolean("national"))) {
                malFreightInfo.setFreight(freightDyn.getBigDecimal("basefreight"));
            }
            malFreightInfo.setDifferenceAmount(malFreightInfo.getThresholdPrice().subtract(totalAmount));
            if (malFreightInfo.getFreight().compareTo(BigDecimal.ZERO) <= 0) {
                res.remove(supplierId);
                continue;
            }
            res.put(supplierId, malFreightInfo);
        }
        return res;
    }

    private Map<Long, MalFreightInfo> initSupplierIdFreightInfoMap(MalFreightParam malFreightParam) {
        HashMap<Long, MalFreightInfo> supplierIdFreightInfoMap = new HashMap<Long, MalFreightInfo>(16);
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            MalFreightInfo malFreightInfo = supplierIdFreightInfoMap.getOrDefault(malFeeGoods.getSupplierId(), new MalFreightInfo());
            malFreightInfo.setSupplierName(malFeeGoods.getSupplierName());
            malFreightInfo.setSupplierId(malFeeGoods.getSupplierId());
            supplierIdFreightInfoMap.put(malFeeGoods.getSupplierId(), malFreightInfo);
        }
        return supplierIdFreightInfoMap;
    }

    private Map<Long, BigDecimal> getSupplierIdToTotalAmountMap(MalFreightParam malFreightParam) {
        HashMap<Long, BigDecimal> supplierIdToTotalAmountMap = new HashMap<Long, BigDecimal>(16);
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            BigDecimal supTotalAmount = supplierIdToTotalAmountMap.getOrDefault(malFeeGoods.getSupplierId(), BigDecimal.ZERO);
            supplierIdToTotalAmountMap.put(malFeeGoods.getSupplierId(), supTotalAmount.add(malFeeGoods.getQty().multiply(malFeeGoods.getFeePrice())));
        }
        return supplierIdToTotalAmountMap;
    }

    private boolean matchLevel1(String placeOrderLongNumber, String longNum) {
        if (StringUtils.isBlank((CharSequence)placeOrderLongNumber) || StringUtils.isBlank((CharSequence)longNum)) {
            return false;
        }
        String[] split = placeOrderLongNumber.split("\\.");
        if (longNum.split("\\.").length == 1 && split.length >= 1) {
            return split[0].equals(longNum);
        }
        return false;
    }

    private boolean matchLevel2(String placeOrderLongNumber, String longNum) {
        if (StringUtils.isBlank((CharSequence)placeOrderLongNumber) || StringUtils.isBlank((CharSequence)longNum)) {
            return false;
        }
        String[] split = placeOrderLongNumber.split("\\.");
        if (longNum.split("\\.").length == 2) {
            return split[0].equals(longNum.split("\\.")[0]) && split[1].equals(longNum.split("\\.")[1]);
        }
        return false;
    }

    private Map<Object, DynamicObject> getObjectDynamicObjectMap(Set<Long> supplierIdSet) {
        QFilter freightFilter = new QFilter("supplier", "in", supplierIdSet);
        String freightFields = "supplier.id,national,basefreight,entryentity.longnumber,entryentity.price,entryentity.freight";
        return BusinessDataServiceHelper.loadFromCache((String)"ent_freightscheme", (String)freightFields, (QFilter[])new QFilter[]{freightFilter}, (String)"entryentity.longnumber desc");
    }
}

