/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderParam;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResult;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResultSku;
import kd.scm.mal.business.placeorder.entity.MalSnSubmitOrderSku;
import kd.scm.mal.business.placeorder.service.impl.MalGenericEcSubmitOrderServiceImpl;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import net.sf.json.JSONArray;

public class MalSnSubmitOrderServiceImpl
extends MalGenericEcSubmitOrderServiceImpl {
    private static final Log log = LogFactory.getLog(MalSnSubmitOrderServiceImpl.class);

    @Override
    public MalEcSubmitOrderResult submitEcOrder(MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Map submitResult;
        Map<String, Object> params = new HashMap<String, Object>(32);
        params.put("thirdOrder", malEcSubmitOrderParam.getThirdOrder());
        JSONArray skus = JSONArray.fromObject((Object)malEcSubmitOrderParam.getEcSkus());
        for (int i = 0; i < skus.size(); ++i) {
            skus.getJSONObject(i).remove("goodsId");
        }
        params.put("sku", skus);
        params.put("receiverName", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("provinceId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("cityId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("countyId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        String mappingTownId = malEcSubmitOrderParam.getMalEcAddressMapping().getMappingTownId();
        if ("0".equals(mappingTownId)) {
            mappingTownId = "";
        }
        params.put("townId", mappingTownId);
        params.put("address", malEcSubmitOrderParam.getMalReceipt().toString());
        params.put("mobile", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("email", malEcSubmitOrderParam.getMalReceipt().getEmail());
        params.put("zip", malEcSubmitOrderParam.getMalReceipt().getPostalCode());
        params.put("remark", malEcSubmitOrderParam.getRemark());
        params.put("invoiceState", "0");
        params.put("invoiceType", malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        params.put("invoiceTitle", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle());
        params.put("invoiceContent", "1");
        params.put("paymentType", malEcSubmitOrderParam.getPaymentType());
        BigDecimal freight = malEcSubmitOrderParam.getFreight();
        params.put("amount", malEcSubmitOrderParam.getSumTaxAmount().subtract(freight).setScale(8, RoundingMode.HALF_UP));
        params.put("servFee", freight.setScale(8, RoundingMode.HALF_UP));
        params.put("regCode", malEcSubmitOrderParam.getMalInvoicingInfo().getTaxRegNum().trim());
        params.put("regCompanyName", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle().trim());
        params.put("regPhone", malEcSubmitOrderParam.getMalInvoicingInfo().getPhone().trim());
        params.put("regAddr", malEcSubmitOrderParam.getMalInvoicingInfo().getAddress().trim());
        params.put("regBank", malEcSubmitOrderParam.getMalInvoicingInfo().getDepositBank().trim());
        params.put("regBankAccount", malEcSubmitOrderParam.getMalInvoicingInfo().getBankAccount().trim());
        params.put("invoiceName", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("invoicePhone", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("invoiceAddress", mappingTownId);
        params.put("invoiceProvice", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("invoiceCity", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("invoiceCounty", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        params = this.beforeSubmitEcOrder(params, malEcSubmitOrderParam);
        log.info("\u751f\u6210\u82cf\u5b81\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570" + params);
        try {
            submitResult = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_SN_ORDER_addMixpayorder", params));
        }
        catch (KDBizException e) {
            if (StringUtils.isBlank((CharSequence)malEcSubmitOrderParam.getMalReceipt().getPostalCode())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u8d27\u5730\u5740\u7684\u90ae\u7f16\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalSnSubmitOrderServiceImpl_1", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            throw e;
        }
        MalEcSubmitOrderResult malEcSubmitOrderResult = this.parseResult(submitResult, malEcSubmitOrderParam);
        malEcSubmitOrderResult = this.afterSubmitEcOrder(malEcSubmitOrderResult, submitResult);
        log.info("\u8c03\u7528\u751f\u6210\u82cf\u5b81\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + submitResult);
        return malEcSubmitOrderResult;
    }

    private MalEcSubmitOrderResult parseResult(Map<String, Object> submitResult, MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Object taxAmount;
        MalEcSubmitOrderResult malEcSubmitOrderResult = new MalEcSubmitOrderResult();
        malEcSubmitOrderResult.setEcOrderId(String.valueOf(submitResult.get("orderId")));
        Map data = EcApiUtil.getSnOrderDetail((String)malEcSubmitOrderResult.getEcOrderId());
        Object freight = data.get("totalFreight");
        if (freight != null) {
            malEcSubmitOrderResult.setFreight(new BigDecimal(String.valueOf(freight)));
        }
        if ((taxAmount = data.get("orderAmt")) != null) {
            malEcSubmitOrderResult.setTaxAmount(new BigDecimal(String.valueOf(taxAmount)));
        }
        List orderItemList = (List)data.get("orderItemList");
        List ecSkus = (List)malEcSubmitOrderParam.getEcSkus();
        BigDecimal sumTax = BigDecimal.ZERO;
        for (Map orderItem : orderItemList) {
            String skuId = String.valueOf(orderItem.get("commdtyCode"));
            MalEcSubmitOrderResultSku malEcSubmitOrderResultSku = new MalEcSubmitOrderResultSku();
            for (MalSnSubmitOrderSku malSnSubmitOrderSku : ecSkus) {
                if (!StringUtils.equals((CharSequence)String.valueOf(malSnSubmitOrderSku.getSkuId()), (CharSequence)skuId)) continue;
                malEcSubmitOrderResultSku.setGoodsId(malSnSubmitOrderSku.getGoodsId());
            }
            malEcSubmitOrderResultSku.setQty(new BigDecimal(orderItem.get("skuNum").toString()));
            malEcSubmitOrderResultSku.setTaxPrice(new BigDecimal(orderItem.get("unitPrice").toString()));
            malEcSubmitOrderResultSku.setTaxRate(new BigDecimal(orderItem.get("taxRate").toString()));
            malEcSubmitOrderResultSku.setPrice(malEcSubmitOrderResultSku.getTaxPrice().divide(BigDecimal.ONE.add(malEcSubmitOrderResultSku.getTaxRate()), 2, RoundingMode.HALF_UP));
            malEcSubmitOrderResultSku.setTax(malEcSubmitOrderResultSku.getTaxPrice().subtract(malEcSubmitOrderResultSku.getPrice()));
            sumTax = sumTax.add(malEcSubmitOrderResultSku.getTax());
            malEcSubmitOrderResultSku.setTaxAmount(new BigDecimal(orderItem.get("skuAmt").toString()));
            malEcSubmitOrderResultSku.setSubOrderId(String.valueOf(orderItem.get("orderItemId")));
            malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList().add(malEcSubmitOrderResultSku);
        }
        malEcSubmitOrderResult.setTax(sumTax);
        malEcSubmitOrderResult.setAmount(malEcSubmitOrderResult.getTaxAmount().subtract(sumTax));
        malEcSubmitOrderResult.setInvoiceType(malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        return malEcSubmitOrderResult;
    }

    @Override
    public DynamicObject saveEcOrder(MalEcSubmitOrderResult malEcSubmitOrderResult) {
        DynamicObject snOrderDyn = CommonUtil.createDefaultDyn((String)"pbd_order_sn");
        snOrderDyn.set("porderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        snOrderDyn.set("orderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        snOrderDyn.set("ordernakedamount", (Object)malEcSubmitOrderResult.getAmount());
        snOrderDyn.set("ordertaxamount", (Object)malEcSubmitOrderResult.getTax());
        snOrderDyn.set("freight", (Object)malEcSubmitOrderResult.getFreight());
        snOrderDyn.set("orderamount", (Object)malEcSubmitOrderResult.getTaxAmount());
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            snOrderDyn.set("currency", (Object)currency);
        } else {
            snOrderDyn.set("currency", (Object)"1");
        }
        snOrderDyn.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        snOrderDyn.set("suborderstate", (Object)"1");
        snOrderDyn.set("orderstate", (Object)"1");
        snOrderDyn.set("invoicetype", (Object)malEcSubmitOrderResult.getInvoiceType());
        snOrderDyn.set("submitstate", (Object)"0");
        snOrderDyn.set("createtime", (Object)new Date());
        DynamicObjectCollection entryDyoCol = snOrderDyn.getDynamicObjectCollection("entryentity");
        for (MalEcSubmitOrderResultSku sku : malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)sku.getGoodsId());
            entryDyo.set("qty", (Object)sku.getQty());
            entryDyo.set("price", (Object)sku.getTaxPrice());
            entryDyo.set("taxrate", (Object)sku.getTaxRate());
            entryDyo.set("taxamount", (Object)sku.getTax());
            entryDyo.set("nakedamount", (Object)sku.getPrice());
        }
        DynamicObject[] sevedSnOrderDyns = (DynamicObject[])SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{snOrderDyn});
        return sevedSnOrderDyns[0];
    }

    @Override
    public String getOrderStatusFieldKey() {
        return "orderstate";
    }

    @Override
    Object prepareEcSkus(MalCacheGoodsInfo malCacheGoodsInfo, DynamicObject goodsEntryDyn) {
        if (malCacheGoodsInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalSnSubmitOrderServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
        }
        MalSnSubmitOrderSku malSnSubmitOrderSku = new MalSnSubmitOrderSku();
        malSnSubmitOrderSku.setGoodsId(goodsEntryDyn.getLong("goods_id"));
        malSnSubmitOrderSku.setSkuId(malCacheGoodsInfo.getProductNumber());
        malSnSubmitOrderSku.setNum(String.valueOf(goodsEntryDyn.getInt("qty")));
        malSnSubmitOrderSku.setUnitPrice(malCacheGoodsInfo.getTaxPrice());
        return malSnSubmitOrderSku;
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_SUNING.getVal();
    }
}

