/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.placeorder.entity.MalSurchargeInfo;
import kd.scm.mal.business.placeorder.entity.MalSurchargeParam;
import kd.scm.mal.business.placeorder.entity.MalSurchargeResult;
import kd.scm.mal.business.placeorder.service.MalSurchargeService;

public class MalSurchageServiceImpl
implements MalSurchargeService {
    private static final Log log = LogFactory.getLog(MalSurchageServiceImpl.class);

    @Override
    public MalSurchargeResult getMalSurcharge(MalSurchargeParam malSurchargeParam) {
        log.info("\u83b7\u53d6\u9644\u52a0\u8d39:" + malSurchargeParam);
        MalSurchargeResult res = new MalSurchargeResult();
        if (malSurchargeParam.getGoodsIdToQtyMap().isEmpty()) {
            return res;
        }
        int pricePrecision = this.getDefaultPricePrecision();
        HashMap goodsIdToSurchargeIdsMap = new HashMap(malSurchargeParam.getGoodsIdToQtyMap().size() << 2);
        String selectFields = "id,surchargeid,supplier.id";
        QFilter filter = new QFilter("id", "in", malSurchargeParam.getGoodsIdToQtyMap().keySet());
        HashSet allSurchargeIdSet = new HashSet(16);
        HashMap goodsIdToSupplierIdMap = new HashMap();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        Object object = null;
        try {
            dataSet.forEach(row -> {
                List surchargeIdList = goodsIdToSurchargeIdsMap.getOrDefault(row.getLong("id"), new ArrayList());
                String surchargeIds = row.getString("surchargeid");
                if (StringUtils.isNotBlank((CharSequence)surchargeIds)) {
                    for (String surchargeId : surchargeIds.split(",")) {
                        if (!StringUtils.isNotBlank((CharSequence)surchargeId)) continue;
                        surchargeIdList.add(Long.valueOf(surchargeId));
                    }
                }
                allSurchargeIdSet.addAll(surchargeIdList);
                goodsIdToSurchargeIdsMap.put(row.getLong("id"), surchargeIdList);
                res.getSupplierIdToExtAmountMap().put(row.getLong("supplier.id"), BigDecimal.ZERO);
                goodsIdToSupplierIdMap.put(row.getLong("id"), row.getLong("supplier.id"));
            });
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!allSurchargeIdSet.isEmpty()) {
            Map surchargeDynMap = BusinessDataServiceHelper.loadFromCache((Object[])allSurchargeIdSet.toArray(), (String)"ent_surcharge");
            for (Map.Entry entry : goodsIdToSurchargeIdsMap.entrySet()) {
                BigDecimal qty = malSurchargeParam.getGoodsIdToQtyMap().get(entry.getKey());
                if (qty == null) continue;
                MalSurchargeInfo malSurchargeInfo = new MalSurchargeInfo();
                for (Long surchargeId : (List)entry.getValue()) {
                    BigDecimal actualCost;
                    DynamicObject surchargeDyn = (DynamicObject)surchargeDynMap.get(surchargeId);
                    if (surchargeDyn == null) continue;
                    BigDecimal perCost = surchargeDyn.getBigDecimal("cost");
                    BigDecimal maxCost = surchargeDyn.getBigDecimal("maxcost");
                    if (qty.multiply(perCost).compareTo(maxCost) <= 0) {
                        actualCost = perCost.multiply(qty);
                        malSurchargeInfo.setPerAmount(perCost.add(malSurchargeInfo.getPerAmount()));
                    } else {
                        actualCost = maxCost;
                        malSurchargeInfo.setPerAmount(maxCost.divide(qty, RoundingMode.HALF_UP).setScale(pricePrecision, RoundingMode.HALF_UP));
                    }
                    malSurchargeInfo.setRowTotalExtAmount(actualCost.add(malSurchargeInfo.getRowTotalExtAmount()));
                    res.addGoodsIdToExtAmount((Long)entry.getKey(), malSurchargeInfo);
                    Long supplierId = (Long)goodsIdToSupplierIdMap.get(entry.getKey());
                    BigDecimal supExtAmount = res.getSupplierIdToExtAmountMap().getOrDefault(supplierId, BigDecimal.ZERO);
                    supExtAmount = supExtAmount.add(actualCost);
                    res.getSupplierIdToExtAmountMap().put(supplierId, supExtAmount);
                }
            }
        }
        log.info("\u83b7\u53d6\u8fd0\u8d39\u7ed3\u679c" + res);
        return res;
    }

    private int getDefaultPricePrecision() {
        DynamicObject currencyDyn;
        String defaultCurrency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isBlank((CharSequence)defaultCurrency)) {
            defaultCurrency = "1";
        }
        if ((currencyDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(defaultCurrency), (String)"bd_currency")) != null) {
            return currencyDyn.getInt("priceprecision");
        }
        return 6;
    }
}

