/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderParam;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResult;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResultSku;
import kd.scm.mal.business.placeorder.entity.MalXfsSubmitOrderSku;
import kd.scm.mal.business.placeorder.service.impl.MalGenericEcSubmitOrderServiceImpl;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import kd.scm.malcore.cache.CacheKeyHelper;
import kd.scm.malcore.cache.MalObjectCache;
import net.sf.json.JSONArray;

public class MalXfsSubmitOrderServiceImpl
extends MalGenericEcSubmitOrderServiceImpl {
    private static final Log log = LogFactory.getLog(MalXfsSubmitOrderServiceImpl.class);

    @Override
    public MalEcSubmitOrderResult submitEcOrder(MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Map<String, Object> params = new HashMap<String, Object>(32);
        params.put("projectId", "");
        params.put("thirdOrder", malEcSubmitOrderParam.getThirdOrder());
        params.put("amount", malEcSubmitOrderParam.getSumTaxAmount());
        params.put("servFee", malEcSubmitOrderParam.getFreight());
        JSONArray skus = JSONArray.fromObject((Object)malEcSubmitOrderParam.getEcSkus());
        for (int i = 0; i < skus.size(); ++i) {
            skus.getJSONObject(i).remove("goodsId");
        }
        params.put("sku", skus);
        params.put("receiverName", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("receiverCompany", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle().trim());
        params.put("provinceId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("cityId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("countyId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        params.put("townId", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingTownId());
        params.put("address", malEcSubmitOrderParam.getMalReceipt().toString());
        params.put("chnCustomerName", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle().trim());
        params.put("mobile", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("remark", malEcSubmitOrderParam.getRemark());
        params = this.beforeSubmitEcOrder(params, malEcSubmitOrderParam);
        log.info("\u751f\u6210\u946b\u65b9\u76db\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570" + params);
        Map submitResult = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_XFS_ORDER_submitPreOrder", params));
        MalEcSubmitOrderResult malEcSubmitOrderResult = this.parseResult(submitResult, malEcSubmitOrderParam);
        malEcSubmitOrderResult = this.afterSubmitEcOrder(malEcSubmitOrderResult, submitResult);
        log.info("\u8c03\u7528\u751f\u6210\u946b\u65b9\u76db\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + submitResult);
        return malEcSubmitOrderResult;
    }

    private MalEcSubmitOrderResult parseResult(Map<String, Object> submitResult, MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Object freight;
        MalEcSubmitOrderResult malEcSubmitOrderResult = new MalEcSubmitOrderResult();
        malEcSubmitOrderResult.setEcOrderId(String.valueOf(submitResult.get("orderNo")));
        Map orderDetail = (Map)EcGroupApiUtil.getEcOrderDetail((String)malEcSubmitOrderResult.getEcOrderId(), (String)EcPlatformEnum.ECPLATFORM_XFS.getVal()).get(EcPlatformEnum.ECPLATFORM_XFS.getVal());
        Object orderPrice = orderDetail.get("orderAmount");
        if (orderPrice != null) {
            malEcSubmitOrderResult.setTaxAmount(new BigDecimal(String.valueOf(orderPrice)));
        }
        if ((freight = orderDetail.get("freight")) != null) {
            malEcSubmitOrderResult.setFreight(new BigDecimal(String.valueOf(freight)));
        }
        List bizSkus = (List)orderDetail.get("skuInfos");
        MalObjectCache malObjectCache = MalObjectCache.get(MalCacheGoodsInfo.class);
        for (Map bizSku : bizSkus) {
            MalCacheGoodsInfo cacheGoodsInfo;
            Object price;
            MalEcSubmitOrderResultSku malEcSubmitOrderResultSku = new MalEcSubmitOrderResultSku();
            List ecSkus = (List)malEcSubmitOrderParam.getEcSkus();
            for (MalXfsSubmitOrderSku malXfsSubmitOrderSku : ecSkus) {
                if (!StringUtils.equals((CharSequence)String.valueOf(malXfsSubmitOrderSku.getSkuNo()), (CharSequence)String.valueOf(bizSku.get("skuNo")))) continue;
                malEcSubmitOrderResultSku.setGoodsId(malXfsSubmitOrderSku.getGoodsId());
            }
            Object num = bizSku.get("buyNum");
            if (num != null) {
                malEcSubmitOrderResultSku.setQty(new BigDecimal(String.valueOf(num)));
            }
            if ((price = bizSku.get("settlePrice")) != null) {
                malEcSubmitOrderResultSku.setTaxPrice(new BigDecimal(String.valueOf(price)));
            }
            if ((cacheGoodsInfo = (MalCacheGoodsInfo)malObjectCache.get(CacheKeyHelper.keyForTrace((String)String.valueOf(malEcSubmitOrderResultSku.getGoodsId())))) != null) {
                malEcSubmitOrderResultSku.setEcPrice(cacheGoodsInfo.getEcPrice());
            }
            malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList().add(malEcSubmitOrderResultSku);
        }
        return malEcSubmitOrderResult;
    }

    @Override
    public DynamicObject saveEcOrder(MalEcSubmitOrderResult malEcSubmitOrderResult) {
        DynamicObject ecOrderDyn = CommonUtil.createDefaultDyn((String)"pbd_order_xfs");
        ecOrderDyn.set("porderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("orderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("ordernakedamount", (Object)malEcSubmitOrderResult.getAmount());
        ecOrderDyn.set("ordertaxamount", (Object)malEcSubmitOrderResult.getTax());
        ecOrderDyn.set("freight", (Object)malEcSubmitOrderResult.getFreight());
        ecOrderDyn.set("orderamount", (Object)malEcSubmitOrderResult.getTaxAmount());
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            ecOrderDyn.set("currency", (Object)currency);
        } else {
            ecOrderDyn.set("currency", (Object)"1");
        }
        ecOrderDyn.set("invoicetype", (Object)malEcSubmitOrderResult.getInvoiceType());
        ecOrderDyn.set("createtime", (Object)new Date());
        DynamicObjectCollection entryDyoCol = ecOrderDyn.getDynamicObjectCollection("entryentity");
        for (MalEcSubmitOrderResultSku sku : malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)sku.getGoodsId());
            entryDyo.set("qty", (Object)sku.getQty());
            entryDyo.set("price", (Object)sku.getTaxPrice());
            entryDyo.set("taxrate", (Object)sku.getTaxRate());
            entryDyo.set("taxamount", (Object)sku.getTax());
            entryDyo.set("nakedamount", (Object)sku.getPrice());
        }
        DynamicObject[] sevedSnOrderDyns = (DynamicObject[])SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{ecOrderDyn});
        return sevedSnOrderDyns[0];
    }

    @Override
    public String getOrderStatusFieldKey() {
        return "state";
    }

    @Override
    public Object prepareEcSkus(MalCacheGoodsInfo malCacheGoodsInfo, DynamicObject goodsEntryDyn) {
        if (malCacheGoodsInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalXfsSubmitOrderServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
        }
        MalXfsSubmitOrderSku malXfsSubmitOrderSku = new MalXfsSubmitOrderSku();
        malXfsSubmitOrderSku.setGoodsId(goodsEntryDyn.getLong("goods_id"));
        malXfsSubmitOrderSku.setSkuNo(malCacheGoodsInfo.getProductNumber());
        malXfsSubmitOrderSku.setBuyNum(goodsEntryDyn.getInt("qty"));
        malXfsSubmitOrderSku.setSettlePrice(malCacheGoodsInfo.getTaxPrice());
        return malXfsSubmitOrderSku;
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_XFS.getVal();
    }
}

