/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderParam;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResult;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResultSku;
import kd.scm.mal.business.placeorder.entity.MalXySubmitOrderSku;
import kd.scm.mal.business.placeorder.service.impl.MalGenericEcSubmitOrderServiceImpl;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import kd.scm.malcore.cache.CacheKeyHelper;
import kd.scm.malcore.cache.MalObjectCache;
import net.sf.json.JSONArray;

public class MalXySubmitOrderServiceImpl
extends MalGenericEcSubmitOrderServiceImpl {
    private static final Log log = LogFactory.getLog(MalXySubmitOrderServiceImpl.class);

    @Override
    public MalEcSubmitOrderResult submitEcOrder(MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Map<String, Object> params = new HashMap<String, Object>(32);
        params.put("thirdOrder", malEcSubmitOrderParam.getThirdOrder());
        params.put("orderCompany", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle());
        JSONArray skus = JSONArray.fromObject((Object)malEcSubmitOrderParam.getEcSkus());
        for (int i = 0; i < skus.size(); ++i) {
            skus.getJSONObject(i).remove("goodsId");
        }
        params.put("sku", skus);
        params.put("name", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("province", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("city", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("county", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        params.put("town", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingTownId());
        params.put("address", malEcSubmitOrderParam.getMalReceipt().toString());
        params.put("mobile", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("email", malEcSubmitOrderParam.getMalReceipt().getEmail());
        params.put("zip", malEcSubmitOrderParam.getMalReceipt().getPostalCode());
        params.put("remark", malEcSubmitOrderParam.getRemark());
        params.put("logisticalRemark", "");
        params.put("promiseDate", "1");
        params.put("invoiceState", "2");
        params.put("invoiceType", malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        params.put("companyName", malEcSubmitOrderParam.getMalInvoicingInfo().getTitle());
        params.put("receiptCompanyTel", malEcSubmitOrderParam.getMalInvoicingInfo().getPhone());
        params.put("receiptCompanyAddr", malEcSubmitOrderParam.getMalInvoicingInfo().getAddress());
        params.put("receiptTaxNo", malEcSubmitOrderParam.getMalInvoicingInfo().getTaxRegNum().trim());
        params.put("receiptBankName", malEcSubmitOrderParam.getMalInvoicingInfo().getDepositBank().trim());
        params.put("receiptAccount", malEcSubmitOrderParam.getMalInvoicingInfo().getBankAccount().trim());
        params.put("invoiceName", malEcSubmitOrderParam.getMalReceipt().getReceiptName());
        params.put("invoicePhone", malEcSubmitOrderParam.getMalReceipt().getPhone());
        params.put("invoiceProvice", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingProvinceId());
        params.put("invoiceCity", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCityId());
        params.put("invoiceCounty", malEcSubmitOrderParam.getMalEcAddressMapping().getMappingCountyId());
        params.put("invoiceAddress", malEcSubmitOrderParam.getMalReceipt().toString());
        params.put("purchaseId", "");
        params.put("purchaseName", "");
        params.put("purchaseAccount", "");
        params.put("purchaseMobile", "");
        params = this.beforeSubmitEcOrder(params, malEcSubmitOrderParam);
        log.info("\u751f\u6210\u897f\u57df\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570" + params);
        Map submitResult = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)JdApiParser.getJdApiNumber((String)EcPlatformEnum.ECPLATFORM_XY.getVal(), (String)"SRM_XY_ORDER_submitOrder"), params));
        MalEcSubmitOrderResult malEcSubmitOrderResult = this.parseResult(submitResult, malEcSubmitOrderParam);
        malEcSubmitOrderResult = this.afterSubmitEcOrder(malEcSubmitOrderResult, submitResult);
        log.info("\u8c03\u7528\u751f\u6210\u897f\u57df\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + submitResult);
        return malEcSubmitOrderResult;
    }

    private MalEcSubmitOrderResult parseResult(Map<String, Object> submitResult, MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Object orderTaxPrice;
        Object freight;
        Object orderPrice;
        MalEcSubmitOrderResult malEcSubmitOrderResult = new MalEcSubmitOrderResult();
        String orderId = String.valueOf(submitResult.get("orderId"));
        malEcSubmitOrderResult.setEcOrderId(orderId);
        Map orderDetail = EcApiUtil.getXyOrderDetail((String)orderId);
        Object orderNakedPrice = orderDetail.get("orderNakedPrice");
        if (orderNakedPrice != null) {
            malEcSubmitOrderResult.setAmount(new BigDecimal(String.valueOf(orderNakedPrice)));
        }
        if ((orderPrice = orderDetail.get("orderPrice")) != null) {
            malEcSubmitOrderResult.setTaxAmount(new BigDecimal(String.valueOf(orderPrice)));
        }
        if ((freight = orderDetail.get("freight")) != null) {
            malEcSubmitOrderResult.setFreight(new BigDecimal(String.valueOf(freight)));
        }
        if ((orderTaxPrice = orderDetail.get("orderTaxPrice")) != null) {
            malEcSubmitOrderResult.setTax(new BigDecimal(String.valueOf(orderTaxPrice)));
        }
        malEcSubmitOrderResult.setInvoiceType(malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        List bizSkus = (List)submitResult.get("sku");
        MalObjectCache malObjectCache = MalObjectCache.get(MalCacheGoodsInfo.class);
        for (Map bizSku : bizSkus) {
            MalCacheGoodsInfo cacheGoodsInfo;
            Object taxRate;
            Object nakedPrice;
            Object taxPrice;
            Object price;
            MalEcSubmitOrderResultSku malEcSubmitOrderResultSku = new MalEcSubmitOrderResultSku();
            List ecSkus = (List)malEcSubmitOrderParam.getEcSkus();
            for (MalXySubmitOrderSku malXySubmitOrderSku : ecSkus) {
                if (!StringUtils.equals((CharSequence)String.valueOf(malXySubmitOrderSku.getSkuId()), (CharSequence)String.valueOf(bizSku.get("skuId")))) continue;
                malEcSubmitOrderResultSku.setGoodsId(malXySubmitOrderSku.getGoodsId());
            }
            Object num = bizSku.get("num");
            if (num != null) {
                malEcSubmitOrderResultSku.setQty(new BigDecimal(String.valueOf(num)));
            }
            if ((price = bizSku.get("price")) != null) {
                malEcSubmitOrderResultSku.setTaxPrice(new BigDecimal(String.valueOf(price)));
            }
            if ((taxPrice = bizSku.get("taxPrice")) != null) {
                malEcSubmitOrderResultSku.setTax(new BigDecimal(String.valueOf(taxPrice)));
            }
            if ((nakedPrice = bizSku.get("nakedPrice")) != null) {
                malEcSubmitOrderResultSku.setPrice(new BigDecimal(String.valueOf(nakedPrice)));
            }
            if ((taxRate = bizSku.get("tax")) != null) {
                malEcSubmitOrderResultSku.setTaxRate(new BigDecimal(String.valueOf(taxRate)));
            }
            if ((cacheGoodsInfo = (MalCacheGoodsInfo)malObjectCache.get(CacheKeyHelper.keyForTrace((String)String.valueOf(malEcSubmitOrderResultSku.getGoodsId())))) != null) {
                malEcSubmitOrderResultSku.setEcPrice(cacheGoodsInfo.getEcPrice());
            }
            malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList().add(malEcSubmitOrderResultSku);
        }
        return malEcSubmitOrderResult;
    }

    @Override
    Object prepareEcSkus(MalCacheGoodsInfo malCacheGoodsInfo, DynamicObject goodsEntryDyn) {
        MalXySubmitOrderSku malXySubmitOrderSku = new MalXySubmitOrderSku();
        if (malCacheGoodsInfo != null) {
            malXySubmitOrderSku.setSkuId(malCacheGoodsInfo.getProductNumber());
        }
        malXySubmitOrderSku.setNum(goodsEntryDyn.getInt("qty"));
        malXySubmitOrderSku.setGoodsId(goodsEntryDyn.getLong("goods_id"));
        malXySubmitOrderSku.setPrice(goodsEntryDyn.getBigDecimal("taxprice"));
        return malXySubmitOrderSku;
    }

    @Override
    public DynamicObject saveEcOrder(MalEcSubmitOrderResult malEcSubmitOrderResult) {
        DynamicObject ecOrderDyn = CommonUtil.createDefaultDyn((String)"pbd_order_xy");
        ecOrderDyn.set("porderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("orderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("ordernakedamount", (Object)malEcSubmitOrderResult.getAmount());
        ecOrderDyn.set("ordertaxamount", (Object)malEcSubmitOrderResult.getTax());
        ecOrderDyn.set("freight", (Object)malEcSubmitOrderResult.getFreight());
        ecOrderDyn.set("orderamount", (Object)malEcSubmitOrderResult.getTaxAmount());
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            ecOrderDyn.set("currency", (Object)currency);
        } else {
            ecOrderDyn.set("currency", (Object)"1");
        }
        ecOrderDyn.set("invoicetype", (Object)malEcSubmitOrderResult.getInvoiceType());
        ecOrderDyn.set("createtime", (Object)new Date());
        DynamicObjectCollection entryDyoCol = ecOrderDyn.getDynamicObjectCollection("entryentity");
        for (MalEcSubmitOrderResultSku sku : malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)sku.getGoodsId());
            entryDyo.set("qty", (Object)sku.getQty());
            entryDyo.set("price", (Object)sku.getTaxPrice());
            entryDyo.set("taxrate", (Object)sku.getTaxRate());
            entryDyo.set("taxamount", (Object)sku.getTax());
            entryDyo.set("nakedamount", (Object)sku.getPrice());
        }
        DynamicObject[] sevedSnOrderDyns = (DynamicObject[])SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{ecOrderDyn});
        return sevedSnOrderDyns[0];
    }

    @Override
    public String getOrderStatusFieldKey() {
        return "orderstate";
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_XY.getVal();
    }
}

