/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderParam;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResult;
import kd.scm.mal.business.placeorder.entity.MalEcSubmitOrderResultSku;
import kd.scm.mal.business.placeorder.entity.MalInvoicingInfo;
import kd.scm.mal.business.placeorder.entity.MalReqPerson;
import kd.scm.mal.business.placeorder.entity.MalZkhSubmitOrderSku;
import kd.scm.mal.business.placeorder.service.impl.MalGenericEcSubmitOrderServiceImpl;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.common.constant.MalPlaceOrderConstant;
import kd.scm.mal.domain.model.goods.MalCacheGoodsInfo;
import kd.scm.malcore.cache.CacheKeyHelper;
import kd.scm.malcore.cache.MalObjectCache;

public class MalZkhSubmitOrderServiceImpl
extends MalGenericEcSubmitOrderServiceImpl {
    private static final Log log = LogFactory.getLog(MalZkhSubmitOrderServiceImpl.class);

    @Override
    public Object prepareEcSkus(MalCacheGoodsInfo malCacheGoodsInfo, DynamicObject goodsEntryDyn) {
        if (malCacheGoodsInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalZkhSubmitOrderServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
        }
        MalZkhSubmitOrderSku malZkhSubmitOrderSku = new MalZkhSubmitOrderSku();
        malZkhSubmitOrderSku.setGoodsId(goodsEntryDyn.getLong("goods_id"));
        malZkhSubmitOrderSku.setSkuId(malCacheGoodsInfo.getProductNumber());
        malZkhSubmitOrderSku.setNum(goodsEntryDyn.getInt("qty"));
        malZkhSubmitOrderSku.setPrice(malCacheGoodsInfo.getTaxPrice());
        malZkhSubmitOrderSku.setNakedPrice(malCacheGoodsInfo.getPrice());
        return malZkhSubmitOrderSku;
    }

    @Override
    public MalEcSubmitOrderParam prepareSubmitOrderParam(DynamicObject malOrderDyn) {
        MalEcSubmitOrderParam malEcSubmitOrderParam = super.prepareSubmitOrderParam(malOrderDyn);
        MalInvoicingInfo malInvoicingInfo = malEcSubmitOrderParam.getMalInvoicingInfo();
        if (malInvoicingInfo == null || StringUtils.isBlank((CharSequence)malInvoicingInfo.getTitle())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5546\u57ce\uff1a\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalZkhSubmitOrderServiceImpl_6", (String)"scm-mal-business", (Object[])new Object[0]));
        }
        if ("2".equals(malInvoicingInfo.getInvoiceType())) {
            if (StringUtils.isBlank((CharSequence)malInvoicingInfo.getTaxRegNum())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5546\u57ce\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalZkhSubmitOrderServiceImpl_7", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)malInvoicingInfo.getDepositBank())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5546\u57ce\uff1a\u5f00\u6237\u94f6\u2f8f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalZkhSubmitOrderServiceImpl_8", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)malInvoicingInfo.getBankAccount())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5546\u57ce\uff1a\u94f6\u2f8f\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalZkhSubmitOrderServiceImpl_9", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)malInvoicingInfo.getPhone())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5546\u57ce\uff1a\u516c\u53f8\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalZkhSubmitOrderServiceImpl_10", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)malInvoicingInfo.getAddress())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5546\u57ce\uff1a\u516c\u53f8\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalZkhSubmitOrderServiceImpl_11", (String)"scm-mal-business", (Object[])new Object[0]));
            }
        }
        return malEcSubmitOrderParam;
    }

    @Override
    public MalEcSubmitOrderResult submitEcOrder(MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Map<String, Object> params = new HashMap<String, Object>(32);
        params.put("thirdOrder", malEcSubmitOrderParam.getThirdOrder());
        List ecSkus = (List)malEcSubmitOrderParam.getEcSkus();
        ArrayList skuInfos = new ArrayList(ecSkus.size());
        for (MalZkhSubmitOrderSku sku : ecSkus) {
            HashMap<String, Object> skuInfo = new HashMap<String, Object>();
            skuInfo.put("skuId", sku.getSkuId());
            skuInfo.put("num", sku.getNum());
            skuInfo.put("price", sku.getPrice());
            skuInfo.put("nakedPrice", sku.getNakedPrice());
            skuInfos.add(skuInfo);
        }
        params.put("sku", skuInfos);
        MalInvoicingInfo malInvoicingInfo = malEcSubmitOrderParam.getMalInvoicingInfo();
        HashMap<String, String> invoiceInfo = new HashMap<String, String>(16);
        invoiceInfo.put("type", malInvoicingInfo.getInvoiceType());
        invoiceInfo.put("title", malInvoicingInfo.getTitle());
        invoiceInfo.put("content", ResManager.loadKDString((String)"\u660e\u7ec6", (String)"MalZkhSubmitOrderServiceImpl_1", (String)"scm-mal-business", (Object[])new Object[0]));
        invoiceInfo.put("enterpriseTaxpayer", malInvoicingInfo.getTaxRegNum());
        invoiceInfo.put("bank", malInvoicingInfo.getDepositBank());
        invoiceInfo.put("account", malInvoicingInfo.getBankAccount());
        invoiceInfo.put("tel", malInvoicingInfo.getPhone());
        invoiceInfo.put("address", malInvoicingInfo.getAddress());
        params.put("invoiceInfo", invoiceInfo);
        MalReqPerson malReqPerson = malEcSubmitOrderParam.getMalReqPerson();
        params.put("purchaseAccount", malReqPerson.getName());
        params.put("purchaseMobile", malReqPerson.getPhone());
        MalReceipt malReceipt = malEcSubmitOrderParam.getMalReceipt();
        params.put("name", malReceipt.getReceiptName());
        String wholeAddress = malReceipt.getWholeAddress();
        params.put("address", wholeAddress);
        params.put("mobile", malReceipt.getPhone());
        String[] addr = this.specialAddressDeal(wholeAddress);
        HashMap<String, String> region = new HashMap<String, String>(8);
        int size = addr.length;
        region.put("province", addr[MalPlaceOrderConstant.PROVINCE_INDEX]);
        region.put("city", addr[MalPlaceOrderConstant.CITY_INDEX]);
        region.put("county", addr[MalPlaceOrderConstant.COUNTY_INDEX]);
        String address = addr[0] + addr[1] + addr[2] + addr[3];
        if (size > 4) {
            region.put("town", addr[MalPlaceOrderConstant.TOWN_INDEX]);
            address = address + addr[4];
        }
        params.put("region", region);
        params.put("remark", malEcSubmitOrderParam.getRemark());
        params.put("invoiceName", malReqPerson.getName());
        params.put("invoicePhone", malReqPerson.getPhone());
        params.put("invoiceAddress", address);
        params = this.beforeSubmitEcOrder(params, malEcSubmitOrderParam);
        log.info("\u751f\u6210\u9707\u5764\u884c\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570\uff1a" + params);
        Map submitResult = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_ZKH_ORDER_submitOrder", params));
        MalEcSubmitOrderResult malEcSubmitOrderResult = this.parseResult(submitResult, malEcSubmitOrderParam);
        malEcSubmitOrderResult = this.afterSubmitEcOrder(malEcSubmitOrderResult, submitResult);
        log.info("\u8c03\u7528\u751f\u6210\u9707\u5764\u884c\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + submitResult);
        return malEcSubmitOrderResult;
    }

    private String[] specialAddressDeal(String wholeAddress) {
        String[] addr = wholeAddress.split("_");
        String beijing = ResManager.loadKDString((String)"\u5317\u4eac", (String)"MalZkhSubmitOrderServiceImpl_2", (String)"scm-mal-business", (Object[])new Object[0]);
        String tianjin = ResManager.loadKDString((String)"\u5929\u6d25", (String)"MalZkhSubmitOrderServiceImpl_3", (String)"scm-mal-business", (Object[])new Object[0]);
        String shanghai = ResManager.loadKDString((String)"\u4e0a\u6d77", (String)"MalZkhSubmitOrderServiceImpl_4", (String)"scm-mal-business", (Object[])new Object[0]);
        String chongqing = ResManager.loadKDString((String)"\u91cd\u5e86", (String)"MalZkhSubmitOrderServiceImpl_5", (String)"scm-mal-business", (Object[])new Object[0]);
        if (addr[0].contains(beijing)) {
            addr = this.addrLoopDeal(addr, beijing);
        } else if (addr[0].contains(tianjin)) {
            addr = this.addrLoopDeal(addr, tianjin);
        } else if (addr[0].contains(shanghai)) {
            addr = this.addrLoopDeal(addr, shanghai);
        } else if (addr[0].contains(chongqing)) {
            addr = this.addrLoopDeal(addr, chongqing);
        }
        return addr;
    }

    private String[] addrLoopDeal(String[] addr, String address) {
        String[] newAddr = new String[addr.length + 1];
        newAddr[0] = address;
        for (int i = 0; i < addr.length; ++i) {
            newAddr[i + 1] = addr[i];
        }
        return newAddr;
    }

    private MalEcSubmitOrderResult parseResult(Map<String, Object> submitResult, MalEcSubmitOrderParam malEcSubmitOrderParam) {
        Object orderState;
        Object orderTaxPrice;
        Object freight;
        Object orderNakedPrice;
        MalEcSubmitOrderResult malEcSubmitOrderResult = new MalEcSubmitOrderResult();
        malEcSubmitOrderResult.setEcOrderId(String.valueOf(submitResult.get("orderId")));
        Map orderDetail = (Map)EcGroupApiUtil.getEcOrderDetail((String)malEcSubmitOrderResult.getEcOrderId(), (String)EcPlatformEnum.ECPLATFORM_ZKH.getVal()).get(EcPlatformEnum.ECPLATFORM_ZKH.getVal());
        Object orderPrice = orderDetail.get("orderPrice");
        if (orderPrice != null) {
            malEcSubmitOrderResult.setTaxAmount(new BigDecimal(String.valueOf(orderPrice)));
        }
        if ((orderNakedPrice = orderDetail.get("orderNakedPrice")) != null) {
            malEcSubmitOrderResult.setAmount(new BigDecimal(String.valueOf(orderNakedPrice)));
        }
        if ((freight = orderDetail.get("freight")) != null) {
            malEcSubmitOrderResult.setFreight(new BigDecimal(String.valueOf(freight)));
        }
        if ((orderTaxPrice = orderDetail.get("orderTaxPrice")) != null) {
            malEcSubmitOrderResult.setTax(new BigDecimal(String.valueOf(orderTaxPrice)));
        }
        if ((orderState = orderDetail.get("orderState")) != null) {
            malEcSubmitOrderResult.setOrderStatus(String.valueOf(orderState));
        }
        List bizSkus = (List)orderDetail.get("sku");
        MalObjectCache malObjectCache = MalObjectCache.get(MalCacheGoodsInfo.class);
        for (Map bizSku : bizSkus) {
            MalCacheGoodsInfo cacheGoodsInfo;
            Object price;
            MalEcSubmitOrderResultSku malEcSubmitOrderResultSku = new MalEcSubmitOrderResultSku();
            List ecSkus = (List)malEcSubmitOrderParam.getEcSkus();
            for (MalZkhSubmitOrderSku malZkhSubmitOrderSku : ecSkus) {
                if (!StringUtils.equals((CharSequence)String.valueOf(malZkhSubmitOrderSku.getSkuId()), (CharSequence)String.valueOf(bizSku.get("skuId")))) continue;
                malEcSubmitOrderResultSku.setGoodsId(malZkhSubmitOrderSku.getGoodsId());
            }
            Object num = bizSku.get("num");
            if (num != null) {
                malEcSubmitOrderResultSku.setQty(new BigDecimal(String.valueOf(num)));
            }
            if ((price = bizSku.get("price")) != null) {
                malEcSubmitOrderResultSku.setTaxPrice(new BigDecimal(String.valueOf(price)));
            }
            Object tax = bizSku.get("tax");
            if (price != null) {
                malEcSubmitOrderResultSku.setTaxRate(new BigDecimal(String.valueOf(tax)));
            }
            Object nakedPrice = bizSku.get("nakedPrice");
            if (price != null && nakedPrice != null) {
                malEcSubmitOrderResultSku.setTax(new BigDecimal(String.valueOf(price)).subtract(new BigDecimal(String.valueOf(nakedPrice))));
            }
            if ((cacheGoodsInfo = (MalCacheGoodsInfo)malObjectCache.get(CacheKeyHelper.keyForTrace((String)String.valueOf(malEcSubmitOrderResultSku.getGoodsId())))) != null) {
                malEcSubmitOrderResultSku.setEcPrice(cacheGoodsInfo.getEcPrice());
            }
            malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList().add(malEcSubmitOrderResultSku);
            malEcSubmitOrderResult.setInvoiceType(malEcSubmitOrderParam.getMalInvoicingInfo().getInvoiceType());
        }
        return malEcSubmitOrderResult;
    }

    @Override
    public DynamicObject saveEcOrder(MalEcSubmitOrderResult malEcSubmitOrderResult) {
        DynamicObject ecOrderDyn = CommonUtil.createDefaultDyn((String)"pbd_order_zkh");
        ecOrderDyn.set("porderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("orderid", (Object)malEcSubmitOrderResult.getEcOrderId());
        ecOrderDyn.set("ordernakedamount", (Object)malEcSubmitOrderResult.getAmount());
        ecOrderDyn.set("ordertaxamount", (Object)malEcSubmitOrderResult.getTax());
        ecOrderDyn.set("freight", (Object)malEcSubmitOrderResult.getFreight());
        ecOrderDyn.set("orderamount", (Object)malEcSubmitOrderResult.getTaxAmount());
        ecOrderDyn.set("state", (Object)"0");
        ecOrderDyn.set("submitstate", (Object)"0");
        ecOrderDyn.set("orderstate", (Object)"1");
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            ecOrderDyn.set("currency", (Object)currency);
        } else {
            ecOrderDyn.set("currency", (Object)"1");
        }
        ecOrderDyn.set("invoicetype", (Object)malEcSubmitOrderResult.getInvoiceType());
        ecOrderDyn.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        ecOrderDyn.set("createtime", (Object)new Date());
        DynamicObjectCollection entryDyoCol = ecOrderDyn.getDynamicObjectCollection("entryentity");
        for (MalEcSubmitOrderResultSku sku : malEcSubmitOrderResult.getMalEcSubmitOrderResultSkuList()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)sku.getGoodsId());
            entryDyo.set("qty", (Object)sku.getQty());
            entryDyo.set("price", (Object)sku.getTaxPrice());
            entryDyo.set("taxrate", (Object)sku.getTaxRate());
            entryDyo.set("taxamount", (Object)sku.getTax());
            entryDyo.set("nakedamount", (Object)sku.getPrice());
        }
        DynamicObject[] sevedSnOrderDyns = (DynamicObject[])SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{ecOrderDyn});
        return sevedSnOrderDyns[0];
    }

    @Override
    public String getOrderStatusFieldKey() {
        return "state";
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_ZKH.getVal();
    }
}

