/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.product.service.impl;

import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.business.product.service.impl.MalEcGroupProductServiceImpl;
import kd.scm.mal.business.product.service.impl.MalXyProductServiceImpl;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalPrice;
import kd.scm.mal.domain.model.goods.MalStock;

public class MalCgProductServiceImpl
implements MalProductService {
    private static final Log log = LogFactory.getLog((String)MalXyProductServiceImpl.class.getName());
    MalEcGroupProductServiceImpl malEcGroupProductService = new MalEcGroupProductServiceImpl();

    @Override
    public Map<Long, MalGoodsInfo> getMalGoodsInfos(List<MalMatGoodsInitParam> malMatGoodsInitParams, boolean initStock, boolean isDetail) {
        Map<Long, MalGoodsInfo> malGoodsInfos = this.malEcGroupProductService.getMalGoodsInfos(malMatGoodsInitParams, initStock, isDetail);
        StringBuilder errorInfos = new StringBuilder();
        for (MalGoodsInfo malGoodsInfo : malGoodsInfos.values()) {
            try {
                if (!isDetail) continue;
                malGoodsInfo.setGuarantee(this.getGurantee(malGoodsInfo));
            }
            catch (Exception e) {
                errorInfos.append(ExceptionUtil.getStackTrace((Throwable)e)).append(System.lineSeparator());
            }
        }
        if (errorInfos.length() > 0) {
            log.error(errorInfos.toString());
        }
        return malGoodsInfos;
    }

    @Override
    public Map<Long, MalPrice> getMalPrices(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return this.malEcGroupProductService.getMalPrices(malMatGoodsInitParams);
    }

    @Override
    public Map<Long, MalStock> getMalStocks(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return this.malEcGroupProductService.getMalStocks(malMatGoodsInitParams);
    }

    private String getGurantee(MalGoodsInfo malGoodsInfo) {
        String shouhou = "<div>\u5177\u4f53\u552e\u540e\u4fe1\u606f\u89c1\u6668\u5149\u5546\u54c1\u9875\u9762</div><div><a  href=\"http://www.colipu.com/itemcode-";
        return shouhou + malGoodsInfo.getProductNumber() + ".html\" target=\"_blank\" >" + malGoodsInfo.getProductName() + "</a></div>";
    }

    @Override
    public String getEcSyncServiceFlowNumber() {
        return "SRM_CG_GOODS_INIT_SUB";
    }
}

