/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.product.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.entity.SkuGoodsInfo;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.enums.MalNoReasonToReturnEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.business.product.service.impl.MalEcGroupProductServiceImpl;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalPrice;
import kd.scm.mal.domain.model.goods.MalSimilarGoods;
import kd.scm.mal.domain.model.goods.MalStock;

public class MalJdProductServiceImpl
implements MalProductService {
    private static final String SPLIT = "_";
    private static final Log log = LogFactory.getLog((String)MalJdProductServiceImpl.class.getName());
    MalEcGroupProductServiceImpl malEcGroupProductService = new MalEcGroupProductServiceImpl();

    @Override
    public Map<Long, MalGoodsInfo> getMalGoodsInfos(List<MalMatGoodsInitParam> malMatGoodsInitParams, boolean initStock, boolean isDetail) {
        Map<Long, MalGoodsInfo> malGoodsInfos = this.malEcGroupProductService.getMalGoodsInfos(malMatGoodsInitParams, initStock, isDetail);
        StringBuilder errorInfos = new StringBuilder();
        for (MalGoodsInfo malGoodsInfo : malGoodsInfos.values()) {
            try {
                if (!isDetail) continue;
                malGoodsInfo.setGuarantee(this.getGurantee(malGoodsInfo));
                malGoodsInfo.setPromiseTips(this.getPromiseTips(malGoodsInfo));
                malGoodsInfo.setNoReasonToReturnText(this.getNoReasonToReturnText(malGoodsInfo));
            }
            catch (Exception e) {
                errorInfos.append(ExceptionUtil.getStackTrace((Throwable)e)).append(System.lineSeparator());
            }
        }
        if (errorInfos.length() > 0) {
            log.error(errorInfos.toString());
        }
        return malGoodsInfos;
    }

    @Override
    public List<MalSimilarGoods> getMalSimilarGoodsList(MalGoodsInfo malGoodsInfo) {
        if (ObjectUtils.isEmpty(malGoodsInfo.getMalSimilarGoodsList())) {
            ArrayList<MalSimilarGoods> malSimilarGoodsList = new ArrayList<MalSimilarGoods>();
            List skuGoodsInfos = EcApiUtil.getJdSimilarSku((String)malGoodsInfo.getProductNumber(), (String)malGoodsInfo.getProductSource());
            skuGoodsInfos.forEach(skuGoodsInfo -> malSimilarGoodsList.add(new MalSimilarGoods(malGoodsInfo.getProductNumber(), (SkuGoodsInfo)skuGoodsInfo)));
            malGoodsInfo.setMalSimilarGoodsList(malSimilarGoodsList);
        }
        return malGoodsInfo.getMalSimilarGoodsList();
    }

    private String getPromiseTips(MalGoodsInfo malGoodsInfo) {
        if (StringUtils.isNotEmpty((CharSequence)malGoodsInfo.getShippingAddress())) {
            String ecAddressNumber = this.getEcAddressNumber(malGoodsInfo);
            if (StringUtils.isNotEmpty((CharSequence)ecAddressNumber) && ecAddressNumber.split(SPLIT).length >= 3) {
                if (ecAddressNumber.split(SPLIT).length == 3) {
                    ecAddressNumber = ecAddressNumber + SPLIT + "0";
                }
                String res = "";
                try {
                    res = String.valueOf(EcApiUtil.getJdPromiseTips((String)malGoodsInfo.getProductNumber(), (String)ecAddressNumber, (String)malGoodsInfo.getProductSource()));
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
                }
                return res;
            }
            log.warn("kd.scm.mal.domain.model.goods.MalGoods.getPromiseTips.ecAddressNumber is Empty");
        }
        return "";
    }

    private String getEcAddressNumber(MalGoodsInfo malGoodsInfo) {
        Object[] ecAddressNumberArr = AddressUtil.getNumberArr((Long)Parser.toLong((Object)malGoodsInfo.getShippingAddress()), (String)malGoodsInfo.getProductSource());
        String res = StringUtils.join((Object[])ecAddressNumberArr, (String)SPLIT);
        log.info("getEcAddressNumber.res:" + res);
        return StringUtils.join((Object[])ecAddressNumberArr, (String)SPLIT);
    }

    @Override
    public Map<Long, MalPrice> getMalPrices(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return this.malEcGroupProductService.getMalPrices(malMatGoodsInitParams);
    }

    @Override
    public Map<Long, MalStock> getMalStocks(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return this.malEcGroupProductService.getMalStocks(malMatGoodsInitParams);
    }

    private String getNoReasonToReturnText(MalGoodsInfo malGoodsInfo) {
        String noReasonToReturn = "";
        List data = (List)EcApiUtil.getJdnoReasonToReturn((String)malGoodsInfo.getProductNumber(), (String)malGoodsInfo.getProductSource());
        if (null != data) {
            noReasonToReturn = MalNoReasonToReturnEnum.fromVal((String)((Map)data.get(0)).get("noReasonToReturn").toString()).getName();
        }
        if (StringUtils.isBlank((CharSequence)noReasonToReturn)) {
            return "";
        }
        String msg = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a\uff1a", (String)"MalJdProductServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]);
        return msg + noReasonToReturn;
    }

    private String getGurantee(MalGoodsInfo malGoodsInfo) {
        String shouhou = "<div>\u5177\u4f53\u552e\u540e\u4fe1\u606f\u89c1\u4eac\u4e1c\u5546\u54c1\u9875\u9762</div><div><a  href=\"https://item.jd.com/";
        return shouhou + malGoodsInfo.getProductNumber() + ".html\" target=\"_blank\" >" + malGoodsInfo.getProductName() + "</a></div>";
    }

    @Override
    public String getEcSyncServiceFlowNumber() {
        return "SRM_JD_GOODS_INIT_SUB";
    }
}

