/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.product.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.SaleAttrInfo;
import kd.scm.common.ecapi.entity.StockInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalPrice;
import kd.scm.mal.domain.model.goods.MalSaleAttr;
import kd.scm.mal.domain.model.goods.MalSimilarGoods;
import kd.scm.mal.domain.model.goods.MalStock;
import kd.scm.malcore.domain.GoodsInventory;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.malcore.domain.MalProdPool;
import kd.scm.malcore.enums.MallStatusEnum;
import org.apache.commons.lang.StringEscapeUtils;

public class MalSelfProductServiceImpl
implements MalProductService {
    private static final Log log = LogFactory.getLog((String)MalSelfProductServiceImpl.class.getName());

    @Override
    public Map<Long, MalGoodsInfo> getMalGoodsInfos(List<MalMatGoodsInitParam> malMatGoodsInitParams, boolean initStock, boolean isDetail) {
        DynamicObjectCollection prodPoolDyns = MalSelfProductServiceImpl.getProdPoolsDyns(malMatGoodsInitParams);
        Map<Long, DynamicObject> goodsId2ProdPoolDynMap = MalSelfProductServiceImpl.getGoodsId2ProdPoolDyn(prodPoolDyns);
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            DynamicObject prodPoolDyn = goodsId2ProdPoolDynMap.get(malMatGoodsInitParam.getGoodsId());
            if (prodPoolDyn == null) continue;
            malMatGoodsInitParam.setProtocolId(prodPoolDyn.getLong("protocol.id"));
        }
        Map<Long, MalGoodsInfo> res = MalSelfProductServiceImpl.initSelfGoodsInfo(prodPoolDyns);
        MalSelfProductServiceImpl.preHandleMalMatGoodsInitParamsByMalGoodsInfos(malMatGoodsInitParams, res);
        MalSelfProductServiceImpl.fillProdPoolInfo(malMatGoodsInitParams, res);
        Map<Long, MalPrice> malPriceMap = MalPrice.batchInstance(malMatGoodsInitParams);
        Map<Object, Object> malStockMap = new HashMap(malMatGoodsInitParams.size() << 2);
        if (initStock) {
            malStockMap = this.getMalStocks(malMatGoodsInitParams);
        }
        if (isDetail) {
            StringBuilder errorInfos = new StringBuilder();
            for (MalGoodsInfo malGoodsInfo : res.values()) {
                try {
                    malGoodsInfo.setAttributeMap(MalProductUtil.getGoodsInfoAttr((String)malGoodsInfo.getProductId()));
                    malGoodsInfo.setSpecification(this.getSpecification(malGoodsInfo));
                }
                catch (Exception e) {
                    errorInfos.append(ExceptionUtil.getStackTrace((Throwable)e)).append(System.lineSeparator());
                }
            }
            if (errorInfos.length() > 0) {
                log.error(errorInfos.toString());
            }
        }
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            MalGoodsInfo goodsInfo = res.getOrDefault(malMatGoodsInitParam.getGoodsId(), new MalGoodsInfo());
            MalPrice malPrice = malPriceMap.get(malMatGoodsInitParam.getGoodsId());
            MalStock malStock = (MalStock)malStockMap.get(malMatGoodsInitParam.getGoodsId());
            if (malPrice != null) {
                goodsInfo.setTaxPrice(malPrice.getTaxprice());
                goodsInfo.setTaxRate(malPrice.getTaxrate());
                goodsInfo.setTaxRateId(malPrice.getTaxrateId());
                goodsInfo.setPrice(malPrice.getPrice());
                goodsInfo.setShopPrice(malPrice.getShopprice());
                goodsInfo.setPriceModifyTime(malPrice.getModifytime());
                goodsInfo.setLadderPriceInfos(malPrice.getLadderPriceInfos());
                goodsInfo.setLadderPriceRange(malPrice.getLadderPriceRange());
                goodsInfo.setComparePrices(malPrice.getComparePrices());
            }
            if (malStock == null) continue;
            goodsInfo.setStockState(malStock.stockStateDesc());
        }
        return res;
    }

    private static void preHandleMalMatGoodsInitParamsByMalGoodsInfos(List<MalMatGoodsInitParam> malMatGoodsInitParams, Map<Long, MalGoodsInfo> goodsInfoMap) {
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            MalGoodsInfo malGoodsInfo = goodsInfoMap.get(malMatGoodsInitParam.getGoodsId());
            if (malGoodsInfo == null) continue;
            malMatGoodsInitParam.setSku(malGoodsInfo.getProductNumber());
            malMatGoodsInitParam.setGoodsUnitId(Long.valueOf(malGoodsInfo.getProductUnitID()));
        }
    }

    private static void fillProdPoolInfo(List<MalMatGoodsInitParam> malMatGoodsInitParams, Map<Long, MalGoodsInfo> res) {
        long orgId = RequestContext.get().getOrgId();
        if (malMatGoodsInitParams.get(0).getOrgId() != null && malMatGoodsInitParams.get(0).getOrgId() != 0L) {
            orgId = malMatGoodsInitParams.get(0).getOrgId();
        }
        HashSet selfGoodsIds = new HashSet();
        res.forEach((goodsId, malGoodsInfo) -> {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoodsInfo.getProductSource())) {
                selfGoodsIds.add(goodsId);
            }
        });
        if (selfGoodsIds.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("goods.id", "in", selfGoodsIds).and("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
        String selectFields = "isgoodvisible,id,minorderqty,leadtime,goods.number,goods.id,protocol.purmode,protocol.billno,protocol.id,protocol.effectdate,protocol.invaliddate,entryentity.orgname,protocolentry.id";
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selectFields, (QFilter[])qFilter.toArray());
        for (DynamicObject prodPool : prodPools) {
            MalGoodsInfo malGoodsInfo2 = res.get(prodPool.getLong("goods.id"));
            if (malGoodsInfo2 == null) continue;
            malGoodsInfo2.getApplicableOrgSet().add(prodPool.getLong("entryentity.orgname"));
            malGoodsInfo2.setOrgId(orgId);
            malGoodsInfo2.setGoodsVisible(prodPool.getBoolean("isgoodvisible"));
            if (prodPool.getLong("entryentity.orgname") != orgId && !malGoodsInfo2.isGoodsVisible()) continue;
            malGoodsInfo2.setLeadtime(prodPool.getInt("leadtime"));
            malGoodsInfo2.setMinOrderQty(prodPool.getBigDecimal("minorderqty"));
            malGoodsInfo2.setProtocolBillno(prodPool.getString("protocol.billno"));
            malGoodsInfo2.setProtocolId(prodPool.getLong("protocol.id"));
            malGoodsInfo2.setProtocolEntryId(prodPool.getLong("protocolentry.id"));
        }
    }

    private static Map<Long, MalGoodsInfo> initSelfGoodsInfo(DynamicObjectCollection goodsDyns) {
        HashMap<Long, MalGoodsInfo> res = new HashMap<Long, MalGoodsInfo>(goodsDyns.size() << 2);
        for (DynamicObject goodsDyn : goodsDyns) {
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsDyn.get("source"))) continue;
            MalGoodsInfo goodsInfo = MalSelfProductServiceImpl.convertProdManageToGoodsInfo(goodsDyn);
            res.put(goodsDyn.getLong("id"), goodsInfo);
        }
        return res;
    }

    private static MalGoodsInfo convertProdManageToGoodsInfo(DynamicObject goodsDyn) {
        MalGoodsInfo goodsInfo = new MalGoodsInfo();
        goodsInfo.setProductId(goodsDyn.getString("id"));
        goodsInfo.setProductNumber(goodsDyn.getString("number"));
        goodsInfo.setProductImgPath(MalProductUtil.getPictureUrl((String)goodsDyn.getString("thumbnail")));
        goodsInfo.setProductName(goodsDyn.getString("name"));
        goodsInfo.setProductDesc(goodsDyn.getString("description"));
        goodsInfo.setProductModel(goodsDyn.getString("model"));
        goodsInfo.setRemark(goodsDyn.getString("remark"));
        goodsInfo.setProductSource(goodsDyn.getString("source"));
        goodsInfo.setSupplierId(goodsDyn.getLong("supplier.id"));
        goodsInfo.setSupplier(goodsDyn.getString("supplier.name"));
        goodsInfo.setSupplierName(goodsDyn.getString("supplier.name"));
        goodsInfo.setProductUnitID(goodsDyn.getString("unit"));
        goodsInfo.setProductCurrID(goodsDyn.getString("curr"));
        goodsInfo.setRemark(goodsDyn.getString("number"));
        goodsInfo.setSupplierMallStatus(goodsDyn.getString("supplier.mallstatus"));
        goodsInfo.setTaxRate(goodsDyn.getBigDecimal("taxrate"));
        goodsInfo.setBrandId(goodsDyn.getString("brand"));
        goodsInfo.setPicture1(MalProductUtil.getPictureUrl((String)goodsDyn.getString("picture1")));
        goodsInfo.setPicture2(MalProductUtil.getPictureUrl((String)goodsDyn.getString("picture2")));
        goodsInfo.setPicture3(MalProductUtil.getPictureUrl((String)goodsDyn.getString("picture3")));
        goodsInfo.setPicture4(MalProductUtil.getPictureUrl((String)goodsDyn.getString("picture4")));
        goodsInfo.setCategoryNumber(goodsDyn.getString("category.number"));
        goodsInfo.setCategoryName(goodsDyn.getString("category.name"));
        goodsInfo.setCategoryId(goodsDyn.getString("category.id"));
        goodsInfo.setCentralpurtype(goodsDyn.getString("centralpurtype"));
        String content_tag = goodsDyn.getString("content_tag");
        goodsInfo.setProdPoolId(goodsDyn.getLong("poolid"));
        if (!StringUtils.isEmpty((CharSequence)content_tag)) {
            goodsInfo.setProductDetail(content_tag);
        } else {
            goodsInfo.setProductDetail(goodsDyn.getString("content"));
        }
        goodsInfo.setGuarantee(goodsDyn.getString("guarantee"));
        goodsInfo.setPackinglist(goodsDyn.getString("packinglist"));
        goodsInfo.setBarCode(goodsDyn.getString("barcode"));
        goodsInfo.setMallStatus(goodsDyn.getString("mallstatus"));
        goodsInfo.setSpecification(goodsDyn.getString("specification_tag"));
        goodsInfo.setMaterialId(goodsDyn.getLong("materialid"));
        goodsInfo.setMaterialName(goodsDyn.getString("materialname"));
        goodsInfo.setSupplierPhone(goodsDyn.getString("supplierphone"));
        goodsInfo.setSpuNumber(goodsDyn.getString("spunumber"));
        goodsInfo.setCreateTime(goodsDyn.getDate("createtime"));
        goodsInfo.setSaleStatus(goodsDyn.getString("salestatus"));
        goodsInfo.setVideoLocation(goodsDyn.getBoolean("videolocation"));
        return goodsInfo;
    }

    private static Map<Long, DynamicObject> getGoodsId2ProdPoolDyn(DynamicObjectCollection prodPoolDyns) {
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>(prodPoolDyns.size());
        for (DynamicObject prodPoolDyn : prodPoolDyns) {
            res.put(prodPoolDyn.getLong("id"), prodPoolDyn);
        }
        return res;
    }

    private static DynamicObjectCollection getProdPoolsDyns(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        long orgId = 0L;
        if (malMatGoodsInitParams.size() > 0) {
            orgId = malMatGoodsInitParams.get(0).getOrgId();
        }
        ArrayList<Long> goodsIds = new ArrayList<Long>(malMatGoodsInitParams.size());
        ArrayList<String> goodsNumbers = new ArrayList<String>(malMatGoodsInitParams.size());
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            if (malMatGoodsInitParam.getGoodsId() != null && malMatGoodsInitParam.getGoodsId() != 0L) {
                goodsIds.add(malMatGoodsInitParam.getGoodsId());
            }
            if (!StringUtils.isNotEmpty((CharSequence)malMatGoodsInitParam.getSku())) continue;
            goodsNumbers.add(malMatGoodsInitParam.getSku());
        }
        if (goodsIds.isEmpty() && goodsNumbers.isEmpty()) {
            return new DynamicObjectCollection();
        }
        if (goodsIds.isEmpty()) {
            QFilter goodsFilter = new QFilter("number", "in", goodsNumbers).and("source", "=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
            Map id2GoodsDynMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_goods", (QFilter[])new QFilter[]{goodsFilter});
            for (DynamicObject goodsDyn : id2GoodsDynMap.values()) {
                for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
                    if (!StringUtils.equals((CharSequence)malMatGoodsInitParam.getSku(), (CharSequence)goodsDyn.getString("number"))) continue;
                    malMatGoodsInitParam.setGoodsId(goodsDyn.getLong("id"));
                }
                goodsIds.add(goodsDyn.getLong("id"));
            }
        }
        QFilter filter = new QFilter("goods.id", "in", goodsIds);
        HashSet<Long> unQueryGoodsIds = new HashSet<Long>(goodsIds.size());
        unQueryGoodsIds.addAll(goodsIds);
        String selectFields = "goods.id id,goods.number number,goods.thumbnail thumbnail,goods.name name,goods.description description,goods.model model,goods.remark remark,goods.source source,goods.supplier supplier,goods.supplier.id supplier.id,goods.supplier.name supplier.name,goods.supplier.mallstatus supplier.mallstatus,goods.unit unit,goods.taxrate taxrate,goods.curr curr,goods.price price,goods.taxprice taxprice,price poolprice,mallstatus poolmallstatus,taxprice pooltaxprice,goods.shopprice shopprice,goods.mallstatus mallstatus,goods.brand brand,goods.createtime createtime,goods.picture1 picture1,goods.picture2 picture2,goods.picture3 picture3,goods.picture4 picture4,goods.category.number category.number,goods.category.name  category.name,goods.category.id category.id,centralpurtype,goods.content_tag content_tag,goods.content content,goods.guarantee guarantee,goods.packinglist packinglist,salestatus,minorderqty,leadtime,protocol.id,goods.spunumber spunumber,goods.specification_tag specification_tag,goods.prodmatmapping.materielfield.id materialid,goods.prodmatmapping.materielfield.name materialname, goods.supplier.bizpartner_phone supplierphone,goods.videolocation videolocation,goods.barcode barcode,id poolid";
        QFilter orgFilter = new QFilter("isgoodvisible", "=", (Object)true);
        orgFilter.or(new QFilter("entryentity.orgname", "=", (Object)orgId));
        filter.and(orgFilter);
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selectFields, (QFilter[])filter.toArray());
        DynamicObjectCollection infoCols = new DynamicObjectCollection();
        HashSet<Long> prodIds = new HashSet<Long>(1024);
        for (DynamicObject info : prodPools) {
            if (!MallStatusEnum.SOLD.getVal().equals(info.getString("poolmallstatus"))) continue;
            prodIds.add(info.getLong("id"));
        }
        for (DynamicObject info : prodPools) {
            if (MallStatusEnum.SOLD.getVal().equals(info.getString("poolmallstatus"))) {
                info.set("taxprice", (Object)info.getBigDecimal("pooltaxprice"));
                info.set("price", (Object)info.getBigDecimal("poolprice"));
                info.set("shopprice", (Object)info.getBigDecimal("pooltaxprice"));
            } else if (prodIds.contains(info.getLong("id"))) continue;
            info.set("mallstatus", (Object)info.getString("poolmallstatus"));
            info.set("salestatus", (Object)"A");
            infoCols.add((Object)info);
            unQueryGoodsIds.remove(info.getLong("id"));
        }
        if (!unQueryGoodsIds.isEmpty()) {
            DynamicObjectCollection goodsDyns = MalSelfProductServiceImpl.getGoodsDyns(new ArrayList<Long>(unQueryGoodsIds));
            for (DynamicObject goodsDyn : goodsDyns) {
                goodsDyn.set("salestatus", (Object)"B");
            }
            infoCols.addAll((Collection)goodsDyns);
        }
        return infoCols;
    }

    private static DynamicObjectCollection getGoodsDyns(List<Long> goodsIds) {
        String selectFields = "id,number,thumbnail,name,description,model,remark,source,supplier,supplier.id,supplier.name,supplier.mallstatus,unit,taxrate,curr,price,taxprice,shopprice,mallstatus,brand,createtime,picture1,picture2,picture3,picture4,category.number,category.name,category.id,centralpurtype,specification_tag,content_tag,content,guarantee,packinglist,protocolentry.prodpool.minorderqty minorderqty,protocolentry.prodpool.leadtime leadtime,protocolentry.protocol.id protocol.id,spunumber,prodmatmapping.materielfield.id materialid,prodmatmapping.materielfield.name materialname,supplier.bizpartner_phone supplierphone,barcode,protocolentry.prodpool.id poolid,protocolentry.prodpool.salestatus salestatus,videolocation";
        QFilter filter = new QFilter("id", "in", goodsIds);
        return QueryServiceHelper.query((String)"pmm_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    @Override
    public Map<Long, MalPrice> getMalPrices(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        ArrayList<MalProdPool> malProdPools = new ArrayList<MalProdPool>(malMatGoodsInitParams.size());
        malMatGoodsInitParams.forEach(malMatGoodsInitParam -> {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malMatGoodsInitParam.getPlatform())) {
                MalProdPool malProdPool = new MalProdPool();
                malProdPool.setGoodsId(malMatGoodsInitParam.getGoodsId());
                malProdPool.setOrgId(malMatGoodsInitParam.getOrgId());
                malProdPool.setQty(malMatGoodsInitParam.getQty());
                malProdPool.setProtocolId(malMatGoodsInitParam.getProtocolId());
                malProdPools.add(malProdPool);
            }
        });
        if (!malProdPools.isEmpty()) {
            return MalSelfProductServiceImpl.selfPriceFromProdPool(malProdPools);
        }
        return new HashMap<Long, MalPrice>();
    }

    private static Map<Long, MalPrice> selfPriceFromProdPool(List<MalProdPool> malProdPools) {
        return MalSelfProductServiceImpl.selfLadderPrice(malProdPools);
    }

    private static Map<Long, MalPrice> selfLadderPrice(List<MalProdPool> malProdPools) {
        Map prodPools = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"PmmProdPoolPriceQueryService", (String)"getProdPoolPriceMap", (Object[])new Object[]{malProdPools});
        HashMap<Long, MalPrice> res = new HashMap<Long, MalPrice>(prodPools.size());
        Map taxrate2TaxrateIdMap = MalProductUtil.getTaxrate2TaxrateIdMap();
        prodPools.forEach((goodsId, priceInfo) -> {
            BigDecimal taxrate = (BigDecimal)priceInfo.get("taxrateid.taxrate");
            if ((Long)priceInfo.get("taxrateid") == 0L) {
                taxrate = (BigDecimal)priceInfo.get("taxrate");
            }
            if (taxrate == null) {
                taxrate = BigDecimal.ZERO;
            }
            MalPrice malPrice = new MalPrice(String.valueOf(goodsId), (BigDecimal)priceInfo.get("taxprice"), (BigDecimal)priceInfo.get("price"), (BigDecimal)priceInfo.get("shopprice"), taxrate, taxrate2TaxrateIdMap.getOrDefault(taxrate.stripTrailingZeros(), 0L), null);
            malPrice.setOrgId(((MalProdPool)malProdPools.get(0)).getOrgId());
            malPrice.setLadderPriceRange((Map)priceInfo.get("ladderPriceRange"));
            if (null != priceInfo.get("ladderPriceCol")) {
                malPrice.setLadderPriceInfos((List)priceInfo.get("ladderPriceCol"));
            } else {
                malPrice.setLadderPriceInfos(new ArrayList<LadderPriceInfo>());
            }
            res.put((Long)goodsId, malPrice);
        });
        return res;
    }

    @Override
    public Map<Long, MalStock> getMalStocks(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(malMatGoodsInitParams.size());
        for (MalMatGoodsInitParam goodsIdInitParam : malMatGoodsInitParams) {
            if (!kd.bos.util.StringUtils.isNotEmpty((String)goodsIdInitParam.getPlatform()) || !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsIdInitParam.getPlatform())) continue;
            selfGoodsIds.add(goodsIdInitParam.getGoodsId());
        }
        return MalSelfProductServiceImpl.getSelfStockInfo(selfGoodsIds);
    }

    @Override
    public List<MalSimilarGoods> getMalSimilarGoodsList(MalGoodsInfo malGoodsInfo) {
        if (ObjectUtils.isEmpty(malGoodsInfo.getMalSimilarGoodsList())) {
            malGoodsInfo.setMalSimilarGoodsList(this.getSelfSimilarGoodsList(malGoodsInfo));
        }
        return malGoodsInfo.getMalSimilarGoodsList();
    }

    private static Map<Long, MalStock> getSelfStockInfo(List<Long> selfGoodsIds) {
        HashMap<Long, MalStock> res = new HashMap<Long, MalStock>(selfGoodsIds.size());
        ArrayList<GoodsInventoryHandleSku> skuList = new ArrayList<GoodsInventoryHandleSku>(selfGoodsIds.size());
        for (Long goodsId : selfGoodsIds) {
            if (goodsId == null || goodsId == 0L) continue;
            GoodsInventoryHandleSku sku = new GoodsInventoryHandleSku();
            sku.setGoodsId(goodsId);
            skuList.add(sku);
        }
        if (!skuList.isEmpty()) {
            List goodsInventories = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsInventoryService", (String)"queryGoodsInventory", (Object[])new Object[]{skuList});
            for (GoodsInventory goodsInventory : goodsInventories) {
                StockInfo selfStock = new StockInfo();
                selfStock.setGoodsId(String.valueOf(goodsInventory.getGoodsId()));
                if (!goodsInventory.isUnlimited()) {
                    selfStock.setStockStateDesc(goodsInventory.getAvailableQty().stripTrailingZeros().toPlainString());
                } else {
                    selfStock.setStockStateDesc("");
                }
                res.put(goodsInventory.getGoodsId(), new MalStock(selfStock));
            }
        }
        return res;
    }

    private List<MalSimilarGoods> getSelfSimilarGoodsList(MalGoodsInfo malGoodsInfo) {
        QFilter filter = new QFilter("number", "=", (Object)malGoodsInfo.getSpuNumber()).and("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"B")).and("spuskumapentry.confirmstatus", "=", (Object)"B");
        return this.getMalSimilarGoodsListByFilter(malGoodsInfo, filter);
    }

    private List<MalSimilarGoods> getMalSimilarGoodsListByFilter(MalGoodsInfo malGoodsInfo, QFilter filter) {
        String selectFields = "spuskumapentry.spuatrdetailentry.saleprodattributeid.id,spuskumapentry.spuatrdetailentry.saleprodattributeid.prodattributegroup.name,spuskumapentry.spuatrdetailentry.saleprodattributeid.name,spuskumapentry.spuatrdetailentry.saleprodattributevalueid.id,spuskumapentry.spuatrdetailentry.saleprodattributevalueid.name,spuskumapentry.goods.id,spuskumapentry.goods.number,saleattributeentry.saleprodattribute.id,saleattributeentry.seq,saleattributeentry.saleatrvalueentry.saleprodattributevalue.id,saleattributeentry.saleatrvalueentry.seq";
        DynamicObjectCollection spuInfoDynCol = QueryServiceHelper.query((String)"pmm_spu", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"spuskumapentry.spuatrdetailentry.saleprodattributeid.name,spuskumapentry.spuatrdetailentry.saleprodattributevalueid.name");
        LinkedHashMap<Long, MalSimilarGoods> attrId2MalSimilarGoodsMap = new LinkedHashMap<Long, MalSimilarGoods>(spuInfoDynCol.size());
        HashMap<Long, MalSaleAttr> attrValueId2MalSaleAttrMap = new HashMap<Long, MalSaleAttr>(spuInfoDynCol.size());
        int dim = 1;
        HashMap<Long, Integer> attrSeqMap = new HashMap<Long, Integer>(spuInfoDynCol.size());
        HashMap<Long, Integer> attrValueSeqMap = new HashMap<Long, Integer>(spuInfoDynCol.size());
        for (DynamicObject spuInfoDyn : spuInfoDynCol) {
            Integer attrValueSeq;
            HashSet<Long> skuIds;
            SaleAttrInfo saleAttrInfo;
            attrSeqMap.put(spuInfoDyn.getLong("saleattributeentry.saleprodattribute.id"), spuInfoDyn.getInt("saleattributeentry.seq"));
            attrValueSeqMap.put(spuInfoDyn.getLong("saleattributeentry.saleatrvalueentry.saleprodattributevalue.id"), spuInfoDyn.getInt("saleattributeentry.saleatrvalueentry.seq"));
            MalSimilarGoods malSimilarGoods = (MalSimilarGoods)attrId2MalSimilarGoodsMap.get(spuInfoDyn.getLong("spuskumapentry.spuatrdetailentry.saleprodattributeid.id"));
            if (malSimilarGoods == null) {
                malSimilarGoods = new MalSimilarGoods();
                ArrayList<MalSaleAttr> malSaleAttrs = new ArrayList<MalSaleAttr>();
                saleAttrInfo = new SaleAttrInfo();
                saleAttrInfo.setSaleValue(spuInfoDyn.getString("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.name"));
                skuIds = new HashSet<Long>(spuInfoDynCol.size());
                skuIds.add(spuInfoDyn.getLong("spuskumapentry.goods.id"));
                saleAttrInfo.setSkuIds(skuIds);
                MalSaleAttr malSaleAttr = new MalSaleAttr(saleAttrInfo);
                if (malGoodsInfo.getProductId().equals(spuInfoDyn.getString("spuskumapentry.goods.id"))) {
                    malSimilarGoods.setSelectedSku(malGoodsInfo.getProductNumber());
                    malSaleAttr.setSelected(true);
                }
                malSaleAttrs.add(malSaleAttr);
                malSimilarGoods.setDim(dim++);
                malSimilarGoods.setSaleName(spuInfoDyn.getString("spuskumapentry.spuatrdetailentry.saleprodattributeid.name"));
                malSimilarGoods.setSaleGroupName(spuInfoDyn.getString("spuskumapentry.spuatrdetailentry.saleprodattributeid.prodattributegroup.name"));
                malSimilarGoods.setMalSaleAttrs(malSaleAttrs);
                attrId2MalSimilarGoodsMap.put(spuInfoDyn.getLong("spuskumapentry.spuatrdetailentry.saleprodattributeid.id"), malSimilarGoods);
                attrValueId2MalSaleAttrMap.put(spuInfoDyn.getLong("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.id"), malSaleAttr);
            } else {
                MalSaleAttr malSaleAttr = (MalSaleAttr)attrValueId2MalSaleAttrMap.get(spuInfoDyn.getLong("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.id"));
                if (malSaleAttr == null) {
                    saleAttrInfo = new SaleAttrInfo();
                    saleAttrInfo.setSaleValue(spuInfoDyn.getString("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.name"));
                    skuIds = new HashSet(spuInfoDynCol.size());
                    skuIds.add(spuInfoDyn.getLong("spuskumapentry.goods.id"));
                    saleAttrInfo.setSkuIds(skuIds);
                    malSaleAttr = new MalSaleAttr(saleAttrInfo);
                    malSimilarGoods.getMalSaleAttrs().add(malSaleAttr);
                    attrValueId2MalSaleAttrMap.put(spuInfoDyn.getLong("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.id"), malSaleAttr);
                } else {
                    malSaleAttr.getSkuIds().add(spuInfoDyn.getLong("spuskumapentry.goods.id"));
                }
                if (malGoodsInfo.getProductId().equals(spuInfoDyn.getString("spuskumapentry.goods.id"))) {
                    malSimilarGoods.setSelectedSku(malGoodsInfo.getProductNumber());
                    malSaleAttr.setSelected(true);
                }
            }
            Integer attrSeq = (Integer)attrSeqMap.get(spuInfoDyn.getLong("spuskumapentry.spuatrdetailentry.saleprodattributeid.id"));
            if (attrSeq != null) {
                malSimilarGoods.setSeq(attrSeq);
            }
            if ((attrValueSeq = (Integer)attrValueSeqMap.get(spuInfoDyn.getLong("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.id"))) == null) continue;
            MalSaleAttr malSaleAttr = (MalSaleAttr)attrValueId2MalSaleAttrMap.get(spuInfoDyn.getLong("spuskumapentry.spuatrdetailentry.saleprodattributevalueid.id"));
            malSaleAttr.setSeq(attrValueSeq);
        }
        ArrayList<MalSimilarGoods> malSimilarGoods = new ArrayList<MalSimilarGoods>(attrId2MalSimilarGoodsMap.values());
        this.sortMalSimilarGoodsByAttrSeq(malSimilarGoods);
        return malSimilarGoods;
    }

    private void sortMalSimilarGoodsByAttrSeq(List<MalSimilarGoods> malSimilarGoods) {
        malSimilarGoods.sort(Comparator.comparingInt(MalSimilarGoods::getSeq));
        for (MalSimilarGoods malSimilarGood : malSimilarGoods) {
            List<MalSaleAttr> malSaleAttrs = malSimilarGood.getMalSaleAttrs();
            malSaleAttrs.sort(Comparator.comparingInt(MalSaleAttr::getSeq));
        }
    }

    private String getSpecification(MalGoodsInfo malGoodsInfo) {
        StringBuilder sb = new StringBuilder();
        Map attributeMap = malGoodsInfo.getAttributeMap();
        String prefix = "<div style = 'padding: 12px 0;line-height: 220%;color: #999;font-size: 12px;border-bottom: 1px solid #eee;display: block;clear: both;'><h3 style = 'font-weight: 400;width: 110px;text-align: right;float: left;font-size: 12px;width: 110px;'>";
        String prefix0 = "</h3>";
        for (Map.Entry entry : attributeMap.entrySet()) {
            String groupKey = String.valueOf(entry.getKey());
            Map valueMap = (Map)entry.getValue();
            QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(groupKey));
            DynamicObject groupDyo = QueryServiceHelper.queryOne((String)"pmm_prodattributegroup", (String)"name", (QFilter[])new QFilter[]{filter});
            if (Objects.nonNull(groupDyo)) {
                sb.append(prefix).append(groupDyo.getString("name")).append(prefix0);
            } else {
                sb.append(prefix).append(prefix0);
            }
            String prefix1 = "<dl style='margin-left: 110px;'><dl style='margin:0;'><dt style = 'width: 160px;float: left;text-align: right;padding-right: 30px;'>";
            String prefix2 = "</dt><dd style = 'margin-left: 210px;display: block;margin-inline-start: 40px;'>";
            String prefix3 = "</dd></dl></dl>";
            for (Map.Entry entryObj : valueMap.entrySet()) {
                String key = String.valueOf(entryObj.getKey());
                QFilter idfilter = new QFilter("id", "=", (Object)Long.valueOf(key));
                DynamicObject prodAttributeDyo = QueryServiceHelper.queryOne((String)"pmm_prodattribute", (String)"name,prodattributename.name newname", (QFilter[])new QFilter[]{idfilter});
                if (!Objects.nonNull(prodAttributeDyo)) continue;
                List valueList = (List)entryObj.getValue();
                String atrVal = StringEscapeUtils.escapeHtml((String)((String)valueList.get(0)));
                sb.append(prefix1).append(prodAttributeDyo.getString("newname")).append(prefix2).append(atrVal).append(prefix3);
            }
            String prefix5 = "</div>";
            sb.append(prefix5);
        }
        if (Objects.nonNull(malGoodsInfo.getSpecification())) {
            sb.append(malGoodsInfo.getSpecification());
        }
        return sb.toString();
    }

    @Override
    public String getEcSyncServiceFlowNumber() {
        return "";
    }
}

