/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.product.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.entity.SaleAttrInfo;
import kd.scm.common.ecapi.entity.SkuGoodsInfo;
import kd.scm.common.ecapi.entity.SnCharacterInfo;
import kd.scm.common.ecapi.entity.SnGoodsInfo;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.business.product.service.impl.MalEcGroupProductServiceImpl;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalPrice;
import kd.scm.mal.domain.model.goods.MalSimilarGoods;
import kd.scm.mal.domain.model.goods.MalStock;

public class MalSnProductServiceImpl
implements MalProductService {
    private static final Log log = LogFactory.getLog((String)MalSnProductServiceImpl.class.getName());
    MalEcGroupProductServiceImpl malEcGroupProductService = new MalEcGroupProductServiceImpl();

    @Override
    public Map<Long, MalGoodsInfo> getMalGoodsInfos(List<MalMatGoodsInitParam> malMatGoodsInitParams, boolean initStock, boolean isDetail) {
        Map<Long, MalGoodsInfo> malGoodsInfos = this.malEcGroupProductService.getMalGoodsInfos(malMatGoodsInitParams, initStock, isDetail);
        StringBuilder errorInfos = new StringBuilder();
        for (MalGoodsInfo malGoodsInfo : malGoodsInfos.values()) {
            try {
                if (!isDetail) continue;
                malGoodsInfo.setGuarantee(this.getGurantee(malGoodsInfo));
                malGoodsInfo.setIsJDLogistics(this.getEcLogistics(malGoodsInfo));
                malGoodsInfo.setNoReasonToReturnText(this.getNoReasonToReturnText(malGoodsInfo));
            }
            catch (Exception e) {
                errorInfos.append(ExceptionUtil.getStackTrace((Throwable)e)).append(System.lineSeparator());
            }
        }
        if (errorInfos.length() > 0) {
            log.error(errorInfos.toString());
        }
        return malGoodsInfos;
    }

    @Override
    public List<MalSimilarGoods> getMalSimilarGoodsList(MalGoodsInfo malGoodsInfo) {
        if (ObjectUtils.isEmpty(malGoodsInfo.getMalSimilarGoodsList())) {
            List snGoodsInfos = EcApiUtil.getSnSimilarSku((String)malGoodsInfo.getProductNumber());
            List<MalSimilarGoods> malSimilarGoodsList = this.convertSnGoodsInfos2SimilarGoods(malGoodsInfo, snGoodsInfos);
            malGoodsInfo.setMalSimilarGoodsList(malSimilarGoodsList);
        }
        return malGoodsInfo.getMalSimilarGoodsList();
    }

    private List<MalSimilarGoods> convertSnGoodsInfos2SimilarGoods(MalGoodsInfo malGoodsInfo, List<SnGoodsInfo> snGoodsInfos) {
        log.info("kd.scm.mal.domain.model.goods.MalGoods.convertSnGoodsInfos2SimilarGoods.snGoodsInfos:" + snGoodsInfos);
        if (snGoodsInfos == null) {
            return new ArrayList<MalSimilarGoods>();
        }
        ArrayList<MalSimilarGoods> res = new ArrayList<MalSimilarGoods>(snGoodsInfos.size());
        for (int i = 0; i < snGoodsInfos.size(); ++i) {
            SkuGoodsInfo skuGoodsInfo = new SkuGoodsInfo();
            skuGoodsInfo.setDim(Integer.valueOf(i));
            skuGoodsInfo.setSaleName(snGoodsInfos.get(i).getSaleName());
            ArrayList<SaleAttrInfo> saleAttrInfos = new ArrayList<SaleAttrInfo>(snGoodsInfos.get(i).getSnCharacterInfo().size());
            for (SnCharacterInfo snCharacterInfo : snGoodsInfos.get(i).getSnCharacterInfo()) {
                SaleAttrInfo saleAttrInfo = new SaleAttrInfo();
                saleAttrInfo.setSaleValue(snCharacterInfo.getCharacterValueName());
                HashSet<String> skuIds = new HashSet<String>();
                skuIds.add(snCharacterInfo.getSkuId());
                saleAttrInfo.setSkuIds(skuIds);
                saleAttrInfos.add(saleAttrInfo);
            }
            skuGoodsInfo.setSaleAttrList(saleAttrInfos);
            MalSimilarGoods malSimilarGoods = new MalSimilarGoods(malGoodsInfo.getProductNumber(), skuGoodsInfo);
            res.add(malSimilarGoods);
        }
        return res;
    }

    private String getEcLogistics(MalGoodsInfo malGoodsInfo) {
        List result;
        boolean issuccess;
        Map invoke = (Map)EcApiUtil.getSnIsJDLogistics((String)MalPlaceOrderUtils.getCityId((String)malGoodsInfo.getShippingAddress()), (String)malGoodsInfo.getProductNumber());
        if (invoke != null && (issuccess = ((Boolean)invoke.get("success")).booleanValue()) && (result = (List)invoke.get("result")) != null) {
            return ((Map)result.get(0)).get("isFactorySend").toString();
        }
        return "";
    }

    @Override
    public Map<Long, MalPrice> getMalPrices(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return this.malEcGroupProductService.getMalPrices(malMatGoodsInitParams);
    }

    @Override
    public Map<Long, MalStock> getMalStocks(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return this.malEcGroupProductService.getMalStocks(malMatGoodsInitParams);
    }

    private String getNoReasonToReturnText(MalGoodsInfo malGoodsInfo) {
        String noReasonToReturn = "";
        Map data = (Map)EcApiUtil.getSnnoReasonToReturn((String)malGoodsInfo.getProductNumber(), (BigDecimal)malGoodsInfo.getTaxPrice().setScale(2));
        if (((Boolean)data.get("success")).booleanValue()) {
            List result = (List)data.get("result");
            noReasonToReturn = String.valueOf(((Map)result.get(0)).get("noReasonTip"));
        }
        if (StringUtils.isBlank((CharSequence)noReasonToReturn)) {
            return "";
        }
        String msg = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a\uff1a", (String)"MalSnProductServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]);
        return msg + noReasonToReturn;
    }

    private String getGurantee(MalGoodsInfo malGoodsInfo) {
        String shouhou = "<div>\u5177\u4f53\u552e\u540e\u4fe1\u606f\u89c1\u82cf\u5b81\u6613\u8d2d\u5546\u54c1\u9875\u9762</div><div><a  href=\"https://product.suning.com/";
        return shouhou + malGoodsInfo.getProductNumber() + ".html\" target=\"_blank\" >" + malGoodsInfo.getProductName() + "</a></div>";
    }

    @Override
    public String getEcSyncServiceFlowNumber() {
        return "SRM_SN_GOODS_INIT_SUB";
    }
}

