/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.product.service.impl;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.MalNoReasonToReturnEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.business.product.service.impl.MalEcGroupProductServiceImpl;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalPrice;
import kd.scm.mal.domain.model.goods.MalStock;

public class MalXyProductServiceImpl
implements MalProductService {
    private static final Log log = LogFactory.getLog((String)MalXyProductServiceImpl.class.getName());
    MalEcGroupProductServiceImpl malEcGroupProductService = new MalEcGroupProductServiceImpl();

    @Override
    public Map<Long, MalGoodsInfo> getMalGoodsInfos(List<MalMatGoodsInitParam> malMatGoodsInitParams, boolean initStock, boolean isDetail) {
        Map<Long, MalGoodsInfo> malGoodsInfos = this.malEcGroupProductService.getMalGoodsInfos(malMatGoodsInitParams, initStock, isDetail);
        StringBuilder errorInfos = new StringBuilder();
        for (MalGoodsInfo malGoodsInfo : malGoodsInfos.values()) {
            try {
                if (!isDetail) continue;
                malGoodsInfo.setNoReasonToReturnText(this.getNoReasonToReturnText(malGoodsInfo));
                malGoodsInfo.setGuarantee(this.getGurantee(malGoodsInfo));
            }
            catch (Exception e) {
                errorInfos.append((CharSequence)errorInfos.append(ExceptionUtil.getStackTrace((Throwable)e))).append(System.lineSeparator());
            }
        }
        if (errorInfos.length() > 0) {
            log.error(errorInfos.toString());
        }
        return malGoodsInfos;
    }

    @Override
    public Map<Long, MalPrice> getMalPrices(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return this.malEcGroupProductService.getMalPrices(malMatGoodsInitParams);
    }

    @Override
    public Map<Long, MalStock> getMalStocks(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return this.malEcGroupProductService.getMalStocks(malMatGoodsInitParams);
    }

    private String getNoReasonToReturnText(MalGoodsInfo malGoodsInfo) {
        String noReasonToReturnText = malGoodsInfo.getNoReasonToReturnText();
        noReasonToReturnText = "0".equals(noReasonToReturnText) ? "1" : "0";
        String noReasonToReturn = MalNoReasonToReturnEnum.fromVal((String)noReasonToReturnText).getName();
        if (StringUtils.isBlank((CharSequence)noReasonToReturn)) {
            return "";
        }
        String msg = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a\uff1a", (String)"MalXyProductServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]);
        return msg + noReasonToReturn;
    }

    private String getGurantee(MalGoodsInfo malGoodsInfo) {
        String shouhou = "<div>\u5177\u4f53\u552e\u540e\u4fe1\u606f\u89c1\u897f\u57df\u5546\u54c1\u9875\u9762</div><div><a  href=\"https://www.ehsy.com/product-";
        return shouhou + malGoodsInfo.getProductNumber() + ".html\" target=\"_blank\" >" + malGoodsInfo.getProductName() + "</a></div>";
    }

    @Override
    public String getEcSyncServiceFlowNumber() {
        return "SRM_XY_GOODS_INIT_SUB";
    }
}

