/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.receipt.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.common.util.MalAddressUtil;

public class MalReceiptServiceImpl
implements MalReceiptService {
    private static final Log log = LogFactory.getLog(MalReceiptServiceImpl.class);

    @Override
    public MalReceipt getReceiptById(Long receiptId) {
        DynamicObject admindivisionDyn;
        if (receiptId == null) {
            return null;
        }
        DynamicObject receiptDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)receiptId, (String)"mal_address");
        MalReceipt malReceipt = this.structureMalReceiptByReceiptDyn(receiptDyn);
        if (receiptDyn != null && (admindivisionDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)receiptDyn.getLong("address"), (String)"bd_admindivision")) != null) {
            malReceipt.setLongNumber(admindivisionDyn.getString("longnumber"));
        }
        return malReceipt;
    }

    @Override
    public MalReceipt getDetaultReceipt() {
        return this.getDefaultReceiptByOrg(RequestContext.get().getOrgId());
    }

    @Override
    public MalReceipt getDefaultReceiptByOrg(Long orgId) {
        log.info("@@@kd.scm.mal.business.receipt.service.impl.MalReceiptServiceImpl.getDefaultReceiptByOrg");
        DynamicObject defaultAddress = MalAddressUtil.getDefaultAddress();
        MalReceipt malReceipt = new MalReceipt();
        if (defaultAddress == null) {
            log.info("\u67e5\u8be2\u5171\u4eab\u5730\u5740");
            List<MalReceipt> allSharingReceiptByOrg = this.getAllSharingReceiptByOrg(orgId);
            if (CollectionUtils.isEmpty(allSharingReceiptByOrg)) {
                log.info("\u672a\u7ef4\u62a4\u5730\u5740\u3002");
                return malReceipt;
            }
            malReceipt = allSharingReceiptByOrg.get(0);
        } else {
            malReceipt = this.structureMalReceiptByReceiptDyn(defaultAddress);
        }
        DynamicObject admindivisionDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(malReceipt.getAdmindivisionId()), (String)"bd_admindivision");
        if (admindivisionDyn != null) {
            malReceipt.setLongNumber(admindivisionDyn.getString("longnumber"));
        }
        return malReceipt;
    }

    @Override
    public List<MalReceipt> getAllSharingReceiptByOrg(Long orgId) {
        log.info("@@@kd.scm.mal.business.receipt.service.impl.MalReceiptServiceImpl.getUserAllReceipt");
        QFilter sharingQFilter = new QFilter("type", "=", (Object)"B");
        sharingQFilter.and("enable", "=", (Object)"1");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_address", (Long)orgId);
        sharingQFilter.and(baseDataFilter);
        String selectFields = "id,name,phone,address,wholeaddress,mapaddress,jdaddressnum,email,postalcode,type";
        DynamicObjectCollection allAddress = QueryServiceHelper.query((String)"pmm_address", (String)selectFields, (QFilter[])sharingQFilter.toArray(), (String)"createtime desc");
        ArrayList<MalReceipt> malReceipts = new ArrayList<MalReceipt>(allAddress.size());
        if (CollectionUtils.isEmpty((Collection)allAddress)) {
            log.info("\u65e0\u5171\u4eab\u5730\u5740\u3002");
        } else {
            for (DynamicObject address : allAddress) {
                MalReceipt malReceipt = this.structureMalReceiptByReceiptDyn(address);
                malReceipts.add(malReceipt);
            }
        }
        return malReceipts;
    }

    private MalReceipt structureMalReceiptByReceiptDyn(DynamicObject receiptDyn) {
        MalReceipt malReceipt = null;
        if (receiptDyn != null) {
            malReceipt = new MalReceipt();
            malReceipt.setReceiptId(receiptDyn.getLong("id"));
            malReceipt.setAdmindivisionId(receiptDyn.getString("address"));
            malReceipt.setReceiptName(receiptDyn.getString("name"));
            malReceipt.setPhone(receiptDyn.getString("phone"));
            malReceipt.setEmail(receiptDyn.getString("email"));
            malReceipt.setWholeAddress(receiptDyn.getString("wholeaddress"));
            malReceipt.setPostalCode(receiptDyn.getString("postalcode"));
            malReceipt.setMapAddress(receiptDyn.getString("mapaddress"));
            malReceipt.setType(receiptDyn.getString("type"));
        }
        return malReceipt;
    }
}

