/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.search.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.util.CommonUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.business.search.service.MalSearchService;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalPrice;
import kd.scm.mal.domain.model.search.MalFilterBar;
import kd.scm.mal.domain.model.search.MalFilterItem;
import kd.scm.mal.domain.model.search.MalFilterItemValue;
import kd.scm.mal.domain.model.search.MalSearchParam;
import kd.scm.mal.domain.model.search.MalSearchResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MalJdSearchServiceImpl
implements MalSearchService {
    private static final Log logger = LogFactory.getLog(MalJdSearchServiceImpl.class);
    private static final String FILTER_ITEM_FIRST_CATEGORY_ID = "11";
    private static final String FILTER_ITEM_SECOND_CATEGORY_ID = "12";
    private static final String FILTER_ITEM_THIRD_CATEGORY_ID = "13";
    private static final String FILTER_ITEM_BRAND_ID = "21";

    @Override
    public MalSearchResult search(MalSearchParam malSearchParam, DynamicObject malSearchDyn) {
        Map<String, Object> paramMap;
        Map result;
        logger.info("\u4eac\u4e1c\u641c\u7d22\uff1a" + malSearchParam);
        MalSearchResult malSearchResult = new MalSearchResult();
        if (malSearchParam.getPageNum() <= 0) {
            malSearchParam.setPageNum(0);
        }
        if (malSearchParam.getPageSize() <= 0) {
            malSearchParam.setPageSize(malSearchDyn.getInt("pagesize"));
        }
        if (!ObjectUtils.isEmpty((Object)(result = (Map)ApiAccessor.invoke((String)"SRM_JD_GOODS_search", paramMap = this.convert2ApiParam(malSearchParam))))) {
            Object resultCount = result.get("resultCount");
            if (resultCount != null) {
                malSearchResult.setTotals(Long.parseLong(String.valueOf(resultCount)));
            }
            ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>(malSearchParam.getPageSize());
            Object hitResult = result.get("hitResult");
            ArrayList<MalMatGoodsInitParam> malMatGoodsInitParamList = new ArrayList<MalMatGoodsInitParam>();
            if (!ObjectUtils.isEmpty(hitResult)) {
                List<MalFilterBar> malFilterBars = this.convertAgg(result);
                malSearchResult.setMalFilterBars(malFilterBars);
                if (malSearchDyn == null) {
                    malSearchDyn = CommonUtil.createDefaultDyn((String)"mal_newsearch_v1");
                }
                List hitResultList = (List)hitResult;
                DynamicObjectCollection entryCol = malSearchDyn.getDynamicObjectCollection("search_entryentity");
                entryCol.clear();
                long virtualGoodsId = 1L;
                List<EsFilterField> customEsFilterFields = malSearchParam.getCustomEsFilterFields();
                Boolean filterNonSync = false;
                for (EsFilterField customEsFilterField : customEsFilterFields) {
                    if (!"filterNonSync".equals(customEsFilterField.getName())) continue;
                    filterNonSync = (Boolean)customEsFilterField.getKeywords()[0];
                }
                for (Object hitObj : hitResultList) {
                    MalMatGoodsInitParam malMatGoodsInitParam = new MalMatGoodsInitParam();
                    malMatGoodsInitParam.setGoodsId(virtualGoodsId++);
                    malMatGoodsInitParam.setQueryFromEcApi(true);
                    malMatGoodsInitParam.setPlatform(EcPlatformEnum.ECPLATFORM_JD.getVal());
                    HashMap<String, String> goodsObj = new HashMap<String, String>(16);
                    DynamicObject entry2 = entryCol.addNew();
                    Object imageUrl = hitObj.get("imageUrl");
                    if (imageUrl != null) {
                        String thumbnail = "http://img13.360buyimg.com/n1/" + imageUrl;
                        goodsObj.put("thumbnail", thumbnail);
                        entry2.set("searchgoods_img", (Object)thumbnail);
                        entry2.set("searchgoods_img1", (Object)thumbnail);
                    }
                    malMatGoodsInitParam.setPlatform(EcPlatformEnum.ECPLATFORM_JD.getVal());
                    goodsObj.put("number", (String)hitObj.get("wareId"));
                    entry2.set("searchgoods_sku", hitObj.get("wareId"));
                    malMatGoodsInitParam.setSku(String.valueOf(hitObj.get("wareId")));
                    goodsObj.put("name", (String)hitObj.get("wareName"));
                    entry2.set("searchgoods_name", hitObj.get("wareName"));
                    entry2.set("searchgoods_name1", hitObj.get("wareName"));
                    goodsObj.put("brandname", (String)hitObj.get("brand"));
                    entry2.set("brandname1", hitObj.get("brand"));
                    goodsObj.put("source", EcPlatformEnum.ECPLATFORM_JD.getVal());
                    entry2.set("productgoods_source", (Object)EcPlatformEnum.ECPLATFORM_JD.getVal());
                    goodsObj.put("suppliername", EcPlatformEnum.ECPLATFORM_JD.getName());
                    entry2.set("supplier", (Object)EcPlatformEnum.ECPLATFORM_JD.getName());
                    entry2.set("supplier1", (Object)EcPlatformEnum.ECPLATFORM_JD.getName());
                    goodsObj.put("centralpurtype", "1");
                    String centralpurtypeName = ResManager.loadKDString((String)"\u96c6\u56e2\u96c6\u91c7", (String)"MalJdSearchServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]);
                    goodsObj.put("centralpurtype_name", centralpurtypeName);
                    entry2.set("centralpurtype", (Object)centralpurtypeName);
                    entry2.set("centralpurtype1", (Object)centralpurtypeName);
                    resultData.add(goodsObj);
                    malMatGoodsInitParamList.add(malMatGoodsInitParam);
                }
                logger.info("\u4ece\u63a5\u53e3\u53d6\u7535\u5546\u4ef7\u683c");
                Map<String, MalPrice> sku2PriceMap = this.getSku2PriceMap(malMatGoodsInitParamList);
                for (Map map : resultData) {
                    MalPrice malPrice = sku2PriceMap.get(String.valueOf(map.get("number")));
                    if (malPrice == null) continue;
                    map.put("price", malPrice.getTaxprice());
                    map.put("shopprice", malPrice.getShopprice());
                }
                Map<String, Long> sku2GoodsIdMap = this.getSku2GoodsIdMap(sku2PriceMap.keySet());
                for (DynamicObject entry3 : entryCol) {
                    MalPrice malPrice = sku2PriceMap.get(entry3.getString("searchgoods_sku"));
                    if (malPrice != null) {
                        entry3.set("searchgoods_price", (Object)malPrice.getTaxprice());
                        entry3.set("searchgoods_price1", (Object)malPrice.getTaxprice());
                        entry3.set("searchgoods_shopprice1", (Object)malPrice.getShopprice());
                    }
                    entry3.set("searchgoods_pk", (Object)sku2GoodsIdMap.get(entry3.getString("searchgoods_sku")));
                }
                if (filterNonSync.booleanValue()) {
                    entryCol.removeIf(entry -> StringUtils.isNotEmpty((CharSequence)entry.getString("searchgoods_pk")));
                }
            } else if (malSearchDyn != null) {
                DynamicObjectCollection entryCol = malSearchDyn.getDynamicObjectCollection("search_entryentity");
                entryCol.clear();
            }
            malSearchResult.setResultData(resultData);
            malSearchResult.setMalNewSearchDyn(malSearchDyn);
        }
        return malSearchResult;
    }

    private Map<String, Long> getSku2GoodsIdMap(Set<String> skus) {
        HashMap<String, Long> res = new HashMap<String, Long>(skus.size() << 2);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", skus).and("source", "=", (Object)EcPlatformEnum.ECPLATFORM_JD.getVal())}, null);){
            for (Row row : dataSet) {
                res.put(row.getString("number"), row.getLong("id"));
            }
        }
        return res;
    }

    private List<MalFilterBar> convertAgg(Map<String, Object> apiSearchResult) {
        ArrayList<MalFilterBar> malFilterBars = new ArrayList<MalFilterBar>(4);
        malFilterBars.addAll(this.convertCategoryAggregate(apiSearchResult.get("categoryAggregate")));
        MalFilterBar brandFilterBar = this.convertBrandAgg(apiSearchResult.get("brandAggregate"));
        if (brandFilterBar != null) {
            malFilterBars.add(brandFilterBar);
        }
        return malFilterBars;
    }

    private List<MalFilterBar> convertCategoryAggregate(Object categoryAggregate) {
        ArrayList<MalFilterBar> categoryFilterBars = new ArrayList<MalFilterBar>(3);
        if (categoryAggregate != null) {
            JSONObject categoryAggregateJo = JSONObject.fromObject((Object)categoryAggregate);
            JSONArray firstCategoryJa = categoryAggregateJo.getJSONArray("firstCategory");
            ArrayList<MalFilterItemValue> firstFilterItemValues = new ArrayList<MalFilterItemValue>(firstCategoryJa.size());
            for (int i = 0; i < firstCategoryJa.size(); ++i) {
                JSONObject category = firstCategoryJa.getJSONObject(i);
                MalFilterItemValue malFilterItemValue = new MalFilterItemValue(category.getString("name"), category.getString("catId"));
                firstFilterItemValues.add(malFilterItemValue);
            }
            categoryFilterBars.add(new MalFilterBar(ResManager.loadKDString((String)"\u4e00\u7ea7\u5206\u7c7b", (String)"MalJdSearchServiceImpl_1", (String)"scm-mal-business", (Object[])new Object[0]), FILTER_ITEM_FIRST_CATEGORY_ID, firstFilterItemValues));
            JSONArray secondCategoryJa = categoryAggregateJo.getJSONArray("secondCategory");
            ArrayList<MalFilterItemValue> secondFilterItemValues = new ArrayList<MalFilterItemValue>(secondCategoryJa.size());
            for (int i = 0; i < secondCategoryJa.size(); ++i) {
                JSONObject category = secondCategoryJa.getJSONObject(i);
                MalFilterItemValue malFilterItemValue = new MalFilterItemValue(category.getString("name"), category.getString("catId"));
                secondFilterItemValues.add(malFilterItemValue);
            }
            categoryFilterBars.add(new MalFilterBar(ResManager.loadKDString((String)"\u4e8c\u7ea7\u5206\u7c7b", (String)"MalJdSearchServiceImpl_2", (String)"scm-mal-business", (Object[])new Object[0]), FILTER_ITEM_SECOND_CATEGORY_ID, secondFilterItemValues));
            JSONArray thridCategoryJa = categoryAggregateJo.getJSONArray("thridCategory");
            ArrayList<MalFilterItemValue> thirdFilterItemValues = new ArrayList<MalFilterItemValue>(thridCategoryJa.size());
            for (int i = 0; i < thridCategoryJa.size(); ++i) {
                JSONObject category = thridCategoryJa.getJSONObject(i);
                MalFilterItemValue malFilterItemValue = new MalFilterItemValue(category.getString("name"), category.getString("catId"));
                thirdFilterItemValues.add(malFilterItemValue);
            }
            categoryFilterBars.add(new MalFilterBar(ResManager.loadKDString((String)"\u4e09\u7ea7\u5206\u7c7b", (String)"MalJdSearchServiceImpl_3", (String)"scm-mal-business", (Object[])new Object[0]), FILTER_ITEM_THIRD_CATEGORY_ID, thirdFilterItemValues));
        }
        return categoryFilterBars;
    }

    private MalFilterBar convertBrandAgg(Object brandAggregateObj) {
        if (brandAggregateObj != null) {
            JSONObject brandAggregateJo = JSONObject.fromObject((Object)brandAggregateObj);
            JSONArray brandList = brandAggregateJo.getJSONArray("brandList");
            ArrayList<MalFilterItemValue> malFilterItemValues = new ArrayList<MalFilterItemValue>(brandList.size());
            for (int i = 0; i < brandList.size(); ++i) {
                JSONObject brand = brandList.getJSONObject(i);
                MalFilterItemValue malFilterItemValue = new MalFilterItemValue(brand.getString("name"), brand.getString("name"));
                malFilterItemValues.add(malFilterItemValue);
            }
            return new MalFilterBar(ResManager.loadKDString((String)"\u5546\u54c1\u54c1\u724c", (String)"MalJdSearchServiceImpl_4", (String)"scm-mal-business", (Object[])new Object[0]), FILTER_ITEM_BRAND_ID, malFilterItemValues);
        }
        return null;
    }

    private Map<String, Object> convert2ApiParam(MalSearchParam malSearchParam) {
        HashMap<String, Object> res = new HashMap<String, Object>(24);
        res.put("pageIndex", malSearchParam.getPageNum() + 1);
        res.put("pageSize", malSearchParam.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)malSearchParam.getSearchText())) {
            res.put("keyword", malSearchParam.getSearchText());
        }
        if (StringUtils.isNotEmpty((CharSequence)malSearchParam.getCategoryNumber())) {
            if (malSearchParam.getCategoryLevel() == 1) {
                res.put("cid1", malSearchParam.getCategoryNumber());
            } else if (malSearchParam.getCategoryLevel() == 2) {
                res.put("cid2", malSearchParam.getCategoryNumber());
            } else {
                res.put("catId", malSearchParam.getCategoryNumber());
            }
        }
        if (malSearchParam.getStartPrice() != null && malSearchParam.getStartPrice().compareTo(BigDecimal.ZERO) > 0) {
            res.put("startPrice", malSearchParam.getStartPrice().stripTrailingZeros().toPlainString());
        } else if (malSearchParam.getEndPrice() != null && malSearchParam.getEndPrice().compareTo(BigDecimal.ZERO) > 0) {
            res.put("startPrice", "0");
        }
        if (malSearchParam.getEndPrice() != null && malSearchParam.getEndPrice().compareTo(BigDecimal.ZERO) > 0) {
            res.put("endPrice", malSearchParam.getEndPrice().stripTrailingZeros().toPlainString());
        } else if (malSearchParam.getStartPrice() != null && malSearchParam.getStartPrice().compareTo(BigDecimal.ZERO) > 0) {
            res.put("endPrice", String.valueOf(Integer.MAX_VALUE));
        }
        if (!ObjectUtils.isEmpty(malSearchParam.getBrandNumbers())) {
            res.put("brands", String.join((CharSequence)",", malSearchParam.getBrandNumbers()));
        }
        if (StringUtils.isNotEmpty((CharSequence)malSearchParam.getCategoryNumber1())) {
            res.put("cid1", malSearchParam.getCategoryNumber1());
        }
        if (StringUtils.isNotEmpty((CharSequence)malSearchParam.getCategoryNumber2())) {
            res.put("cid2", malSearchParam.getCategoryNumber2());
        }
        if (StringUtils.isNotEmpty((CharSequence)malSearchParam.getSort())) {
            res.put("sortType", this.convertSortType(malSearchParam.getSort()));
        }
        if (malSearchParam.getRedisStore().booleanValue()) {
            res.put("redisStore", malSearchParam.getRedisStore());
        }
        List<MalFilterItem> malFilterItemList = malSearchParam.getMalFilterItemList();
        for (MalFilterItem malFilterItem : malFilterItemList) {
            if (FILTER_ITEM_BRAND_ID.equals(String.valueOf(malFilterItem.getAggId()))) {
                res.put("brands", malFilterItem.getFilterItemValueId());
            }
            if (FILTER_ITEM_FIRST_CATEGORY_ID.equals(String.valueOf(malFilterItem.getAggId()))) {
                res.put("cid1", malFilterItem.getFilterItemValueId());
            }
            if (FILTER_ITEM_SECOND_CATEGORY_ID.equals(String.valueOf(malFilterItem.getAggId()))) {
                res.put("cid2", malFilterItem.getFilterItemValueId());
            }
            if (!FILTER_ITEM_THIRD_CATEGORY_ID.equals(String.valueOf(malFilterItem.getAggId()))) continue;
            res.put("catId", malFilterItem.getFilterItemValueId());
        }
        return res;
    }

    private Object convertSortType(String sort) {
        if ("sales_true".equals(sort)) {
            return "sale_asc";
        }
        if ("sales_false".equals(sort)) {
            return "sale_desc";
        }
        if ("price_true".equals(sort)) {
            return "price_asc";
        }
        if ("price_false".equals(sort)) {
            return "price_desc";
        }
        if ("modifytime_false".equals(sort)) {
            return "winsdate_desc";
        }
        return sort;
    }

    private Map<String, MalPrice> getSku2PriceMap(List<MalMatGoodsInitParam> malMatGoodsInitParamList) {
        HashMap<String, MalPrice> res = new HashMap<String, MalPrice>(malMatGoodsInitParamList.size() << 2);
        MalProductService malProductService = MalBusinessFactory.serviceOf(MalProductService.class, EcPlatformEnum.ECPLATFORM_JD.getVal());
        if (malProductService != null) {
            Map<Long, MalPrice> malPrices = malProductService.getMalPrices(malMatGoodsInitParamList);
            for (MalPrice malPrice : malPrices.values()) {
                res.put(malPrice.getSku(), malPrice);
            }
        }
        return res;
    }
}

