/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.mal.business.model.menu.BussinessCard;
import kd.scm.mal.business.model.menu.MenuItem;
import kd.scm.mal.business.shopcenter.MalDefaultService;
import kd.scm.mal.business.shopcenter.MalMyInvoiceService;
import kd.scm.mal.business.shopcenter.MalMyOrderCommentService;
import kd.scm.mal.business.shopcenter.MalMyOrderService;
import kd.scm.mal.business.shopcenter.MalReturnReqService;

public class MalNewShopCenterService {
    public Set<Long> queryTarEntityID(QFilter[] qFilters, String tab, String formId) {
        HashSet<Long> ids = new HashSet(1024);
        MalDefaultService service = new MalDefaultService(formId);
        switch (formId) {
            case "mal_order": {
                service = new MalMyOrderService();
                break;
            }
            case "mal_returnreq": {
                service = new MalReturnReqService();
                break;
            }
            case "pur_invoice": {
                service = new MalMyInvoiceService();
                break;
            }
            case "mal_order_comment": {
                service = new MalMyOrderCommentService();
            }
        }
        QFilter qFilter = null;
        if (qFilters.length > 0) {
            qFilter = qFilters[0];
            for (int i = 1; i < qFilters.length; ++i) {
                qFilter.and(qFilters[i]);
            }
        }
        QFilter tabQfilter = new QFilter("group.entity.number", "=", (Object)formId);
        tabQfilter.and(new QFilter("status", "=", (Object)"C"));
        tabQfilter.and(new QFilter("tabnumber", "=", (Object)tab));
        tabQfilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject tabInfo = QueryServiceHelper.queryOne((String)"mal_tab", (String)"number,name,filter,filter_tag,id", (QFilter[])tabQfilter.toArray());
        ids = service.getInfoIds(tabInfo, qFilter, tab);
        return ids;
    }

    public List<MenuItem> getMenus() {
        QFilter filter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        LinkedHashMap menuItemMap = new LinkedHashMap();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"mal_menuclass", (String)"id,name,mseq", (QFilter[])new QFilter[]{filter}, (String)"mseq");){
            ds.forEach(row -> {
                MenuItem parentMenuItem = new MenuItem();
                parentMenuItem.setKey(row.getLong("id"));
                parentMenuItem.setName(row.getString("name"));
                menuItemMap.put(row.getLong("id"), parentMenuItem);
            });
        }
        ds = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"mal_menu", (String)"id,name,menuseq,class.name,entity.number,class.id", (QFilter[])new QFilter[]{filter}, null);
        var4_4 = null;
        try {
            ds.forEach(row -> {
                MenuItem menuItem = new MenuItem();
                menuItem.setKey(row.getLong("id"));
                menuItem.setName(row.getString("name"));
                menuItem.setUrl(this.getUrl(row.getString("entity.number"), row.getString("name")));
                MenuItem parentMenuItem = (MenuItem)menuItemMap.get(row.getLong("class.id"));
                if (parentMenuItem != null) {
                    List<MenuItem> menuItems = parentMenuItem.getSubMenuItems();
                    if (menuItems == null) {
                        menuItems = new ArrayList<MenuItem>();
                    }
                    menuItem.setDropdown(true);
                    menuItems.add(menuItem);
                    parentMenuItem.setSubMenuItems(menuItems);
                }
            });
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return new ArrayList<MenuItem>(menuItemMap.values());
    }

    private String getUrl(String formId, String caption) {
        return UrlService.getDomainContextUrl() + "/index.html?formId=mal_newshopcenter&showFormId=" + formId + "&formCaption=" + caption + "&accountId=" + RequestContext.get().getAccountId();
    }

    public List<BussinessCard> getBussinessCards() {
        ArrayList<BussinessCard> cards = new ArrayList<BussinessCard>(1024);
        QFilter qFilter = new QFilter("show_in_login", "=", (Object)true);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("group.status", "=", (Object)"C"));
        qFilter.and(new QFilter("group.enable", "=", (Object)"1"));
        qFilter.and(new QFilter("group.class.status", "=", (Object)"C"));
        qFilter.and(new QFilter("group.class.enable", "=", (Object)"1"));
        String selectors = "number,name,id,tabnumber,tabseq,filter,filter_tag,group.entity.number,show_in_login";
        DynamicObjectCollection malTabs = QueryServiceHelper.query((String)"mal_tab", (String)selectors, (QFilter[])qFilter.toArray(), (String)"group.entity.number,tabseq");
        for (DynamicObject tabInfo : malTabs) {
            String formId = tabInfo.getString("group.entity.number");
            MalDefaultService service = new MalDefaultService(formId);
            switch (formId) {
                case "mal_order": {
                    service = new MalMyOrderService();
                    break;
                }
                case "mal_returnreq": {
                    service = new MalReturnReqService();
                    break;
                }
                case "pur_invoice": {
                    service = new MalMyInvoiceService();
                    break;
                }
            }
            Set<Long> ids = service.getInfoIds(tabInfo, service.getDefaultFilters(), tabInfo.getString("tabnumber"));
            BussinessCard bussinessCard = new BussinessCard();
            bussinessCard.setId(tabInfo.getLong("id"));
            bussinessCard.setName(tabInfo.getString("name"));
            bussinessCard.setCount(ids.size());
            String urlStr = UrlService.getDomainContextUrl() + "/index.html?formId=mal_newshopcenter&showFormId=" + formId + "&showTab=" + tabInfo.getString("tabnumber") + "&accountId=" + RequestContext.get().getAccountId();
            bussinessCard.setUrl(urlStr);
            cards.add(bussinessCard);
        }
        return cards;
    }
}

