/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.shopcart.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderValidateOption;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderValidateResult;
import kd.scm.mal.business.placeorder.service.impl.MalPlaceOrderServiceImpl;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.shopcart.vo.MalAddCartParam;
import kd.scm.mal.business.shopcart.vo.MalCarResultVO;
import kd.scm.mal.business.shopcart.vo.MalCartItemVo;
import kd.scm.mal.business.shopcart.vo.MalCartVo;
import kd.scm.mal.business.shopcart.vo.MalSupplierToCartItemsVo;
import kd.scm.mal.common.addcart.impl.MalSelfAddToCart;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;

public class MalShopCartServiceImpl
implements MalShopCartService {
    private static final Log log = LogFactory.getLog((String)MalShopCartServiceImpl.class.getName());

    @Override
    public void addToCart(Long goodsId, String platform, BigDecimal qty) {
        ArrayList<MalAddCartParam> malAddCartParams = new ArrayList<MalAddCartParam>(2);
        MalAddCartParam malAddCartParam = new MalAddCartParam();
        malAddCartParam.setPlatform(platform);
        malAddCartParam.setGoodsNumber("");
        malAddCartParam.setGoodsId(goodsId);
        malAddCartParam.setQty(qty);
        malAddCartParams.add(malAddCartParam);
        this.batchAddToCart(malAddCartParams);
    }

    @Override
    public void batchAddToCart(List<MalAddCartParam> malAddCartParams) {
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(malAddCartParams.size());
        HashMap<Long, MalAddCartParam> goodsId2AddCartParamMap = new HashMap<Long, MalAddCartParam>(malAddCartParams.size() << 2);
        long currentOrgId = RequestContext.get().getOrgId();
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(malAddCartParams.size());
        for (MalAddCartParam malAddCartParam : malAddCartParams) {
            if (malAddCartParam.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u7684\u5546\u54c1\u6570\u91cf\u5e94\u5927\u4e8e0\u3002", (String)"MalShopCartServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malAddCartParam.getPlatform())) {
                ecGoodsIds.add(malAddCartParam.getGoodsId());
            }
            goodsId2AddCartParamMap.put(malAddCartParam.getGoodsId(), malAddCartParam);
            malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParamWithSku(malAddCartParam.getGoodsId(), malAddCartParam.getGoodsNumber(), malAddCartParam.getPlatform(), malAddCartParam.getQty(), "", currentOrgId));
        }
        Map<Long, MalGoods> malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, false, false);
        MalPlaceOrderValidateResult validateResult = new MalPlaceOrderServiceImpl().validateGoods(new HashMap<Long, BigDecimal>(), malGoodsMap, RequestContext.get().getOrgId(), new MalPlaceOrderValidateOption());
        if (!validateResult.getErrorInfos().isEmpty()) {
            throw new KDBizException(String.join((CharSequence)(";" + System.lineSeparator()), validateResult.getErrorInfos()));
        }
        this.afterBatchAddToCart(ecGoodsIds, malGoodsMap, goodsId2AddCartParamMap);
    }

    private void afterBatchAddToCart(List<Long> ecGoodsIds, Map<Long, MalGoods> malGoodsMap, Map<Long, MalAddCartParam> goodsId2AddCartParamMap) {
        long currentOrgId = RequestContext.get().getOrgId();
        MalGoods.syncEcGoodsToGoodsManage(new HashSet<Long>(ecGoodsIds));
        QFilter personFilter = new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter goodsFilter = new QFilter("goods", "in", malGoodsMap.keySet());
        DynamicObject[] shopCarts = BusinessDataServiceHelper.load((String)"mal_shopcartbill", (String)"id,goods.id,org.id,qty,taxamount,goodsimg,goodsname,goodsdesc,goodsource,taxprice,unit.id,curr.id,supplier,price,taxrate,org", (QFilter[])new QFilter[]{personFilter, goodsFilter});
        HashSet<Long> needDeleteShopCartIdSet = new HashSet<Long>(shopCarts.length);
        ArrayList<DynamicObject> needUpdateShopCartDyns = new ArrayList<DynamicObject>(shopCarts.length);
        HashSet<Long> existShopCartGoodsIdSet = new HashSet<Long>(shopCarts.length);
        for (DynamicObject shopCartDyn : shopCarts) {
            MalGoods malGoods = malGoodsMap.get(shopCartDyn.getLong("goods.id"));
            if (malGoods == null) continue;
            Long orgId = shopCartDyn.getLong("org.id");
            MalAddCartParam malAddCartParam = goodsId2AddCartParamMap.get(malGoods.getId());
            if (orgId == 0L || orgId.equals(currentOrgId)) {
                needUpdateShopCartDyns.add(this.updateShopCartDyn(shopCartDyn, malGoods, malAddCartParam));
                existShopCartGoodsIdSet.add(shopCartDyn.getLong("goods.id"));
                continue;
            }
            if (!malGoods.isGoodsVisible()) continue;
            needDeleteShopCartIdSet.add(shopCartDyn.getLong("id"));
        }
        ArrayList<DynamicObject> newShopCartDyns = new ArrayList<DynamicObject>(malGoodsMap.size());
        for (MalGoods malGoods : malGoodsMap.values()) {
            if (existShopCartGoodsIdSet.contains(malGoods.getId())) continue;
            newShopCartDyns.add(this.createNewShopCartDyn(malGoods, goodsId2AddCartParamMap.get(malGoods.getId())));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", String.valueOf(true));
        if (!needUpdateShopCartDyns.isEmpty()) {
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)"mal_shopcartbill", (DynamicObject[])needUpdateShopCartDyns.toArray(new DynamicObject[0]), (OperateOption)option));
        }
        if (!newShopCartDyns.isEmpty()) {
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)"mal_shopcartbill", (DynamicObject[])newShopCartDyns.toArray(new DynamicObject[0]), (OperateOption)option));
        }
        if (!needDeleteShopCartIdSet.isEmpty()) {
            DeleteServiceHelper.delete((String)"mal_shopcartbill", (QFilter[])new QFilter[]{new QFilter("id", "in", needDeleteShopCartIdSet)});
        }
    }

    private DynamicObject createNewShopCartDyn(MalGoods malGoods, MalAddCartParam malAddCartParam) {
        DynamicObject shopCartDyn = BusinessDataServiceHelper.newDynamicObject((String)"mal_shopcartbill");
        shopCartDyn.set("qty", (Object)malAddCartParam.getQty());
        shopCartDyn.set("goods", (Object)malGoods.getProductId());
        shopCartDyn.set("goodsimg", (Object)malGoods.getThumbnail());
        shopCartDyn.set("goodsname", (Object)malGoods.getProductName());
        shopCartDyn.set("goodsdesc", (Object)malGoods.getProductModel());
        shopCartDyn.set("goodsource", (Object)malGoods.getProductSource());
        shopCartDyn.set("taxprice", (Object)malGoods.getTaxPrice());
        shopCartDyn.set("unit_id", (Object)malGoods.getProductUnitID());
        shopCartDyn.set("taxamount", (Object)malGoods.getTaxPrice().multiply(shopCartDyn.getBigDecimal("qty")));
        shopCartDyn.set("curr_id", (Object)malGoods.getCurrency());
        shopCartDyn.set("supplier", (Object)malGoods.getSupplierId());
        shopCartDyn.set("price", (Object)malGoods.getPrice());
        shopCartDyn.set("taxrate", (Object)malGoods.getTaxRate());
        shopCartDyn.set("person", (Object)RequestContext.get().getCurrUserId());
        shopCartDyn.set("billdate", (Object)new Date());
        if (malGoods.isGoodsVisible()) {
            shopCartDyn.set("org", (Object)0L);
        } else {
            shopCartDyn.set("org", (Object)RequestContext.get().getOrgId());
        }
        return shopCartDyn;
    }

    private DynamicObject updateShopCartDyn(DynamicObject shopCartDyn, MalGoods malGoods, MalAddCartParam malAddCartParam) {
        BigDecimal newQty = shopCartDyn.getBigDecimal("qty").add(malAddCartParam.getQty());
        shopCartDyn.set("qty", (Object)newQty);
        shopCartDyn.set("taxamount", (Object)newQty.multiply(malGoods.getTaxPrice()));
        shopCartDyn.set("goodsimg", (Object)malGoods.getThumbnail());
        shopCartDyn.set("goodsname", (Object)malGoods.getProductName());
        shopCartDyn.set("goodsdesc", (Object)malGoods.getProductModel());
        shopCartDyn.set("taxprice", (Object)malGoods.getTaxPrice());
        shopCartDyn.set("unit_id", (Object)malGoods.getProductUnitID());
        shopCartDyn.set("supplier", (Object)malGoods.getSupplierId());
        shopCartDyn.set("price", (Object)malGoods.getPrice());
        shopCartDyn.set("taxrate", (Object)malGoods.getTaxRate());
        if (malGoods.isGoodsVisible()) {
            shopCartDyn.set("org", (Object)0L);
        } else {
            shopCartDyn.set("org", (Object)RequestContext.get().getOrgId());
        }
        return shopCartDyn;
    }

    @Override
    public MalCartVo getCart(Long receiptId) {
        if (receiptId == null || receiptId == 0L) {
            receiptId = MalBusinessFactory.serviceOf(MalReceiptService.class).getDetaultReceipt().getReceiptId();
        }
        return this.getMalCartVo(receiptId);
    }

    private MalCartVo getMalCartVo(Long receiptId) {
        MalReceipt malReceipt;
        MalCartVo malCartVo = new MalCartVo();
        if (receiptId == null || receiptId == 0L) {
            malReceipt = MalBusinessFactory.serviceOf(MalReceiptService.class).getDetaultReceipt();
        } else {
            malReceipt = MalBusinessFactory.serviceOf(MalReceiptService.class).getReceiptById(receiptId);
            if (malReceipt == null) {
                malReceipt = MalBusinessFactory.serviceOf(MalReceiptService.class).getDetaultReceipt();
            }
        }
        malCartVo.setMalReceipt(malReceipt);
        LinkedHashMap<Long, MalSupplierToCartItemsVo> supplierIdToSupplierToCartItemsVoMap = new LinkedHashMap<Long, MalSupplierToCartItemsVo>();
        String selectFields = "id,goods.id,goods.thumbnail,goods.number,remark,goods.name,goods.model,goodsdesc,stockqty,taxprice,qty,goods.unit.id,taxamount,goodsource,supplier.id,supplier.number,supplier.name,org";
        QFilter qFilter = new QFilter("person.id", "=", (Object)RequestContext.get().getCurrUserId()).and("goods.number", "is not null", null).and("org.id", "in", Arrays.asList(0L, RequestContext.get().getOrgId()));
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>();
        HashMap<Long, BigDecimal> goodsIdToQtyMap = new HashMap<Long, BigDecimal>();
        DataSet shopCartDataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"mal_shopcartbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"supplier,goods.number asc");
        Object object = null;
        try {
            for (Row shopCartRow : shopCartDataSet) {
                Long supplierId = shopCartRow.getLong("supplier.id");
                MalSupplierToCartItemsVo malSupplierToCartItemsVo = (MalSupplierToCartItemsVo)supplierIdToSupplierToCartItemsVoMap.get(supplierId);
                if (malSupplierToCartItemsVo == null) {
                    malSupplierToCartItemsVo = new MalSupplierToCartItemsVo();
                    malSupplierToCartItemsVo.setSupplierId(supplierId);
                    malSupplierToCartItemsVo.setSupplierName(shopCartRow.getString("supplier.name"));
                    String platform = shopCartRow.getString("goodsource");
                    malSupplierToCartItemsVo.setPlatform(platform);
                    malSupplierToCartItemsVo.setPlatformName(EcPlatformEnum.fromVal((String)platform).getName());
                }
                supplierIdToSupplierToCartItemsVoMap.put(supplierId, malSupplierToCartItemsVo);
                MalMatGoodsInitParam malMatGoodsInitParam = MalMatGoodsInitParam.buildGeneralParam(shopCartRow.getLong("goods.id"), shopCartRow.getString("goodsource"), shopCartRow.getBigDecimal("qty"), malReceipt.getAdmindivisionId(), RequestContext.get().getOrgId());
                malMatGoodsInitParams.add(malMatGoodsInitParam);
                goodsIdToQtyMap.put(shopCartRow.getLong("goods.id"), shopCartRow.getBigDecimal("qty"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (shopCartDataSet != null) {
                if (object != null) {
                    try {
                        shopCartDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    shopCartDataSet.close();
                }
            }
        }
        Map<Long, MalGoods> malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, true, false);
        for (MalGoods malGoods : malGoodsMap.values()) {
            MalSupplierToCartItemsVo malSupplierToCartItemsVo;
            String supplierId = malGoods.getSupplierId();
            if (!StringUtils.isNotBlank((CharSequence)supplierId) || (malSupplierToCartItemsVo = (MalSupplierToCartItemsVo)supplierIdToSupplierToCartItemsVoMap.get(Long.valueOf(supplierId))) == null) continue;
            MalCartItemVo cartItemVo = this.createCartItemVo(malGoods, goodsIdToQtyMap);
            malSupplierToCartItemsVo.getMalCartItemVoList().add(cartItemVo);
        }
        malCartVo.setMalSupplierToCartItemsVoList(new ArrayList<MalSupplierToCartItemsVo>(supplierIdToSupplierToCartItemsVoMap.values()));
        return malCartVo;
    }

    private MalCartItemVo createCartItemVo(MalGoods malGoods, Map<Long, BigDecimal> goodsIdToQtyMap) {
        MalCartItemVo malCartItemVo = new MalCartItemVo();
        malCartItemVo.setPlatform(malGoods.getPlatform());
        malCartItemVo.setGoodsId(malGoods.getId());
        malCartItemVo.setGoodsName(malGoods.getName());
        malCartItemVo.setGoodsNumber(malGoods.getNumber());
        malCartItemVo.setThumbnail(malGoods.getThumbnail());
        malCartItemVo.setStockDesc(malGoods.getStockDesc());
        malCartItemVo.setMallStatusValid(malGoods.validateMallStatus());
        malCartItemVo.setOrgSaleable(malGoods.validateOrgSaleable(RequestContext.get().getOrgId()));
        malCartItemVo.setInStock(malGoods.validateStock(BigDecimal.ONE));
        malCartItemVo.setMinOrderQty(malGoods.getMinOrderQty());
        malCartItemVo.setTaxPrice(malGoods.getTaxPrice());
        malCartItemVo.setQty(goodsIdToQtyMap.get(malGoods.getId()));
        return malCartItemVo;
    }

    @Override
    public void modifyCartItemQty(Long goodsId, String platform, BigDecimal qty) {
        if (qty == null || goodsId == null) {
            return;
        }
        QFilter filter = new QFilter("goods.id", "=", (Object)goodsId).and("person.id", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObject cartDyn = BusinessDataServiceHelper.loadSingle((String)"mal_shopcartbill", (String)"qty,taxamount", (QFilter[])new QFilter[]{filter});
        if (cartDyn == null) {
            return;
        }
        BigDecimal oldQty = cartDyn.getBigDecimal("qty");
        MalSelfAddToCart selfService = new MalSelfAddToCart();
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
            selfService.addCart(goodsId, qty.subtract(oldQty));
        } else {
            cartDyn.set("qty", (Object)qty);
            MalGoods malGoods = MalGoods.of(MalMatGoodsInitParam.buildGeneralParam(goodsId, platform, qty, null, null), false, false);
            cartDyn.set("taxamount", (Object)qty.multiply(malGoods.getTaxPrice()));
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{cartDyn});
    }

    @Override
    public void deleteCartItems(List<Long> goodsIds) {
        QFilter qFilter = new QFilter("goods.id", "in", goodsIds).and("person.id", "=", (Object)RequestContext.get().getCurrUserId());
        log.info("{}\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\uff1a{}", (Object)RequestContext.get().getCurrUserId(), goodsIds);
        DeleteServiceHelper.delete((String)"mal_shopcartbill", (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public List<MalCarResultVO> batchAddToCartHasResult(List<MalAddCartParam> malAddCartParams) {
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(malAddCartParams.size());
        HashMap<Long, MalAddCartParam> goodsId2AddCartParamMap = new HashMap<Long, MalAddCartParam>(malAddCartParams.size() << 2);
        ArrayList<MalCarResultVO> resultList = new ArrayList<MalCarResultVO>(16);
        long currentOrgId = RequestContext.get().getOrgId();
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(malAddCartParams.size());
        List<Long> goodsIds = new ArrayList<Long>(malAddCartParams.size());
        for (MalAddCartParam malAddCartParam : malAddCartParams) {
            if (malAddCartParam.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                String message = ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u7684\u5546\u54c1\u6570\u91cf\u5e94\u5927\u4e8e0\u3002", (String)"MalShopCartServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]);
                resultList.add(this.createMalCarResultVO(malAddCartParam.getGoodsId(), null, malAddCartParam.getGoodsNumber(), message));
                continue;
            }
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malAddCartParam.getPlatform())) {
                ecGoodsIds.add(malAddCartParam.getGoodsId());
            }
            goodsId2AddCartParamMap.put(malAddCartParam.getGoodsId(), malAddCartParam);
            malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParamWithSku(malAddCartParam.getGoodsId(), malAddCartParam.getGoodsNumber(), malAddCartParam.getPlatform(), malAddCartParam.getQty(), "", currentOrgId));
            goodsIds.add(malAddCartParam.getGoodsId());
        }
        Map<Long, MalGoods> malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, false, false);
        MalPlaceOrderValidateResult malPlaceOrderValidateResult = new MalPlaceOrderServiceImpl().validateGoods(new HashMap<Long, BigDecimal>(), malGoodsMap, RequestContext.get().getOrgId(), new MalPlaceOrderValidateOption());
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getOrgId(), (String)"bos_org");
        if (!malPlaceOrderValidateResult.getErrorInfos().isEmpty()) {
            String message;
            if (!malPlaceOrderValidateResult.getInvalidMallStatusProdIDList().isEmpty()) {
                message = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalShopCartServiceImpl_1", (String)"scm-mal-business", (Object[])new Object[0]);
                goodsIds = this.addError(resultList, malPlaceOrderValidateResult.getInvalidMallStatusProdIDList(), message, goodsIds);
            }
            if (!malPlaceOrderValidateResult.getInvalidPriceProdIDList().isEmpty()) {
                message = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u4ef7\u683c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalShopCartServiceImpl_2", (String)"scm-mal-business", (Object[])new Object[0]);
                goodsIds = this.addError(resultList, malPlaceOrderValidateResult.getInvalidPriceProdIDList(), message, goodsIds);
            }
            if (!malPlaceOrderValidateResult.getInvalidStockProdIDList().isEmpty()) {
                message = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u7f3a\u8d27\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalShopCartServiceImpl_3", (String)"scm-mal-business", (Object[])new Object[0]);
                goodsIds = this.addError(resultList, malPlaceOrderValidateResult.getInvalidStockProdIDList(), message, goodsIds);
            }
            if (!malPlaceOrderValidateResult.getInvalidMinOrderQtyIDList().isEmpty()) {
                message = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u7684\u91c7\u8d2d\u6570\u91cf\u672a\u8fbe\u8d77\u8ba2\u91cf\u3002", (String)"MalShopCartServiceImpl_4", (String)"scm-mal-business", (Object[])new Object[0]);
                goodsIds = this.addError(resultList, malPlaceOrderValidateResult.getInvalidMinOrderQtyIDList(), message, goodsIds);
            }
            if (!malPlaceOrderValidateResult.getInvalidOrgProdIDList().isEmpty()) {
                message = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u5728\u7533\u8bf7\u7ec4\u7ec7\u3010{0}\u3011\u4e0b\u4e0d\u53ef\u552e\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalShopCartServiceImpl_5", (String)"scm-mal-business", (Object[])new Object[]{orgDyn.getString("name")});
                goodsIds = this.addError(resultList, malPlaceOrderValidateResult.getInvalidOrgProdIDList(), message, goodsIds);
            }
        }
        if (goodsIds.size() == 0) {
            return resultList;
        }
        MalGoods.syncEcGoodsToGoodsManage(new HashSet<Long>(ecGoodsIds));
        QFilter personFilter = new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter goodsFilter = new QFilter("goods", "in", goodsIds);
        DynamicObject[] shopCarts = BusinessDataServiceHelper.load((String)"mal_shopcartbill", (String)"id,goods.id,org.id,qty,taxamount,goodsimg,goodsname,goodsdesc,goodsource,taxprice,unit.id,curr.id,supplier,price,taxrate,org", (QFilter[])new QFilter[]{personFilter, goodsFilter});
        HashSet<Long> needDeleteShopCartIdSet = new HashSet<Long>(shopCarts.length);
        ArrayList<DynamicObject> needUpdateShopCartDyns = new ArrayList<DynamicObject>(shopCarts.length);
        HashSet<Long> existShopCartGoodsIdSet = new HashSet<Long>(shopCarts.length);
        for (DynamicObject shopCartDyn : shopCarts) {
            MalGoods malGoods = malGoodsMap.get(shopCartDyn.getLong("goods.id"));
            if (malGoods == null) continue;
            Long orgId = shopCartDyn.getLong("org.id");
            MalAddCartParam malAddCartParam = (MalAddCartParam)goodsId2AddCartParamMap.get(malGoods.getId());
            if (orgId == 0L || orgId.equals(currentOrgId)) {
                needUpdateShopCartDyns.add(this.updateShopCartDyn(shopCartDyn, malGoods, malAddCartParam));
                existShopCartGoodsIdSet.add(shopCartDyn.getLong("goods.id"));
                continue;
            }
            if (!malGoods.isGoodsVisible()) continue;
            needDeleteShopCartIdSet.add(shopCartDyn.getLong("id"));
        }
        ArrayList<DynamicObject> newShopCartDyns = new ArrayList<DynamicObject>(malGoodsMap.size());
        for (Long goodsid : goodsIds) {
            MalGoods malGoods = malGoodsMap.get(goodsid);
            if (existShopCartGoodsIdSet.contains(malGoods.getId())) continue;
            newShopCartDyns.add(this.createNewShopCartDyn(malGoods, (MalAddCartParam)goodsId2AddCartParamMap.get(malGoods.getId())));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", String.valueOf(true));
        if (!needUpdateShopCartDyns.isEmpty()) {
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"mal_shopcartbill", (DynamicObject[])needUpdateShopCartDyns.toArray(new DynamicObject[0]), (OperateOption)option);
            this.addError(resultList, ecGoodsIds, result);
        }
        if (!newShopCartDyns.isEmpty()) {
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"mal_shopcartbill", (DynamicObject[])newShopCartDyns.toArray(new DynamicObject[0]), (OperateOption)option);
            this.addError(resultList, ecGoodsIds, result);
        }
        if (!needDeleteShopCartIdSet.isEmpty()) {
            DeleteServiceHelper.delete((String)"mal_shopcartbill", (QFilter[])new QFilter[]{new QFilter("id", "in", needDeleteShopCartIdSet)});
        }
        HashMap<String, ArrayList<Long>> dataMap = new HashMap<String, ArrayList<Long>>(16);
        dataMap.put("goodsIds", ecGoodsIds);
        EventServiceHelper.triggerEventSubscribe((String)"pmm_ecgoods.pricemonitor", (String)SerializationUtils.toJsonString(dataMap));
        return resultList;
    }

    private void addError(List<MalCarResultVO> resultList, List<Long> ecGoodsIds, OperationResult result) {
        if (result.getAllErrorInfo() == null || result.getAllErrorInfo().size() == 0) {
            return;
        }
        for (IOperateInfo op : result.getAllErrorOrValidateInfo()) {
            resultList.add(this.createMalCarResultVO(Long.parseLong(op.getPkValue().toString()), null, null, op.getMessage()));
            ecGoodsIds.remove(Long.parseLong(op.getPkValue().toString()));
        }
    }

    private MalCarResultVO createMalCarResultVO(Long goodsId, String goodsName, String goodsNumber, String errorMessage) {
        MalCarResultVO resultVo = new MalCarResultVO();
        resultVo.setGoodsId(goodsId);
        resultVo.setGoodsName(goodsName);
        resultVo.setGoodsNumber(goodsNumber);
        resultVo.setErrorMessage(errorMessage);
        return resultVo;
    }

    private List<Long> addError(List<MalCarResultVO> resultList, List<Long> dataList, String message, List<Long> ecGoodsIds) {
        for (Long goodsId : dataList) {
            resultList.add(this.createMalCarResultVO(goodsId, null, null, message));
            ecGoodsIds.remove(goodsId);
        }
        return ecGoodsIds;
    }
}

