/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.shopcenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.mal.business.shopcenter.INewShopCenterService;

public class MalDefaultService
implements INewShopCenterService {
    private String formId = "";
    private String menuId = "";

    public MalDefaultService(String formId) {
        this.formId = formId;
    }

    public MalDefaultService(String formId, String menuId) {
        this.formId = formId;
        this.menuId = menuId;
    }

    public MalDefaultService() {
    }

    @Override
    public List<Map<String, Object>> getTabData() {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", "all-" + this.getFormId());
        data.put("name", ResManager.loadKDString((String)"\u5168\u90e8", (String)"MalDefaultService_0", (String)"scm-mal-business", (Object[])new Object[0]));
        data.put("type", "1");
        datas.add(data);
        datas.addAll(this.getExtTabData());
        return datas;
    }

    @Override
    public Map<String, Object> getBillParams(String tabKey) {
        Set<Object> ids = new HashSet(1024);
        QFilter tabQfilter = new QFilter("group.entity.number", "=", (Object)this.getFormId());
        tabQfilter.and(new QFilter("status", "=", (Object)"C"));
        tabQfilter.and(new QFilter("tabnumber", "=", (Object)tabKey));
        tabQfilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject tabInfo = QueryServiceHelper.queryOne((String)"mal_tab", (String)"number,name,filter,filter_tag,id", (QFilter[])tabQfilter.toArray());
        ids = this.getInfoIds(tabInfo, this.getDefaultFilters(), tabKey);
        QFilter qfilter = this.getQfilter(tabInfo, this.getDefaultFilters());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1024);
        paramMap.put("ids", SerializationUtils.toJsonString((Object)ids.toArray()));
        if (null != qfilter) {
            paramMap.put("qf", this.getQfilter(tabInfo, this.getDefaultFilters()));
        }
        paramMap.put("status", tabKey);
        return paramMap;
    }

    @Override
    public boolean checkPermission() {
        QFilter qFilter = new QFilter("id", "=", (Object)this.getFormId());
        DynamicObject bos_entityobject = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"bizappid.id", (QFilter[])qFilter.toArray());
        if (null != bos_entityobject) {
            String bizappid = bos_entityobject.getString("bizappid.id");
            return PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)bizappid, (String)this.getFormId());
        }
        return false;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    protected List<Map<String, Object>> getExtTabData() {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        QFilter tabQfilter = new QFilter("group.entity.number", "=", (Object)this.getFormId());
        tabQfilter.and(new QFilter("status", "=", (Object)"C"));
        tabQfilter.and(new QFilter("enable", "=", (Object)"1"));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> data = new HashMap<String, String>();
        DynamicObjectCollection tabCol = QueryServiceHelper.query((String)"mal_tab", (String)"number,name,filter,id,tabnumber", (QFilter[])tabQfilter.toArray(), (String)"tabseq");
        for (DynamicObject tab : tabCol) {
            String name = tab.getString("name");
            String tabnumber = tab.getString("tabnumber");
            data = new HashMap();
            data.put("id", tabnumber);
            stringBuilder.setLength(0);
            data.put("name", name);
            data.put("type", "0");
            datas.add(data);
        }
        return datas;
    }

    public QFilter getQfilter(DynamicObject tabInfo, QFilter defaultFilters) {
        QFilter qFilter1 = null;
        if (null != tabInfo && null != tabInfo.getString("filter_tag") && !tabInfo.getString("filter_tag").isEmpty()) {
            String filterStr = tabInfo.getString("filter_tag");
            qFilter1 = this.getCommonFilters(filterStr);
        }
        if (qFilter1 != null) {
            if (defaultFilters != null) {
                return qFilter1.and(defaultFilters);
            }
            return qFilter1;
        }
        if (defaultFilters != null) {
            return defaultFilters;
        }
        return null;
    }

    @Override
    public Set<Long> getInfoIds(DynamicObject tabInfo, QFilter defaultFilters, String tabnumber) {
        Set<Long> ids = new HashSet<Long>(1024);
        QFilter qFilter1 = null;
        if (null != tabInfo && null != tabInfo.getString("filter_tag") && !tabInfo.getString("filter_tag").isEmpty()) {
            String filterStr = tabInfo.getString("filter_tag");
            qFilter1 = this.getCommonFilters(filterStr);
        }
        if (qFilter1 != null) {
            ids = defaultFilters != null ? this.getIdCount(qFilter1.and(defaultFilters)) : this.getIdCount(qFilter1);
        } else if (defaultFilters != null) {
            ids = this.getIdCount(defaultFilters);
        }
        if (qFilter1 == null && defaultFilters == null) {
            ids = this.getIdCount(null);
        }
        return ids;
    }

    protected Set<Long> getIdCount(QFilter qFilter) {
        DynamicObjectCollection infoCol = null;
        infoCol = null == qFilter ? QueryServiceHelper.query((String)this.getFormId(), (String)"id", null) : QueryServiceHelper.query((String)this.getFormId(), (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> ids = new HashSet<Long>(1024);
        for (DynamicObject row : infoCol) {
            Long id = row.getLong("id");
            ids.add(id);
        }
        return ids;
    }

    protected QFilter getCommonFilters(String filterStr) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.getFormId());
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }

    @Override
    public QFilter getDefaultFilters() {
        String filter_tag;
        QFilter qFilter = null;
        String selector = "filter_tag";
        qFilter = !StringUtils.isBlank((CharSequence)this.menuId) ? new QFilter("id", "=", (Object)Long.parseLong(this.menuId)) : new QFilter("entity.number", "=", (Object)this.formId);
        DynamicObject menu = QueryServiceHelper.queryOne((String)"mal_menu", (String)selector, (QFilter[])qFilter.toArray());
        if (null != menu && !StringUtils.isEmpty((CharSequence)(filter_tag = menu.getString("filter_tag")))) {
            QFilter commonFilters = this.getCommonFilters(filter_tag);
            return commonFilters;
        }
        return null;
    }

    @Override
    public String getFormType() {
        QFilter qFilter = new QFilter("number", "=", (Object)this.getFormId());
        DynamicObject bosEntity = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"modeltype", (QFilter[])qFilter.toArray());
        String formType = "1";
        if (null != bosEntity) {
            String type;
            switch (type = bosEntity.getString("modeltype")) {
                case "BillFormModel": 
                case "BaseFormModel": {
                    formType = "1";
                    break;
                }
                case "ReportFormModel": {
                    formType = "3";
                    break;
                }
                case "DynamicFormModel": {
                    formType = "2";
                }
            }
        }
        return formType;
    }
}

