/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.shopcenter;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.mal.business.shopcenter.MalDefaultService;
import kd.scm.mal.common.util.MalAuthorityUtils;

public class MalMyOrderService
extends MalDefaultService {
    @Override
    public List<Map<String, Object>> getTabData() {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", "allorder");
        data.put("name", ResManager.loadKDString((String)"\u5168\u90e8\u8ba2\u5355", (String)"MalMyOrderService_0", (String)"scm-mal-business", (Object[])new Object[0]));
        data.put("type", "1");
        datas.add(data);
        datas.addAll(this.getExtTabData());
        return datas;
    }

    private Set<Long> getOrderCount(QFilter qFilter) {
        DynamicObjectCollection infoCol = QueryServiceHelper.query((String)"mal_order", (String)"id,billstatus,entryentity.erplogstatus,entryentity.purtype.checktype", (QFilter[])qFilter.toArray());
        HashSet<Long> ids = new HashSet<Long>(1024);
        for (DynamicObject row : infoCol) {
            Long id = row.getLong("id");
            ids.add(id);
        }
        return ids;
    }

    @Override
    public Map<String, Object> getBillParams(String tabKey) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1024);
        paramMap.put("status", tabKey);
        return paramMap;
    }

    @Override
    public QFilter getDefaultFilters() {
        Date now = TimeServiceHelper.now();
        QFilter qFilter = new QFilter("billdate", "<", (Object)now);
        qFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.addMonth((Date)now, (int)-3)));
        QFilter userQFilter = MalAuthorityUtils.getMalOrderViewAuthorityFilter((String)RequestContext.get().getUserId(), (String)"deporg.id", (String)"mal_order");
        if (null != userQFilter) {
            qFilter.and(userQFilter);
        }
        return qFilter;
    }

    @Override
    public String getFormId() {
        return "mal_order";
    }

    @Override
    public Set<Long> getInfoIds(DynamicObject tabInfo, QFilter qFilter, String tabKey) {
        Set<Object> ids = new HashSet(1024);
        QFilter qFilter1 = null;
        if (null != tabInfo && null != tabInfo.getString("filter_tag") && !tabInfo.getString("filter_tag").isEmpty()) {
            String filterStr = tabInfo.getString("filter_tag");
            qFilter1 = super.getCommonFilters(filterStr);
        }
        if (qFilter1 != null) {
            ids = null != qFilter ? this.getOrderCount(qFilter.and(qFilter1)) : this.getOrderCount(qFilter1);
        } else {
            switch (tabKey) {
                case "savesubmit": {
                    ids = this.getSaveSubmitIds(qFilter);
                    break;
                }
                case "saloutcount": {
                    ids = this.getsaloutIDs(qFilter);
                    break;
                }
                case "receivecount": {
                    ids = this.getReceiveIds(qFilter);
                    break;
                }
                case "finishcount": {
                    ids = this.getFinishIds(qFilter);
                    break;
                }
                case "allorder": {
                    ids = this.getAllIds(qFilter);
                    break;
                }
                case "cancelcount": {
                    ids = this.getCancelIds(qFilter);
                }
            }
        }
        return ids;
    }

    private Set<Long> getReceiveIds(QFilter qFilter) {
        String erplogstatus;
        HashSet<Long> receiveStatusSet = new HashSet<Long>(1024);
        QFilter billsattusFilter = new QFilter("billstatus", "=", (Object)"C");
        billsattusFilter.and(qFilter);
        DynamicObjectCollection infoCol = QueryServiceHelper.query((String)"mal_order", (String)"id,billstatus,entryentity.erplogstatus,entryentity.purtype.checktype", (QFilter[])billsattusFilter.toArray());
        HashSet<Long> saloutSet = new HashSet<Long>(1024);
        HashSet<Long> receiveSet = new HashSet<Long>(1024);
        HashSet<Long> instockSet = new HashSet<Long>(1024);
        for (DynamicObject row : infoCol) {
            erplogstatus = row.getString("entryentity.erplogstatus");
            if ("B".equals(erplogstatus) || "D".equals(erplogstatus) || "F".equals(erplogstatus)) {
                receiveStatusSet.add(row.getLong("id"));
                continue;
            }
            if ("C".equals(erplogstatus)) {
                saloutSet.add(row.getLong("id"));
            }
            if ("E".equals(erplogstatus)) {
                receiveSet.add(row.getLong("id"));
            }
            if (!"G".equals(erplogstatus)) continue;
            instockSet.add(row.getLong("id"));
        }
        for (DynamicObject row : infoCol) {
            erplogstatus = row.getString("entryentity.erplogstatus");
            Long id = row.getLong("id");
            if (("A".equals(erplogstatus) || "C".equals(erplogstatus)) && saloutSet.contains(id)) {
                receiveStatusSet.add(id);
                continue;
            }
            if (("A".equals(erplogstatus) || "C".equals(erplogstatus)) && receiveSet.contains(id)) {
                receiveStatusSet.add(id);
                continue;
            }
            if (!"A".equals(erplogstatus) && !"C".equals(erplogstatus) && !"E".equals(erplogstatus) || !instockSet.contains(id)) continue;
            receiveStatusSet.add(id);
        }
        return receiveStatusSet;
    }

    private int getFinishCount(QFilter qFilter) {
        Set<Long> finishSet = this.getFinishIds(qFilter);
        return finishSet.size();
    }

    private Set<Long> getFinishIds(QFilter qFilter) {
        Set<Long> orderCount = this.getOrderCount(qFilter);
        Set<Long> saveSubmitIds = this.getSaveSubmitIds(qFilter);
        Set<Long> saloutIDs = this.getsaloutIDs(qFilter);
        Set<Long> receiveIds = this.getReceiveIds(qFilter);
        Set<Long> cancelIds = this.getCancelIds(qFilter);
        orderCount.removeAll(saveSubmitIds);
        orderCount.removeAll(saloutIDs);
        orderCount.removeAll(receiveIds);
        orderCount.removeAll(cancelIds);
        return orderCount;
    }

    private int getOrderCancelCount(QFilter qFilter) {
        Set<Long> cancelIds = this.getCancelIds(qFilter);
        return cancelIds.size();
    }

    private Set<Long> getCancelIds(QFilter qFilter) {
        QFilter cancelQfilter = new QFilter("billstatus", "=", (Object)"Z");
        cancelQfilter.and(qFilter);
        DynamicObjectCollection infoCol = QueryServiceHelper.query((String)"mal_order", (String)"id,billstatus,entryentity.erplogstatus,entryentity.purtype.checktype", (QFilter[])cancelQfilter.toArray());
        HashSet<Long> ids = new HashSet<Long>(1024);
        for (DynamicObject row : infoCol) {
            Long id = row.getLong("id");
            ids.add(id);
        }
        return ids;
    }

    private Set<Long> getAllIds(QFilter qFilter) {
        DynamicObjectCollection infoCol = QueryServiceHelper.query((String)"mal_order", (String)"id", (QFilter[])(qFilter == null ? null : qFilter.toArray()));
        HashSet<Long> ids = new HashSet<Long>(1024);
        for (DynamicObject row : infoCol) {
            Long id = row.getLong("id");
            ids.add(id);
        }
        return ids;
    }

    private int getOrderSaloutCOunt(QFilter qFilter) {
        Set<Long> saloutSet = this.getsaloutIDs(qFilter);
        return saloutSet.size();
    }

    private Set<Long> getsaloutIDs(QFilter qFilter) {
        QFilter saloutQfilter = new QFilter("entryentity.erplogstatus", "=", (Object)"");
        saloutQfilter.or(new QFilter("entryentity.erplogstatus", "=", (Object)"A"));
        saloutQfilter.and(new QFilter("billstatus", "=", (Object)"C")).and(qFilter);
        HashSet<Long> saloutSet = new HashSet<Long>(1024);
        DynamicObjectCollection infoCol = QueryServiceHelper.query((String)"mal_order", (String)"id,billstatus,entryentity.erplogstatus,entryentity.purtype.checktype", (QFilter[])saloutQfilter.toArray());
        for (DynamicObject row : infoCol) {
            String erplogstatus = row.getString("entryentity.erplogstatus");
            Long id = row.getLong("id");
            saloutSet.add(id);
            if ("A".equals(erplogstatus) || "".equals(erplogstatus)) continue;
            saloutSet.remove(id);
        }
        return saloutSet;
    }

    private int getOrderSaveSubmitCOunt(QFilter qFilter) {
        Set<Long> saveSubmitIds = this.getSaveSubmitIds(qFilter);
        return saveSubmitIds.size();
    }

    private Set<Long> getSaveSubmitIds(QFilter qFilter) {
        QFilter saveSubmitQfilter = new QFilter("billstatus", "=", (Object)"A");
        saveSubmitQfilter.or(new QFilter("billstatus", "=", (Object)"B"));
        saveSubmitQfilter.and(qFilter);
        DynamicObjectCollection infoCol = QueryServiceHelper.query((String)"mal_order", (String)"id,billstatus,entryentity.erplogstatus,entryentity.purtype.checktype", (QFilter[])saveSubmitQfilter.toArray());
        HashSet<Long> ids = new HashSet<Long>(1024);
        for (DynamicObject row : infoCol) {
            Long id = row.getLong("id");
            ids.add(id);
        }
        return ids;
    }
}

