/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.stock.service.impl;

import java.math.BigDecimal;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.StockEnum;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalStock;

public class MalStockServiceImpl
implements MalStockService {
    private static final Log log = LogFactory.getLog(MalStockServiceImpl.class);

    @Override
    public boolean validEcGoodsStock(MalGoods malGoods, BigDecimal orderQty) {
        if (orderQty == null) {
            orderQty = BigDecimal.ZERO;
        }
        if (malGoods == null) {
            return false;
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) || EcPlatformEnum.ECPLATFORM_XY.getVal().equals(malGoods.getPlatform())) {
            return true;
        }
        if (StockEnum.SOLDOUT.getName().equals(malGoods.getStockDesc())) {
            return false;
        }
        if (StockEnum.SALE.getName().equals(malGoods.getStockDesc())) {
            return true;
        }
        return StringUtils.isNumeric((CharSequence)malGoods.getStockDesc()) && new BigDecimal(malGoods.getStockDesc()).compareTo(orderQty) >= 0;
    }

    @Override
    public boolean validGoodsStock(MalGoods malGoods, BigDecimal orderQty) {
        if (malGoods == null || malGoods.getStockDesc() == null) {
            return true;
        }
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
            return this.validEcGoodsStock(malGoods, orderQty);
        }
        return this.validGoodsStockStateDesc(malGoods.getStockDesc(), orderQty);
    }

    @Override
    public boolean validGoodsStock(MalStock malStock, BigDecimal orderQty) {
        if (malStock == null) {
            return false;
        }
        return this.validGoodsStockStateDesc(malStock.stockStateDesc(), orderQty);
    }

    private boolean validGoodsStockStateDesc(String stockStateDesc, BigDecimal orderQty) {
        log.info("MalStockService.validGoodsStockStateDesc:stockStateDesc-" + stockStateDesc);
        if (StockEnum.SOLDOUT.getName().equals(stockStateDesc)) {
            return false;
        }
        if ("".equals(stockStateDesc) || StockEnum.SALE.getName().equals(stockStateDesc)) {
            return true;
        }
        try {
            BigDecimal stock = new BigDecimal(stockStateDesc);
            if (stock.compareTo(orderQty) < 0) {
                return false;
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

