/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.model;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.util.MalBizFowUtil;

public class MalEntity {
    protected DynamicObject dyn;

    public MalEntity(DynamicObject dyn) {
        this.dyn = dyn;
    }

    public final String getEnityNumber() {
        return this.dyn.getDynamicObjectType().getName();
    }

    public MalEntity() {
    }

    public static OperationResult executeOp(String op, DynamicObject dyn) {
        Objects.requireNonNull(dyn);
        if (dyn.isQueryObj()) {
            throw new KDBizException("queryObj can not executeOp.");
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)op, (String)dyn.getDynamicObjectType().getName(), (DynamicObject[])new DynamicObject[]{dyn}, (OperateOption)MalBizFowUtil.createDefaultOpiton());
        if (operationResult.getSuccessPkIds().isEmpty()) {
            throw new KDBizException(operationResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
        }
        return operationResult;
    }

    public static OperationResult executeOp(String op, List<DynamicObject> dyn) {
        if (dyn.size() == 0) {
            throw new KDBizException("queryObj can not executeOp.");
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)op, (String)dyn.get(0).getDynamicObjectType().getName(), (Object[])dyn.toArray(), (OperateOption)MalBizFowUtil.createDefaultOpiton());
        if (operationResult.getSuccessPkIds().isEmpty()) {
            throw new KDBizException(operationResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
        }
        return operationResult;
    }

    public static OperationResult executeOp(String op, String entityName, Set<Long> ids) {
        Objects.requireNonNull(ids);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)op, (String)entityName, (Object[])ids.toArray(), (OperateOption)MalBizFowUtil.createDefaultOpiton());
        if (operationResult.getSuccessPkIds().isEmpty()) {
            throw new KDBizException(operationResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
        }
        return operationResult;
    }

    public <T> T getDefValue(String key) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)this.getEnityNumber());
        DataEntityPropertyCollection propertyCollection = dt.getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            if (!(property instanceof IFieldHandle) || ((IFieldHandle)property).isSysField() || !key.equals(property.getName())) continue;
            return (T)((IFieldHandle)property).getDefValue();
        }
        return null;
    }
}

